/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.utils;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import com.xdja.safeclient.bean.LanguageBean;
import com.xdja.safeclient.utils.OttoUtil;
import com.xdja.safeclient.utils.SharedPreferencesUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LocaleUtil {
    public static final String SIMPLIFIED_CHINESE = "\u7b80\u4f53\u4e2d\u6587";
    public static final String ENGLISH = "English";
    public static Map<String, Locale> languages = new HashMap<String, Locale>();
    private static Locale systemLocale = null;

    public static Locale getSystemLocale() {
        return systemLocale;
    }

    public static void setSystemLocale(Locale systemLocale) {
        LocaleUtil.systemLocale = systemLocale;
    }

    public static boolean autoChoose(Context context) {
        return (Boolean)SharedPreferencesUtil.get(context, "auto", true);
    }

    public static String getCurrentLocaleName(Context context) {
        return (String)SharedPreferencesUtil.get(context, "current_language", "");
    }

    public static Locale getCurrent(Context context) {
        return LocaleUtil.parseLocale(LocaleUtil.getCurrentLocaleName(context));
    }

    public static Locale parseLocale(String languageName) {
        return languages.get(languageName);
    }

    public static void changeLanguage(Context context, Locale locale) {
        Resources resources = context.getResources();
        Configuration configuration = resources.getConfiguration();
        DisplayMetrics dm = resources.getDisplayMetrics();
        configuration.locale = locale;
        resources.updateConfiguration(configuration, dm);
        OttoUtil.customChangeLanguage(resources.getConfiguration().locale);
    }

    public static void changeLanguage(Context context, LanguageBean language, ChangeListener listener) {
        Resources resources = context.getResources();
        Configuration configuration = resources.getConfiguration();
        DisplayMetrics dm = resources.getDisplayMetrics();
        configuration.locale = language.isAuto() ? LocaleUtil.getSystemLocale() : language.getLocale();
        resources.updateConfiguration(configuration, dm);
        listener.onChange(language);
        OttoUtil.customChangeLanguage(resources.getConfiguration().locale);
    }

    static {
        languages.put(SIMPLIFIED_CHINESE, Locale.SIMPLIFIED_CHINESE);
        languages.put(ENGLISH, Locale.ENGLISH);
        systemLocale = Locale.getDefault();
    }

    public static interface ChangeListener {
        public void onChange(LanguageBean var1);
    }
}

