/*
 * Decompiled with CFR 0.152.
 */
package com.longmai.security.plugin.driver.otg;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import com.longmai.security.plugin.base.PluginException;
import com.longmai.security.plugin.device.Device;
import com.longmai.security.plugin.device.DeviceManager;
import com.longmai.security.plugin.driver.conn.Connection;
import com.longmai.security.plugin.driver.otg.ConnectionImpl;
import com.longmai.security.plugin.util.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeviceManagerImple
implements DeviceManager {
    private static final String TAG = DeviceManagerImple.class.getName();
    private static final String ACTION_USB_PERMISSION = "com.longmai.USB_PERMISSION";
    public static final int VID = 1372;
    public static final int PID = 58904;
    private PendingIntent permissionIntent;
    private Context context;
    private UsbManager usbManager;
    private Connection conn;
    private HashMap<String, UsbDevice> devices = new HashMap();
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            LogUtil.d((String)TAG, (String)("Thread: " + Thread.currentThread().getName() + " Id: " + Thread.currentThread().getId()));
            String action = intent.getAction();
            if (DeviceManagerImple.ACTION_USB_PERMISSION.equals(action)) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                    if (intent.getBooleanExtra("permission", false)) {
                        if (device != null) {
                            LogUtil.d((String)TAG, (String)"\u6388\u6743\u6210\u529f");
                        }
                    } else {
                        LogUtil.w((String)TAG, (String)("permission denied for device " + device));
                        LogUtil.w((String)TAG, (String)"\u6388\u6743\u5931\u8d25");
                    }
                    DeviceManagerImple deviceManagerImple = DeviceManagerImple.this;
                    synchronized (deviceManagerImple) {
                        DeviceManagerImple.this.notify();
                    }
                }
            }
        }
    };

    public DeviceManagerImple(Context context) throws PluginException {
        if (context == null) {
            throw new PluginException("Context is null");
        }
        this.context = context;
        this.usbManager = (UsbManager)context.getSystemService("usb");
    }

    public List<Device> find(int timeOut, String ... parameter) throws PluginException {
        return this.find(parameter);
    }

    public List<Device> find(String ... parameter) throws PluginException {
        LogUtil.d((String)TAG, (String)"find(...)");
        if (this.usbManager == null) {
            throw new PluginException("UsbManager is null");
        }
        ArrayList<Device> list = new ArrayList<Device>();
        this.devices = this.usbManager.getDeviceList();
        for (Map.Entry<String, UsbDevice> entry : this.devices.entrySet()) {
            String key = entry.getKey();
            UsbDevice val = entry.getValue();
            if (val.getProductId() != 58904 || val.getVendorId() != 1372) continue;
            list.add(new Device(0, key, 0));
        }
        return list;
    }

    public synchronized Connection getConnection(Device device) throws PluginException {
        return this.getConnection(device, 0);
    }

    public Connection getConnection(Device device, int timeout) throws PluginException {
        LogUtil.d((String)TAG, (String)"getConnection()");
        UsbDevice usbDevice = this.devices.get(device.getName());
        if (usbDevice == null) {
            throw new PluginException(12);
        }
        if (this.conn != null) {
            this.conn.close();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.usbManager.hasPermission(usbDevice)) {
            LogUtil.d((String)TAG, (String)"hasPermission Yes");
            this.conn = new ConnectionImpl(this.usbManager, usbDevice);
            return this.conn;
        }
        LogUtil.w((String)TAG, (String)"hasPermission No");
        IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
        this.context.registerReceiver(this.mUsbReceiver, filter);
        this.permissionIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        this.usbManager.requestPermission(usbDevice, this.permissionIntent);
        try {
            LogUtil.d((String)TAG, (String)("Thread: " + Thread.currentThread().getName() + " Id: " + Thread.currentThread().getId()));
            this.wait(timeout);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.context.unregisterReceiver(this.mUsbReceiver);
        if (this.usbManager.hasPermission(usbDevice)) {
            this.conn = new ConnectionImpl(this.usbManager, usbDevice);
            return this.conn;
        }
        throw new PluginException(17);
    }
}

