/*
 * Decompiled with CFR 0.152.
 */
package com.longmai.security.plugin.driver.otg;

import android.content.Context;
import android.os.Build;
import com.longmai.security.plugin.base.PluginException;
import com.longmai.security.plugin.device.DeviceManager;
import com.longmai.security.plugin.driver.Driver;
import com.longmai.security.plugin.driver.DriverManager;
import com.longmai.security.plugin.driver.otg.DeviceManagerImple;
import com.longmai.security.plugin.util.LogUtil;

public class OTGDriver
implements Driver {
    private static final String TAG = OTGDriver.class.getName();
    private static final int currentapiVersion = Build.VERSION.SDK_INT;
    private DeviceManager deviceManager;
    private Context context;

    static {
        try {
            DriverManager.registerDriver((Driver)new OTGDriver());
        }
        catch (Exception e) {
            throw new RuntimeException("Can't register driver!");
        }
        LogUtil.d((String)TAG, (String)"register driver");
    }

    public void init() throws PluginException {
        LogUtil.d((String)TAG, (String)"init()");
        throw new PluginException("Driver failed to initialize");
    }

    public void init(Object context) throws PluginException {
        LogUtil.d((String)TAG, (String)"init()");
        if (currentapiVersion < 14) {
            throw new PluginException(5);
        }
        if (!(context instanceof Context)) {
            throw new PluginException("Driver failed to initialize");
        }
        this.context = (Context)context;
    }

    public DeviceManager getDeviceManager() throws PluginException {
        LogUtil.d((String)TAG, (String)"getDeviceManager()");
        if (this.deviceManager == null) {
            this.deviceManager = new DeviceManagerImple(this.context);
        }
        return this.deviceManager;
    }

    public void uninit() throws PluginException {
        LogUtil.d((String)TAG, (String)"uninit()");
        this.context = null;
        this.deviceManager = null;
        DriverManager.deregisterDriver((Driver)this);
    }
}

