/*
 * Decompiled with CFR 0.152.
 */
package com.longmai.security.plugin.driver.otg.io.stack;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.util.Log;
import com.longmai.security.plugin.base.PluginException;
import com.longmai.security.plugin.driver.otg.io.stack.MessagePool;
import com.longmai.security.plugin.util.Hex;
import com.longmai.security.plugin.util.Int2Bytes;
import com.longmai.security.plugin.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.TimeoutException;

public class MessagePoolImpl
implements MessagePool,
Runnable {
    private static final String TAG = MessagePoolImpl.class.getName();
    private static final int MAX_BUFF = 64;
    private static volatile int msgState;
    private static final int SEND_OK = 0;
    private static final int SEND_FAIL = 1;
    private static final int SEND_ING = 2;
    private static final int RECEIVCE_OK = 3;
    private static final int RECEIVCE_WAIT = 4;
    private static final int RECEIVCE_ING = 5;
    private static final int SEND_TIMEOUT = 6;
    private static final int DATA_BAD = 7;
    private static final int MSG_PROTOCOL = 8;
    private static final int RECEIVCE_FAIL = 9;
    private UsbInterface usbInterface;
    private UsbDevice usbDevice;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;
    private UsbDeviceConnection connection;
    private ByteArrayOutputStream pool;
    private static volatile byte counter;
    private volatile boolean runFlag;
    private int timeOut = 0;

    static {
        counter = (byte)-128;
    }

    public MessagePoolImpl(UsbDeviceConnection connection, UsbDevice usbDevice) {
        this.connection = connection;
        this.usbDevice = usbDevice;
    }

    @Override
    public void init() throws PluginException {
        LogUtil.d((String)TAG, (String)"init()");
        this.pool = new ByteArrayOutputStream(4096);
        int count = this.usbDevice.getInterfaceCount();
        if (count <= 0) {
            throw new PluginException("UsbDevice Interface Count " + count);
        }
        this.usbInterface = this.usbDevice.getInterface(0);
        LogUtil.d((String)TAG, (String)("InterfaceClass:" + this.usbInterface.getInterfaceClass()));
        LogUtil.d((String)TAG, (String)("InterfaceSubclass:" + this.usbInterface.getInterfaceSubclass()));
        count = this.usbInterface.getEndpointCount();
        if (count < 2) {
            throw new PluginException("UsbInterface Endpoint Count " + count);
        }
        int i = 0;
        while (i < count) {
            UsbEndpoint point = this.usbInterface.getEndpoint(i);
            int nDirection = point.getDirection();
            int nType = point.getType();
            if (nType == 3) {
                if (nDirection == 0) {
                    this.outEndpoint = point;
                } else if (nDirection == 128) {
                    this.inEndpoint = point;
                }
            }
            ++i;
        }
        boolean isClaimInterface = this.connection.claimInterface(this.usbInterface, true);
        if (!isClaimInterface) {
            throw new PluginException("message pool init exception");
        }
        Thread receive = new Thread(this);
        receive.start();
        LogUtil.d((String)TAG, (String)("receive.start() - Thread: " + receive.getName() + " Id: " + receive.getId()));
    }

    @Override
    public int getTimeOut() {
        LogUtil.d((String)TAG, (String)"getTimeOut()");
        return this.timeOut;
    }

    @Override
    public void setTimeOut(int timeOut) {
        LogUtil.d((String)TAG, (String)("setTimeOut() timeOut:" + timeOut));
        this.timeOut = timeOut;
    }

    @Override
    public int write(byte[] apdu) throws IOException {
        LogUtil.d((String)TAG, (String)"write()");
        return this.write(apdu, 0, apdu.length);
    }

    @Override
    public synchronized int write(byte[] apdu, int off, int len) throws IOException {
        LogUtil.d((String)TAG, (String)"writeEx()");
        msgState = 2;
        int frameSize = 63;
        int nCount = len / frameSize;
        int nLast = len % frameSize;
        byte[] nLen = Int2Bytes.int2byte((int)len, (int)2, (boolean)false);
        byte[] tmp = new byte[64];
        tmp[0] = -108;
        tmp[1] = -2;
        tmp[2] = 1;
        tmp[17] = nLen[0];
        tmp[18] = nLen[1];
        tmp[20] = counter = (byte)(counter + 1);
        LogUtil.d((String)TAG, (String)("Head: " + new String(Hex.encode((byte[])tmp))));
        int l = this.connection.controlTransfer(33, 9, 512, 0, tmp, 64, this.timeOut);
        if (l <= 0) {
            throw new IOException("control transfer exception 0x80");
        }
        int i = 0;
        while (i < nCount) {
            tmp = new byte[64];
            System.arraycopy(apdu, i * frameSize + off, tmp, 1, frameSize);
            tmp[0] = (byte)frameSize;
            LogUtil.d((String)TAG, (String)("Body: " + new String(Hex.encode((byte[])tmp))));
            l = this.connection.controlTransfer(33, 9, 512, 0, tmp, 64, this.timeOut);
            if (l <= 0) {
                throw new IOException("control transfer exception");
            }
            ++i;
        }
        tmp = new byte[64];
        System.arraycopy(apdu, nCount * frameSize + off, tmp, 1, nLast);
        tmp[0] = (byte)(nLast | 0x40);
        LogUtil.d((String)TAG, (String)("Tail: " + new String(Hex.encode((byte[])tmp))));
        l = this.connection.controlTransfer(33, 9, 512, 0, tmp, 64, this.timeOut);
        if (l <= 0) {
            throw new IOException("control transfer exception 0x40");
        }
        msgState = 0;
        return len;
    }

    @Override
    public synchronized byte[] read() throws IOException, TimeoutException {
        LogUtil.d((String)TAG, (String)("read() - msgState:" + msgState + ". Thread: " + Thread.currentThread().getName() + " Id: " + Thread.currentThread().getId()));
        switch (msgState) {
            case 0: 
            case 2: 
            case 4: 
            case 5: {
                try {
                    this.wait(this.timeOut);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 1: 
            case 6: {
                throw new IOException("control transfer send exception");
            }
            case 9: {
                throw new IOException("control transfer receivce exception");
            }
            case 7: 
            case 8: {
                throw new IOException("data exception");
            }
        }
        if (msgState != 3) {
            if (msgState == 0) {
                throw new TimeoutException();
            }
            throw new IOException("control transfer receivce exception");
        }
        byte[] apdu = this.pool.toByteArray();
        Log.d((String)TAG, (String)("read() - " + new String(Hex.encode((byte[])apdu))));
        if (apdu[0] != -86 || apdu[1] != -86) {
            return null;
        }
        byte _counter = apdu[19];
        if (_counter != counter) {
            throw new IOException("counter exception");
        }
        int nLen = Int2Bytes.bytes2int((byte[])apdu, (int)2, (int)2, (boolean)false);
        if (apdu.length < 20 + nLen) {
            throw new IOException("read data length exception");
        }
        return Arrays.copyOfRange(apdu, 20, 20 + nLen);
    }

    @Override
    public synchronized void destroy() {
        LogUtil.d((String)TAG, (String)("destroy() Thread: " + Thread.currentThread().getName() + " Id: " + Thread.currentThread().getId()));
        this.runFlag = false;
        if (this.connection != null && this.usbInterface != null) {
            this.connection.releaseInterface(this.usbInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LogUtil.w((String)TAG, (String)("Interrupt Transfer Receive Thread Run. Thread: " + Thread.currentThread().getName() + " Id: " + Thread.currentThread().getId()));
        this.runFlag = true;
        int maxPacketSize = this.inEndpoint.getMaxPacketSize();
        ByteBuffer buffer = ByteBuffer.allocate(maxPacketSize);
        UsbRequest request = new UsbRequest();
        request.initialize(this.connection, this.inEndpoint);
        while (this.runFlag) {
            boolean isQueueOk = request.queue(buffer, maxPacketSize);
            if (isQueueOk && this.connection.requestWait() == request) {
                byte[] tmp = buffer.array();
                LogUtil.d((String)TAG, (String)("Receiver : " + new String(Hex.encode((byte[])tmp, (int)0, (int)tmp.length))));
                byte token = tmp[0];
                int isFirstPackage = token >> 7 & 1;
                int isLastPackage = token >> 6 & 1;
                int dataLen = token & 0x3F;
                if (isFirstPackage == 1) {
                    msgState = 5;
                    this.pool.reset();
                }
                this.pool.write(tmp, 1, dataLen);
                if (isLastPackage != 1) continue;
                MessagePoolImpl messagePoolImpl = this;
                synchronized (messagePoolImpl) {
                    msgState = 3;
                    this.notifyAll();
                    continue;
                }
            }
            MessagePoolImpl messagePoolImpl = this;
            synchronized (messagePoolImpl) {
                msgState = 9;
                this.notifyAll();
            }
            LogUtil.e((String)TAG, (String)("requestWait failed, exiting " + isQueueOk));
            break;
        }
        LogUtil.w((String)TAG, (String)("Interrupt Transfer Receive Thread end. Thread: " + Thread.currentThread().getName() + " Id: " + Thread.currentThread().getId()));
    }
}

