/*
 * Decompiled with CFR 0.152.
 */
package com.mpt.aidlservice;

import com.mpt.aidlservice.Base64;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends OutputStream {
    private static final int BUFFER_LENGTH = 3;
    private int position;
    private byte[] buffer;
    private int lineLength;
    private boolean breakLines;
    private byte[] b4;
    private boolean suspendEncoding;
    private byte[] alphabet;
    private OutputStream out;

    public Base64OutputStream(OutputStream out) {
        this(out, 0);
    }

    public Base64OutputStream(OutputStream out, int options) {
        this.out = out;
        this.breakLines = (options & 8) != 8;
        this.buffer = new byte[3];
        this.position = 0;
        this.lineLength = 0;
        this.suspendEncoding = false;
        this.b4 = new byte[4];
        this.alphabet = Base64.getAlphabet(options);
    }

    @Override
    public void write(int theByte) throws IOException {
        if (this.suspendEncoding) {
            this.out.write(theByte);
            return;
        }
        this.buffer[this.position++] = (byte)theByte;
        if (this.position >= 3) {
            byte[] data = Base64.encode3to4(this.b4, this.buffer, 3, this.alphabet);
            this.out.write(data);
            this.lineLength += 4;
            if (this.breakLines && this.lineLength >= 76) {
                this.out.write(10);
                this.lineLength = 0;
            }
            this.position = 0;
        }
    }

    @Override
    public void write(byte[] theBytes, int off, int len) throws IOException {
        if (this.suspendEncoding) {
            this.out.write(theBytes, off, len);
            return;
        }
        for (int i = 0; i < len; ++i) {
            this.write(theBytes[off + i]);
        }
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void flushBase64() throws IOException {
        if (this.position > 0) {
            this.out.write(Base64.encode3to4(this.b4, this.buffer, this.position, this.alphabet));
            this.position = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBase64();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flushBase64();
        this.out.close();
        this.buffer = null;
        this.out = null;
    }

    public void suspendEncoding() throws IOException {
        this.flushBase64();
        this.suspendEncoding = true;
    }

    public void resumeEncoding() {
        this.suspendEncoding = false;
    }
}

