/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.autoupdate;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import android.widget.Toast;
import com.xdja.autoupdate.SCFileInfo;
import com.xdja.autoupdate.SCUpdateFunc;
import com.xdja.autoupdate.SCUpdateSocket;
import com.xdja.autoupdate.SCVersionInfo;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.R;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SCAutoUpdate {
    public static String serverIP = "";
    public static String serverPort = "";
    private static String factory = "";
    private static String mod = "";
    private static String os = "";
    private static String soft = "";
    private static String username = "";
    private static ArrayList<SCVersionInfo> verList = new ArrayList();
    private static String version = "";
    private static String date = "";
    private static String comment = "";
    private static String updatetag = "";
    private String tempversion = "";
    private static ArrayList<SCFileInfo> fileList = new ArrayList();
    public static SCUpdateSocket sl = null;
    public static Context context = null;
    public static String packageName = "";
    public static String privateDir = "";
    private static String TAG = "SCAutoUpdate";
    private static AtomicInteger atomicInteger = new AtomicInteger(0);
    static boolean isMainActivity = false;
    public static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static void updateStart(Context context, boolean isShowDialog, boolean isMain) {
        SCAutoUpdate.updateStart(context, isShowDialog);
        isMainActivity = isMain;
    }

    public static void updateStart(Context context, boolean isShowDialog) {
        packageName = context.getPackageName();
        privateDir = context.getFilesDir().getPath();
        SCAutoUpdate.context = context;
        if (!isShowDialog) {
            if (SCAutoUpdate.updateSilence()) {
                Log.d(TAG, "need update");
                return;
            }
            Log.d(TAG, "not update");
        }
        if (atomicInteger.get() == 0) {
            SCAutoUpdate g;
            SCAutoUpdate sCAutoUpdate = g = new SCAutoUpdate();
            sCAutoUpdate.getClass();
            CheckVerTask checktask = sCAutoUpdate.new CheckVerTask(isShowDialog);
            checktask.execute(new String[0]);
        } else {
            Log.i(TAG, "check is running");
        }
    }

    private static boolean updateSilence() {
        int fileListNum;
        SCAutoUpdate.ParseVersionInfo(privateDir + "/ClientVer.xml");
        File file = new File(privateDir + "/update_s.xml");
        if (!file.exists()) {
            Log.d(TAG, "update_s.xml not exists");
            return false;
        }
        boolean res = SCAutoUpdate.ParseConfigInfo("update_s.xml");
        if (!res) {
            file.delete();
            Log.e(TAG, "ParseConfigInfo failed");
            return false;
        }
        String verName = "";
        try {
            verName = SCAutoUpdate.context.getPackageManager().getPackageInfo((String)SCAutoUpdate.context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        Log.d(TAG, "version = " + version);
        Log.d(TAG, "verName = " + verName);
        String[] tmpVerName = verName.split("\\.");
        String[] tmpVersion = version.split("\\.");
        Log.d(TAG, "tmpVersion.length = " + tmpVersion.length);
        Log.d(TAG, "tmpVerName.length = " + tmpVerName.length);
        boolean isNeedUpdate = false;
        if (tmpVerName.length != tmpVersion.length) {
            isNeedUpdate = true;
        } else {
            for (int i = 0; i < tmpVerName.length; ++i) {
                Log.d(TAG, "Version[" + i + "] = " + tmpVersion[i]);
                Log.d(TAG, "VerName[" + i + "] = " + tmpVerName[i]);
                if (Integer.parseInt(tmpVersion[i]) <= Integer.parseInt(tmpVerName[i])) continue;
                isNeedUpdate = true;
                break;
            }
        }
        if (isNeedUpdate) {
            Log.d(TAG, "install package....");
            fileListNum = fileList.size();
            for (int i = 0; i < fileListNum; ++i) {
                Intent intent;
                if (i != fileListNum - 1) {
                    return false;
                }
                SCFileInfo fi = fileList.get(i);
                Log.d(TAG, "fi.filename = " + fi.filename);
                File updateFile = new File(privateDir + "/" + fi.filename);
                if (!updateFile.exists()) {
                    Log.d(TAG, fi.filename + " not exists");
                    return false;
                }
                try {
                    String Code = SCAutoUpdate.getHash(privateDir + "/" + fi.filename, "MD5");
                    if (!Code.equals(fi.checkCode)) {
                        file.delete();
                        Log.d(TAG, "\u6587\u4ef6\u5185\u5bb9\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\uff01");
                        return false;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
                if (updatetag.equals("0")) {
                    if (context == null) {
                        if (sl == null) continue;
                        sl.close();
                        sl = null;
                        continue;
                    }
                    intent = new Intent("android.intent.action.VIEW");
                    intent.setFlags(0x10000000);
                    intent.setDataAndType(Uri.fromFile((File)new File(privateDir + "/" + fi.filename)), "application/vnd.android.package-archive");
                    context.startActivity(intent);
                    continue;
                }
                intent = new Intent("android.intent.action.VIEW");
                intent.setFlags(0x10000000);
                intent.setDataAndType(Uri.fromFile((File)new File(privateDir + "/" + fi.filename)), "application/vnd.android.package-archive");
                context.startActivity(intent);
            }
        } else {
            fileListNum = fileList.size();
            for (int i = 0; i < fileListNum; ++i) {
                if (i != fileListNum - 1) {
                    return false;
                }
                SCFileInfo fi = fileList.get(i);
                Log.d(TAG, "delete file : " + fi.filename);
                File updateFile = new File(privateDir + "/" + fi.filename);
                if (!updateFile.exists()) {
                    Log.d(TAG, fi.filename + " not exists");
                    continue;
                }
                updateFile.delete();
            }
            return false;
        }
        SCVersionInfo ver = new SCVersionInfo();
        ver.version = version;
        ver.date = date;
        ver.note = comment;
        verList.add(ver);
        SCAutoUpdate.ReWriteVersionInfo(privateDir + "/ClientVer.xml");
        return true;
    }

    public static void CreateVersionInfo(Context mContext, String filename) {
        if (!new File(filename).exists()) {
            InputStream in = null;
            FileOutputStream out = null;
            try {
                in = mContext.getResources().getAssets().open("ClientVer.xml");
                out = mContext.openFileOutput("ClientVer.xml", 0);
                byte[] buffer = new byte[8192];
                int count = 0;
                while ((count = in.read(buffer)) > 0) {
                    out.write(buffer, 0, count);
                    out.flush();
                }
                in.close();
                out.close();
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                SCUpdateFunc.popAlert(mContext, StringUtil.getStringRes(context, R.string.update), mContext.getString(R.string.init_version_failed));
            }
        }
    }

    public static void CloseSocket(Context mContext, String filename) {
        if (sl != null) {
            sl.close();
            sl = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAssertClientVerInfo(Context mContext) {
        String mod = "";
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            InputStream in = mContext.getResources().getAssets().open("ClientVer.xml");
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("Mod");
            if (nodeList.item(0).getFirstChild() != null) {
                mod = nodeList.item(0).getFirstChild().getNodeValue();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
        return mod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAssertUpdateInfo(Context mContext, String filename, String attribute) {
        String mod = "";
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            InputStream in = mContext.getResources().getAssets().open(filename);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName(attribute);
            if (nodeList.item(0).getFirstChild() != null) {
                mod = nodeList.item(0).getFirstChild().getNodeValue();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
        return mod;
    }

    public static boolean deleteDir(File dirFile) {
        boolean flag = false;
        File[] fileArray = dirFile.listFiles();
        if (fileArray == null) {
            return dirFile.delete();
        }
        for (File fp : fileArray) {
            if (fp.isFile()) {
                if (fp.delete()) continue;
                return false;
            }
            flag = SCAutoUpdate.deleteDir(fp);
            if (!flag) {
                return false;
            }
            flag = fp.delete();
            if (flag) continue;
            return false;
        }
        return true;
    }

    public static void delUserdata(Context context, String fileDir) {
        String verName = "";
        try {
            verName = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        SCAutoUpdate.CreateVersionInfo(context, fileDir + "/ClientVer.xml");
        SCAutoUpdate.ParseVersionInfo(fileDir + "/ClientVer.xml");
        String phonetype = SCAutoUpdate.getAssertClientVerInfo(context);
        if (!phonetype.equals("") && !phonetype.equals(mod)) {
            SCAutoUpdate.clearTempDate(fileDir);
            return;
        }
        SharedPreferences sharePre = context.getSharedPreferences("mxtchat", 0);
        String versionCode = sharePre.getString("versionCode", "");
        if (verName.equals(versionCode)) {
            return;
        }
        if (verList.size() > 0) {
            SCVersionInfo vi = verList.get(verList.size() - 1);
            if (verName.equals(vi.version)) {
                try {
                    File tfile;
                    SharedPreferences.Editor share = context.getSharedPreferences("mxtchat", 0).edit();
                    share.putString("versionCode", verName);
                    share.commit();
                    String delDb = sharePre.getString("DeleteDb", "");
                    String fname = sharePre.getString("MainFileName", "");
                    if (!fname.equals("") && (tfile = new File(fileDir + "/" + fname)).exists()) {
                        tfile.delete();
                    }
                    if (delDb.equals("1")) {
                        SCAutoUpdate.clearTempDate(fileDir);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void clearTempDate(String fileDir) {
        File file = new File(privateDir + "/databases/mysql.db3");
        if (file.exists()) {
            file.delete();
        }
        File dir = new File(privateDir);
        SCAutoUpdate.deleteDir(dir);
    }

    public static void updateDeleteVer(Context context, String filedir) {
        String delver = SCAutoUpdate.getAssertUpdateInfo(context, "Update.xml", "DeleteVer");
        SharedPreferences sharePre = context.getSharedPreferences("mxtchat", 0);
        String oldDelver = sharePre.getString("DeleteVer", "");
        if (oldDelver.equals("") || !delver.equals("") && !delver.equals(oldDelver)) {
            File file = new File(filedir + "/ClientVer.xml");
            if (file.exists()) {
                file.delete();
            }
            SCAutoUpdate.CreateVersionInfo(context, filedir + "/ClientVer.xml");
            SharedPreferences.Editor share = context.getSharedPreferences("mxtchat", 0).edit();
            share.putString("DeleteVer", delver);
            share.commit();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ParseVersionInfo(String filename) {
        verList.clear();
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(filename);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("ServerIP");
            if (nodeList.item(0).getFirstChild() != null) {
                serverIP = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("ServerPort")).item(0).getFirstChild() != null) {
                serverPort = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("Factory")).item(0).getFirstChild() != null) {
                factory = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("Mod")).item(0).getFirstChild() != null) {
                mod = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("OS")).item(0).getFirstChild() != null) {
                os = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("Soft")).item(0).getFirstChild() != null) {
                soft = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("UserName")).item(0).getFirstChild() != null) {
                username = nodeList.item(0).getFirstChild().getNodeValue();
            }
            nodeList = root.getElementsByTagName("Ver");
            int nodeNum = nodeList.getLength();
            Element childElement = null;
            NodeList childList = null;
            for (int i = 0; i < nodeNum; ++i) {
                SCVersionInfo vi = new SCVersionInfo();
                childElement = (Element)nodeList.item(i);
                childList = childElement.getElementsByTagName("Version");
                vi.version = childList.item(0).getFirstChild().getNodeValue();
                childList = childElement.getElementsByTagName("Date");
                vi.date = childList.item(0).getFirstChild().getNodeValue();
                childList = childElement.getElementsByTagName("Note");
                if (childList.item(0).getFirstChild() != null) {
                    vi.note = childList.item(0).getFirstChild().getNodeValue();
                }
                verList.add(vi);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int ParseConfirmInfo(byte[] confirmInfo) {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(confirmInfo);
            doc = docBuilder.parse(stream);
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("Result");
            if (nodeList.item(0).getFirstChild() != null) {
                String result = nodeList.item(0).getFirstChild().getNodeValue();
                int n = Integer.parseInt(result);
                return n;
            }
            int n = -1;
            return n;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ParseConfigInfo(String filename) {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        boolean res = false;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(privateDir + "/" + filename);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("Version");
            if (nodeList.item(0).getFirstChild() != null) {
                version = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("Date")).item(0).getFirstChild() != null) {
                date = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("Comment")).item(0).getFirstChild() != null) {
                comment = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("UpdateTag")).item(0).getFirstChild() != null) {
                updatetag = nodeList.item(0).getFirstChild().getNodeValue();
            }
            nodeList = root.getElementsByTagName("File");
            int nodeNum = nodeList.getLength();
            Element childElement = null;
            NodeList childList = null;
            fileList.clear();
            for (int i = 0; i < nodeNum; ++i) {
                SCFileInfo fi = new SCFileInfo();
                childElement = (Element)nodeList.item(i);
                childList = childElement.getElementsByTagName("RPath");
                if (childList.item(0).getFirstChild() != null) {
                    fi.rpath = childList.item(0).getFirstChild().getNodeValue();
                }
                if ((childList = childElement.getElementsByTagName("LPath")).item(0).getFirstChild() != null) {
                    fi.lpath = childList.item(0).getFirstChild().getNodeValue();
                }
                if ((childList = childElement.getElementsByTagName("FName")).item(0).getFirstChild() != null) {
                    fi.filename = childList.item(0).getFirstChild().getNodeValue();
                }
                if ((childList = childElement.getElementsByTagName("CheckCode")).item(0).getFirstChild() != null) {
                    fi.checkCode = childList.item(0).getFirstChild().getNodeValue().toLowerCase();
                }
                if ((childList = childElement.getElementsByTagName("DeleteDb")).item(0).getFirstChild() != null) {
                    fi.deleteDb = childList.item(0).getFirstChild().getNodeValue();
                }
                if ((childList = childElement.getElementsByTagName("FSize")).item(0).getFirstChild() != null) {
                    fi.filesize = Integer.parseInt(childList.item(0).getFirstChild().getNodeValue());
                }
                if ((childList = childElement.getElementsByTagName("Action")).item(0).getFirstChild() != null) {
                    fi.action = Integer.parseInt(childList.item(0).getFirstChild().getNodeValue());
                }
                if ((childList = childElement.getElementsByTagName("State")).item(0).getFirstChild() != null) {
                    fi.state = Integer.parseInt(childList.item(0).getFirstChild().getNodeValue());
                }
                if ((childList = childElement.getElementsByTagName("CSize")).item(0).getFirstChild() != null) {
                    fi.csize = Integer.parseInt(childList.item(0).getFirstChild().getNodeValue());
                }
                fileList.add(fi);
            }
            res = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            res = false;
        }
        finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ParseTempInfo(String filename) {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        boolean res = false;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(privateDir + "/" + filename);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("Version");
            if (nodeList.item(0).getFirstChild() != null) {
                this.tempversion = nodeList.item(0).getFirstChild().getNodeValue();
            }
            res = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            res = false;
        }
        finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
        return res;
    }

    public static void ReWriteVersionInfo(String filename) {
        StringBuffer verstr = new StringBuffer();
        verstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        verstr.append("<Root>");
        verstr.append("<ServerIP>" + serverIP + "</ServerIP>");
        verstr.append("<ServerPort>" + serverPort + "</ServerPort>");
        verstr.append("<Factory>" + factory + "</Factory>");
        verstr.append("<Mod>" + mod + "</Mod>");
        verstr.append("<OS>" + os + "</OS>");
        verstr.append("<Soft>" + soft + "</Soft>");
        verstr.append("<UserName>" + username + "</UserName>");
        int verListNum = verList.size();
        SCVersionInfo vi = null;
        for (int i = 0; i < verListNum; ++i) {
            vi = verList.get(i);
            verstr.append("<Ver>");
            verstr.append("<Version>" + vi.version + "</Version>");
            verstr.append("<Date>" + vi.date + "</Date>");
            verstr.append("<Note>" + vi.note + "</Note>");
            verstr.append("</Ver>");
        }
        verstr.append("</Root>");
        SCUpdateFunc.WriteFile(filename, verstr.toString(), false);
    }

    private void ReWriteConfigInfo(String filename) {
        StringBuffer getfile = new StringBuffer();
        getfile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        getfile.append("<Root>");
        getfile.append("<Version>" + version + "</Version>");
        getfile.append("<Date>" + date + "</Date>");
        getfile.append("<Comment>" + comment + "</Comment>");
        getfile.append("<UpdateTag>" + updatetag + "</UpdateTag>");
        getfile.append("<Files>");
        int fileListNum = fileList.size();
        SCFileInfo fi = null;
        for (int i = 0; i < fileListNum; ++i) {
            fi = fileList.get(i);
            getfile.append("<File>");
            getfile.append("<RPath>" + fi.rpath + "</RPath>");
            getfile.append("<LPath>" + fi.lpath + "</LPath>");
            getfile.append("<FName>" + fi.filename + "</FName>");
            getfile.append("<FSize>" + fi.filesize + "</FSize>");
            getfile.append("<Action>" + fi.action + "</Action>");
            getfile.append("<State>" + fi.state + "</State>");
            getfile.append("<CSize>" + fi.csize + "</CSize>");
            getfile.append("<DeleteDb>" + fi.deleteDb + "</DeleteDb>");
            getfile.append("<CheckCode>" + fi.checkCode + "</CheckCode>");
            getfile.append("</File>");
        }
        getfile.append("</Files>");
        getfile.append("</Root>");
        SCUpdateFunc.WriteFile(filename, getfile.toString(), false);
    }

    private void doNewVersionForceUpdate() {
        StringBuffer sb = new StringBuffer();
        sb.append(context.getString(R.string.have_new_version));
        sb.append(version + ",");
        sb.append(comment);
        sb.append(context.getString(R.string.force_update_or_quit));
        AlertDialog dialog = new AlertDialog.Builder(context).setTitle(R.string.update_software).setMessage((CharSequence)sb.toString()).setPositiveButton((CharSequence)StringUtil.getStringRes(context, R.string.update), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                GetFileTask getfiletask = new GetFileTask();
                getfiletask.execute(new String[0]);
                dialog.dismiss();
            }
        }).setNegativeButton((CharSequence)StringUtil.getStringRes(context, R.string.exit), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                dialog.dismiss();
                Function.exitApp(context);
            }
        }).create();
        dialog.setCancelable(false);
        dialog.show();
    }

    private void doNewVersionUpdate() {
        StringBuffer sb = new StringBuffer();
        sb.append(context.getString(R.string.have_new_version));
        sb.append(version + ",");
        sb.append(comment);
        sb.append(context.getString(R.string.confirm_update));
        AlertDialog dialog = new AlertDialog.Builder(context).setTitle((CharSequence)StringUtil.getStringRes(context, R.string.update_software)).setMessage((CharSequence)sb.toString()).setPositiveButton((CharSequence)StringUtil.getStringRes(context, R.string.update), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                GetFileTask getfiletask = new GetFileTask();
                getfiletask.execute(new String[0]);
                dialog.dismiss();
            }
        }).setNegativeButton(R.string.dont_update, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                dialog.dismiss();
            }
        }).create();
        dialog.setCancelable(false);
        dialog.getWindow().setType(2003);
        dialog.show();
    }

    private void doNewVersionUpdateSilence() {
        SilenceGetFileTask getfiletask = new SilenceGetFileTask();
        getfiletask.execute(new String[0]);
    }

    private static String getHostAddress(String domain) {
        if (domain == null) {
            Log.e(TAG, "domain is null");
            return null;
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(new String(domain));
            if (inetAddress == null) {
                Log.e(TAG, "get InetAddress By Name failed");
                return null;
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            Log.e(TAG, "Unknow Domain Name:" + domain);
            return null;
        }
        Log.d(TAG, "Update Addr:" + inetAddress.getHostAddress());
        return inetAddress.getHostAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> GetUpdateConfig(Context mCon, String fileDir) {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        ArrayList<String> IP_Port = new ArrayList<String>();
        String updateIP = "";
        String updatePort = "";
        SCAutoUpdate.CreateVersionInfo(mCon, fileDir + "/ClientVer.xml");
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(fileDir + "//ClientVer.xml");
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("ServerIP");
            if (nodeList.item(0).getFirstChild() != null) {
                updateIP = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("ServerPort")).item(0).getFirstChild() != null) {
                updatePort = nodeList.item(0).getFirstChild().getNodeValue();
            }
            IP_Port.add(updateIP);
            IP_Port.add(updatePort);
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
        return IP_Port;
    }

    public static void SetUpdateConfig(String fileDir, String updateIP, String updatePort) {
        try {
            SCAutoUpdate.ParseVersionInfo(fileDir + "/ClientVer.xml");
            serverIP = updateIP;
            serverPort = updatePort;
            SCAutoUpdate.ReWriteVersionInfo(fileDir + "/ClientVer.xml");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void deleteDbfileTfcard() {
        File dbfile;
        boolean sdCardExit = false;
        sdCardExit = Environment.getExternalStorageState().equals("mounted");
        if (sdCardExit && (dbfile = new File(Environment.getExternalStorageDirectory() + "/MXTCHAT/mxt.mp3")).exists()) {
            dbfile.delete();
        }
    }

    public static String getHash(String fileName, String hashType) throws Exception {
        FileInputStream fis = new FileInputStream(fileName);
        byte[] buffer = new byte[1024];
        MessageDigest md5 = MessageDigest.getInstance(hashType);
        int numRead = 0;
        while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
            md5.update(buffer, 0, numRead);
        }
        ((InputStream)fis).close();
        return SCAutoUpdate.toHexString(md5.digest());
    }

    public static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
        }
        return sb.toString();
    }

    private class SilenceGetFileTask
    extends AsyncTask<String, Integer, String> {
        private SilenceGetFileTask() {
        }

        protected void onPreExecute() {
            if (context == null) {
                if (sl != null) {
                    sl.close();
                    sl = null;
                }
                return;
            }
        }

        protected void onPostExecute(String obj) {
            String result;
            if (sl != null) {
                sl.close();
                sl = null;
            }
            if ((result = obj) != null) {
                Log.d(TAG, "file download fail ," + result);
                try {
                    if (context == null) {
                        if (sl != null) {
                            sl.close();
                            sl = null;
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(e.getMessage());
                }
            } else {
                Log.d(TAG, "file download success");
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected String doInBackground(String ... params) {
            try {
                int nres = -1;
                if (serverIP.equals("")) {
                    return StringUtil.getStringRes(context, R.string.update_module_server_address_empty);
                }
                if (serverPort.equals("")) {
                    return StringUtil.getStringRes(context, R.string.update_module_server_port_empty);
                }
                String hostIP = SCAutoUpdate.getHostAddress(serverIP);
                if (hostIP == null) {
                    return StringUtil.getStringRes(context, R.string.update_module_host_error);
                }
                sl = new SCUpdateSocket(hostIP, Integer.parseInt(serverPort));
                nres = sl.connect();
                if (nres != 0) {
                    sl = null;
                    SCAutoUpdate.this.ReWriteConfigInfo(privateDir + "/update_s.xml");
                    return StringUtil.getStringRes(context, R.string.update_module_connect_server_error);
                }
                int fileListNum = fileList.size();
                if (fileListNum == 0) {
                    File file = new File(privateDir + "/update_s.xml");
                    file.delete();
                    return StringUtil.getStringRes(context, R.string.all_file_newest);
                }
                int i = 0;
                while (true) {
                    block42: {
                        File file;
                        if (i >= fileListNum) {
                            return null;
                        }
                        SCFileInfo fi = (SCFileInfo)fileList.get(i);
                        if (i == fileListNum - 1) {
                            SharedPreferences.Editor share = context.getSharedPreferences("mxtchat", 0).edit();
                            share.putString("MainFileName", fi.filename);
                            share.putString("DeleteDb", fi.deleteDb);
                            share.commit();
                        }
                        if ((fi.csize == 0 || fi.csize == fi.filesize) && (file = new File(privateDir + "/" + fi.filename)).exists()) {
                            try {
                                String Code = SCAutoUpdate.getHash(privateDir + "/" + fi.filename, "MD5");
                                if (!Code.equals(fi.checkCode)) {
                                    file.delete();
                                    return StringUtil.getStringRes(context, R.string.verify_failed_redownload);
                                }
                                return null;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (fi.csize < fi.filesize) {
                            File dF = new File(privateDir + "/" + fi.filename);
                            if (dF.exists() && dF.length() != (long)fi.csize) {
                                fi.csize = (int)dF.length();
                            }
                            StringBuffer getfile = new StringBuffer();
                            getfile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                            getfile.append("<Root>");
                            getfile.append("<Req>getfile</Req>");
                            getfile.append("<RPath>" + fi.rpath + "</RPath>");
                            getfile.append("<LPath>" + fi.lpath + "</LPath>");
                            getfile.append("<FName>" + fi.filename + "</FName>");
                            getfile.append("<FSize>" + fi.filesize + "</FSize>");
                            getfile.append("<FPos>" + fi.csize + "</FPos>");
                            getfile.append("</Root>");
                            if (sl == null) {
                                Log.e(TAG, "sl is null");
                                return "inner error";
                            }
                            nres = sl.sendData(getfile.toString());
                            if (nres != 0) {
                                SCAutoUpdate.this.ReWriteConfigInfo(privateDir + "/update_s.xml");
                                return StringUtil.getStringRes(context, R.string.upgrade_request_failed);
                            }
                            byte[] result = sl.recvData();
                            if (result == null) {
                                SCAutoUpdate.this.ReWriteConfigInfo(privateDir + "/update_s.xml");
                                return StringUtil.getStringRes(context, R.string.receive_upgrade_param_timeout);
                            }
                            int res = SCAutoUpdate.this.ParseConfirmInfo(result);
                            boolean flag = true;
                            File file2 = new File(privateDir + "/update_s.xml");
                            File tfile = new File(privateDir + "/" + fi.filename);
                            switch (res) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    file2.delete();
                                    return context.getString(R.string.file_not_exist);
                                }
                                case 2: {
                                    file2.delete();
                                    return context.getString(R.string.read_file_failed);
                                }
                                case 3: {
                                    file2.delete();
                                    return context.getString(R.string.file_size_unmatch);
                                }
                                case 4: {
                                    file2.delete();
                                    return context.getString(R.string.offset_invalid);
                                }
                                case 5: {
                                    file2.delete();
                                    return context.getString(R.string.param_unmatch);
                                }
                                default: {
                                    break block42;
                                }
                            }
                            while (fi.csize < fi.filesize) {
                                byte[] data = new byte[fi.filesize - fi.csize];
                                int currentLen = 0;
                                try {
                                    if (sl == null) {
                                        return StringUtil.getStringRes(context, R.string.socket_close);
                                    }
                                    currentLen = SCAutoUpdate.sl.sin.read(data, 0, fi.filesize - fi.csize);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    return StringUtil.getStringRes(context, R.string.receive_upgrade_data_timeout);
                                }
                                if (currentLen == -1) {
                                    SCAutoUpdate.this.ReWriteConfigInfo(privateDir + "/update_s.xml");
                                    return StringUtil.getStringRes(context, R.string.receive_upgrade_data_timeout);
                                }
                                fi.csize += currentLen;
                                this.publishProgress(new Integer[]{(int)((float)fi.csize / (float)fi.filesize * 100.0f)});
                                FileOutputStream out = null;
                                try {
                                    String tempStr = privateDir + "/" + fi.filename;
                                    out = new FileOutputStream(tempStr, true);
                                    out.write(data, 0, currentLen);
                                    out.flush();
                                    out.close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    tfile.delete();
                                    fi.state = 0;
                                    fi.csize = 0;
                                    SCAutoUpdate.this.ReWriteConfigInfo(privateDir + "/update_s.xml");
                                    return StringUtil.getStringRes(context, R.string.write_upgrade_file_error);
                                }
                                if (flag && tfile.exists()) {
                                    try {
                                        Runtime.getRuntime().exec("chmod 644 " + privateDir + "/" + fi.filename);
                                        flag = false;
                                    }
                                    catch (Exception e) {
                                        flag = true;
                                        e.printStackTrace();
                                    }
                                }
                                if (fi.csize >= fi.filesize) {
                                    fi.state = 2;
                                    SCAutoUpdate.this.ReWriteConfigInfo(privateDir + "/update_s.xml");
                                    try {
                                        String Code = SCAutoUpdate.getHash(privateDir + "/" + fi.filename, "MD5");
                                        if (!Code.equals(fi.checkCode)) {
                                            tfile.delete();
                                            file2.delete();
                                            return StringUtil.getStringRes(context, R.string.verify_failed_redownload);
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    break;
                                }
                                fi.state = 1;
                                SCAutoUpdate.this.ReWriteConfigInfo(privateDir + "/update_s.xml");
                            }
                            if (Compatibility.isZhengZhouShiju()) {
                                Intent intent = new Intent("android.intent.action.VIEW");
                                intent.setFlags(0x10000000);
                                intent.setDataAndType(Uri.fromFile((File)new File(privateDir + "/" + fi.filename)), "application/vnd.android.package-archive");
                                context.startActivity(intent);
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                SCAutoUpdate.this.ReWriteConfigInfo(privateDir + "/update_s.xml");
                return StringUtil.getStringRes(context, R.string.network_error);
            }
        }
    }

    private class GetFileTask
    extends AsyncTask<String, Integer, String> {
        private ProgressDialog pDialog = null;

        private GetFileTask() {
        }

        protected void onPreExecute() {
            if (context == null) {
                if (sl != null) {
                    sl.close();
                    sl = null;
                }
                return;
            }
            this.pDialog = new ProgressDialog(context);
            this.pDialog.setProgressStyle(1);
            if (updatetag.equals("0")) {
                this.pDialog.setTitle((CharSequence)StringUtil.getStringRes(context, R.string.alert));
                this.pDialog.setMessage((CharSequence)context.getString(R.string.downloading_wait));
            } else {
                this.pDialog.setTitle((CharSequence)StringUtil.getStringRes(context, R.string.alert));
                this.pDialog.setMessage((CharSequence)StringUtil.getStringRes(context, R.string.downloading_wait));
            }
            if (updatetag.equals("0")) {
                this.pDialog.setButton((CharSequence)StringUtil.getStringRes(context, R.string.negative), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int i) {
                        dialog.cancel();
                        if (sl != null) {
                            sl.close();
                            sl = null;
                        }
                    }
                });
            }
            this.pDialog.setMax(100);
            this.pDialog.setIndeterminate(false);
            this.pDialog.setCancelable(false);
            this.pDialog.show();
        }

        protected void onPostExecute(String obj) {
            String result;
            this.pDialog.dismiss();
            if (sl != null) {
                sl.close();
                sl = null;
            }
            if ((result = obj) != null) {
                try {
                    if (context == null) {
                        if (sl != null) {
                            sl.close();
                            sl = null;
                        }
                        return;
                    }
                    AlertDialog alert = new AlertDialog.Builder(context).setTitle((CharSequence)StringUtil.getStringRes(context, R.string.alert)).setMessage(R.string.download_failed).setNeutralButton((CharSequence)StringUtil.getStringRes(context, R.string.positive), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dlg, int which) {
                        }
                    }).create();
                    alert.setCancelable(false);
                    alert.show();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(e.getMessage());
                }
            } else {
                int fileListNum = fileList.size();
                for (int i = 0; i < fileListNum; ++i) {
                    if (i != fileListNum - 1) {
                        return;
                    }
                    final SCFileInfo fi = (SCFileInfo)fileList.get(i);
                    if (updatetag.equals("0")) {
                        if (context == null) {
                            if (sl == null) continue;
                            sl.close();
                            sl = null;
                            continue;
                        }
                        AlertDialog dialog = new AlertDialog.Builder(context).setTitle((CharSequence)StringUtil.getStringRes(context, R.string.alert)).setMessage(R.string.upgrade_choice).setPositiveButton((CharSequence)StringUtil.getStringRes(context, R.string.upgrade), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                Intent intent = new Intent("android.intent.action.VIEW");
                                intent.setFlags(0x10000000);
                                intent.setDataAndType(Uri.fromFile((File)new File(privateDir + "/" + fi.filename)), "application/vnd.android.package-archive");
                                context.startActivity(intent);
                            }
                        }).setNegativeButton(R.string.upgrade_later, new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                            }
                        }).setNeutralButton(R.string.delete_file, new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                AlertDialog dia = new AlertDialog.Builder(context).setTitle((CharSequence)StringUtil.getStringRes(context, R.string.alert)).setMessage(R.string.delete_upgrade_file_or_not).setPositiveButton((CharSequence)StringUtil.getStringRes(context, R.string.positive), new DialogInterface.OnClickListener(){

                                    public void onClick(DialogInterface dialog, int which) {
                                        File file = new File(privateDir + "/" + fi.filename);
                                        file.delete();
                                        dialog.dismiss();
                                    }
                                }).setNegativeButton((CharSequence)StringUtil.getStringRes(context, R.string.negative), new DialogInterface.OnClickListener(){

                                    public void onClick(DialogInterface dialog, int whichButton) {
                                        dialog.dismiss();
                                    }
                                }).create();
                                dia.show();
                                dia.setCancelable(false);
                            }
                        }).create();
                        dialog.setCancelable(false);
                        try {
                            Activity activity = (Activity)context;
                            if (activity.isFinishing()) continue;
                            dialog.show();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setFlags(0x10000000);
                    intent.setDataAndType(Uri.fromFile((File)new File(privateDir + "/" + fi.filename)), "application/vnd.android.package-archive");
                    context.startActivity(intent);
                }
                File file = new File(privateDir + "/update_s.xml");
                file.delete();
                SCVersionInfo ver = new SCVersionInfo();
                ver.version = version;
                ver.date = date;
                ver.note = comment;
                verList.add(ver);
                SCAutoUpdate.ReWriteVersionInfo(privateDir + "/ClientVer.xml");
            }
        }

        protected void onProgressUpdate(Integer ... values) {
            this.pDialog.setProgress(values[0].intValue());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected String doInBackground(String ... params) {
            try {
                int fileListNum;
                int nres = -1;
                if (updatetag.equals("0")) {
                    if (serverIP.equals("")) {
                        return StringUtil.getStringRes(context, R.string.update_module_server_address_empty);
                    }
                    if (serverPort.equals("")) {
                        return StringUtil.getStringRes(context, R.string.update_module_server_port_empty);
                    }
                    String hostIP = SCAutoUpdate.getHostAddress(serverIP);
                    if (hostIP == null) {
                        return StringUtil.getStringRes(context, R.string.update_module_host_error);
                    }
                    sl = new SCUpdateSocket(hostIP, Integer.parseInt(serverPort));
                    nres = sl.connect();
                    if (nres != 0) {
                        sl = null;
                        SCAutoUpdate.this.ReWriteConfigInfo(privateDir + "/update_s.xml");
                        return context.getString(R.string.connect_update_server_failed);
                    }
                }
                if ((fileListNum = fileList.size()) == 0) {
                    File file = new File(privateDir + "/update_s.xml");
                    file.delete();
                    return context.getString(R.string.all_file_newest);
                }
                int i = 0;
                while (true) {
                    block40: {
                        File file;
                        if (i >= fileListNum) {
                            return null;
                        }
                        SCFileInfo fi = (SCFileInfo)fileList.get(i);
                        if (i == fileListNum - 1) {
                            SharedPreferences.Editor share = context.getSharedPreferences("mxtchat", 0).edit();
                            share.putString("MainFileName", fi.filename);
                            share.putString("DeleteDb", fi.deleteDb);
                            share.commit();
                        }
                        if ((fi.csize == 0 || fi.csize == fi.filesize) && (file = new File(privateDir + "/" + fi.filename)).exists()) {
                            try {
                                String Code = SCAutoUpdate.getHash(privateDir + "/" + fi.filename, "MD5");
                                if (!Code.equals(fi.checkCode)) {
                                    file.delete();
                                    return context.getString(R.string.verify_failed_redownload);
                                }
                                return null;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (fi.csize >= fi.filesize) break block40;
                        File dF = new File(privateDir + "/" + fi.filename);
                        if (dF.exists() && dF.length() != (long)fi.csize) {
                            fi.csize = (int)dF.length();
                        }
                        StringBuffer getfile = new StringBuffer();
                        getfile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        getfile.append("<Root>");
                        getfile.append("<Req>getfile</Req>");
                        getfile.append("<RPath>" + fi.rpath + "</RPath>");
                        getfile.append("<LPath>" + fi.lpath + "</LPath>");
                        getfile.append("<FName>" + fi.filename + "</FName>");
                        getfile.append("<FSize>" + fi.filesize + "</FSize>");
                        getfile.append("<FPos>" + fi.csize + "</FPos>");
                        getfile.append("</Root>");
                        nres = sl.sendData(getfile.toString());
                        if (nres != 0) {
                            SCAutoUpdate.this.ReWriteConfigInfo(privateDir + "/update_s.xml");
                            return context.getString(R.string.upgrade_request_failed);
                        }
                        byte[] result = sl.recvData();
                        if (result == null) {
                            SCAutoUpdate.this.ReWriteConfigInfo(privateDir + "/update_s.xml");
                            return context.getString(R.string.receive_upgrade_param_timeout);
                        }
                        int res = SCAutoUpdate.this.ParseConfirmInfo(result);
                        boolean flag = true;
                        File file2 = new File(privateDir + "/update_s.xml");
                        File tfile = new File(privateDir + "/" + fi.filename);
                        switch (res) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                file2.delete();
                                return context.getString(R.string.file_not_exist);
                            }
                            case 2: {
                                file2.delete();
                                return context.getString(R.string.read_file_failed);
                            }
                            case 3: {
                                file2.delete();
                                return context.getString(R.string.file_size_unmatch);
                            }
                            case 4: {
                                file2.delete();
                                return context.getString(R.string.offset_invalid);
                            }
                            case 5: {
                                file2.delete();
                                return context.getString(R.string.param_unmatch);
                            }
                            default: {
                                break block40;
                            }
                        }
                        while (fi.csize < fi.filesize) {
                            byte[] data = new byte[fi.filesize - fi.csize];
                            int currentLen = 0;
                            try {
                                if (sl == null) {
                                    return context.getString(R.string.socket_close);
                                }
                                currentLen = SCAutoUpdate.sl.sin.read(data, 0, fi.filesize - fi.csize);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                return context.getString(R.string.receive_upgrade_data_timeout);
                            }
                            if (currentLen == -1) {
                                SCAutoUpdate.this.ReWriteConfigInfo(privateDir + "/update_s.xml");
                                return StringUtil.getStringRes(context, R.string.receive_upgrade_data_timeout);
                            }
                            fi.csize += currentLen;
                            this.publishProgress(new Integer[]{(int)((float)fi.csize / (float)fi.filesize * 100.0f)});
                            FileOutputStream out = null;
                            try {
                                String tempStr = privateDir + "/" + fi.filename;
                                out = new FileOutputStream(tempStr, true);
                                out.write(data, 0, currentLen);
                                out.flush();
                                out.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                tfile.delete();
                                fi.state = 0;
                                fi.csize = 0;
                                SCAutoUpdate.this.ReWriteConfigInfo(privateDir + "/update_s.xml");
                                return context.getString(R.string.write_upgrade_file_error);
                            }
                            if (flag && tfile.exists()) {
                                try {
                                    Runtime.getRuntime().exec("chmod 644 " + privateDir + "/" + fi.filename);
                                    flag = false;
                                }
                                catch (Exception e) {
                                    flag = true;
                                    e.printStackTrace();
                                }
                            }
                            if (fi.csize >= fi.filesize) {
                                fi.state = 2;
                                SCAutoUpdate.this.ReWriteConfigInfo(privateDir + "/update_s.xml");
                                try {
                                    String Code = SCAutoUpdate.getHash(privateDir + "/" + fi.filename, "MD5");
                                    if (!Code.equals(fi.checkCode)) {
                                        tfile.delete();
                                        file2.delete();
                                        return StringUtil.getStringRes(context, R.string.verify_failed_redownload);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                break;
                            }
                            fi.state = 1;
                            SCAutoUpdate.this.ReWriteConfigInfo(privateDir + "/update_s.xml");
                        }
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                SCAutoUpdate.this.ReWriteConfigInfo(privateDir + "/update_s.xml");
                return context.getString(R.string.network_error);
            }
        }
    }

    private class CheckVerTask
    extends AsyncTask<String, Integer, String> {
        private ProgressDialog pDialog = null;
        private boolean isShowDialog = false;

        public CheckVerTask(boolean isShowDialog) {
            Log.d(TAG, "CheckVerTask, isShowDialog = " + isShowDialog);
            this.isShowDialog = isShowDialog;
        }

        protected void onPreExecute() {
            Log.d(TAG, "onPreExecute, isShowDialog = " + this.isShowDialog);
            atomicInteger.incrementAndGet();
            if (this.isShowDialog) {
                this.pDialog = new ProgressDialog(context);
                this.pDialog.setProgressStyle(0);
                this.pDialog.setTitle((CharSequence)context.getString(R.string.connecting));
                this.pDialog.setMessage((CharSequence)context.getString(R.string.check_new_version));
                this.pDialog.setCancelable(false);
                this.pDialog.getWindow().setType(2003);
                this.pDialog.show();
            }
        }

        protected void onCancelled() {
            super.onCancelled();
            if (atomicInteger.get() != 0) {
                atomicInteger.decrementAndGet();
            }
        }

        protected String doInBackground(String ... params) {
            try {
                SCAutoUpdate.CreateVersionInfo(context, privateDir + "/ClientVer.xml");
                SCAutoUpdate.ParseVersionInfo(privateDir + "/ClientVer.xml");
                String verName = "";
                try {
                    verName = SCAutoUpdate.context.getPackageManager().getPackageInfo((String)SCAutoUpdate.context.getPackageName(), (int)0).versionName;
                }
                catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                }
                if (verList.size() > 0) {
                    SCVersionInfo vi = (SCVersionInfo)verList.get(verList.size() - 1);
                    if (!verName.equals(vi.version) && verList.size() > 1) {
                        verList.remove(verList.size() - 1);
                        SCAutoUpdate.ReWriteVersionInfo(privateDir + "/ClientVer.xml");
                    }
                }
                StringBuffer checkVer = new StringBuffer();
                checkVer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                checkVer.append("<Root>");
                checkVer.append("<Req>checkver</Req>");
                checkVer.append("<Factory>" + factory + "</Factory>");
                checkVer.append("<Mod>" + mod + "</Mod>");
                checkVer.append("<OS>" + os + "</OS>");
                checkVer.append("<Soft>" + soft + "</Soft>");
                checkVer.append("<Version>" + verName + "</Version>");
                checkVer.append("<UserName>" + username + "</UserName>");
                checkVer.append("</Root>");
                if (serverIP.equals("")) {
                    return context.getString(R.string.update_module_server_address_empty);
                }
                if (serverPort.equals("")) {
                    return context.getString(R.string.update_module_server_port_empty);
                }
                String hostIP = SCAutoUpdate.getHostAddress(serverIP);
                if (hostIP == null) {
                    return context.getString(R.string.update_module_host_error);
                }
                sl = new SCUpdateSocket(hostIP, Integer.parseInt(serverPort));
                int nres = sl.connect();
                if (nres != 0) {
                    sl = null;
                    return context.getString(R.string.update_module_connect_server_error);
                }
                nres = sl.sendData(checkVer.toString());
                if (nres != 0) {
                    return context.getString(R.string.update_module_send_data_failed);
                }
                byte[] result = sl.recvData();
                if (result == null) {
                    return context.getString(R.string.receive_data_time_out);
                }
                nres = SCAutoUpdate.this.ParseConfirmInfo(result);
                switch (nres) {
                    case 0: {
                        result = sl.recvData();
                        if (result == null) {
                            return "\u63a5\u6536\u5347\u7ea7\u914d\u7f6e\u4fe1\u606f\u8d85\u65f6";
                        }
                        new File(privateDir + "/update_temp.xml").delete();
                        if (new File(privateDir + "/update_s.xml").exists()) {
                            SCUpdateFunc.WriteFile(privateDir + "/update_temp.xml", result, false);
                            break;
                        }
                        SCUpdateFunc.WriteFile(privateDir + "/update_s.xml", result, false);
                        break;
                    }
                    case 1: {
                        return context.getString(R.string.all_file_newest);
                    }
                    case 2: {
                        return context.getString(R.string.no_config);
                    }
                    case 3: {
                        return context.getString(R.string.search_upgrade_config_failed);
                    }
                    case 4: {
                        return context.getString(R.string.upgrade_config_file_not_exist);
                    }
                    case -1: {
                        return context.getString(R.string.read_upgrade_info_failed);
                    }
                }
                return null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return context.getString(R.string.unknown_error);
            }
        }

        protected void onPostExecute(String result) {
            atomicInteger.decrementAndGet();
            if (context instanceof Activity) {
                if (((Activity)context).isFinishing() || ((Activity)context).isDestroyed()) {
                    Log.i(TAG, "log----------activity is destroyed");
                } else if (this.pDialog != null) {
                    this.pDialog.dismiss();
                }
            }
            if (result != null) {
                if (!isMainActivity) {
                    if (this.isShowDialog) {
                        Toast.makeText((Context)context, (CharSequence)result, (int)0).show();
                    } else {
                        Log.d(TAG, "CheckVerTask, result = " + result);
                    }
                } else {
                    Log.d(TAG, "main act without tips");
                    isMainActivity = false;
                }
            } else {
                File file = new File(privateDir + "/update_s.xml");
                File temfile = new File(privateDir + "/update_temp.xml");
                boolean res = SCAutoUpdate.ParseConfigInfo("update_s.xml");
                if (!res) {
                    file.delete();
                    return;
                }
                if (temfile.exists()) {
                    if (SCAutoUpdate.this.ParseTempInfo("update_temp.xml")) {
                        if (!SCAutoUpdate.this.tempversion.equals(version)) {
                            File tfile;
                            file.delete();
                            SharedPreferences sharePre = context.getSharedPreferences("mxtchat", 0);
                            String fname = sharePre.getString("MainFileName", "");
                            if (!fname.equals("") && (tfile = new File(privateDir + "/" + fname)).exists()) {
                                tfile.delete();
                            }
                            temfile.renameTo(file);
                            boolean r = SCAutoUpdate.ParseConfigInfo("update_s.xml");
                            if (!r) {
                                file.delete();
                                return;
                            }
                        } else {
                            temfile.delete();
                        }
                    } else {
                        temfile.delete();
                        return;
                    }
                }
                if (context == null) {
                    if (sl != null) {
                        sl.close();
                        sl = null;
                    }
                    return;
                }
                if (updatetag.equals("0") || !this.isShowDialog) {
                    if (sl != null) {
                        sl.close();
                        sl = null;
                    }
                    if (this.isShowDialog) {
                        SCAutoUpdate.this.doNewVersionUpdate();
                    } else {
                        SCAutoUpdate.this.doNewVersionUpdateSilence();
                    }
                } else {
                    SCAutoUpdate.this.doNewVersionForceUpdate();
                }
            }
        }
    }
}

