/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.key.contentprovider;

import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import com.xdja.SafeKey.XDJA_SM2_PARAM;
import com.xdja.safeclient.MyApplication;

public class ContentProviderKey {
    private static final String MAIN_PACKAGE = "com.xdja.safeclient";
    private static final String AUTOHORITY = "com.xdja.providers.safetfprovider";
    private static final Uri URI = Uri.parse((String)"content://com.xdja.providers.safetfprovider");
    private static final String METHOD_VERIFYPIN = "verifyPIN";
    private static final String METHOD_GETSAFECARDID = "getSafeCardID";
    private static final String METHOD_RSAPRIKEYCALC = "rsaPriKeyCalc";
    private static final String METHOD_SM2SIGN = "sm2Sign";
    private static final String METHOD_GET_SM2_PARAM = "getSM2Param";
    private static final String METHOD_GET_SM2_ID = "getSM2ID";
    private static final String METHOD_READ_DEFAULT_CERT = "readDefaultCert";
    private Context mContext = MyApplication.myApplication.getApplicationContext();
    private ContentResolver contentResolver = this.mContext.getContentResolver();
    private static ContentProviderKey instance = null;
    private static final String THIS_FILE = "ContentProviderKey";

    private ContentProviderKey() {
    }

    public static ContentProviderKey getInstance() {
        if (instance == null) {
            instance = new ContentProviderKey();
        }
        return instance;
    }

    public boolean checkProvider() {
        if (this.mContext.getPackageName().equals(MAIN_PACKAGE)) {
            Log.d((String)THIS_FILE, (String)"This is main package.");
            return false;
        }
        ContentProviderClient client = this.contentResolver.acquireContentProviderClient(URI);
        if (client != null) {
            Log.d((String)THIS_FILE, (String)"client != null");
            client.release();
            return true;
        }
        Log.e((String)THIS_FILE, (String)"client == null");
        return false;
    }

    public int verifyPIN(int role, byte[] pin) {
        Bundle bundle = new Bundle();
        bundle.putString("pin", new String(pin));
        try {
            Bundle result = this.contentResolver.call(URI, METHOD_VERIFYPIN, null, bundle);
            return result.getInt("ret");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return -200;
        }
    }

    public int getCardID(byte[] cardId, int[] len) {
        try {
            Bundle result = this.contentResolver.call(URI, METHOD_GETSAFECARDID, null, null);
            if (result != null) {
                String cardStr = result.getString("result");
                len[0] = cardStr.length();
                System.arraycopy(cardStr.getBytes(), 0, cardId, 0, len[0]);
                return 0;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return -200;
        }
        return 0;
    }

    public int readSignCert(byte[] cert, int[] certlen) {
        int ret = -1;
        try {
            Bundle result = this.contentResolver.call(URI, METHOD_READ_DEFAULT_CERT, null, null);
            if (result != null) {
                byte[] certOut;
                ret = result.getInt("ret");
                if (ret == 0 && (certOut = result.getByteArray("result")) != null) {
                    System.arraycopy(certOut, 0, cert, 0, certOut.length);
                    certlen[0] = certOut.length;
                }
                return ret;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return -200;
        }
        return 0;
    }

    public int RSAPrikeyCalc(int bits, byte[] data, int size, byte[] out, int[] outSize) {
        Bundle bundle = new Bundle();
        Log.d((String)THIS_FILE, (String)"Get into RSA PRIKEY CALC");
        bundle.putInt("bits", bits);
        bundle.putByteArray("datain", data);
        bundle.putInt("inlen", size);
        try {
            Bundle result = this.contentResolver.call(URI, METHOD_RSAPRIKEYCALC, null, bundle);
            if (result != null) {
                int ret = result.getInt("ret");
                if (ret == 0) {
                    byte[] tmp = result.getByteArray("result");
                    outSize[0] = tmp.length;
                    System.arraycopy(tmp, 0, out, 0, tmp.length);
                }
                return ret;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return -200;
        }
        return -200;
    }

    public int SM2Sign(int isHashed, byte[] dataIn, int inLen, byte[] signData, int[] signDataLen) {
        Bundle bundle = new Bundle();
        bundle.putInt("ishashed", isHashed);
        bundle.putByteArray("datain", dataIn);
        bundle.putInt("inlen", inLen);
        try {
            Bundle result = this.contentResolver.call(URI, METHOD_SM2SIGN, null, bundle);
            if (result != null) {
                int ret = result.getInt("ret");
                if (ret == 0) {
                    byte[] tmp = result.getByteArray("result");
                    signDataLen[0] = tmp.length;
                    System.arraycopy(tmp, 0, signData, 0, tmp.length);
                }
                return ret;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return -200;
        }
        return -200;
    }

    public int getSM2Param(XDJA_SM2_PARAM sm2Param) {
        try {
            Bundle result = this.contentResolver.call(URI, METHOD_GET_SM2_PARAM, null, null);
            if (result != null) {
                result.setClassLoader(XDJA_SM2_PARAM.class.getClassLoader());
                int ret = result.getInt("ret");
                if (ret == 0) {
                    XDJA_SM2_PARAM xdja_sm2_param = (XDJA_SM2_PARAM)result.getParcelable("result");
                    System.arraycopy(xdja_sm2_param.p, 0, sm2Param.p, 0, 32);
                    System.arraycopy(xdja_sm2_param.a, 0, sm2Param.a, 0, 32);
                    System.arraycopy(xdja_sm2_param.b, 0, sm2Param.b, 0, 32);
                    System.arraycopy(xdja_sm2_param.n, 0, sm2Param.n, 0, 32);
                    System.arraycopy(xdja_sm2_param.x, 0, sm2Param.x, 0, 32);
                    System.arraycopy(xdja_sm2_param.y, 0, sm2Param.y, 0, 32);
                }
                return ret;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return -200;
        }
        return -200;
    }

    public int getSM2ID(byte[] id, int[] len) {
        Log.d((String)THIS_FILE, (String)"Get into get sm2 id method.");
        try {
            Bundle result = this.contentResolver.call(URI, METHOD_GET_SM2_ID, null, null);
            if (result != null) {
                int ret = result.getInt("ret");
                if (ret == 0) {
                    int idlen;
                    byte[] idbuf = result.getByteArray("id");
                    len[0] = idlen = result.getInt("len");
                    System.arraycopy(idbuf, 0, id, 0, idlen);
                }
                Log.d((String)THIS_FILE, (String)("Get sm2 id ret " + ret));
                return ret;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return -200;
        }
        return -200;
    }

    public static class StatusCode {
        public static final int SUCCESS = 0;
        public static final int CALL_PROVIDER_FAILED = -200;
    }
}

