/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.telephony.TelephonyManager;
import android.widget.Toast;
import com.orhanobut.logger.LogLevel;
import com.orhanobut.logger.Logger;
import com.safetf.SafeTF;
import com.squareup.otto.Subscribe;
import com.xdja.safeclient.CrashHandler;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.GuardianHelper;
import com.xdja.safeclient.R;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.bean.SafeVerifyStageInfo;
import com.xdja.safeclient.bean.UpgradeVersionInfo;
import com.xdja.safeclient.config.PropertiesConfig;
import com.xdja.safeclient.config.SslClientConfig;
import com.xdja.safeclient.config.UpgradeConfig;
import com.xdja.safeclient.event.EventManager;
import com.xdja.safeclient.ottoobj.ExitAppEvent;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.LocaleUtil;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.OttoUtil;
import com.xdja.safeclient.utils.SharedPreferencesUtil;
import com.xdja.safeclient.utils.StringUtil;
import com.xdja.safeclient.wrapper.QuitWrapper;
import com.xdja.sslvpn.SSLVPN;
import com.xdja.third.emm.EmmServcieCallback;
import com.xdja.third.emm.SecManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MyApplication
extends Application
implements EmmServcieCallback {
    public static final boolean isDebug = false;
    public static final String LOG_TAG = "SafeClient";
    public String curVersion = "";
    public String env_flag = "";
    public String mobile_os = "";
    public String channel_type = "";
    public String firewall = "";
    public String close_wifi = "";
    public String close_bluetooth = "";
    public boolean isWeakPassWD = true;
    public SslClientConfig sslClientConfig = null;
    public UpgradeConfig upgradeConfig = null;
    public SSLVPN sslvpn = null;
    public Activity topActivity = null;
    public List<Activity> activityList = null;
    public PropertiesConfig propertiesConfig = null;
    public static final int ANDROID_4_4_VERSION = 19;
    public static String packageName = "";
    String g_DevPath = "";
    public static final int OPEN_DEV_AUTO = 1;
    public static final int OPEN_DEV_BY_PATH = 2;
    public static int devOpenFlag = 0;
    public static MyApplication myApplication = null;
    public int disableFlag = 1;
    public static boolean selfStartFlag = false;
    public static boolean rememberPin = false;
    public static final String TAG = "MyApplication";
    public static BluetoothAdapter bluetoothAdapter = null;
    private Handler handler = new Handler(Looper.getMainLooper());
    private static final int SIM_VALID = 0;
    private static final int SIM_INVALID = -1;
    private static int simState = -1;
    BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action;
            switch (action = intent.getAction()) {
                case "android.intent.action.SIM_STATE_CHANGED": {
                    TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                    int prevState = simState;
                    simState = tm.getSimState();
                    Log.d(MyApplication.TAG, "sim state changed.Current state " + simState);
                    EventManager.getInstance().onSimStateChanged(prevState, simState);
                    break;
                }
                case "android.net.conn.CONNECTIVITY_CHANGE": {
                    ConnectivityManager cm;
                    NetworkInfo info;
                    Log.d(MyApplication.TAG, "network state has changed");
                    MyApplication mapp = myApplication;
                    if (mapp.sslvpn != null) {
                        mapp.sslvpn.guardianLearn(GuardianHelper.guardian_option.G_OPT_NETWORK_SWITCHED.ordinal(), GuardianHelper.getNetWorkType(context).ordinal());
                    }
                    if ((info = (cm = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null && info.isConnected()) {
                        if (mapp.sslvpn == null) break;
                        mapp.sslvpn.notifyNetworkReconnect(1);
                        break;
                    }
                    if (!Function.isVPNConnected()) break;
                    if (0 == MyApplication.myApplication.sslClientConfig.transportMode) {
                        VpnService.errorState = StringUtil.getStringRes((Context)myApplication, R.string.check_network);
                        SafeVerifyStageInfo stageInfo = new SafeVerifyStageInfo();
                        stageInfo.name = StringUtil.getStringRes((Context)myApplication, R.string.safe_verify);
                        stageInfo.error = VpnService.errorState;
                        stageInfo.result = StringUtil.getStringRes((Context)myApplication, R.string.fail);
                        VpnService.sslStageList.add(stageInfo);
                        break;
                    }
                    TunVpnService.errorState = StringUtil.getStringRes((Context)myApplication, R.string.check_network);
                    SafeVerifyStageInfo stageInfo = new SafeVerifyStageInfo();
                    stageInfo.name = StringUtil.getStringRes((Context)myApplication, R.string.safe_verify);
                    stageInfo.error = TunVpnService.errorState;
                    stageInfo.result = StringUtil.getStringRes((Context)myApplication, R.string.fail);
                    TunVpnService.sslStageList.add(stageInfo);
                    break;
                }
                case "com.xdja.safeclient.EXIT_TUN_CLIENT": {
                    if (!MyApplication.this.getPackageName().equals("com.xdja.safeclient.tun") || MyApplication.this.propertiesConfig.hasProviderKey() != 1) break;
                    Log.d(MyApplication.TAG, "Forward client cover card not avalible, exit tun client!!");
                    Function.stopVPN((Context)myApplication);
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            Function.exitApp((Context)myApplication);
                        }
                    }, 2000L);
                }
            }
        }
    };

    public Handler getHandler() {
        return this.handler;
    }

    private String getSelfProcessName() {
        String processName = "";
        int pid = Process.myPid();
        ActivityManager am = (ActivityManager)this.getSystemService("activity");
        List list = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo info : list) {
            if (info.pid != pid) continue;
            processName = info.processName;
        }
        return processName;
    }

    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        String processName = this.getSelfProcessName();
        if (!processName.equals(base.getPackageName())) {
            return;
        }
        myApplication = this;
        packageName = myApplication.getPackageName();
        Compatibility.initAreaVersion();
        Log.e(TAG, "CurrentVersion" + Compatibility.getAreaVersion());
        packageName = this.getPackageName();
        try {
            this.curVersion = this.getPackageManager().getPackageInfo((String)this.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d(TAG, "Get app version failed." + e.getMessage());
        }
        this.dealAssetsFile();
        this.sslClientConfig = new SslClientConfig();
        this.readSslclientConfigFile();
        this.loadProperties();
        Log.e(TAG, "Call init key module int application");
    }

    private void registerRecievers() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SIM_STATE_CHANGED");
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        filter.addAction("com.xdja.safeclient.EXIT_TUN_CLIENT");
        this.registerReceiver(this.broadcastReceiver, filter);
    }

    private void unregisterRecievers() {
        if (this.broadcastReceiver != null) {
            this.unregisterReceiver(this.broadcastReceiver);
        }
    }

    public void onTerminate() {
        this.unregisterRecievers();
        super.onTerminate();
    }

    private void loadProperties() {
        String propertiesPath = "conf.properties";
        InputStream in = null;
        try {
            in = this.getResources().getAssets().open(propertiesPath);
            this.propertiesConfig = new PropertiesConfig(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkAppReplacingState() {
        if (this.getResources() == null) {
            Process.killProcess((int)Process.myPid());
        }
    }

    public void onCreate() {
        super.onCreate();
        String processName = this.getSelfProcessName();
        if (!processName.equals(this.getPackageName())) {
            return;
        }
        this.checkAppReplacingState();
        QuitWrapper.resetHasBeenQuit((Context)this);
        Log.d(TAG, "application INIT");
        OttoUtil.register(this);
        this.initLogger();
        if (LocaleUtil.autoChoose((Context)this)) {
            SSLVPN.setLocale(Locale.getDefault());
        } else {
            Locale locale = LocaleUtil.getCurrent((Context)this);
            if (locale != null) {
                SSLVPN.setLocale(locale);
            }
        }
        File pageInternal = this.getFilesDir();
        String internalFilesDir = "/data/data/com.xdja.safeclient/files/";
        if (pageInternal != null) {
            internalFilesDir = pageInternal.getPath();
            Log.d(TAG, "getFilesDir = " + internalFilesDir);
        }
        this.env_flag = this.getResources().getString(R.string.env_flag);
        this.mobile_os = this.getResources().getString(R.string.mobile_os);
        this.channel_type = this.getResources().getString(R.string.channel_type);
        this.firewall = this.getResources().getString(R.string.firewall);
        this.close_wifi = this.getResources().getString(R.string.close_wifi);
        this.close_bluetooth = this.getResources().getString(R.string.close_bluetooth);
        this.activityList = new ArrayList<Activity>();
        this.sslClientConfig.setPrivDir(internalFilesDir.getBytes());
        this.sslClientConfig.setSdkVersion(Build.VERSION.SDK_INT);
        this.sslClientConfig.setDevPath("".getBytes());
        this.sslClientConfig.setDevOpenFlag(devOpenFlag);
        this.upgradeConfig = new UpgradeConfig();
        this.readUpgradeConfigFile();
        this.initDevState();
        File page = this.getExternalFilesDir(null);
        if (page != null) {
            String extFilePath = page.getAbsolutePath();
            CrashHandler crashHandler = CrashHandler.getInstance();
            crashHandler.init(this.getApplicationContext(), extFilePath + "/crash");
        }
        Function.setSafeVpnState(this.getApplicationContext(), false);
        Function.setSafeTunVpnState(this.getApplicationContext(), false);
        if (Compatibility.getAreaVersion() == 10000) {
            SecManager.getInstance().initServer((Context)this, this);
            this.checkDevAdmin();
        }
        bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        SSLVPN.initVPN(this.getPackageName(), this.getFilesDir().getPath(), 0, Compatibility.needBindAllIP() ? 1 : 0, this.propertiesConfig.getDisablePublicNetwork());
        this.registerRecievers();
    }

    public void checkDevAdmin() {
        Intent intent = new Intent();
        intent.setAction("com.xdja.emm.InitService");
        intent.setPackage("com.xdja.emm");
        this.startService(intent);
    }

    public String getDevPath() {
        this.getExternalFilesDir(null);
        int handle = 0;
        Log.d(TAG, "getDevPath()");
        SafeTF tf = new SafeTF();
        if (Build.VERSION.SDK_INT >= 19) {
            ArrayList<String> devList = null;
            String devpath = "";
            this.g_DevPath = "";
            devList = Function.findSdcardPrivatePath(Compatibility.getTFPackage((Context)this));
            for (int i = 0; i < devList.size(); ++i) {
                devpath = devList.get(i) + "/";
                Log.d(TAG, "devpath = " + devpath);
                handle = tf.OpenSTFCard(devpath);
                if (0 != handle) {
                    this.g_DevPath = devpath;
                    Log.d(TAG, "OpenSTFCard success, g_DevPath = " + this.g_DevPath);
                    devOpenFlag = 2;
                    tf.CloseSTFCard(handle);
                    return this.g_DevPath;
                }
                devOpenFlag = 0;
                Log.d(TAG, "OpenSTFCard failed,handle = " + handle);
            }
        }
        return "";
    }

    public void initDevState() {
        int blueState;
        BluetoothAdapter bluetooth;
        int wifiState;
        this.disableFlag = 1;
        WifiManager wifi = (WifiManager)this.getSystemService("wifi");
        if (wifi != null && (2 == (wifiState = wifi.getWifiState()) || 3 == wifiState) && this.propertiesConfig.getmDisableWifi() == 1) {
            wifi.setWifiEnabled(false);
            Log.d(TAG, "setWifiEnabled(false)");
        }
        if ((bluetooth = BluetoothAdapter.getDefaultAdapter()) != null && (11 == (blueState = bluetooth.getState()) || 12 == blueState) && this.propertiesConfig.getmDisableBluetoolth() == 1) {
            try {
                bluetooth.disable();
                Log.d(TAG, "bluetooth.disable");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSslclientConfigFile() {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        String privatePath = "";
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            privatePath = this.getFilesDir().getPath();
            FileInputStream in = new FileInputStream(privatePath + "/config.xml");
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("CONFIGINFO");
            if (nodeList != null && nodeList.getLength() > 0) {
                Element elt = (Element)nodeList.item(0);
                Node eltTransportMode = elt.getElementsByTagName("TRANSPORTMODE").item(0);
                if (eltTransportMode == null || eltTransportMode.getFirstChild() == null) {
                    Toast.makeText((Context)this, (int)R.string.config_error_trans_mode_empty, (int)0).show();
                    return;
                }
                Node eltCertMode = elt.getElementsByTagName("CERTMODE").item(0);
                if (eltCertMode == null || eltCertMode.getFirstChild() == null) {
                    Toast.makeText((Context)this, (int)R.string.config_error_cert_empty, (int)0).show();
                    return;
                }
                Node eltGatewayIp = elt.getElementsByTagName("GATEWAYIP").item(0);
                if (eltGatewayIp == null || eltGatewayIp.getFirstChild() == null) {
                    Toast.makeText((Context)this, (int)R.string.config_error_gateway1_address_empty, (int)0).show();
                    return;
                }
                Node eltGatewayIp2 = elt.getElementsByTagName("GATEWAYIP2").item(0);
                Node eltGatewayIp3 = elt.getElementsByTagName("GATEWAYIP3").item(0);
                Node eltGatewayPort = elt.getElementsByTagName("GATEWAYPORT").item(0);
                if (eltGatewayPort == null || eltGatewayPort.getFirstChild() == null) {
                    Toast.makeText((Context)this, (int)R.string.config_error_gateway_port_empty, (int)0).show();
                    return;
                }
                Node eltCipherSuit = elt.getElementsByTagName("CIPHERSUITE").item(0);
                if (eltCipherSuit == null || eltCipherSuit.getFirstChild() == null) {
                    Toast.makeText((Context)this, (int)R.string.config_error_cipher_suite_empty, (int)0).show();
                    return;
                }
                Node eltConnectTimeout = elt.getElementsByTagName("CONNECTTIMEOUT").item(0);
                if (eltConnectTimeout == null || eltConnectTimeout.getFirstChild() == null) {
                    Toast.makeText((Context)this, (int)R.string.config_error_connect_timeout_empty, (int)0).show();
                    return;
                }
                Node eltRetryConnectCount = elt.getElementsByTagName("RETRYCONNECTCOUNT").item(0);
                if (eltRetryConnectCount == null || eltRetryConnectCount.getFirstChild() == null) {
                    Toast.makeText((Context)this, (int)R.string.config_error_reconnect_count_empty, (int)0).show();
                    return;
                }
                Node eltRole = elt.getElementsByTagName("ROLE").item(0);
                if (eltRole == null || eltRole.getFirstChild() == null) {
                    Toast.makeText((Context)this, (int)R.string.config_error_role_empty, (int)0).show();
                    return;
                }
                Node eltPrivatePort = elt.getElementsByTagName("PRIVATEPORT").item(0);
                if (eltPrivatePort == null || eltPrivatePort.getFirstChild() == null) {
                    Toast.makeText((Context)this, (int)R.string.config_error_private_port_empty, (int)0).show();
                    return;
                }
                Node eltCertId = elt.getElementsByTagName("CERTID").item(0);
                if (eltCertId == null || eltCertId.getFirstChild() == null) {
                    Toast.makeText((Context)this, (int)R.string.config_error_cert_id_empty, (int)0).show();
                    return;
                }
                Node eltPubkeyId = elt.getElementsByTagName("PUBKEYID").item(0);
                if (eltPubkeyId == null || eltPubkeyId.getFirstChild() == null) {
                    Toast.makeText((Context)this, (int)R.string.config_error_pubkey_id_empty, (int)0).show();
                    return;
                }
                Node eltPrikeyId = elt.getElementsByTagName("PRIKEYID").item(0);
                if (eltPrikeyId == null || eltPrikeyId.getFirstChild() == null) {
                    Toast.makeText((Context)this, (int)R.string.config_error_prikey_id_empty, (int)0).show();
                    return;
                }
                Node eltLogSwitch = elt.getElementsByTagName("LOGSWITCH").item(0);
                if (eltLogSwitch == null || eltLogSwitch.getFirstChild() == null) {
                    Toast.makeText((Context)this, (int)R.string.config_error_log_switch_empty, (int)0).show();
                    return;
                }
                Node eltLogLevel = elt.getElementsByTagName("LOGLEVEL").item(0);
                if (eltLogLevel == null || eltLogLevel.getFirstChild() == null) {
                    Toast.makeText((Context)this, (int)R.string.config_error_log_level_empty, (int)0).show();
                    return;
                }
                Node eltLogFileSize = elt.getElementsByTagName("LOGFILESIZE").item(0);
                if (eltLogFileSize == null || eltLogFileSize.getFirstChild() == null) {
                    Toast.makeText((Context)this, (int)R.string.config_error_log_size_empty, (int)0).show();
                    return;
                }
                Node eltMixNum = elt.getElementsByTagName("MIXNUM").item(0);
                if (eltMixNum == null || eltMixNum.getFirstChild() == null) {
                    Toast.makeText((Context)this, (int)R.string.config_error_mix_num_empty, (int)0).show();
                    return;
                }
                Node eltMixDeno = elt.getElementsByTagName("MIXDENO").item(0);
                if (eltMixDeno == null || eltMixDeno.getFirstChild() == null) {
                    Toast.makeText((Context)this, (int)R.string.config_error_mix_deno_empty, (int)0).show();
                    return;
                }
                Node eltAclVersion = elt.getElementsByTagName("ACLVERSION").item(0);
                if (eltAclVersion == null || eltAclVersion.getFirstChild() == null) {
                    Toast.makeText((Context)this, (int)R.string.config_error_acl_version_empty, (int)0).show();
                    return;
                }
                String transportMode = eltTransportMode.getFirstChild().getNodeValue();
                String certMode = eltCertMode.getFirstChild().getNodeValue();
                String gatewayIp = eltGatewayIp.getFirstChild().getNodeValue();
                String gatewayIp2 = null;
                gatewayIp2 = eltGatewayIp2 != null && eltGatewayIp2.getFirstChild() != null ? eltGatewayIp2.getFirstChild().getNodeValue() : gatewayIp;
                String gatewayIp3 = null;
                gatewayIp3 = eltGatewayIp3 != null && eltGatewayIp3.getFirstChild() != null ? eltGatewayIp3.getFirstChild().getNodeValue() : gatewayIp;
                String gatewayPort = eltGatewayPort.getFirstChild().getNodeValue();
                String cipherSuit = eltCipherSuit.getFirstChild().getNodeValue();
                String connectTimeout = eltConnectTimeout.getFirstChild().getNodeValue();
                String retryConnectCount = eltRetryConnectCount.getFirstChild().getNodeValue();
                String roleStr = eltRole.getFirstChild().getNodeValue();
                String certId = eltCertId.getFirstChild().getNodeValue();
                String pubkeyId = eltPubkeyId.getFirstChild().getNodeValue();
                String prikeyId = eltPrikeyId.getFirstChild().getNodeValue();
                String priPort = eltPrivatePort.getFirstChild().getNodeValue();
                String logSwitch = eltLogSwitch.getFirstChild().getNodeValue();
                String logLevel = eltLogLevel.getFirstChild().getNodeValue();
                String logFileSize = eltLogFileSize.getFirstChild().getNodeValue();
                String mixNum = eltMixNum.getFirstChild().getNodeValue();
                String mixDeno = eltMixDeno.getFirstChild().getNodeValue();
                String aclVerison = eltAclVersion.getFirstChild().getNodeValue();
                this.sslClientConfig.setTransportMode(Integer.parseInt(transportMode));
                this.sslClientConfig.setCertMode(Integer.parseInt(certMode));
                this.sslClientConfig.setGateWayIp(gatewayIp.getBytes());
                if (eltGatewayIp2 != null && eltGatewayIp2.getFirstChild() != null) {
                    this.sslClientConfig.setGateWayIp2(gatewayIp2.getBytes());
                }
                if (eltGatewayIp3 != null && eltGatewayIp3.getFirstChild() != null) {
                    this.sslClientConfig.setGateWayIp3(gatewayIp3.getBytes());
                }
                this.sslClientConfig.setGateWayPort(Integer.parseInt(gatewayPort));
                this.sslClientConfig.setCipherSuit(Integer.parseInt(cipherSuit));
                this.sslClientConfig.setConnectTimeOut(Integer.parseInt(connectTimeout));
                this.sslClientConfig.setRetryConnectCount(Integer.parseInt(retryConnectCount));
                this.sslClientConfig.setLogSwitch(Integer.parseInt(logSwitch));
                this.sslClientConfig.setLogLevel(Integer.parseInt(logLevel));
                this.sslClientConfig.setLogFileSize(Integer.parseInt(logFileSize));
                this.sslClientConfig.setMixNum(Integer.parseInt(mixNum));
                this.sslClientConfig.setMixDeno(Integer.parseInt(mixDeno));
                this.sslClientConfig.setAclVersion(Integer.parseInt(aclVerison));
                this.sslClientConfig.setRole(Integer.parseInt(roleStr));
                this.sslClientConfig.setPrivatePort(Integer.parseInt(priPort));
                byte[] byt_certId = new byte[2];
                byte[] byt_pubkeyId = new byte[2];
                byte[] byt_prikeyId = new byte[2];
                Function.Hex_Decode(certId.getBytes(), byt_certId, 2);
                Function.Hex_Decode(pubkeyId.getBytes(), byt_pubkeyId, 2);
                Function.Hex_Decode(prikeyId.getBytes(), byt_prikeyId, 2);
                this.sslClientConfig.setCertId(byt_certId);
                this.sslClientConfig.setPubkeyId(byt_pubkeyId);
                this.sslClientConfig.setPrikeyId(byt_prikeyId);
                String caPath = privatePath + "/ca.cer";
                this.sslClientConfig.setCaPath(caPath.getBytes());
            }
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
    }

    public void writeSslclientConfigFile() {
        StringBuffer configXml = new StringBuffer();
        configXml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        configXml.append("<Root>");
        configXml.append("<CONFIGINFO>");
        configXml.append("<TRANSPORTMODE>" + this.sslClientConfig.transportMode + "</TRANSPORTMODE>");
        configXml.append("<CERTMODE>" + this.sslClientConfig.certMode + "</CERTMODE>");
        configXml.append("<GATEWAYIP>" + new String(this.sslClientConfig.gateWayIp) + "</GATEWAYIP>");
        String gw2 = null;
        gw2 = this.sslClientConfig.gateWayIp2 == null ? "" : new String(this.sslClientConfig.gateWayIp2);
        String gw3 = null;
        gw3 = this.sslClientConfig.gateWayIp3 == null ? "" : new String(this.sslClientConfig.gateWayIp3);
        configXml.append("<GATEWAYIP2>" + gw2 + "</GATEWAYIP2>");
        configXml.append("<GATEWAYIP3>" + gw3 + "</GATEWAYIP3>");
        configXml.append("<GATEWAYPORT>" + this.sslClientConfig.gateWayPort + "</GATEWAYPORT>");
        configXml.append("<CIPHERSUITE>" + this.sslClientConfig.cipherSuit + "</CIPHERSUITE>");
        configXml.append("<CONNECTTIMEOUT>" + this.sslClientConfig.connectTimeOut + "</CONNECTTIMEOUT>");
        configXml.append("<RETRYCONNECTCOUNT>" + this.sslClientConfig.retryConnectCount + "</RETRYCONNECTCOUNT>");
        configXml.append("<ROLE>" + this.sslClientConfig.role + "</ROLE>");
        configXml.append("<PRIVATEPORT>" + this.sslClientConfig.privatePort + "</PRIVATEPORT>");
        String certId = String.format("%02x%02x", this.sslClientConfig.certId[0], this.sslClientConfig.certId[1]);
        String pubkeyId = String.format("%02x%02x", this.sslClientConfig.pubkeyId[0], this.sslClientConfig.pubkeyId[1]);
        String prikeyId = String.format("%02x%02x", this.sslClientConfig.prikeyId[0], this.sslClientConfig.prikeyId[1]);
        configXml.append("<CERTID>" + certId + "</CERTID>");
        configXml.append("<PUBKEYID>" + pubkeyId + "</PUBKEYID>");
        configXml.append("<PRIKEYID>" + prikeyId + "</PRIKEYID>");
        configXml.append("<LOGSWITCH>" + this.sslClientConfig.logSwitch + "</LOGSWITCH>");
        configXml.append("<LOGLEVEL>" + this.sslClientConfig.logLevel + "</LOGLEVEL>");
        configXml.append("<LOGFILESIZE>" + this.sslClientConfig.logFileSize + "</LOGFILESIZE>");
        configXml.append("<MIXNUM>" + this.sslClientConfig.mixNum + "</MIXNUM>");
        configXml.append("<MIXDENO>" + this.sslClientConfig.mixDeno + "</MIXDENO>");
        configXml.append("<ACLVERSION>" + this.sslClientConfig.aclVersion + "</ACLVERSION>");
        configXml.append("</CONFIGINFO>");
        configXml.append("</Root>");
        Function.writePrivateFile((Context)this, "config.xml", configXml.toString());
    }

    public void dealAssetsFile() {
        SharedPreferences sharedPreferences = this.getSharedPreferences("SafeClientConfig", 0);
        String preVersion = sharedPreferences.getString("preVersion", "");
        Log.d("app", "preVersion " + preVersion);
        Log.d("app", "curVersion " + this.curVersion);
        if (preVersion.equals("")) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString("preVersion", this.curVersion);
            editor.commit();
            if (Compatibility.getAreaVersion() == 10000) {
                Log.d("app", "copy emm apk file");
                Function.copyAssets((Context)this, Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "emm_guiyang.apk", "emm_guiyang.apk");
                Log.d("app", "copy push apk file");
                Function.copyAssets((Context)this, Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "push_guiyang.apk", "push_guiyang.apk");
            }
            Function.moveFile((Context)this, "ca.cer");
            Function.moveFile((Context)this, "config.xml");
            Function.moveFile((Context)this, "ClientVer.xml");
            Function.moveFile((Context)this, "tuncontrol");
            Function.moveFile((Context)this, "conf.properties");
        } else {
            if (preVersion.equals(this.curVersion)) {
                Function.moveFile((Context)this, "ca.cer");
                Function.moveFile((Context)this, "tuncontrol");
                Function.moveFile((Context)this, "conf.properties");
            } else {
                Function.moveFile((Context)this, "ca.cer");
                Function.moveFile((Context)this, "config.xml");
                Function.moveFile((Context)this, "ClientVer.xml");
                Function.moveFile((Context)this, "tuncontrol");
                Function.moveFile((Context)this, "conf.properties");
                if (Compatibility.getAreaVersion() == 10000) {
                    Function.copyAssets((Context)this, Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "emm_guiyang.apk", "emm_guiyang.apk");
                    Function.copyAssets((Context)this, Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "push_guiyang.apk", "push_guiyang.apk");
                }
            }
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString("preVersion", this.curVersion);
            editor.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readUpgradeConfigFile() {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        String privatePath = "";
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            privatePath = this.getFilesDir().getPath();
            FileInputStream in = new FileInputStream(privatePath + "/ClientVer.xml");
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();
            Node eltIP = root.getElementsByTagName("ServerIP").item(0);
            Node eltPort = root.getElementsByTagName("ServerPort").item(0);
            Node eltFactory = root.getElementsByTagName("Factory").item(0);
            Node eltMod = root.getElementsByTagName("Mod").item(0);
            Node eltOS = root.getElementsByTagName("OS").item(0);
            Node eltSoft = root.getElementsByTagName("Soft").item(0);
            Node eltUserName = root.getElementsByTagName("UserName").item(0);
            if (eltIP.getFirstChild() != null) {
                this.upgradeConfig.serverIp = eltIP.getFirstChild().getNodeValue();
            }
            if (eltPort.getFirstChild() != null) {
                this.upgradeConfig.serverPort = eltPort.getFirstChild().getNodeValue();
            }
            this.upgradeConfig.factory = eltFactory.getFirstChild().getNodeValue();
            this.upgradeConfig.mod = eltMod.getFirstChild().getNodeValue();
            this.upgradeConfig.os = eltOS.getFirstChild().getNodeValue();
            this.upgradeConfig.soft = eltSoft.getFirstChild().getNodeValue();
            this.upgradeConfig.userName = eltUserName.getFirstChild().getNodeValue();
            NodeList nodeList = root.getElementsByTagName("Ver");
            int nodeNum = nodeList.getLength();
            Element childElement = null;
            NodeList childList = null;
            for (int i = 0; i < nodeNum; ++i) {
                UpgradeVersionInfo vi = new UpgradeVersionInfo();
                childElement = (Element)nodeList.item(i);
                childList = childElement.getElementsByTagName("Version");
                vi.version = childList.item(0).getFirstChild().getNodeValue();
                childList = childElement.getElementsByTagName("Date");
                vi.date = childList.item(0).getFirstChild().getNodeValue();
                childList = childElement.getElementsByTagName("Note");
                if (childList.item(0).getFirstChild() != null) {
                    vi.note = childList.item(0).getFirstChild().getNodeValue();
                }
                this.upgradeConfig.verList.add(vi);
            }
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
    }

    public void writeUpgradeConfigFile() {
        StringBuffer verXml = new StringBuffer();
        verXml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        verXml.append("<Root>");
        verXml.append("<ServerIP>" + this.upgradeConfig.serverIp + "</ServerIP>");
        verXml.append("<ServerPort>" + this.upgradeConfig.serverPort + "</ServerPort>");
        verXml.append("<Factory>" + this.upgradeConfig.factory + "</Factory>");
        verXml.append("<Mod>" + this.upgradeConfig.mod + "</Mod>");
        verXml.append("<OS>" + this.upgradeConfig.os + "</OS>");
        verXml.append("<Soft>\u5b89\u5168\u5ba2\u6237\u7aef</Soft>");
        verXml.append("<UserName>ldz</UserName>");
        int verListNum = this.upgradeConfig.verList.size();
        UpgradeVersionInfo vi = null;
        for (int i = 0; i < verListNum; ++i) {
            vi = this.upgradeConfig.verList.get(i);
            verXml.append("<Ver>");
            verXml.append("<Version>" + vi.version + "</Version>");
            verXml.append("<Date>" + vi.date + "</Date>");
            verXml.append("<Note>" + vi.note + "</Note>");
            verXml.append("</Ver>");
        }
        verXml.append("</Root>");
        Function.writePrivateFile((Context)this, "ClientVer.xml", verXml.toString());
    }

    private void initLogger() {
        Logger.init((String)LOG_TAG).methodCount(3).logLevel(LogLevel.NONE);
    }

    @Subscribe
    public void handleExitAppEvent(ExitAppEvent event) {
        if (this.propertiesConfig.getmDisableFlag() == 1) {
            this.disableFlag = 0;
        }
    }

    private String getPackageVersion(String packageName) {
        PackageManager pm = this.getPackageManager();
        try {
            PackageInfo info = pm.getPackageInfo(packageName, 16384);
            if (null != info) {
                return info.versionName;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void onConnected() {
        if (Compatibility.getAreaVersion() == 10000) {
            Log.d(TAG, "EMM service connected.");
            int ret = -1;
            String pushVersion = this.getPackageVersion("com.xdja.jxpush");
            if (pushVersion == null || pushVersion.compareTo("4.0.5.7") < 0) {
                String apkPath = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "push_guiyang.apk";
                File apkFile = new File(apkPath);
                String apkUri = Uri.fromFile((File)apkFile).toString();
                ret = SecManager.getInstance().silentInstall(apkUri, 2);
                if (ret == 1) {
                    Log.d(TAG, "Install push apk file success.");
                }
            } else {
                Log.d(TAG, "No need to install push apk file");
            }
            if (!((Boolean)SharedPreferencesUtil.get((Context)this, "emm_apk_installed_flag", false)).booleanValue()) {
                String emmVersion = this.getPackageVersion("com.xdja.emm");
                if (emmVersion != null && emmVersion.compareTo("1.1.11.0620") >= 0 && !emmVersion.equals("1.1.8.1201")) {
                    return;
                }
                String apkPath = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "emm_guiyang.apk";
                File apkFile = new File(apkPath);
                String apkUri = Uri.fromFile((File)apkFile).toString();
                ret = SecManager.getInstance().silentInstall(apkUri, 2);
                if (ret == 1) {
                    SharedPreferencesUtil.put((Context)this, "emm_apk_installed_flag", true);
                }
            }
        }
    }

    @Override
    public void onDisnnected() {
        if (Compatibility.getAreaVersion() == 10000) {
            // empty if block
        }
    }
}

