/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.activity;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RadioButton;
import android.widget.TextView;
import com.safetf.CertDetailInfo;
import com.xdja.key.KeyWrapper;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.config.SslClientConfig;
import com.xdja.safeclient.ui.AlertUtil;
import com.xdja.safeclient.utils.ByteUtil;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CertSetActivity
extends BaseActivity
implements View.OnClickListener,
AdapterView.OnItemClickListener {
    ImageView btn_titleLeft = null;
    TextView tv_title = null;
    ImageView btn_titleRight = null;
    public ListView lv_listView = null;
    MyAdapter myAdapter = null;
    List<CertDetailInfo> certList = null;
    MyApplication myApplication = null;
    private byte mCertType = 0;
    private static final String TAG = "CertSetActivity";
    public static boolean justShow = false;
    public static final String FLAG_JUST_SHOW = "just_show";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_certset);
        justShow = this.getIntent().getBooleanExtra(FLAG_JUST_SHOW, false);
        this.myApplication = (MyApplication)this.getApplication();
        this.mCertType = (byte)this.myApplication.propertiesConfig.getmCertType();
        Log.d(TAG, "loadProperties, mCertType = " + this.mCertType);
        this.btn_titleLeft = (ImageView)this.findViewById(R.id.titlebar_leftbtn);
        this.tv_title = (TextView)this.findViewById(R.id.titlebar_text);
        this.btn_titleRight = (ImageView)this.findViewById(R.id.titlebar_rightbtn);
        this.lv_listView = (ListView)this.findViewById(R.id.listview);
        this.tv_title.setText((CharSequence)this.getString(R.string.certset));
        if (justShow) {
            this.btn_titleRight.setVisibility(8);
        } else {
            this.btn_titleRight.setVisibility(0);
        }
        this.btn_titleRight.setBackgroundResource(R.drawable.save);
        this.btn_titleLeft.setOnClickListener((View.OnClickListener)this);
        this.btn_titleRight.setOnClickListener((View.OnClickListener)this);
        this.lv_listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.lv_listView = (ListView)this.findViewById(R.id.listview);
        this.certList = this.getData();
        if (this.certList != null) {
            this.myAdapter = new MyAdapter(this.certList);
            int defaultPosition = this.getDefaultSelectCertPosition();
            this.myAdapter.setcurSelectPosition(defaultPosition);
            this.myAdapter.setDefaultPosition(defaultPosition);
            Log.d(TAG, "\u9ed8\u8ba4\u8bc1\u4e66\u4f4d\u7f6e" + defaultPosition);
            this.lv_listView.setAdapter((ListAdapter)this.myAdapter);
        }
        this.myApplication.activityList.add(this);
        this.myApplication.topActivity = this;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d(TAG, "onDestroy");
        if (this.myApplication.activityList != null) {
            this.myApplication.activityList.remove((Object)this);
        }
    }

    public int getDefaultSelectCertPosition() {
        SslClientConfig sslClientConfig = this.myApplication.sslClientConfig;
        int size = this.certList.size();
        for (int i = 0; i < size; ++i) {
            if (!Arrays.equals(sslClientConfig.getCertId(), this.certList.get((int)i).certId)) continue;
            return i;
        }
        return -1;
    }

    public void onClick(View arg0) {
        int viewId = arg0.getId();
        if (R.id.titlebar_rightbtn == viewId) {
            this.save();
        } else if (R.id.titlebar_leftbtn == viewId) {
            this.finish();
        }
    }

    private List<CertDetailInfo> getData() {
        int nres = -1;
        ArrayList<CertDetailInfo> list = new ArrayList<CertDetailInfo>();
        CertDetailInfo certDetailInfo = null;
        MyApplication application = MyApplication.myApplication;
        byte[] fid = new byte[]{0, 41};
        byte[] certBuf = new byte[2048];
        int[] certLen = new int[1];
        if (application != null && application.sslClientConfig != null) {
            fid = application.sslClientConfig.getCertId();
            Log.d(TAG, "CertId :" + fid[0] + fid[1]);
        }
        if ((nres = KeyWrapper.getInstance().readSignCert(certBuf, certLen)) != 0) {
            Log.d(TAG, "Read cert failed. " + KeyWrapper.StatusCode.getComment(nres));
            return null;
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            ByteArrayInputStream bin = new ByteArrayInputStream(certBuf);
            CertificateFactory cf = null;
            cf = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(bin);
            certDetailInfo = new CertDetailInfo();
            certDetailInfo.issuerOrg = cert.getIssuerX500Principal().getName();
            certDetailInfo.issuerCn = cert.getIssuerDN().getName();
            certDetailInfo.subjectOrg = cert.getSubjectX500Principal().getName();
            certDetailInfo.subjectCn = cert.getSubjectDN().getName();
            System.arraycopy(fid, 0, certDetailInfo.certId, 0, 2);
            certDetailInfo.indate = formatter.format(cert.getNotBefore()) + "/" + formatter.format(cert.getNotAfter());
            certDetailInfo.sn = cert.getSerialNumber().toString(16);
            list.add(certDetailInfo);
            bin.close();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        if (list.size() == 0) {
            AlertUtil.popAlert((Context)this, StringUtil.getStringRes((Context)this, R.string.alert), StringUtil.getStringRes((Context)this, R.string.lack_cert));
            return null;
        }
        return list;
    }

    public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
        MyAdapter adapt = (MyAdapter)arg0.getAdapter();
        adapt.setcurSelectPosition(arg2);
        adapt.notifyDataSetChanged();
    }

    public void save() {
        int ctnNo;
        SslClientConfig sslClientConfig = this.myApplication.sslClientConfig;
        if (this.myAdapter == null) {
            return;
        }
        int curSelectPosition = this.myAdapter.getcurSelectPosition();
        try {
            ctnNo = this.certList.get((int)curSelectPosition).ctnNo;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            return;
        }
        byte[] certId = new byte[2];
        byte[] pubkeyId = new byte[2];
        byte[] prikeyId = new byte[2];
        if (0 == ctnNo) {
            sslClientConfig.setRole(1);
            if (this.mCertType == 0) {
                certId[0] = 0;
                certId[1] = 41;
                pubkeyId[0] = 0;
                pubkeyId[1] = 42;
                prikeyId[0] = 0;
                prikeyId[1] = 43;
            } else {
                certId[0] = 0;
                certId[1] = 44;
                pubkeyId[0] = 0;
                pubkeyId[1] = 45;
                prikeyId[0] = 0;
                prikeyId[1] = 46;
            }
            sslClientConfig.setCertId(certId);
            sslClientConfig.setPubkeyId(pubkeyId);
            sslClientConfig.setPrikeyId(prikeyId);
            this.myApplication.writeSslclientConfigFile();
        } else if (4 == ctnNo) {
            sslClientConfig.setRole(17);
            if (this.mCertType == 0) {
                certId[0] = 0;
                certId[1] = 69;
                pubkeyId[0] = 0;
                pubkeyId[1] = 70;
                prikeyId[0] = 0;
                prikeyId[1] = 71;
            } else {
                certId[0] = 0;
                certId[1] = 72;
                pubkeyId[0] = 0;
                pubkeyId[1] = 73;
                prikeyId[0] = 0;
                prikeyId[1] = 74;
            }
            sslClientConfig.setCertId(certId);
            sslClientConfig.setPubkeyId(pubkeyId);
            sslClientConfig.setPrikeyId(prikeyId);
            this.myApplication.writeSslclientConfigFile();
        } else if (6 == ctnNo) {
            sslClientConfig.setRole(17);
            if (this.mCertType == 0) {
                certId[0] = 0;
                certId[1] = 83;
                pubkeyId[0] = 0;
                pubkeyId[1] = 84;
                prikeyId[0] = 0;
                prikeyId[1] = 85;
            } else {
                certId[0] = 0;
                certId[1] = 86;
                pubkeyId[0] = 0;
                pubkeyId[1] = 87;
                prikeyId[0] = 0;
                prikeyId[1] = 88;
            }
            sslClientConfig.setCertId(certId);
            sslClientConfig.setPubkeyId(pubkeyId);
            sslClientConfig.setPrikeyId(prikeyId);
            this.myApplication.writeSslclientConfigFile();
        }
        this.finish();
    }

    private class MyAdapter
    extends BaseAdapter {
        private LayoutInflater inflater;
        private Holder holder;
        private int curSelectPosition = -1;
        private int defaultPosition = -1;
        private List<CertDetailInfo> certList = null;

        public MyAdapter(List<CertDetailInfo> certList) {
            this.certList = certList;
            this.inflater = LayoutInflater.from((Context)CertSetActivity.this);
        }

        public void setcurSelectPosition(int curSelectPosition) {
            this.curSelectPosition = curSelectPosition;
        }

        public int getcurSelectPosition() {
            return this.curSelectPosition;
        }

        public void setDefaultPosition(int defaultPosition) {
            this.defaultPosition = defaultPosition;
        }

        public int getCount() {
            return this.certList.size();
        }

        public Object getItem(int arg0) {
            return arg0;
        }

        public long getItemId(int arg0) {
            return arg0;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = this.inflater.inflate(R.layout.certlist, null);
                this.holder = new Holder();
                this.holder.whole_layout = (LinearLayout)convertView.findViewById(R.id.whole_layout);
                this.holder.tv_subject = (TextView)convertView.findViewById(R.id.subject);
                this.holder.tv_issuer = (TextView)convertView.findViewById(R.id.issuer);
                this.holder.tv_sn = (TextView)convertView.findViewById(R.id.sn);
                this.holder.tv_indate = (TextView)convertView.findViewById(R.id.indate);
                this.holder.rb_defaultCert = (RadioButton)convertView.findViewById(R.id.defaultcert);
                convertView.setTag((Object)this.holder);
            } else {
                this.holder = (Holder)convertView.getTag();
            }
            if (justShow) {
                this.holder.rb_defaultCert.setVisibility(8);
            } else {
                this.holder.rb_defaultCert.setVisibility(0);
            }
            CertDetailInfo certInfo = this.certList.get(position);
            this.holder.tv_subject.setText((CharSequence)certInfo.subjectCn);
            this.holder.tv_issuer.setText((CharSequence)certInfo.issuerCn);
            this.holder.tv_sn.setText((CharSequence)certInfo.sn);
            this.holder.tv_indate.setText((CharSequence)certInfo.indate);
            if (position == this.curSelectPosition) {
                this.holder.rb_defaultCert.setChecked(true);
            } else {
                this.holder.rb_defaultCert.setChecked(false);
            }
            this.setBackground(position, convertView);
            if (Compatibility.isXiAnJWT()) {
                if (position != this.defaultPosition) {
                    this.holder.whole_layout.setVisibility(8);
                } else {
                    this.holder.whole_layout.setVisibility(0);
                    ByteUtil.print("CertId\uff1a", certInfo.certId);
                }
                Log.d(CertSetActivity.TAG, "The version is JWT of Xi'an.");
            }
            return convertView;
        }

        public void setBackground(int position, View convertView) {
            convertView.setBackgroundResource(this.getListItemBG(position));
        }

        private int getListItemBG(int position) {
            if (1 == this.certList.size()) {
                return R.drawable.list_item_single;
            }
            if (position == 0) {
                return R.drawable.list_item_top;
            }
            if (position == this.certList.size() - 1) {
                return R.drawable.list_item_bottom;
            }
            return R.drawable.list_item_middle;
        }

        private class Holder {
            private LinearLayout whole_layout;
            private TextView tv_subject;
            private TextView tv_issuer;
            private TextView tv_sn;
            private TextView tv_indate;
            private RadioButton rb_defaultCert;

            private Holder() {
            }
        }
    }
}

