/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.activity;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.TrafficStatistics;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.bean.TrafficTable;
import com.xdja.safeclient.utils.Log;
import java.text.ParseException;
import java.util.Calendar;

public class TrafficStatisticsActivity
extends BaseActivity {
    private TextView mTrafficAmountUp = null;
    private TextView mTrafficAmountDown = null;
    private TextView mTrafficUp = null;
    private TextView mTrafficDown = null;
    private TextView mTrafficAverageUp = null;
    private TextView mTrafficAverageDown = null;
    private TextView mStartTimeDisplay = null;
    private Button mStartTimeButton = null;
    private TextView mEndTimeDisplay = null;
    private Button mEndTimeButton = null;
    private Calendar mCal = null;
    private int mStartYear;
    private int mStartMonth;
    private int mStartDay;
    private int mEndYear;
    private int mEndMonth;
    private int mEndDay;
    private TrafficStatistics mTrafficStatistics = null;
    MyApplication myApplication = null;
    private String TAG = "TrafficStaticsActivity";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_traffic_statistics);
        this.myApplication = (MyApplication)this.getApplication();
        Log.d(this.TAG, "onCreate");
        this.mCal = Calendar.getInstance();
        this.mLeftBtn = (ImageView)this.findViewById(R.id.titlebar_leftbtn);
        this.mRightBtn = (ImageView)this.findViewById(R.id.titlebar_rightbtn);
        this.mTitleText = (TextView)this.findViewById(R.id.titlebar_text);
        this.initTitleText();
        this.initLeftBtn();
        this.initStartTime();
        this.initEndTime();
        this.mTrafficUp = (TextView)this.findViewById(R.id.traffic_up);
        this.mTrafficDown = (TextView)this.findViewById(R.id.traffic_down);
        this.mTrafficAverageUp = (TextView)this.findViewById(R.id.traffic_average_up);
        this.mTrafficAverageDown = (TextView)this.findViewById(R.id.traffic_average_down);
        this.myApplication.activityList.add(this);
        this.myApplication.topActivity = this;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d(this.TAG, "onDestroy");
        if (this.myApplication.activityList != null) {
            this.myApplication.activityList.remove((Object)this);
        }
    }

    protected void onResume() {
        super.onResume();
        Log.d(this.TAG, "onResume");
        this.initTrafficStatisticsDB();
        this.initTrafficAmount();
    }

    protected void onPause() {
        super.onPause();
        Log.d(this.TAG, "onPause");
        this.closeTrafficStatisticsDB();
    }

    private void initTrafficStatisticsDB() {
        this.mTrafficStatistics = new TrafficStatistics();
        this.mTrafficStatistics.openDB((Context)this);
    }

    private void closeTrafficStatisticsDB() {
        this.mTrafficStatistics.closeDB();
    }

    private void initTrafficAmount() {
        TrafficTable trafTable = new TrafficTable();
        this.mTrafficAmountUp = (TextView)this.findViewById(R.id.traffic_amount_up);
        this.mTrafficAmountDown = (TextView)this.findViewById(R.id.traffic_amount_down);
        if (this.mTrafficStatistics != null && this.mTrafficAmountUp != null && this.mTrafficAmountDown != null) {
            this.mTrafficStatistics.queryTrafficAmount(this.mTrafficStatistics.getmDB(), trafTable);
            this.mTrafficAmountUp.setText((CharSequence)(this.getString(R.string.traffic_amount_up).toString() + String.format("%.1f", Float.valueOf(trafTable.getmTrafficUp())) + this.getString(R.string.MB)));
            this.mTrafficAmountDown.setText((CharSequence)(this.getString(R.string.traffic_amount_down).toString() + String.format("%.1f", Float.valueOf(trafTable.getmTrafficDown())) + this.getString(R.string.MB)));
        }
    }

    private void getTraffic(TrafficTable trafTable) {
        if (trafTable != null && this.mTrafficStatistics != null && this.mTrafficUp != null && this.mTrafficDown != null) {
            this.mTrafficStatistics.queryTraffic(this.mTrafficStatistics.getmDB(), trafTable);
            this.mTrafficUp.setText((CharSequence)(this.getString(R.string.traffic_up).toString() + String.format("%.1f", Float.valueOf(trafTable.getmTrafficUp())) + this.getString(R.string.MB)));
            this.mTrafficDown.setText((CharSequence)(this.getString(R.string.traffic_down).toString() + String.format("%.1f", Float.valueOf(trafTable.getmTrafficDown())) + this.getString(R.string.MB)));
        }
    }

    private void getTrafficAverage(TrafficTable trafTable) throws ParseException {
        if (trafTable != null && this.mTrafficStatistics != null && this.mTrafficAverageUp != null && this.mTrafficAverageDown != null) {
            this.mTrafficStatistics.queryTrafficAverage(this.mTrafficStatistics.getmDB(), trafTable);
            this.mTrafficAverageUp.setText((CharSequence)(this.getString(R.string.traffic_average_up).toString() + String.format("%.1f", Float.valueOf(trafTable.getmTrafficUp())) + this.getString(R.string.MB)));
            this.mTrafficAverageDown.setText((CharSequence)(this.getString(R.string.traffic_average_down).toString() + String.format("%.1f", Float.valueOf(trafTable.getmTrafficDown())) + this.getString(R.string.MB)));
        }
    }

    private void initStartTime() {
        this.mStartTimeDisplay = (TextView)this.findViewById(R.id.start_time_display);
        this.mStartTimeButton = (Button)this.findViewById(R.id.start_time_button);
        this.mStartYear = this.mCal.get(1);
        this.mStartMonth = this.mCal.get(2) + 1;
        this.mStartDay = this.mCal.get(5);
        this.mStartTimeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TrafficStatisticsActivity.this.showDialog(0);
            }
        });
    }

    private void initEndTime() {
        this.mEndTimeDisplay = (TextView)this.findViewById(R.id.end_time_display);
        this.mEndTimeButton = (Button)this.findViewById(R.id.end_time_button);
        this.mEndYear = this.mCal.get(1);
        this.mEndMonth = this.mCal.get(2) + 1;
        this.mEndDay = this.mCal.get(5);
        this.mEndTimeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TrafficStatisticsActivity.this.showDialog(1);
            }
        });
    }

    protected Dialog onCreateDialog(int id2) {
        if (0 == id2) {
            DatePickerDialog.OnDateSetListener startDateListener = new DatePickerDialog.OnDateSetListener(){

                public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                    TrafficStatisticsActivity.this.mStartYear = year;
                    TrafficStatisticsActivity.this.mStartMonth = monthOfYear + 1;
                    TrafficStatisticsActivity.this.mStartDay = dayOfMonth;
                    TrafficStatisticsActivity.this.mStartTimeDisplay.setText((CharSequence)(String.format("%04d", TrafficStatisticsActivity.this.mStartYear) + "-" + String.format("%02d", TrafficStatisticsActivity.this.mStartMonth) + "-" + String.format("%02d", TrafficStatisticsActivity.this.mStartDay)));
                    Toast.makeText((Context)view.getContext(), (CharSequence)TrafficStatisticsActivity.this.getString(R.string.select_end_time), (int)0).show();
                }
            };
            return new DatePickerDialog((Context)this, startDateListener, this.mStartYear, this.mStartMonth - 1, this.mStartDay);
        }
        if (1 == id2) {
            DatePickerDialog.OnDateSetListener endDateListener = new DatePickerDialog.OnDateSetListener(){

                public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                    TrafficStatisticsActivity.this.mEndYear = year;
                    TrafficStatisticsActivity.this.mEndMonth = monthOfYear + 1;
                    TrafficStatisticsActivity.this.mEndDay = dayOfMonth;
                    TrafficStatisticsActivity.this.mEndTimeDisplay.setText((CharSequence)(String.format("%4d", TrafficStatisticsActivity.this.mEndYear) + "-" + String.format("%02d", TrafficStatisticsActivity.this.mEndMonth) + "-" + String.format("%02d", TrafficStatisticsActivity.this.mEndDay)));
                    if (TrafficStatisticsActivity.this.mEndYear < TrafficStatisticsActivity.this.mStartYear || TrafficStatisticsActivity.this.mEndYear == TrafficStatisticsActivity.this.mStartYear && TrafficStatisticsActivity.this.mEndMonth < TrafficStatisticsActivity.this.mStartMonth || TrafficStatisticsActivity.this.mEndYear == TrafficStatisticsActivity.this.mStartYear && TrafficStatisticsActivity.this.mEndMonth == TrafficStatisticsActivity.this.mStartMonth && TrafficStatisticsActivity.this.mEndDay < TrafficStatisticsActivity.this.mStartDay) {
                        Toast.makeText((Context)view.getContext(), (CharSequence)TrafficStatisticsActivity.this.getString(R.string.endtime_less_than_startime), (int)1).show();
                        TrafficStatisticsActivity.this.mTrafficUp.setText((CharSequence)TrafficStatisticsActivity.this.getString(R.string.traffic_up).toString());
                        TrafficStatisticsActivity.this.mTrafficDown.setText((CharSequence)TrafficStatisticsActivity.this.getString(R.string.traffic_down).toString());
                        TrafficStatisticsActivity.this.mTrafficAverageUp.setText((CharSequence)TrafficStatisticsActivity.this.getString(R.string.traffic_average_up).toString());
                        TrafficStatisticsActivity.this.mTrafficAverageDown.setText((CharSequence)TrafficStatisticsActivity.this.getString(R.string.traffic_average_down).toString());
                    } else {
                        TrafficTable trafTable = new TrafficTable(TrafficStatisticsActivity.this.mStartYear, TrafficStatisticsActivity.this.mStartMonth, TrafficStatisticsActivity.this.mStartDay, TrafficStatisticsActivity.this.mEndYear, TrafficStatisticsActivity.this.mEndMonth, TrafficStatisticsActivity.this.mEndDay);
                        TrafficStatisticsActivity.this.getTraffic(trafTable);
                        TrafficTable trafTableAverage = new TrafficTable(TrafficStatisticsActivity.this.mStartYear, TrafficStatisticsActivity.this.mStartMonth, TrafficStatisticsActivity.this.mStartDay, TrafficStatisticsActivity.this.mEndYear, TrafficStatisticsActivity.this.mEndMonth, TrafficStatisticsActivity.this.mEndDay);
                        try {
                            TrafficStatisticsActivity.this.getTrafficAverage(trafTableAverage);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            return new DatePickerDialog((Context)this, endDateListener, this.mEndYear, this.mEndMonth - 1, this.mEndDay);
        }
        return null;
    }

    @Override
    protected void initTitleText() {
        super.initTitleText();
        this.mTitleText.setText(R.string.label_traffic_statistics);
    }
}

