/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.receiver;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.StartVpnActivity;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.event.EventManager;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.wrapper.PinWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class bootBroadcastReceiver
extends BroadcastReceiver {
    private int autoStart = 0;
    private int disableWifi = 0;
    private int disableBluetoolth = 0;
    private String TAG = "bootBroadcastReceiver";
    public static final int DISABLE_RETRY_SSL = 1;
    public static final int ENABLE_RETRY_SSL = 0;
    public static final String ACTION_SDCARD_MOUNTED = "android.intent.action.MEDIA_MOUNTED";
    public static final String ACTION_SDCARD_EJECT = "android.intent.action.MEDIA_EJECT";

    public void onReceive(Context context, Intent intent) {
        this.loadPropertiesConfig(context);
        String action = intent.getAction();
        Log.d(this.TAG, action);
        switch (action) {
            case "android.intent.action.MEDIA_MOUNTED": {
                Log.e(this.TAG, "SDCARD mounted event  device " + intent.getData().toString());
                EventManager.getInstance().onSDCardStateChanged(1001);
                break;
            }
            case "android.intent.action.MEDIA_EJECT": {
                Log.d(this.TAG, "SDCARD eject event");
                if (intent.getData().toString().contains("udisk")) {
                    Log.d(this.TAG, "onReceive igore second sdcard eject");
                    return;
                }
                EventManager.getInstance().onSDCardStateChanged(1000);
                break;
            }
            case "android.intent.action.BOOT_COMPLETED": {
                Log.d(this.TAG, "device boot completed");
                this.startAutoStart(context);
                break;
            }
            case "android.net.wifi.WIFI_STATE_CHANGED": {
                Log.d(this.TAG, "wifi state has changed");
                this.checkWifiState(context, intent);
                break;
            }
            case "android.bluetooth.adapter.action.STATE_CHANGED": {
                Log.d(this.TAG, "bluetooth state has changed");
                this.checkBluetoothState();
                break;
            }
            case "com.xdja.safeclient.action.STOP_SERVICE": {
                Log.d(this.TAG, "outer call stop service");
                if (context.getPackageName().equals("com.xdja.safeclient.tun")) break;
                this.stopVpn();
                break;
            }
            case "com.xdja.safeclient.tun.action.STOP_SERVICE": {
                Log.d(this.TAG, "Stop video client");
                if (!context.getPackageName().equals("com.xdja.safeclient.tun")) break;
                this.stopVpn();
                break;
            }
            case "com.xdja.safeclient.guardian_advise": {
                break;
            }
            case "com.xdja.safeclient.repeat_wakeup_device": {
                break;
            }
        }
    }

    private void startAutoStart(final Context context) {
        if (this.autoStart == 1) {
            Log.d(this.TAG, "prepare start automatically");
            if (PinWrapper.getPin(context) == null) {
                return;
            }
            if (!Function.getSafeVpnState(context)) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        bootBroadcastReceiver.this.startVpn(context);
                    }
                }).start();
            }
        } else {
            Log.d(this.TAG, "no need to start automatically");
        }
    }

    private void startVpn(Context context) {
        MyApplication myApplication = MyApplication.myApplication;
        if (myApplication == null) {
            Log.e(this.TAG, "startVpn,myApplication == null");
        }
        if (myApplication.sslClientConfig.getTransportMode() == 0) {
            Intent intent = new Intent();
            intent.setClassName(MyApplication.packageName, "com.xdja.safeclient.VpnService");
            context.startService(intent);
        } else {
            try {
                Intent intent = new Intent(context, StartVpnActivity.class);
                intent.setFlags(0x10400000);
                context.startActivity(intent);
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e(this.TAG, "startActivity StartVpnActivity failed");
            }
        }
    }

    private void checkWifiState(Context context, Intent intent) {
        int wifiState;
        MyApplication myApplication = MyApplication.myApplication;
        WifiManager wifi = (WifiManager)context.getSystemService("wifi");
        if (wifi != null && (2 == (wifiState = wifi.getWifiState()) || 3 == wifiState) && this.disableWifi == 1 && myApplication.disableFlag == 1) {
            wifi.setWifiEnabled(false);
            Log.d(this.TAG, "setWifiEnabled(false)");
        }
    }

    private void checkBluetoothState() {
        int blueState;
        MyApplication myApplication = MyApplication.myApplication;
        BluetoothAdapter bluetooth = BluetoothAdapter.getDefaultAdapter();
        if (bluetooth != null && (11 == (blueState = bluetooth.getState()) || 12 == blueState) && this.disableBluetoolth == 1 && myApplication.disableFlag == 1) {
            try {
                bluetooth.disable();
                Log.d("bootBroadcastReceiver", "bluetooth.disable");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void checkNetWorkState(Context context) {
        Log.d(this.TAG, "\u7f51\u7edc\u72b6\u6001\u5df2\u7ecf\u6539\u53d8");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = connectivityManager.getActiveNetworkInfo();
        if (info != null && info.isAvailable()) {
            String name = info.getTypeName();
            Log.d(this.TAG, "\u5f53\u524d\u7f51\u7edc\u540d\u79f0\uff1a" + name);
            this.enableRetrySSL(0);
        } else {
            Log.d(this.TAG, "\u6ca1\u6709\u53ef\u7528\u7f51\u7edc");
            this.enableRetrySSL(1);
        }
    }

    private void enableRetrySSL(int value) {
        final MyApplication myApplication = MyApplication.myApplication;
        final String cmdValue = value == 1 ? "DISABLE_RETRY_SSL" : "ENABLE_RETRY_SSL";
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (0 == myApplication.sslClientConfig.transportMode) {
                    Object object = VpnService.xlock;
                    synchronized (object) {
                        if (VpnService.sock != null) {
                            VpnService.sock.sendData(cmdValue);
                            byte[] state = new byte[1024];
                            int statelen = VpnService.sock.recvData(state);
                            if (statelen > 0) {
                                Log.d(bootBroadcastReceiver.this.TAG, "state = " + new String(state, 0, statelen));
                            }
                        }
                    }
                }
                Object object = TunVpnService.lock;
                synchronized (object) {
                    if (TunVpnService.sock != null) {
                        TunVpnService.sock.sendData(cmdValue);
                        byte[] state = new byte[1024];
                        int statelen = TunVpnService.sock.recvData(state);
                        if (statelen > 0) {
                            Log.d(bootBroadcastReceiver.this.TAG, "state = " + new String(state, 0, statelen));
                        }
                    }
                }
            }
        }).start();
    }

    public void stopVpn() {
        MyApplication myApplication = MyApplication.myApplication;
        if (0 == myApplication.sslClientConfig.transportMode) {
            this.stopVpnService(myApplication);
            Log.d(this.TAG, "TransMode to stop service");
        } else {
            this.stopTunVpnService(myApplication);
            Log.d(this.TAG, "TunMode to stop service");
        }
    }

    public void stopVpnService(MyApplication myApplication) {
        boolean res = false;
        Log.d(this.TAG, "stop VpnService...");
        Intent intent = new Intent((Context)myApplication, VpnService.class);
        res = myApplication.stopService(intent);
        if (!res) {
            Log.e(this.TAG, "stop VpnService failed");
        } else {
            Log.d(this.TAG, "stop VpnService success ");
        }
    }

    public void stopTunVpnService(MyApplication myApplication) {
        Log.d(this.TAG, "stop TunVpnService...");
        if (myApplication == null) {
            Log.e(this.TAG, "myApplication == null");
        }
        try {
            boolean res = false;
            try {
                if (TunVpnService.mInterface != null) {
                    Log.d(this.TAG, "TunVpnService.mInterface.close");
                    TunVpnService.mInterface.close();
                    TunVpnService.mInterface = null;
                    if (TunVpnService.tunVpnObj != null) {
                        TunVpnService.tunVpnObj.destroyBuilder();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (myApplication.sslvpn != null) {
                myApplication.sslvpn.closeTunFd();
            }
            Intent intent = new Intent();
            intent.setClassName(MyApplication.packageName, "com.xdja.safeclient.TunVpnService");
            res = myApplication.stopService(intent);
            if (!res) {
                Log.e(this.TAG, "stop TunVpnService failed");
            } else {
                Log.d(this.TAG, "stop TunVpnService success ");
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    private void loadPropertiesConfig(Context context) {
        String propertiesPath = "conf.properties";
        InputStream in = null;
        try {
            in = context.getResources().getAssets().open(propertiesPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Properties prop = new Properties();
        try {
            prop.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String strAutoStart = (String)prop.get("autoStart");
        this.autoStart = Integer.parseInt(strAutoStart);
        Log.d(this.TAG, "loadProperties, autoStart = " + this.autoStart);
        String strDisableWifi = (String)prop.get("disableWifi");
        this.disableWifi = Integer.parseInt(strDisableWifi);
        Log.d(this.TAG, "loadProperties, disableWifi = " + this.disableWifi);
        String strDisableBluetoolth = (String)prop.get("disableBluetoolth");
        this.disableBluetoolth = Integer.parseInt(strDisableBluetoolth);
        Log.d(this.TAG, "loadProperties, disableBluetoolth = " + this.disableBluetoolth);
    }
}

