/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.tun;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.xdja.key.KeyModuleStateListener;
import com.xdja.key.KeyWrapper;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.LogUtil;

public class StartVpnActivity
extends Activity {
    private String TAG = "StartVpnActivity";
    MyApplication myApplication = null;
    String SafePin = null;
    private String ServerIP = null;
    private int ServerPort = -1;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.myApplication = (MyApplication)this.getApplication();
        this.SafePin = this.getIntent().getStringExtra("SafePin");
        if (this.SafePin != null) {
            LogUtil.d(this.TAG, this.SafePin);
        }
        this.ServerIP = this.getIntent().getStringExtra("ServerIP");
        this.ServerPort = this.getIntent().getIntExtra("ServerPort", -1);
        if (Compatibility.getAreaVersion() == 10000 && this.myApplication != null) {
            this.myApplication.checkDevAdmin();
        }
        if (KeyWrapper.getInstance().getState() == 1) {
            Log.d(this.TAG, "Key module is init in progress. Wait!");
            KeyWrapper.getInstance().addKeyModuleStateListener(new KeyModuleStateListener(){

                @Override
                public void onStateChanged(int curState) {
                    switch (curState) {
                        case 3: 
                        case 4: {
                            KeyWrapper.getInstance().removeKeyModuleStateListener(this);
                            break;
                        }
                        case 2: {
                            Log.d(StartVpnActivity.this.TAG, "Start safeclient now");
                            KeyWrapper.getInstance().removeKeyModuleStateListener(this);
                            if (StartVpnActivity.this.myApplication.sslClientConfig.getTransportMode() == 0) {
                                StartVpnActivity.this.startVpnService();
                                break;
                            }
                            StartVpnActivity.this.startTunVpnService();
                        }
                    }
                }
            });
        } else if (this.myApplication.sslClientConfig.getTransportMode() == 0) {
            this.startVpnService();
        } else {
            this.startTunVpnService();
        }
    }

    protected void onActivityResult(int request, int result, Intent data) {
        if (-1 == result) {
            ComponentName name;
            Log.d(this.TAG, "onActivityResult , user permit");
            Intent ittTunVpn = new Intent((Context)this, TunVpnService.class);
            if (this.SafePin != null) {
                ittTunVpn.putExtra("SafePin", this.SafePin);
            } else {
                ittTunVpn.putExtra("SafePin", "111111");
            }
            if (this.ServerIP != null) {
                ittTunVpn.putExtra("ServerIP", this.ServerIP);
            }
            if (this.ServerPort != -1) {
                ittTunVpn.putExtra("ServerPort", this.ServerPort);
            }
            if ((name = this.startService(ittTunVpn)) == null) {
                Log.d(this.TAG, "start TunVpnService failed");
            } else {
                Log.d(this.TAG, "start TunVpnService success " + name.toString());
            }
        } else {
            Log.d(this.TAG, "onActivityResult , user not permit");
        }
        Compatibility.onStartedByThirdApp((Context)this);
        this.finish();
    }

    public void startTunVpnService() {
        Log.d(this.TAG, "prepare...");
        Intent itt = android.net.VpnService.prepare((Context)this);
        if (itt != null) {
            Log.d(this.TAG, "startActivityForResult...");
            this.startActivityForResult(itt, 0);
        } else {
            Log.d(this.TAG, "onActivityResult...");
            this.onActivityResult(0, -1, null);
        }
    }

    public void startVpnService() {
        ComponentName name;
        Intent ittTunVpn = new Intent((Context)this, VpnService.class);
        if (this.SafePin != null) {
            ittTunVpn.putExtra("SafePin", this.SafePin);
        }
        if (this.ServerIP != null) {
            ittTunVpn.putExtra("ServerIP", this.ServerIP);
        }
        if (this.ServerPort != -1) {
            ittTunVpn.putExtra("ServerPort", this.ServerPort);
        }
        if ((name = this.startService(ittTunVpn)) == null) {
            Log.d(this.TAG, "start VpnService failed");
        } else {
            Log.d(this.TAG, "start VpnService success " + name.toString());
        }
        this.finish();
    }
}

