/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Log {
    private static int logLevel = 6;
    private static String filePath;
    private static Writer writer;
    private static SimpleDateFormat sdf;
    private static final String TAG = "Log";

    private Log(String path) {
        filePath = path;
        writer = null;
    }

    public static void init(String path, int level) throws IOException {
        logLevel = level;
        if (path != null) {
            if (writer != null) {
                Log.e(TAG, "Log file path already set.");
                return;
            }
            File file = new File(path);
            writer = new BufferedWriter(new FileWriter(file), 2048);
            sdf = new SimpleDateFormat("MM-dd hh:mm:ss ", Locale.getDefault());
        }
    }

    public static void setLogLevel(int level) {
        logLevel = level;
    }

    public static int getLogLevel() {
        return logLevel;
    }

    private static void writeLog(String tag, String log) {
        try {
            if (writer != null) {
                writer.write(sdf.format(new Date()));
                writer.write(tag + " :");
                writer.write(log);
                writer.write("\n");
                writer.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void v(String tag, String msg) {
        if (logLevel >= 5) {
            android.util.Log.v((String)tag, (String)msg);
        }
        Log.writeLog(tag, msg);
    }

    public static void v(String tag, String msg, Throwable tr) {
        if (logLevel >= 5) {
            android.util.Log.v((String)tag, (String)msg, (Throwable)tr);
        }
        Log.writeLog(tag, msg);
    }

    public static void d(String tag, String msg) {
        if (logLevel >= 4) {
            android.util.Log.d((String)tag, (String)msg);
        }
        Log.writeLog(tag, msg);
    }

    public static void d(String tag, String msg, Throwable tr) {
        if (logLevel >= 4) {
            android.util.Log.d((String)tag, (String)msg, (Throwable)tr);
        }
        Log.writeLog(tag, msg);
    }

    public static void i(String tag, String msg) {
        if (logLevel >= 3) {
            android.util.Log.i((String)tag, (String)msg);
        }
        Log.writeLog(tag, msg);
    }

    static void i(String tag, String msg, Throwable tr) {
        if (logLevel >= 3) {
            android.util.Log.i((String)tag, (String)msg, (Throwable)tr);
        }
        Log.writeLog(tag, msg);
    }

    public static void w(String tag, String msg) {
        if (logLevel >= 2) {
            android.util.Log.w((String)tag, (String)msg);
        }
        Log.writeLog(tag, msg);
    }

    public static void w(String tag, String msg, Throwable tr) {
        if (logLevel >= 2) {
            android.util.Log.w((String)tag, (String)msg, (Throwable)tr);
        }
        Log.writeLog(tag, msg);
    }

    public static void e(String tag, String msg) {
        if (logLevel >= 1) {
            android.util.Log.e((String)tag, (String)msg);
        }
        Log.writeLog(tag, msg);
    }

    public static void e(String tag, String msg, Throwable tr) {
        if (logLevel >= 1) {
            android.util.Log.e((String)tag, (String)msg, (Throwable)tr);
        }
        Log.writeLog(tag, msg);
    }
}

