/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sslvpn;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.VpnService;
import android.os.Build;
import android.os.PowerManager;
import android.text.TextUtils;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.GuardianHelper;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.activity.SafeVerifyActivity;
import com.xdja.safeclient.config.SslClientConfig;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.SharedPreferencesUtil;
import com.xdja.sslvpn.AppAclList;
import com.xdja.sslvpn.AppAclRule;
import com.xdja.sslvpn.SslvpnStatus;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;

public class SSLVPN {
    private int hHandle = 0;
    private static final String TAG = "sslvpn";
    PowerManager pm = null;
    PowerManager.WakeLock mWakeLock = null;
    public static final int LANGUAGE_ZH = 0;
    public static final int LANGUAGE_EN = 1;
    private AppAclList appAclList = new AppAclList();

    public AppAclList getAppAclList() {
        return this.appAclList;
    }

    public SSLVPN() {
        this.hHandle = this.init();
    }

    public static void setLocale(Locale locale) {
        String lan;
        switch (lan = locale.getLanguage()) {
            case "en": {
                SSLVPN.setNativeLanguage(1);
                break;
            }
            case "zh": {
                SSLVPN.setNativeLanguage(0);
                break;
            }
            default: {
                SSLVPN.setNativeLanguage(0);
            }
        }
    }

    public int setParam(SslClientConfig sslClientConfig) {
        return this.setParam(this.hHandle, sslClientConfig);
    }

    public int startService() {
        return this.startService(this.hHandle);
    }

    public int getStatus(SslvpnStatus sslvpnStatus) {
        return this.getStatus(this.hHandle, sslvpnStatus);
    }

    public int stopService() {
        return this.stopService(this.hHandle);
    }

    public int release() {
        this.release(this.hHandle);
        this.hHandle = 0;
        return 0;
    }

    public int guardianLearn(int opt, long data) {
        Log.d(TAG, "guardianLearn opt:" + opt + " data:" + data);
        return this.guardianLearn(this.hHandle, opt, data);
    }

    public void guardianAdvise(int second) {
        Log.d(TAG, "guardianAdvise second:" + second);
        if (MyApplication.myApplication == null) {
            return;
        }
        if (second <= 200) {
            return;
        }
        GuardianHelper.invokeOnceAlarm(MyApplication.myApplication.getApplicationContext(), second);
    }

    public static int startXdjaKeyService(String packageName, int keyType, Object extra) {
        Log.d("SSLVPN", "startXdjaKeyService");
        return SSLVPN.startXdjaKeyServer(packageName, keyType, extra);
    }

    public static int stopXdjaKeyService() {
        return SSLVPN.stopXdjaKeyServer();
    }

    public static int setNativeLanguage(int lan) {
        return SSLVPN.setLanguage(lan);
    }

    private int addAddress(String addr, int prefixLen, int mtu) {
        VpnService.Builder builder = null;
        if (TunVpnService.tunVpnObj == null) {
            return -1;
        }
        try {
            if (TunVpnService.mInterface != null) {
                Log.d(TAG, "TunVpnService.mInterface.close");
                TunVpnService.mInterface.close();
                TunVpnService.mInterface = null;
                TunVpnService.tunVpnObj.destroyBuilder();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TunVpnService.tunVpnObj.destroyBuilder();
        builder = TunVpnService.tunVpnObj.createBuilder();
        if (MyApplication.myApplication.sslvpn != null) {
            MyApplication.myApplication.sslvpn.closeTunFd();
        }
        Log.d(TAG, "addAddress " + addr + " " + prefixLen);
        Log.d(TAG, "addAddress mtu \uff1a" + mtu);
        try {
            builder.addAddress(addr, prefixLen);
            builder.setMtu(mtu);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    private int addRoute(String addr, int prefixLen) {
        VpnService.Builder builder = null;
        if (TunVpnService.tunVpnObj == null) {
            return -1;
        }
        builder = TunVpnService.tunVpnObj.getBuilder();
        if (builder == null) {
            builder = TunVpnService.tunVpnObj.createBuilder();
        }
        if (MyApplication.myApplication.propertiesConfig.getDisablePublicNetwork() == 1) {
            Log.d(TAG, "Disable public network. Add route 0.0.0.0/0");
            addr = "0.0.0.0";
            prefixLen = 0;
        }
        Log.d(TAG, "addRoute " + addr + " " + prefixLen);
        try {
            builder.addRoute(addr, prefixLen);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    private int configTun() {
        if (TunVpnService.tunVpnObj == null) {
            return -1;
        }
        return TunVpnService.tunVpnObj.getTunFd();
    }

    private void setSessionId(String id2) {
        TunVpnService.setSessionId(id2);
    }

    public int setTunFd(int fd) {
        return this.setTunFd(this.hHandle, fd);
    }

    private native int setTunFd(int var1, int var2);

    public int getSSLSocketFd() {
        return this.getSSLSocketFd(this.hHandle);
    }

    private native int getSSLSocketFd(int var1);

    public void closeTunFd() {
        this.closeTunFd(this.hHandle);
    }

    private native int closeTunFd(int var1);

    private void getWakeLock() {
        this.pm = (PowerManager)MyApplication.myApplication.getSystemService("power");
        this.mWakeLock = this.pm.newWakeLock(1, "XYTEST");
        Log.d(TAG, "mWakeLock.acquire");
        this.mWakeLock.acquire();
    }

    private void releaseWakeLock() {
        Log.d(TAG, "mWakeLock.release");
        if (this.mWakeLock != null) {
            this.mWakeLock.release();
        }
    }

    private String getIpAddress() {
        String ipAddr = null;
        String gateWayIp = null;
        if (MyApplication.myApplication.propertiesConfig.getmHuNanJwt() == 0) {
            return null;
        }
        Log.d(TAG, "version for HuNan Jwt");
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            block2: while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    Log.d(TAG, "hostAddr = " + inetAddress.getHostAddress().toString());
                    ipAddr = inetAddress.getHostAddress().toString();
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ipAddr == null) {
            return null;
        }
        Log.d(TAG, "ipAddr = " + ipAddr);
        String[] temp = ipAddr.split("\\.");
        if (temp.length < 4) {
            return null;
        }
        if (temp[0].equals("10")) {
            if (temp[1].equals("2")) {
                gateWayIp = new String(MyApplication.myApplication.sslClientConfig.getGateWayIp());
            } else if (temp[1].equals("0")) {
                gateWayIp = new String(MyApplication.myApplication.sslClientConfig.getGateWayIp2());
            }
        }
        if (gateWayIp != null) {
            Log.d(TAG, "gateWayIp = " + gateWayIp);
        }
        return gateWayIp;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getIpAddrByProviders() {
        String gateWayIp = null;
        if (MyApplication.myApplication.propertiesConfig.getPickIpByProviders() == 0) {
            return null;
        }
        if (Compatibility.isZhangJiaJieBase()) {
            String ip = Function.getIP();
            if (TextUtils.isEmpty((CharSequence)ip)) {
                Log.e(TAG, "IP address is null");
                return null;
            }
            String[] ipParams = ip.split(".");
            if (ipParams.length != 4) {
                Log.e(TAG, "IP format invalid");
                return gateWayIp;
            }
            String firstIp = ipParams[0];
            String secondIp = ipParams[1];
            String thirdIp = ipParams[2];
            String fourthIp = ipParams[3];
            if (firstIp.equals("192") && secondIp.equals("168") && Integer.parseInt(thirdIp) >= 0 && Integer.parseInt(thirdIp) <= 7 && Integer.parseInt(fourthIp) >= 0 && Integer.parseInt(fourthIp) <= 254) {
                gateWayIp = new String(MyApplication.myApplication.sslClientConfig.getGateWayIp());
                Log.d(TAG, "ZhangJiajie China Mobile    " + ip);
            }
            if (!firstIp.equals("172")) return gateWayIp;
            if (!secondIp.equals("16")) return gateWayIp;
            if (Integer.parseInt(thirdIp) < 0) return gateWayIp;
            if (Integer.parseInt(thirdIp) > 7) return gateWayIp;
            if (Integer.parseInt(fourthIp) < 0) return gateWayIp;
            if (Integer.parseInt(fourthIp) > 255) return gateWayIp;
            gateWayIp = new String(MyApplication.myApplication.sslClientConfig.getGateWayIp3());
            Log.d(TAG, "ZhangJiajie China Telecome  " + ip);
            return gateWayIp;
        }
        Log.d(TAG, "version for zz Jwt");
        String provider = Function.getProvidersName(MyApplication.myApplication.getApplicationContext());
        if (provider != null) {
            gateWayIp = provider.equals("\u4e2d\u56fd\u79fb\u52a8") ? new String(MyApplication.myApplication.sslClientConfig.getGateWayIp()) : (provider.equals("\u4e2d\u56fd\u8054\u901a") ? new String(MyApplication.myApplication.sslClientConfig.getGateWayIp2()) : (provider.equals("\u4e2d\u56fd\u7535\u4fe1") ? new String(MyApplication.myApplication.sslClientConfig.getGateWayIp3()) : new String(MyApplication.myApplication.sslClientConfig.getGateWayIp())));
        }
        if (gateWayIp != null) return gateWayIp;
        return new String(MyApplication.myApplication.sslClientConfig.getGateWayIp());
    }

    private void startVpn(Context context) {
        MyApplication myApplication = MyApplication.myApplication;
        if (myApplication == null) {
            Log.e(TAG, "startVpn,myApplication == null");
        }
        if (myApplication.sslClientConfig.getTransportMode() == 0) {
            Intent intent = new Intent();
            intent.setClassName(context.getPackageName(), "com.xdja.safeclient.VpnService");
            context.startService(intent);
        } else {
            ComponentName componetName = new ComponentName(context.getPackageName(), "com.xdja.safeclient.activity.StartVpnActivity");
            try {
                Intent intent = new Intent();
                intent.setFlags(0x10000000);
                intent.setComponent(componetName);
                context.startActivity(intent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stopVpn() {
        MyApplication myApplication = MyApplication.myApplication;
        if (0 == myApplication.sslClientConfig.transportMode) {
            Function.setSafeVpnState(myApplication.getApplicationContext(), false);
            VpnService.stopService = true;
            this.stopVpnService(myApplication);
        } else {
            this.stopTunVpnService(myApplication);
        }
    }

    public void stopVpnService(MyApplication myApplication) {
        boolean res = false;
        Log.d(TAG, "stop VpnService...");
        Intent intent = new Intent();
        intent.setClassName(MyApplication.packageName, "com.xdja.safeclient.VpnService");
        res = myApplication.stopService(intent);
        if (!res) {
            Log.e(TAG, "stop VpnService failed");
        } else {
            Log.d(TAG, "stop VpnService success ");
        }
    }

    public void stopTunVpnService(MyApplication myApplication) {
        Log.d(TAG, "stop TunVpnService...");
        if (myApplication == null) {
            Log.e(TAG, "myApplication == null");
        }
        try {
            boolean res = false;
            try {
                if (TunVpnService.mInterface != null) {
                    Log.d(TAG, "TunVpnService.mInterface.close");
                    TunVpnService.mInterface.close();
                    TunVpnService.mInterface = null;
                    if (TunVpnService.tunVpnObj != null) {
                        TunVpnService.tunVpnObj.destroyBuilder();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (myApplication.sslvpn != null) {
                myApplication.sslvpn.closeTunFd();
            }
            Intent intent = new Intent();
            intent.setClassName(MyApplication.packageName, "com.xdja.safeclient.TunVpnService");
            res = myApplication.stopService(intent);
            if (!res) {
                Log.e(TAG, "stop TunVpnService failed");
            } else {
                Log.d(TAG, "stop TunVpnService success ");
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    void restartVpnService() {
        if (Build.VERSION.SDK_INT >= 23) {
            return;
        }
        MyApplication myApplication = MyApplication.myApplication;
        if (myApplication.propertiesConfig != null && myApplication.propertiesConfig.getIsWakeLock() == 1) {
            return;
        }
        if (0 != myApplication.sslClientConfig.transportMode) {
            return;
        }
        Log.d(TAG, "restart Vpn Service");
        if (SafeVerifyActivity.stopBtnClick) {
            return;
        }
        this.stopVpn();
        Log.d(TAG, "stopVpn");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Log.d(TAG, "startVpn");
        this.startVpn(MyApplication.myApplication.getApplicationContext());
    }

    String codeConvert(String in) {
        Log.d(TAG, "codeConvert, in = " + in);
        try {
            String utf8 = new String(in.getBytes("utf-8"));
            Log.d(TAG, "codeConvert, utf8 = " + utf8);
            String unicode = new String(utf8.getBytes(), "utf-8");
            Log.d(TAG, "codeConvert, unicode = " + unicode);
            String out = new String(in.getBytes("GBK"));
            Log.d(TAG, "codeConvert, out = " + out);
            return out;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    void notifySateChange(int len, byte[] state) throws UnsupportedEncodingException {
        if (len > 0) {
            if (0 == MyApplication.myApplication.sslClientConfig.transportMode) {
                VpnService.vpnObject.stateChange(Arrays.copyOfRange(state, 4, len), len - 4);
            } else {
                TunVpnService.tunVpnObj.stateChange(Arrays.copyOfRange(state, 4, len), len - 4);
            }
        }
    }

    private native int init();

    private native int setParam(int var1, SslClientConfig var2);

    private native int startService(int var1);

    private native int getStatus(int var1, SslvpnStatus var2);

    private native int stopService(int var1);

    private native int release(int var1);

    private static native int startXdjaKeyServer(String var0, int var1, Object var2);

    private static native int stopXdjaKeyServer();

    private static native int setLanguage(int var0);

    private native int guardianLearn(int var1, int var2, long var3);

    public static native void initVPN(String var0, String var1, int var2, int var3, int var4);

    private native byte[] excuteCmd(int var1, String var2);

    private native void syncErrorState(int var1, int var2);

    private native void notifyNetworkReconnect(int var1, int var2);

    public static native int parsePKCS12(String var0, String var1, byte[] var2, int[] var3, byte[] var4, int[] var5);

    public void notifyNetworkReconnect(int connected) {
        this.notifyNetworkReconnect(this.hHandle, connected);
    }

    public void syncErrorState(int errCode) {
        this.syncErrorState(this.hHandle, errCode);
    }

    public String excuteOuterCmd(String cmd) {
        byte[] resultArray = this.excuteCmd(this.hHandle, cmd);
        String result = null;
        try {
            result = new String(resultArray, "gbk");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (Compatibility.getAreaVersion() == 3001 && MyApplication.myApplication != null) {
            Context context = MyApplication.myApplication.getApplicationContext();
            if (cmd.equals("GETSTATUS") && !TextUtils.isEmpty((CharSequence)result)) {
                String[] commentArray = result.split(" ");
                String resultStr = commentArray[0];
                String stageStr = commentArray[1];
                String errCodeStr = commentArray[2];
                if (resultStr.equals("FAILED") && errCodeStr.equals("-97")) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(resultStr).append(" ").append(stageStr).append(" ").append(errCodeStr).append(" ").append(context.getString(R.string.guoshui_key_not_exist));
                    return sb.toString();
                }
            }
        }
        return result;
    }

    private int addDnsServer(String addr) {
        VpnService.Builder builder = null;
        if (TunVpnService.tunVpnObj == null) {
            return -1;
        }
        builder = TunVpnService.tunVpnObj.getBuilder();
        if (builder == null) {
            builder = TunVpnService.tunVpnObj.createBuilder();
        }
        Log.d(TAG, "addDnsServer " + addr);
        try {
            builder.addDnsServer(addr);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    private int setPreferedGatewayIndex(int index) {
        MyApplication application = MyApplication.myApplication;
        if (application == null) {
            Log.e(TAG, "setPreferedGatewayIPIndex application == null.");
            return -1;
        }
        Log.d(TAG, "setPreferedGatewayIPIndex index = " + index);
        SharedPreferencesUtil.put((Context)application, "prefered_gateway_index", index);
        return 0;
    }

    private int getPreferedGatewayIndex() {
        if (Compatibility.getAreaVersion() == 10000) {
            return 0;
        }
        MyApplication application = MyApplication.myApplication;
        if (application == null) {
            Log.e(TAG, "getPreferedGatewayIPIndex application == null.");
            return 0;
        }
        Integer index = (Integer)SharedPreferencesUtil.get((Context)application, "prefered_gateway_index", 0);
        if (index == null) {
            return 0;
        }
        return index;
    }

    private void notifyNetworkTimeout() {
        MyApplication.myApplication.sendBroadcast(new Intent("com.xdja.safeclient.action.STOP_SERVICE"));
        Compatibility.showNetTimeoutDialog();
    }

    private void initAppAclType(int type) {
        this.appAclList.setAclType(type);
    }

    private void addAppAclRule(String packageName, String hash, String comment) {
        Log.d(TAG, "Package name " + packageName + " hash code " + hash + " comment " + comment);
        this.appAclList.getRuleList().add(new AppAclRule(packageName, hash, comment));
    }

    private void clearAppAclRule() {
        this.appAclList.getRuleList().clear();
    }

    static {
        System.loadLibrary("guardian");
        System.loadLibrary("safekey");
        System.loadLibrary("safetf");
        System.loadLibrary("xdjakeyserver");
        System.loadLibrary(TAG);
        System.loadLibrary("key_mgr");
        System.loadLibrary("key_zhongfu");
    }
}

