/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sslvpn.api;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.xdja.sslvpn.api.VPNApi;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VPN
implements VPNApi {
    public static final String AUTOHORITY = "com.xdja.providers.safetfprovider";
    public static final String METHOD_STARTSAFECLIENT = "startSafeClient";
    public static final String METHOD_GETVERSION = "getVersion";
    public static final String METHOD_ISEXISTDEV = "isExistDev";
    public static final String METHOD_OPENDEV = "openDev";
    public static final String METHOD_CLOSEDEV = "closeDev";
    public static final String METHOD_LOCKDEV = "lockDev";
    public static final String METHOD_UNLOCKDEV = "unlockDev";
    public static final String METHOD_TRANSMIT = "transmit";
    public static final String METHOD_GETDEVINFO = "getDevInfo";
    public static final String METHOD_SETLOGPATH = "setLogPath";
    public static final String METHOD_CHANGEPIN = "changePIN";
    public static final String METHOD_GETPINTRYCOUNT = "getPinTryCount";
    public static final String METHOD_VERIFYPIN = "verifyPIN";
    public static final String METHOD_CARDRESET = "cardReset";
    public static final String METHOD_SELECTFILE = "selectFile";
    public static final String METHOD_GETDIRSIZE = "getDirSize";
    public static final String METHOD_CREATEFILE = "createFile";
    public static final String METHOD_GETFILEINFO = "getFileInfo";
    public static final String METHOD_READFILE = "readFile";
    public static final String METHOD_WRITEFILE = "writeFile";
    public static final String METHOD_READRSAPUBKEY = "readRsaPubKey";
    public static final String METHOD_WRITERSAPUBKEY = "writeRsaPubKey";
    public static final String METHOD_READCERT = "readCert";
    public static final String METHOD_WRITECERT = "writeCert";
    public static final String METHOD_GENRANDOM = "genRandom";
    public static final String METHOD_SM1 = "sm1";
    public static final String METHOD_TMPSM1 = "tmpSM1";
    public static final String METHOD_SM1KEY = "sm1key";
    public static final String METHOD_SM4KEY = "sm4key";
    public static final String METHOD_SM6KEY = "sm6key";
    public static final String METHOD_GENRSAKEYPAIR = "genRSAKeyPair";
    public static final String METHOD_RSAPUBKEYCALC = "rsaPubKeyCalc";
    public static final String METHOD_RSAPRIKEYCALC = "rsaPriKeyCalc";
    public static final String METHOD_RSASIGN = "rsaSign";
    public static final String METHOD_RSASIGNWITHOUTDER = "rsaSignNoDER";
    public static final String METHOD_RSASIGNVERIFY = "rsaSignVerify";
    public static final String METHOD_SM2SIGN = "sm2Sign";
    public static final String METHOD_SM2SIGNVERIFY = "sm2SignVerify";
    public static final String METHOD_SHA1 = "sha1";
    public static final String METHOD_SM3 = "sm3";
    public static final String METHOD_GETTFMOUNTPATH = "getTFMountPath";
    public static final String METHOD_GETSAFECARDID = "getSafeCardID";
    public static final String METHOD_GETPOLICEMANID = "getPolicemanID";
    public static final String METHOD_GET_LAST_VERIFY_TIME = "getLastVerifyTime";
    public static final String METHOD_GET_VPN_TUNNEL_STATE = "getVPNTunnelState";
    public static final String METHOD_GET_MONITOR_SERVER_ADDRESS = "getMonitorServerAddress";
    public static final String METHOD_GET_VENDOR_INFO = "getVendorInfo";
    public static final String METHOD_CHECK_WEAK_PASSWD = "checkWeakPassWD";
    public static final String METHOD_PASSWORD_ENTER = "passwordEnter";
    public static final String METHOD_READ_DEFAULT_CERT = "readDefaultCert";
    public static final String METHOD_EXCUTE_CMD = "excuteCmd";
    public static final Uri SAFETF_URI = Uri.parse((String)"content://com.xdja.providers.safetfprovider");
    private static final Uri URI = Uri.parse((String)"content://com.xdja.providers.safetfprovider");
    private ContentResolver contentResolver = null;
    private Context mContext = null;

    public VPN(Context c) {
        this.mContext = c.getApplicationContext();
        this.contentResolver = c.getContentResolver();
    }

    @Override
    public int start() {
        int ret;
        try {
            Bundle result = this.contentResolver.call(URI, METHOD_STARTSAFECLIENT, null, null);
            ret = result.getInt("ret");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return -2;
        }
        return ret;
    }

    @Override
    public int stop() {
        Intent intent = new Intent();
        intent.setAction("com.xdja.safeclient.action.STOP_SERVICE");
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    @Override
    public VPNApi.StateResult getStatus() {
        VPNApi.StateResult state = new VPNApi.StateResult();
        Bundle inBundle = new Bundle();
        inBundle.putString("cmd", "GETSTATUS");
        try {
            Bundle outBundle = this.contentResolver.call(URI, METHOD_EXCUTE_CMD, null, inBundle);
            int ret = outBundle.getInt("ret");
            if (ret == 0) {
                String comment = outBundle.getString("result");
                String[] commentArray = comment.split(" ");
                String resultStr = commentArray[0];
                String stageStr = commentArray[1];
                String errCodeStr = commentArray[2];
                int errCode = Integer.valueOf(errCodeStr);
                int commentStartIndex = VPN.getCharacterPosition(comment, " ", 3);
                String reasonStr = comment.substring(commentStartIndex);
                state.setComment(reasonStr);
                if (resultStr.equals("OK") && stageStr.equals("100")) {
                    state.setCode(0);
                } else if (resultStr.equals("OK") || errCode >= 0) {
                    state.setCode(1);
                } else if (resultStr.equals("FAILED")) {
                    state.setCode(2);
                }
                state.setOriginalCode(errCode);
            } else {
                state.setCode(-1);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            state.setCode(-2);
        }
        return state;
    }

    @Override
    public String getCardID() {
        try {
            Bundle result = this.contentResolver.call(URI, METHOD_GETSAFECARDID, null, null);
            return result.getString("result");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static int getCharacterPosition(String string2, String pattern, int index) {
        Matcher slashMatcher = Pattern.compile(pattern).matcher(string2);
        int mIdx = 0;
        while (slashMatcher.find() && ++mIdx != index) {
        }
        return slashMatcher.start();
    }
}

