/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.third.emm;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.xdja.emm.framework.binder.IEmmFunctionServer;
import com.xdja.safeclient.utils.Log;
import com.xdja.third.emm.EmmServcieCallback;

public class SecManager {
    private final String TAG = "SecManager";
    private IEmmFunctionServer mEmmServer = null;
    private boolean mConnectServerFlag = false;
    private static final String SERVER_NAME = "xdja.emm.sec.service";
    private static volatile SecManager instance = null;
    private EmmServcieCallback callback = null;
    ServiceConnection connection = new ServiceConnection(){

        public void onServiceDisconnected(ComponentName name) {
            Log.v("SecManager", "EmmSecManager onServiceDisconnected()");
            SecManager.this.mConnectServerFlag = false;
            if (SecManager.this.callback != null) {
                SecManager.this.callback.onDisnnected();
            }
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.v("SecManager", "EmmSecManager onServiceConnected()");
            SecManager.this.mEmmServer = IEmmFunctionServer.Stub.asInterface(service);
            SecManager.this.mConnectServerFlag = true;
            if (SecManager.this.callback != null) {
                SecManager.this.callback.onConnected();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecManager getInstance() {
        if (null != instance) return instance;
        Class<SecManager> clazz = SecManager.class;
        synchronized (SecManager.class) {
            if (null != instance) return instance;
            instance = new SecManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initServer(Context mContext, EmmServcieCallback callback) {
        Log.v("SecManager", "EmmSecManager initServer()");
        Intent intent = new Intent();
        intent.setAction(SERVER_NAME);
        intent.setPackage("com.xdja.emm.framework");
        mContext.bindService(intent, this.connection, 1);
        this.callback = callback;
    }

    public void destroyService(Context mContext) {
        Log.v("SecManager", "EmmSecManager destroyService()");
        mContext.unbindService(this.connection);
    }

    public int silentInstall(String uri, int flags) {
        Log.v("SecManager", "EmmSecManager silentInstall() mConnectServerFlag = " + this.mConnectServerFlag);
        if (!this.isConnectServer()) {
            return -101;
        }
        boolean flag = false;
        try {
            flag = this.mEmmServer.silentInstall(uri, flags);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return flag ? 1 : 0;
    }

    public boolean isConnectServer() {
        return this.mConnectServerFlag;
    }
}

