/*
 * Decompiled with CFR 0.152.
 */
package com.zf.simkeym;

import android.util.Log;
import com.zf.simkeyb.mb.zfBleApi;

public class SimKeyCmd {
    private static final String TAG = "SimKeyCmd";
    private static zfBleApi mBleApi;

    public SimKeyCmd() {
        Log.e((String)TAG, (String)"new SimKeyCmd");
        this.initContext();
    }

    public int initContext() {
        if (mBleApi == null) {
            mBleApi = new zfBleApi();
        }
        if (!mBleApi.initialize()) {
            Log.e((String)TAG, (String)"This Mobil Phone is not available for Ble function!");
            return 1;
        }
        return 0;
    }

    public boolean isBtEnabled() {
        return mBleApi.isBtEnabled();
    }

    public int enumDevice(byte[] deviceList, int[] listLen) {
        return mBleApi.SMK_EnumDevice(deviceList, listLen);
    }

    public int openDevice(byte[] deviceName, byte[] deviceHandle) {
        Log.i((String)TAG, (String)"openDevice begin connect");
        int ret_val = 1;
        String strDeviceName = new String(deviceName);
        Log.i((String)TAG, (String)strDeviceName);
        ret_val = mBleApi.SMK_Connect(strDeviceName);
        if (ret_val == 0) {
            Log.i((String)TAG, (String)"SMK_Connect OK");
        } else {
            Log.e((String)TAG, (String)"SMK_Connect Fail");
        }
        System.arraycopy(deviceName, 0, deviceHandle, 0, deviceName.length);
        Log.i((String)TAG, (String)"openDevice end");
        return ret_val;
    }

    public int closeDevice(byte[] deviceHandle) {
        Log.i((String)TAG, (String)"closeDevice begin");
        int ret_val = 1;
        String strDeviceName = new String(deviceHandle);
        ret_val = mBleApi.SMK_DisConnect(strDeviceName);
        if (ret_val == 0) {
            Log.i((String)TAG, (String)"SMK_DisConnect OK");
        } else {
            Log.e((String)TAG, (String)"SMK_DisConnect Fail");
        }
        Log.i((String)TAG, (String)"closeDevice");
        return ret_val;
    }

    public int simkeyCommandApi(byte[] deviceHandle, byte[] inBuf, int inLen, byte[] outBuf, int[] outLen) {
        Log.i((String)TAG, (String)"simkeyCommandApi begin");
        int ret_val = 1;
        byte[] responseData = new byte[outLen[0] + 16];
        int[] responseLen = new int[2];
        int outPos = 0;
        String strDeviceName = new String(deviceHandle);
        Log.i((String)TAG, (String)("device name: " + strDeviceName));
        responseLen[0] = outLen[0] + 4;
        ret_val = mBleApi.SMK_CommandApi(strDeviceName, inBuf, inLen, responseData, responseLen);
        Log.i((String)TAG, (String)("ret = " + ret_val));
        if (ret_val == 0) {
            ret_val = (responseData[responseLen[0] - 2] & 0xFF) << 8 | responseData[responseLen[0] - 1] & 0xFF;
            if (ret_val != 36864) {
                Log.e((String)TAG, (String)"commandapi");
                Log.e((String)TAG, (String)("ret = " + ret_val));
                if (97 == (ret_val >> 8 & 0xFF)) {
                    outLen[0] = responseLen[0] - 2;
                    if (responseLen[0] > 2) {
                        outPos = 0;
                        System.arraycopy(responseData, outPos, outBuf, 0, responseLen[0] - 2);
                        outLen[0] = responseLen[0] - 2;
                    }
                }
            } else {
                outPos = 0;
                if (responseLen[0] > 2) {
                    System.arraycopy(responseData, outPos, outBuf, 0, responseLen[0] - 2);
                    outLen[0] = responseLen[0] - 2;
                } else if (2 == responseLen[0]) {
                    outLen[0] = 0;
                }
            }
        } else {
            Log.i((String)TAG, (String)"SMK_CommandApi");
            Log.i((String)TAG, (String)("ret = " + ret_val));
        }
        if (ret_val == 0) {
            ret_val = 1;
        }
        Log.i((String)TAG, (String)"simkeyCommandApi end");
        return ret_val;
    }
}

