/*
 * Decompiled with CFR 0.152.
 */
package com.longmai.security.plugin.driver.ble.io.stack;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import com.longmai.security.plugin.base.PluginException;
import com.longmai.security.plugin.driver.ble.base.MessagePool;
import com.longmai.security.plugin.util.Hex;
import com.longmai.security.plugin.util.Int2Bytes;
import com.longmai.security.plugin.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class BleMessagePool
extends MessagePool {
    private static final String TAG = BleMessagePool.class.getName();
    private static final int MAX_BUFF = 20;
    private ByteArrayOutputStream pool;
    private BluetoothGatt serverGatt;
    private BluetoothGattCharacteristic writeCharacteristic;
    private int timeOut;
    private static volatile byte counter = (byte)-128;
    private static final byte[] _STX = "@STX".getBytes();
    private static final byte[] _ETX = "@ETX".getBytes();
    private static volatile int transferState;
    private static final int SEND_OK = 0;
    private static final int SEND_ING = 1;
    private static final int WAIT_ING = 2;
    private static final int WAIT_TIMEOUT = 3;
    private static final int BLE_DATA = 4;
    private static final int BLE_PROTOCOL = 5;
    private byte[] readBuffer;

    @Override
    public void init() throws PluginException {
        LogUtil.d((String)TAG, (String)"init()");
        this.pool = new ByteArrayOutputStream(4096);
    }

    @Override
    public void setTimeOut(int timeOut) {
        LogUtil.d((String)TAG, (String)("setTimeOut() timeOut:" + timeOut));
        this.timeOut = timeOut;
    }

    @Override
    public int getTimeOut() {
        LogUtil.d((String)TAG, (String)("getTimeOut() timeOut:" + this.timeOut));
        return this.timeOut;
    }

    @Override
    public int write(byte[] apdu) throws IOException {
        return this.write(apdu, 0, apdu.length, 128);
    }

    @Override
    public synchronized int write(byte[] apdu, int off, int len, int protocol) throws IOException {
        LogUtil.d((String)TAG, (String)("write() - apdu:" + new String(Hex.encode((byte[])apdu, (int)off, (int)len)) + " protocol:" + protocol));
        byte[] cmd = this.padding(apdu, off, len);
        if (cmd == null) {
            throw new IOException("apdu padding exception");
        }
        switch (protocol) {
            case 0: 
            case 128: 
            case 240: 
            case 241: 
            case 242: 
            case 255: {
                cmd[4] = (byte)protocol;
                break;
            }
            default: {
                throw new IOException("apdu protocol " + protocol + " exception");
            }
        }
        int i = 0;
        while (i < 3) {
            cmd[5] = counter = (byte)(counter + 1);
            LogUtil.w((String)TAG, (String)new String(Hex.encode((byte[])cmd)));
            this.bleSendApdu(cmd);
            try {
                LogUtil.d((String)TAG, (String)("BleMessagePool.read.waiting() - timeOut:" + this.timeOut));
                this.wait(this.timeOut);
                LogUtil.d((String)TAG, (String)"BleMessagePool.read.waited()");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            switch (transferState) {
                case 0: {
                    LogUtil.d((String)TAG, (String)"Send success");
                    return len;
                }
                case 2: {
                    LogUtil.w((String)TAG, (String)("Send timeout " + i));
                    break;
                }
                case 4: {
                    LogUtil.w((String)TAG, (String)"Send failed");
                    break;
                }
                case 5: {
                    throw new IOException("key exchange failed");
                }
            }
            ++i;
        }
        throw new IOException("ble transfer Exception");
    }

    @Override
    public byte[] read() throws IOException {
        LogUtil.d((String)TAG, (String)"read()");
        return this.unpadding(this.readBuffer, 0, this.readBuffer.length);
    }

    @Override
    public void destroy() throws PluginException {
        LogUtil.d((String)TAG, (String)"destroy()");
        this.pool = null;
    }

    @Override
    public void onReceive(byte[] buffer) throws IOException {
        this.onReceive(buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReceive(byte[] buffer, int offset, int length) throws IOException {
        LogUtil.d((String)TAG, (String)("onReceive() - buffer:" + new String(Hex.encode((byte[])buffer, (int)offset, (int)length))));
        if (this.pool != null) {
            this.pool.write(buffer);
            byte[] cmd = this.extract();
            if (cmd != null) {
                if (cmd[5] == counter) {
                    int e = this.getApduErrorCode(cmd);
                    switch (e) {
                        case 0: {
                            this.readBuffer = cmd;
                            transferState = 0;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            transferState = 4;
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e1) {
                                e1.printStackTrace();
                            }
                            break;
                        }
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 239: {
                            transferState = 5;
                        }
                    }
                    LogUtil.d((String)TAG, (String)"BleMessagePool.read.notifying()");
                    BleMessagePool bleMessagePool = this;
                    synchronized (bleMessagePool) {
                        LogUtil.d((String)TAG, (String)"BleMessagePool.read.notify()");
                        this.notify();
                    }
                } else {
                    LogUtil.w((String)TAG, (String)("counter:" + cmd[5] + " do not match."));
                    LogUtil.w((String)TAG, (String)new String(Hex.encode((byte[])cmd)));
                }
            } else {
                LogUtil.w((String)TAG, (String)"extract() is null");
            }
        } else {
            throw new IOException();
        }
    }

    @Override
    public void setWriteCharacteristic(BluetoothGatt serverGatt, BluetoothGattCharacteristic writeCharacteristic) throws IOException {
        LogUtil.d((String)TAG, (String)"setWriteCharacteristic()");
        if (serverGatt == null) {
            throw new IOException("ble gatt is null");
        }
        if (writeCharacteristic == null) {
            throw new IOException("writeCharacteristic is null");
        }
        this.serverGatt = serverGatt;
        this.writeCharacteristic = writeCharacteristic;
    }

    public int bleSendApdu(byte[] cmd) throws IOException {
        LogUtil.d((String)TAG, (String)("bleSendApdu()  counter: " + counter));
        transferState = 1;
        if (this.writeCharacteristic == null) {
            throw new IOException("writeCharacteristic is null");
        }
        byte[] stx = new byte[8];
        System.arraycopy(cmd, 0, stx, 0, 8);
        this.writeCharacteristic.setValue(stx);
        boolean sendFlag = this.writeCharacteristic(this.writeCharacteristic);
        if (!sendFlag) {
            throw new IOException("ble transfer stx exception");
        }
        byte[] data = new byte[cmd.length - 16];
        System.arraycopy(cmd, 8, data, 0, data.length);
        int nCount = data.length / 20;
        int nLeft = data.length % 20;
        int i = 0;
        while (i < nCount) {
            byte[] tmp = new byte[20];
            System.arraycopy(data, i * 20, tmp, 0, 20);
            this.writeCharacteristic.setValue(tmp);
            sendFlag = this.writeCharacteristic(this.writeCharacteristic);
            if (!sendFlag) {
                throw new IOException("ble transfer apdu exception");
            }
            ++i;
        }
        if (nLeft > 0) {
            byte[] tmp = new byte[nLeft];
            System.arraycopy(data, nCount * 20, tmp, 0, nLeft);
            this.writeCharacteristic.setValue(tmp);
            sendFlag = this.writeCharacteristic(this.writeCharacteristic);
            if (!sendFlag) {
                throw new IOException("ble transfer apdu exception");
            }
        }
        byte[] etx = new byte[8];
        System.arraycopy(cmd, cmd.length - 8, etx, 0, 8);
        this.writeCharacteristic.setValue(etx);
        sendFlag = this.writeCharacteristic(this.writeCharacteristic);
        if (!sendFlag) {
            throw new IOException("ble transfer etx exception");
        }
        transferState = 2;
        return 0;
    }

    public synchronized boolean writeCharacteristic(BluetoothGattCharacteristic characteristic) {
        LogUtil.d((String)TAG, (String)"writeCharacteristic()");
        boolean flag = this.serverGatt.writeCharacteristic(characteristic);
        if (!flag) {
            return flag;
        }
        try {
            LogUtil.w((String)TAG, (String)"BleMessagePool.write.waiting()");
            this.wait(5000L);
            LogUtil.w((String)TAG, (String)"BleMessagePool.write.waited()");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        return flag;
    }

    private byte[] padding(byte[] apdu, int off, int length) {
        LogUtil.d((String)TAG, (String)"padding()");
        byte[] BLELen = Int2Bytes.int2byte((int)length, (int)2, (boolean)false);
        byte[] CMD = new byte[_STX.length + 4 + length + 4 + _ETX.length];
        System.arraycopy(_STX, 0, CMD, 0, 4);
        System.arraycopy(BLELen, 0, CMD, 6, 2);
        System.arraycopy(apdu, off, CMD, 8, length);
        System.arraycopy(_ETX, 0, CMD, 8 + length + 4, 4);
        return CMD;
    }

    private byte[] unpadding(byte[] CMD, int off, int length) {
        LogUtil.d((String)TAG, (String)"unpadding()");
        int e = this.getApduErrorCode(CMD);
        if (e != 0) {
            return null;
        }
        byte[] BLELen = new byte[]{CMD[6], CMD[7]};
        int apduLength = Int2Bytes.bytes2int((byte[])BLELen, (boolean)false);
        byte[] apdu = new byte[apduLength];
        System.arraycopy(CMD, 8, apdu, 0, apduLength);
        return apdu;
    }

    private int getApduErrorCode(byte[] cmd) throws RuntimeException {
        LogUtil.d((String)TAG, (String)("getApduErrorCode() - cmd: " + new String(Hex.encode((byte[])cmd))));
        if (!new String(cmd).startsWith("@STX")) {
            return 4;
        }
        byte[] BLELen = new byte[]{cmd[6], cmd[7]};
        int _BLELen = Int2Bytes.bytes2int((byte[])BLELen, (boolean)false);
        byte[] ErrorCode = new byte[4];
        try {
            ErrorCode[0] = cmd[_STX.length + BLELen.length + 2 + _BLELen];
            ErrorCode[1] = cmd[_STX.length + BLELen.length + 2 + _BLELen + 1];
            ErrorCode[2] = cmd[_STX.length + BLELen.length + 2 + _BLELen + 2];
            ErrorCode[3] = cmd[_STX.length + BLELen.length + 2 + _BLELen + 3];
        }
        catch (Exception e) {
            e.printStackTrace();
            return 4;
        }
        int e = Int2Bytes.bytes2int((byte[])ErrorCode, (boolean)false);
        return e;
    }

    private byte[] extract() {
        LogUtil.d((String)TAG, (String)"extract()");
        byte[] buffer = this.pool.toByteArray();
        int endIndex = this.indexOf(buffer, _ETX);
        if (endIndex == -1) {
            return null;
        }
        int remainderLength = buffer.length - (endIndex + 4);
        int beginIndex = this.lastIndexOf(buffer, _STX, endIndex);
        if (beginIndex == -1) {
            this.pool.reset();
            this.pool.write(buffer, endIndex + 4, remainderLength);
            if (remainderLength >= 16) {
                return this.extract();
            }
        } else {
            ByteArrayOutputStream _tmp = new ByteArrayOutputStream();
            int len = endIndex - beginIndex + 4;
            _tmp.write(buffer, beginIndex, len);
            this.pool.reset();
            this.pool.write(buffer, endIndex + 4, remainderLength);
            return _tmp.toByteArray();
        }
        return null;
    }

    private int indexOf(byte[] buffer, byte[] value) {
        int buff_len = buffer.length - value.length;
        int val_len = value.length;
        int i = 0;
        while (i <= buff_len) {
            if (buffer[i] == value[0]) {
                if (val_len > 1) {
                    int j = 1;
                    while (j < val_len) {
                        if (buffer[i + j] == value[j]) {
                            if (j == val_len - 1) {
                                return i;
                            }
                            ++j;
                            continue;
                        }
                        break;
                    }
                } else {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private int lastIndexOf(byte[] buffer, byte[] value, int fromIndex) {
        int val_len = value.length;
        if (fromIndex > buffer.length - val_len) {
            fromIndex = buffer.length - val_len;
        }
        int i = fromIndex;
        while (i >= 0) {
            if (buffer[i] == value[0]) {
                if (val_len > 1) {
                    int j = 1;
                    while (j < val_len) {
                        if (buffer[i + j] == value[j]) {
                            if (j == val_len - 1) {
                                return i;
                            }
                            ++j;
                            continue;
                        }
                        break;
                    }
                } else {
                    return i;
                }
            }
            --i;
        }
        return -1;
    }
}

