/*
 * Decompiled with CFR 0.152.
 */
package com.zfsimkeys.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FileDigest {
    public static byte[] digestSHA1(String s) {
        byte[] digesta = null;
        try {
            MessageDigest alg = MessageDigest.getInstance("SHA-1");
            alg.update(s.getBytes());
            digesta = alg.digest();
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Error: digestSHA1 failed");
        }
        return digesta;
    }

    public static byte[] digestMD5(String s) {
        byte[] digesta = null;
        try {
            MessageDigest alg = MessageDigest.getInstance("MD5");
            alg.update(s.getBytes());
            digesta = alg.digest();
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Error: digestMD5 failed");
        }
        return digesta;
    }

    public static boolean isEqual(byte[] b, String s, int algo) {
        boolean r = false;
        try {
            MessageDigest alg = algo == 0 ? MessageDigest.getInstance("MD5") : MessageDigest.getInstance("SHA-1");
            alg.update(s.getBytes());
            r = MessageDigest.isEqual(b, alg.digest());
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Error: isEqual failed");
        }
        return r;
    }

    public static String byte2Str(byte[] b) {
        String str = "";
        String stmp = "";
        int n = 0;
        while (n < b.length) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            str = stmp.length() == 1 ? String.valueOf(str) + "0" + stmp : String.valueOf(str) + stmp;
            ++n;
        }
        return str;
    }
}

