/*
 * Decompiled with CFR 0.152.
 */
package com.zfsimkeys.security;

import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.util.Strings;

public class SimBltPKCS10CertificationRequest
extends CertificationRequest {
    private static Hashtable algorithms = new Hashtable();
    private static Hashtable params = new Hashtable();
    private static Hashtable keyAlgorithms = new Hashtable();
    private static Hashtable oids = new Hashtable();
    private static Vector noParams = new Vector();
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA1withRSA";

    static {
        algorithms.put("MD5WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("MD5WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("RSAWITHMD5", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("SHA1WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("SHA1WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("RSAWITHSHA1", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("SHA1WITHDSA", new DERObjectIdentifier("1.2.840.10040.4.3"));
        algorithms.put("DSAWITHSHA1", new DERObjectIdentifier("1.2.840.10040.4.3"));
        oids.put(new DERObjectIdentifier("1.2.840.113549.1.1.5"), "SHA1WITHRSA");
        oids.put(new DERObjectIdentifier("1.2.840.113549.1.1.4"), "MD5WITHRSA");
        oids.put(new DERObjectIdentifier("1.2.840.113549.1.1.2"), "MD2WITHRSA");
    }

    private static ASN1Sequence toDERSequence(byte[] bytes) {
        try {
            ASN1InputStream dIn = new ASN1InputStream(bytes);
            return (ASN1Sequence)dIn.readObject();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("badly encoded request");
        }
    }

    public SimBltPKCS10CertificationRequest(byte[] bytes) {
        super(SimBltPKCS10CertificationRequest.toDERSequence(bytes));
    }

    public SimBltPKCS10CertificationRequest(ASN1Sequence sequence) {
        super(sequence);
    }

    public SimBltPKCS10CertificationRequest(String signatureAlgorithm, String subjectName, SubjectPublicKeyInfo subPubKeyInfo, byte[] signData) throws Exception {
        String algorithmName = Strings.toUpperCase((String)signatureAlgorithm);
        DERObjectIdentifier sigOID = (DERObjectIdentifier)algorithms.get(algorithmName);
        if (sigOID == null) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        X509Name subject = new X509Name(subjectName);
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (signData == null) {
            throw new IllegalArgumentException("SimCertManage must not be null");
        }
        this.sigAlgId = AlgorithmIdentifier.getInstance((Object)sigOID.getId());
        try {
            this.reqInfo = new CertificationRequestInfo(subject, subPubKeyInfo, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't encode public key");
        }
        try {
            byte[] e = this.reqInfo.getEncoded();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("exception encoding TBS cert request - " + e);
        }
        this.sigBits = new DERBitString(signData);
    }

    private static X509Name convertName(String CN, String C, String O, String L, String ST) {
        X509Name subject;
        String dirName = "CN=" + CN + ",C=" + C + ",O=" + O + ",L=" + L + ",ST=" + ST;
        try {
            subject = new X509Name(dirName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert name");
        }
        return subject;
    }
}

