/*
 * Decompiled with CFR 0.152.
 */
package com.hed.bluetooth.le.datagram;

import android.annotation.SuppressLint;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@SuppressLint(value={"NewApi"})
public class BluetoothDatagram {
    public static final int MAX_DATA_SIZE = 1024;
    public static int MAX_CHARACTERISTIC_SIZE = 20;
    protected ByteArrayOutputStream mOutput = new ByteArrayOutputStream(1024);
    protected byte[] mData;
    protected boolean mIsEof = true;
    protected ArrayList<Byte> mBuffer = new ArrayList();

    public static BluetoothDatagram newDatagram(byte[] data) {
        return new BluetoothDatagram(data);
    }

    public static BluetoothDatagram newDatagram() {
        return new BluetoothDatagram();
    }

    BluetoothDatagram() {
    }

    BluetoothDatagram(byte[] data) {
        this.mData = (byte[])data.clone();
        this.mOutput.write(127);
        byte[] byArray = this.mData;
        int n = this.mData.length;
        int n2 = 0;
        while (n2 < n) {
            byte oneByte = byArray[n2];
            switch (oneByte) {
                case 127: {
                    this.mOutput.write(16);
                    this.mOutput.write(129);
                    break;
                }
                case -9: {
                    this.mOutput.write(16);
                    this.mOutput.write(130);
                    break;
                }
                case 16: {
                    this.mOutput.write(16);
                    this.mOutput.write(144);
                    break;
                }
                default: {
                    this.mOutput.write(oneByte);
                }
            }
            ++n2;
        }
        this.mOutput.write(247);
    }

    public int size() {
        return this.mOutput.size();
    }

    public byte[] toByteArray() {
        return this.mOutput.toByteArray();
    }

    public byte[] getData() {
        return this.mData;
    }

    public void parse(byte[] datagram) {
        this.parse(datagram, 0, datagram.length);
    }

    public void parse(byte[] datagram, int offset, int count) {
        int i = offset;
        while (i < count) {
            block0 : switch (datagram[i]) {
                case 127: {
                    this.mOutput.reset();
                    this.mIsEof = false;
                    break;
                }
                case 16: {
                    switch (datagram[i + 1]) {
                        case -127: {
                            this.mOutput.write(127);
                            ++i;
                            break block0;
                        }
                        case -126: {
                            this.mOutput.write(247);
                            ++i;
                            break block0;
                        }
                        case -112: {
                            this.mOutput.write(16);
                            ++i;
                            break block0;
                        }
                    }
                    this.mOutput.write(16);
                    break;
                }
                case -9: {
                    this.mIsEof = true;
                    this.mData = this.mOutput.toByteArray();
                    return;
                }
                default: {
                    this.mOutput.write(datagram[i]);
                }
            }
            ++i;
        }
    }

    public boolean isEof() {
        return this.mIsEof;
    }

    public List<byte[]> split(int maxSize) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        byte[] buffer = this.toByteArray();
        int offset = 0;
        while (offset <= this.size()) {
            if (offset == this.size()) break;
            list.add(Arrays.copyOfRange(buffer, offset, offset + Math.min(buffer.length - offset, maxSize)));
            offset += maxSize;
        }
        return list;
    }
}

