/*
 * Decompiled with CFR 0.152.
 */
package com.hed.bluetooth.le.datagram;

import android.annotation.SuppressLint;
import com.hed.bluetooth.le.datagram.BluetoothDatagram;

@SuppressLint(value={"NewApi"})
public class SLIPBluetoothDatagram
extends BluetoothDatagram {
    public static SLIPBluetoothDatagram newDatagram(byte[] data) {
        return new SLIPBluetoothDatagram(data);
    }

    public static SLIPBluetoothDatagram newDatagram() {
        return new SLIPBluetoothDatagram();
    }

    SLIPBluetoothDatagram() {
    }

    SLIPBluetoothDatagram(byte[] data) {
        this.mData = (byte[])data.clone();
        this.mOutput.write(192);
        byte[] byArray = this.mData;
        int n = this.mData.length;
        int n2 = 0;
        while (n2 < n) {
            byte oneByte = byArray[n2];
            switch (oneByte) {
                case -64: {
                    this.mOutput.write(219);
                    this.mOutput.write(220);
                    break;
                }
                case -37: {
                    this.mOutput.write(219);
                    this.mOutput.write(221);
                    break;
                }
                default: {
                    this.mOutput.write(oneByte);
                }
            }
            ++n2;
        }
        this.mOutput.write(192);
    }

    @Override
    public void parse(byte[] datagram, int offset, int count) {
        int i = offset;
        while (i < count) {
            switch (datagram[i]) {
                case -64: {
                    if (this.mIsEof) {
                        this.mOutput.reset();
                        this.mBuffer.clear();
                        this.mIsEof = false;
                        break;
                    }
                    this.mIsEof = true;
                    int j = 0;
                    while (j < this.mBuffer.size()) {
                        switch ((Byte)this.mBuffer.get(j)) {
                            case -37: {
                                switch ((Byte)this.mBuffer.get(j + 1)) {
                                    case -36: {
                                        this.mOutput.write(192);
                                        ++j;
                                        break;
                                    }
                                    case -35: {
                                        this.mOutput.write(219);
                                        ++j;
                                    }
                                }
                                break;
                            }
                            default: {
                                this.mOutput.write(((Byte)this.mBuffer.get(j)).byteValue());
                            }
                        }
                        ++j;
                    }
                    this.mData = this.mOutput.toByteArray();
                    break;
                }
                default: {
                    this.mBuffer.add(new Byte(datagram[i]));
                }
            }
            ++i;
        }
    }

    public static /* bridge */ /* synthetic */ BluetoothDatagram newDatagram() {
        return SLIPBluetoothDatagram.newDatagram();
    }

    public static /* bridge */ /* synthetic */ BluetoothDatagram newDatagram(byte[] byArray) {
        return SLIPBluetoothDatagram.newDatagram(byArray);
    }
}

