/*
 * Decompiled with CFR 0.152.
 */
package com.longmai.security.plugin;

import android.content.Context;
import com.longmai.security.plugin.PluginConfig;
import com.longmai.security.plugin.SOF_AppLib;
import com.longmai.security.plugin.base.BaseConfig;
import com.longmai.security.plugin.device.Device;
import com.longmai.security.plugin.skf.SKFControlService;
import com.longmai.security.plugin.skf.SKFLib;
import com.longmai.security.plugin.util.LogUtil;
import com.longmai.security.plugin.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SOF_DeviceLib {
    private static final String TAG = SOF_DeviceLib.class.getName();
    private static final String VERSION = "2.0.1";
    public static final int Exchange_Key = 0;
    public static final int Signature_Key = 1;
    public static final int SGD_VENDOR_DEFINED = Integer.MIN_VALUE;
    public static final int SGD_RAW = 128;
    public static final int SGD_MD5 = 129;
    public static final int SGD_SHA384 = 130;
    public static final int SGD_SHA512 = 131;
    public static final int SGD_DES_ECB = -2147483119;
    public static final int SGD_DES_CBC = -2147483118;
    public static final int SGD_3DES168_ECB = -2147483071;
    public static final int SGD_3DES168_CBC = -2147483070;
    public static final int SGD_3DES112_ECB = -2147483103;
    public static final int SGD_3DES112_CBC = -2147483102;
    public static final int SGD_AES128_ECB = -2147483375;
    public static final int SGD_AES128_CBC = -2147483374;
    public static final int SGD_AES192_ECB = -2147483359;
    public static final int SGD_AES192_CBC = -2147483358;
    public static final int SGD_AES256_ECB = -2147483327;
    public static final int SGD_AES256_CBC = -2147483326;
    public static final int SGD_SM1_ECB = 257;
    public static final int SGD_SM1_CBC = 258;
    public static final int SGD_SM1_CFB = 260;
    public static final int SGD_SM1_OFB = 264;
    public static final int SGD_SM1_MAC = 272;
    public static final int SGD_SSF33_ECB = 513;
    public static final int SGD_SSF33_CBC = 514;
    public static final int SGD_SSF33_CFB = 516;
    public static final int SGD_SSF33_OFB = 520;
    public static final int SGD_SSF33_MAC = 528;
    public static final int SGD_SM4_ECB = 1025;
    public static final int SGD_SM4_CBC = 1026;
    public static final int SGD_SM4_CFB = 1028;
    public static final int SGD_SM4_OFB = 1032;
    public static final int SGD_SM4_MAC = 1040;
    public static final int SGD_RSA = 65536;
    public static final int SGD_SM2_1 = 131328;
    public static final int SGD_SM2_2 = 131584;
    public static final int SGD_SM2_3 = 132096;
    public static final int SGD_SM3 = 1;
    public static final int SGD_SHA1 = 2;
    public static final int SGD_SHA256 = 4;
    public static final int SECURE_NEVER_ACCOUNT = 0;
    public static final int SECURE_ADM_ACCOUNT = 1;
    public static final int SECURE_USER_ACCOUNT = 16;
    public static final int SECURE_EVERYONE_ACCOUNT = 255;
    public static final int ADMIN_TYPE = 0;
    public static final int USER_TYPE = 1;
    protected static final int ECC_CRYPT_MAX = 128;
    private static Map<String, Device> _devices = new ConcurrentHashMap<String, Device>();
    private static Map<String, SOF_AppLib> _Apps = new ConcurrentHashMap<String, SOF_AppLib>();
    private static BaseConfig config;
    private static SKFLib skf;
    private static final String ConfigFile = "/assets/config.properties";

    static {
        skf = new SKFControlService();
        LogUtil.d(TAG, "Loading Config");
        config = new PluginConfig();
        try {
            config.loadConfig(ConfigFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            skf.SKF_SetLastError(10);
            config = null;
        }
    }

    public static String SOF_GetVersion() {
        LogUtil.d(TAG, "SOF_GetVersion()");
        return VERSION;
    }

    public static int SOF_GetDevState() {
        LogUtil.d(TAG, "SOF_GetDevState()");
        return skf.getConnState();
    }

    public static int SOF_EnumDevices(Context context, List<String> devices) {
        if (config != null) {
            String Id = config.get("Id");
            String Name = config.get("Name");
            String Device2 = config.get("Device");
            SOF_DeviceLib.SOF_LoadLibrary(context, Id, Name, Device2, null, new String[0]);
        }
        if (devices == null) {
            skf.SKF_SetLastError(2);
            return 1;
        }
        _devices.clear();
        ArrayList<Device> dev = new ArrayList<Device>();
        int rtn = skf.SKF_EnumDevices(context, dev);
        if (rtn != 0) {
            return 2;
        }
        for (Device d : dev) {
            _devices.put(d.getName(), d);
        }
        devices.addAll(_devices.keySet());
        return 0;
    }

    public static int SOF_EnumDevices(Context context, List<String> devices, int timeOut) {
        LogUtil.d(TAG, "SOF_EnumDevices() - timeOut:" + timeOut);
        if (config != null) {
            String Id = config.get("Id");
            String Name = config.get("Name");
            String Device2 = config.get("Device");
            SOF_DeviceLib.SOF_LoadLibrary(context, Id, Name, Device2, null, new String[0]);
        }
        if (devices == null) {
            skf.SKF_SetLastError(2);
            return 1;
        }
        if (timeOut < 100) {
            skf.SKF_SetLastError(2);
            return 2;
        }
        _devices.clear();
        ArrayList<Device> dev = new ArrayList<Device>();
        int rtn = skf.SKF_EnumDevices(context, dev, timeOut);
        if (rtn != 0) {
            return 3;
        }
        for (Device d : dev) {
            _devices.put(d.getName(), d);
        }
        devices.addAll(_devices.keySet());
        return 0;
    }

    public static int SOF_EnumDevices(Context context, String regex, List<String> devices, int timeOut) {
        LogUtil.d(TAG, "SOF_EnumDevices() - timeOut:" + timeOut);
        if (config != null) {
            String Id = config.get("Id");
            String Name = config.get("Name");
            String Device2 = config.get("Device");
            SOF_DeviceLib.SOF_LoadLibrary(context, Id, Name, Device2, null, new String[0]);
        }
        if (devices == null) {
            skf.SKF_SetLastError(2);
            return 1;
        }
        if (timeOut < 100) {
            skf.SKF_SetLastError(2);
            return 2;
        }
        _devices.clear();
        ArrayList<Device> dev = new ArrayList<Device>();
        int rtn = skf.SKF_EnumDevices(context, dev, timeOut);
        if (rtn != 0) {
            return 3;
        }
        for (Device d : dev) {
            if (!d.getName().matches(regex)) continue;
            _devices.put(d.getName(), d);
        }
        devices.addAll(_devices.keySet());
        return 0;
    }

    public static int SOF_EnumDeviceByName(Context context, String devName, int timeOut) {
        LogUtil.d(TAG, "SOF_EnumDeviceByName() - devName:" + devName + " timeOut:" + timeOut);
        if (config != null) {
            String Id = config.get("Id");
            String Name = config.get("Name");
            String Device2 = config.get("Device");
            SOF_DeviceLib.SOF_LoadLibrary(context, Id, Name, Device2, null, new String[0]);
        }
        if (timeOut < 100) {
            skf.SKF_SetLastError(2);
            return 1;
        }
        ArrayList<Device> dev = new ArrayList<Device>();
        int rtn = skf.SKF_EnumDeviceByName(context, devName, dev, timeOut);
        if (rtn != 0) {
            return 2;
        }
        for (Device d : dev) {
            _devices.put(d.getName(), d);
        }
        return 0;
    }

    public static int SOF_Connect(String devName, String authCode) {
        LogUtil.d(TAG, "SOF_Connect() - devName:" + devName);
        if (StringUtils.isEmpty(authCode)) {
            authCode = "";
        }
        return SOF_DeviceLib.SOF_Connect(devName, authCode.getBytes());
    }

    public static int SOF_Connect(String devName) {
        return SOF_DeviceLib.SOF_Connect(devName, null);
    }

    public static int SOF_Connect(String devName, byte[] authCode) {
        LogUtil.d(TAG, "SOF_Connect() - devName:" + devName);
        if (StringUtils.isEmpty(devName)) {
            skf.SKF_SetLastError(2);
            return 1;
        }
        Device device = _devices.get(devName);
        if (device == null) {
            skf.SKF_SetLastError(12);
            return 2;
        }
        int rtn = skf.SKF_Connect(device, authCode);
        if (rtn != 0) {
            return 3;
        }
        return 0;
    }

    public static int SOF_ConnectAsync(String devName, byte[] authCode) {
        LogUtil.d(TAG, "SOF_ConnectAsync() - devName:" + devName);
        return 0;
    }

    public static int SOF_EnumApplication(List<String> appNames) {
        LogUtil.d(TAG, "SOF_EnumApplication()");
        if (appNames == null) {
            skf.SKF_SetLastError(2);
            return 1;
        }
        return skf.SKF_EnumApplication(appNames);
    }

    public static SOF_AppLib SOF_GetInstance(String policyName) {
        LogUtil.d(TAG, "SOF_GetInstance() - policyName:" + policyName);
        if (StringUtils.isEmpty(policyName)) {
            LogUtil.d(TAG, "SOF_GetInstance() - " + policyName);
            ArrayList<String> appNames = new ArrayList<String>();
            int rtn = skf.SKF_EnumApplication(appNames);
            if (rtn != 0 || appNames.size() <= 0) {
                return null;
            }
            return SOF_DeviceLib.SOF_GetInstance((String)appNames.get(0));
        }
        SOF_AppLib app = _Apps.get(policyName);
        if (app == null) {
            LogUtil.d(TAG, "Apps.get() - app: null");
            int[] appId = new int[1];
            int rtn = skf.SKF_OpenApp(policyName.getBytes(), appId);
            if (rtn != 0) {
                LogUtil.d(TAG, "SKF_OpenApp() - return: " + rtn);
                return null;
            }
            app = new SOF_AppLib(skf, policyName, appId[0]);
            _Apps.put(policyName, app);
        }
        return app;
    }

    public static int SOF_GetLastError() {
        LogUtil.d(TAG, "SOF_GetLastError()");
        return skf.SKF_GetLastError();
    }

    public static int SOF_GenRandom(int length, byte[] random) {
        LogUtil.d(TAG, "SOF_GenRandom() - length:" + length);
        if (random == null || random.length < length) {
            skf.SKF_SetLastError(2);
            return 1;
        }
        int rtn = skf.SKF_GenRandom(length, random);
        if (rtn != 0) {
            return 2;
        }
        return 0;
    }

    public static int SOF_GetDeviceInfo(byte[] label, byte[] serialNumber, int[] version) {
        LogUtil.d(TAG, "SOF_GetDeviceInfo()");
        int rtn = skf.SKF_GetDevInfo(label, serialNumber, version);
        if (rtn != 0) {
            return 2;
        }
        return 0;
    }

    public static int SOF_GetDeviceInfo(byte[] struct, int[] structLen) {
        LogUtil.d(TAG, "SOF_GetDeviceInfo()");
        byte[] label = new byte[128];
        byte[] serialNumber = new byte[128];
        int[] version = new int[1];
        int[] freeSpace = new int[1];
        int rtn = skf.SKF_GetDevInfo(label, serialNumber, version, freeSpace, struct, structLen);
        if (rtn != 0) {
            return 2;
        }
        return 0;
    }

    public static int SOF_SetLabel(byte[] label) {
        LogUtil.d(TAG, "SOF_SetLabel()");
        if (label == null) {
            skf.SKF_SetLastError(2);
            return 1;
        }
        int rtn = skf.SKF_SetLabel(label);
        if (rtn != 0) {
            return 2;
        }
        return 0;
    }

    public static int SOF_Disconnect() {
        LogUtil.d(TAG, "SOF_Disconnect()");
        _Apps.clear();
        int rtn = skf.SKF_Disconnect();
        if (rtn != 0) {
            return 2;
        }
        return 0;
    }

    public static int SOF_LedControl(int state, int interval) {
        LogUtil.d(TAG, "SOF_LedControl() - state:" + state + " interval:" + interval);
        int rtn = skf.SKF_LedControl(state, interval);
        if (rtn != 0) {
            return 2;
        }
        return 0;
    }

    public static int SOF_LoadLibraryXML(Context context, InputStream is) throws ParserConfigurationException, SAXException, IOException {
        LogUtil.d(TAG, "SOF_LoadLibraryXML()");
        DocumentBuilder domBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document xml = domBuilder.parse(is);
        Element root = xml.getDocumentElement();
        NodeList drivers = root.getElementsByTagName("driver");
        int i = 0;
        while (i < drivers.getLength()) {
            Element driver = (Element)drivers.item(i);
            LogUtil.d(TAG, "id:" + driver.getAttribute("id"));
            LogUtil.d(TAG, "name:" + driver.getAttribute("name"));
            LogUtil.d(TAG, "class:" + driver.getAttribute("class"));
            LogUtil.d(TAG, "describe:" + driver.getAttribute("describe"));
            NodeList propertys = driver.getElementsByTagName("property");
            int j = 0;
            while (j < propertys.getLength()) {
                Element property = (Element)propertys.item(j);
                LogUtil.d(TAG, "property - " + property.getAttribute("name") + ":" + property.getAttribute("value"));
                ++j;
            }
            ++i;
        }
        return 0;
    }

    public static int SOF_LoadLibrary(Context context, String id, String name, String clazz, String describe, String ... propertys) {
        LogUtil.d(TAG, "SOF_LoadLibrary() - id:" + id + " name:" + name + " class:" + clazz + " describe:" + describe);
        config = null;
        return skf.SKF_LoadLibrary(context, id, name, clazz);
    }
}

