/*
 * Decompiled with CFR 0.152.
 */
package com.longmai.security.plugin.driver;

import com.longmai.security.plugin.base.PluginException;
import com.longmai.security.plugin.driver.Driver;
import com.longmai.security.plugin.driver.DriverInfo;
import com.longmai.security.plugin.util.LogUtil;
import java.util.Enumeration;
import java.util.Vector;

public class DriverManager {
    private static final String TAG = DriverManager.class.getName();
    private static Vector<DriverInfo> drivers = new Vector();
    private static boolean initialized = false;

    public static synchronized void registerDriver(Driver driver) throws PluginException {
        if (!initialized) {
            DriverManager.initialize();
        }
        DriverInfo di = new DriverInfo();
        di.driver = driver;
        di.driverClass = driver.getClass();
        di.driverClassName = driver.getClass().getSimpleName();
        drivers.addElement(di);
    }

    public static synchronized void deregisterDriver(Driver driver) {
        Enumeration<DriverInfo> e = drivers.elements();
        while (e.hasMoreElements()) {
            DriverInfo di = e.nextElement();
            if (!di.driver.equals(driver)) continue;
            drivers.remove(di);
        }
    }

    public static Enumeration<DriverInfo> getDrivers() {
        if (drivers.size() <= 0) {
            return null;
        }
        return drivers.elements();
    }

    public static Driver getDriver() throws PluginException {
        if (drivers.size() <= 0) {
            throw new PluginException(9);
        }
        DriverInfo di = drivers.get(0);
        return di.driver;
    }

    public static Driver getDriver(String url) throws PluginException {
        if (drivers.size() <= 0) {
            throw new PluginException(9);
        }
        Enumeration<DriverInfo> e = drivers.elements();
        while (e.hasMoreElements()) {
            DriverInfo di = e.nextElement();
            if (!di.driverClass.getName().equals(url)) continue;
            return di.driver;
        }
        throw new PluginException(9);
    }

    private static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        LogUtil.i(TAG, "Plugin DriverManager initialized");
    }
}

