/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.providers.safetfprovider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import android.widget.Toast;
import com.google.gson.Gson;
import com.safetf.CertDetailInfo;
import com.safetf.SafeTF;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_SM2_PARAM;
import com.xdja.bean.VendorInfoJson;
import com.xdja.key.KeyErrno;
import com.xdja.key.KeyWrapper;
import com.xdja.safeclient.CardOperation;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.StartVpnActivity;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VerifyTime;
import com.xdja.safeclient.utils.Log;
import com.xdja.sslvpn.SslvpnStatus;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

public class SafetfContentProvider
extends ContentProvider {
    private static final int ANDROID_4_4_2 = 19;
    private JNIAPI mSafeKey = new JNIAPI();
    private int mHandle = 0;
    private static final int XKR_IO_FAILED = -2;
    public static final int XKR_INVALID_PARA = -9;
    private static final String THIS_FILE = "SafetfContentProvider";
    private boolean blockMainThread = false;
    private String TAG = "SafetfContentProvider";
    HandlerThread handlerThread = new HandlerThread("provider_thread");
    private Handler myHandler;

    public boolean onCreate() {
        Log.e(this.TAG, "Init key module.");
        this.handlerThread.start();
        this.myHandler = new MyHandler(this.handlerThread.getLooper());
        return false;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    public String getType(Uri uri) {
        return null;
    }

    public Bundle call(String method, String arg, Bundle extras) {
        Log.d("app", "method = " + method);
        Bundle ret = null;
        if (method.equals("startSafeClient")) {
            ret = this.startSafeClient();
        } else if (method.equals("verifyPIN")) {
            ret = this.verifyPIN(extras);
        } else if (method.equals("sm1")) {
            ret = this.sm1(extras);
        } else if (method.equals("rsaPriKeyCalc")) {
            ret = this.rsaPriKeyCalc(extras);
        } else if (method.equals("sm2Sign")) {
            ret = this.sm2Sign(extras);
        } else if (method.equals("getSM2ID")) {
            ret = this.getSM2ID();
        } else if (method.equals("getSM2Param")) {
            ret = this.getSM2Param();
        } else if (method.equals("getSafeCardID")) {
            ret = this.getSafeCardID();
        } else if (method.equals("getPolicemanID")) {
            ret = this.getPolicemanID();
        } else if (method.equals("getLastVerifyTime")) {
            ret = this.getLastVerifyTime();
        } else if (method.equals("getVendorInfo")) {
            ret = this.getVendorInfo();
        } else if (method.equals("getVPNTunnelState")) {
            ret = this.getVPNTunnelState();
        } else if (method.equals("getMonitorServerAddress")) {
            ret = this.getMonitorServerAddress();
        } else if (method.equals("checkWeakPassWD")) {
            ret = this.checkWeakPassWD();
        } else if (method.equals("passwordEnter")) {
            ret = this.passwordEnter(extras);
        } else if (method.equals("readDefaultCert")) {
            ret = this.getDefaultCert();
        } else if (method.equals("getDefaultCertSN")) {
            ret = this.readDefaultCertSN();
        } else if (method.equals("excuteCmd")) {
            ret = this.excuteCmd(extras);
        } else if (method.equals("readFile")) {
            ret = this.readFile(extras);
        } else if (method.equals("readCert")) {
            ret = this.readCert(extras);
        } else if (method.equals("killSafeClient")) {
            ret = this.killClient();
        } else {
            ret = new Bundle();
            ret.putInt("ret", -98);
        }
        return ret;
    }

    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    private int startTunVpn() {
        try {
            Intent intent = new Intent(this.getContext(), StartVpnActivity.class);
            intent.setFlags(0x10400000);
            this.getContext().startActivity(intent);
            if (MyApplication.myApplication.sslClientConfig.getTransportMode() == 1) {
                Log.d(THIS_FILE, "Current mode tun, need to sleep 500 ms to ensure start success");
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e(this.TAG, "startActivity StartVpnActivity failed");
            return -1;
        }
        return 0;
    }

    public Bundle startSafeClient() {
        Bundle retBundle = new Bundle();
        int ret = this.startTunVpn();
        retBundle.putInt("ret", ret);
        return retBundle;
    }

    public Bundle getVersion() {
        Bundle retBundle = new Bundle();
        byte[] version = new byte[256];
        int[] versionLen = new int[1];
        int ret = -1;
        retBundle.putInt("ret", ret);
        return retBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle verifyPIN(final Bundle inBundle) {
        Object lock;
        final Bundle retBundle = new Bundle();
        final int[] ret = new int[]{-1};
        Object object = lock = new Object();
        synchronized (object) {
            this.myHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int role = inBundle.getInt("pinrole", -1);
                    if (role == -1) {
                        String pinStr = inBundle.getString("pin");
                        Log.d(SafetfContentProvider.THIS_FILE, "This is from FORWARD Client invoke");
                        ret[0] = KeyWrapper.getInstance().verifyPIN(pinStr);
                        retBundle.putInt("ret", ret[0]);
                    } else {
                        byte[] pin = inBundle.getByteArray("pin");
                        ret[0] = KeyWrapper.getInstance().xdjaKeyVerifyPIN(new String(pin), role);
                        retBundle.putInt("ret", KeyErrno.errParseToXdja(ret[0]));
                    }
                    Object object = lock;
                    synchronized (object) {
                        lock.notify();
                    }
                }
            });
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return retBundle;
    }

    public Bundle sm1(Bundle inBundle) {
        Bundle retBundle = new Bundle();
        byte[] datain = inBundle.getByteArray("datain");
        int inlen = inBundle.getInt("inlen");
        int flag = inBundle.getInt("flag");
        int kid = inBundle.getInt("kid");
        byte[] iv = inBundle.getByteArray("iv");
        int ret = -1;
        byte[] dataout = new byte[inlen];
        ret = this.mSafeKey.SM1((long)this.mHandle, datain, inlen, flag, dataout, (byte)kid, iv);
        if (ret == 0) {
            retBundle.putByteArray("result", dataout);
        }
        retBundle.putInt("ret", ret);
        return retBundle;
    }

    public Bundle rsaPriKeyCalc(Bundle inBundle) {
        byte[] dataout;
        Bundle retBundle = new Bundle();
        int ret = -1;
        int bits = inBundle.getInt("bits");
        int inlen = inBundle.getInt("inlen");
        byte[] datain = inBundle.getByteArray("datain");
        int[] outlen = new int[1];
        if (bits != 0) {
            dataout = new byte[bits / 8];
            ret = KeyWrapper.getInstance().RSAPrikeyCalc(bits, datain, inlen, dataout, outlen);
        } else {
            byte[] fid = inBundle.getByteArray("fid");
            dataout = new byte[inlen];
            ret = KeyWrapper.getInstance().xdjaRSAPrikeyCalc(fid, datain, inlen, dataout, outlen);
        }
        if (ret == 0) {
            retBundle.putByteArray("result", dataout);
        }
        retBundle.putInt("ret", KeyErrno.errParseToXdja(ret));
        return retBundle;
    }

    public Bundle rsaSignWithoutDER(Bundle inBundle) {
        int[] outlen;
        byte[] dataout;
        boolean NO_HASH;
        Bundle retBundle = new Bundle();
        int bits = inBundle.getInt("bits");
        byte[] prifid = inBundle.getByteArray("prifid");
        int datatype = inBundle.getInt("datatype");
        byte[] datain = inBundle.getByteArray("datain");
        int inlen = inBundle.getInt("inlen");
        byte[] digest = inBundle.getByteArray("digest");
        byte[] sha1Value = new byte[20];
        boolean bl = NO_HASH = datatype == 1;
        if (NO_HASH) {
            int sha1Success = -1;
            sha1Success = this.mSafeKey.SHA1((long)this.mHandle, datain, inlen, sha1Value);
            if (sha1Success != 0) {
                Toast.makeText((Context)this.getContext(), (int)R.string.sha1_digest_error, (int)0).show();
                retBundle.putInt("ret", sha1Success);
                return retBundle;
            }
        } else if (digest == null) {
            Toast.makeText((Context)this.getContext(), (int)R.string.digest_error, (int)0).show();
        }
        byte[] PS = CardOperation.genPSValue(bits == 1024);
        datain = NO_HASH ? CardOperation.formatPKCS(PS, sha1Value) : CardOperation.formatPKCS(PS, digest);
        int ret = -1;
        int inLength = bits == 1024 ? 128 : 256;
        ret = this.mSafeKey.RSAPriKeyCalc((long)this.mHandle, prifid, datain, inLength, dataout = new byte[256], outlen = new int[1]);
        if (ret == 0) {
            byte[] result = new byte[outlen[0]];
            System.arraycopy(dataout, 0, result, 0, result.length);
            retBundle.putByteArray("result", result);
        }
        retBundle.putInt("ret", ret);
        return retBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle sm2Sign(Bundle inBundle) {
        final Bundle retBundle = new Bundle();
        final int[] ret = new int[]{-1};
        final Object lock = new Object();
        final byte[] pubfid = inBundle.getByteArray("pubfid");
        final byte[] prifid = inBundle.getByteArray("prifid");
        final int datatype = inBundle.getInt("datatype");
        final byte[] datain = inBundle.getByteArray("datain");
        final int inlen = inBundle.getInt("inlen");
        final int ishashed = inBundle.getInt("ishashed");
        final byte[] dataout = new byte[64];
        final int[] outlen = new int[1];
        Object object = lock;
        synchronized (object) {
            this.myHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ret[0] = pubfid != null && prifid != null ? KeyWrapper.getInstance().xdjaSM2Sign(pubfid, prifid, datatype, datain, inlen, dataout, outlen) : KeyWrapper.getInstance().SM2Sign(ishashed, datain, inlen, dataout, outlen);
                    if (ret[0] == 0) {
                        retBundle.putByteArray("result", dataout);
                    }
                    Object object = lock;
                    synchronized (object) {
                        lock.notify();
                    }
                }
            });
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        retBundle.putInt("ret", KeyErrno.errParseToXdja(ret[0]));
        return retBundle;
    }

    public Bundle getSM2Param() {
        Bundle result = new Bundle();
        XDJA_SM2_PARAM sm2Param = new XDJA_SM2_PARAM();
        int ret = KeyWrapper.getInstance().getSM2Param(sm2Param);
        if (ret == 0) {
            result.putParcelable("result", (Parcelable)sm2Param);
        }
        result.putInt("ret", ret);
        return result;
    }

    public Bundle getSM2ID() {
        Bundle result = new Bundle();
        byte[] id = new byte[128];
        int[] len = new int[1];
        int ret = KeyWrapper.getInstance().getSM2ID(id, len);
        if (ret == 0) {
            result.putByteArray("id", id);
            result.putInt("len", len[0]);
        }
        result.putInt("ret", ret);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle getSafeCardID() {
        Object lock;
        final Bundle retBundle = new Bundle();
        final int[] ret = new int[]{-1};
        final byte[] cardIdArray = new byte[64];
        final int[] cardIdLen = new int[1];
        Object object = lock = new Object();
        synchronized (object) {
            this.myHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ret[0] = KeyWrapper.getInstance().getSN(cardIdArray, cardIdLen);
                    String cardId = null;
                    if (ret[0] == 0) {
                        cardId = new String(cardIdArray, 0, cardIdLen[0]);
                        Log.d(SafetfContentProvider.this.TAG, "Card id " + cardId);
                    }
                    retBundle.putString("result", cardId);
                    Object object = lock;
                    synchronized (object) {
                        lock.notify();
                    }
                }
            });
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return retBundle;
    }

    public Bundle getPolicemanID() {
        Bundle retBundle = new Bundle();
        int[] handle = new int[2];
        int ret = -1;
        byte[] fid = new byte[]{0, -102};
        int dataLen = 0;
        byte[] pDataLen = new byte[2];
        String policemanID = "";
        if (0 != ret) {
            Log.e(THIS_FILE, "getPolicemanID, OpenDev faild,  ret = " + ret);
            return null;
        }
        ret = this.mSafeKey.ReadFile((long)handle[0], fid, 0, 2, pDataLen);
        if (ret != 0) {
            Log.e(THIS_FILE, "getPolicemanID , get pDataLen failed, ret = " + ret);
            this.mSafeKey.CloseDev((long)handle[0]);
            return null;
        }
        dataLen = SafetfContentProvider.byteToInt(pDataLen, 2);
        Log.d(THIS_FILE, "dataLen = " + dataLen);
        if (dataLen <= 0) {
            Log.e(THIS_FILE, "dataLen = " + dataLen);
            this.mSafeKey.CloseDev((long)handle[0]);
            return null;
        }
        byte[] pData = new byte[dataLen];
        ret = this.mSafeKey.ReadFile((long)handle[0], fid, 2, dataLen, pData);
        if (ret != 0) {
            Log.e(THIS_FILE, "getPolicemanID , get pData failed, ret = " + ret);
            this.mSafeKey.CloseDev((long)handle[0]);
            return null;
        }
        this.mSafeKey.CloseDev((long)handle[0]);
        try {
            policemanID = new String(pData, 0, dataLen, "gbk");
            Log.d(THIS_FILE, "policemanID = " + policemanID);
            retBundle.putString("result", policemanID);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return retBundle;
    }

    public Bundle getLastVerifyTime() {
        Bundle bundle = new Bundle();
        long last = VerifyTime.readLastVerifyTime(this.getContext());
        Log.d("\u8ba4\u8bc1\u65f6\u95f4", "\u8bfb\u53d6\u5230\u7684\u8ba4\u8bc1\u65f6\u95f4" + last);
        bundle.putLong("lastVerifyTime", last);
        return bundle;
    }

    public Bundle getVPNTunnelState() {
        Bundle bundle = new Bundle();
        bundle.putBoolean("result", Function.isVPNConnected());
        return bundle;
    }

    public Bundle getMonitorServerAddress() {
        Bundle bundle = new Bundle();
        int res = -1;
        String serverAddr = null;
        MyApplication myApplication = MyApplication.myApplication;
        JSONObject json = new JSONObject();
        try {
            json.put("jsonrpc", (Object)"2.0");
            json.put("id", (Object)"1");
            JSONObject result = new JSONObject();
            JSONObject serveraddress = new JSONObject();
            if (!Function.isVPNConnected()) {
                result.put("res", (Object)"FAILED");
                Log.d(this.TAG, "safeVerifySuccess false");
            } else {
                result.put("res", (Object)"OK");
                Log.d("AidlService", "safeVerifySuccess true");
                if (0 == myApplication.sslClientConfig.transportMode) {
                    SslvpnStatus sslvpnStatus = new SslvpnStatus();
                    if (myApplication.sslvpn != null) {
                        res = myApplication.sslvpn.getStatus(sslvpnStatus);
                        serveraddress.put("monitorserverip", (Object)"127.0.0.1");
                        if (res == 0 && sslvpnStatus != null) {
                            serveraddress.put("monitorserverporxyport", (Object)sslvpnStatus.monitorserverporxyport);
                            serveraddress.put("monitorserverporxyport1", (Object)sslvpnStatus.monitorserverporxyport1);
                        }
                        serveraddress.put("tunelmode", (Object)"101");
                    } else {
                        result.put("res", (Object)"FAILED");
                    }
                } else {
                    final SslvpnStatus sslvpnStatus = new SslvpnStatus();
                    this.blockMainThread = true;
                    int count = 0;
                    new Thread(){

                        @Override
                        public void run() {
                            SafetfContentProvider.this.getCurSslvpnStatus(sslvpnStatus);
                            SafetfContentProvider.this.blockMainThread = false;
                        }
                    }.start();
                    while (this.blockMainThread && count <= 30) {
                        ++count;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (sslvpnStatus != null) {
                        serveraddress.put("monitorserverip", (Object)sslvpnStatus.monitorSrvIp);
                        serveraddress.put("realPort", (Object)sslvpnStatus.monitorserverporxyport);
                        serveraddress.put("realPort1", (Object)sslvpnStatus.monitorserverporxyport1);
                    }
                    serveraddress.put("tunelmode", (Object)"100");
                }
            }
            result.put("serveraddress", (Object)serveraddress);
            json.put("result", (Object)result);
            serverAddr = json.toString();
            Log.d("AidlService", "getMonitorServerAddress : " + serverAddr);
            bundle.putString("result", serverAddr);
        }
        catch (JSONException e) {
            bundle.putString("result", "");
        }
        return bundle;
    }

    private String buildVendorInfo() {
        String versionStr = null;
        String vendorInfo = null;
        Gson gson = new Gson();
        byte[] version = new byte[256];
        int[] versionLen = new int[1];
        VendorInfoJson vendorinfojosn = new VendorInfoJson();
        int ret = -1;
        ret = this.mSafeKey.GetVersion(version, versionLen);
        if (ret == 0) {
            versionStr = new String(version, 0, versionLen[0]);
        }
        vendorinfojosn.getResult().getVendorinfo().setVendor("xdja");
        vendorinfojosn.getResult().getVendorinfo().setVersion(versionStr);
        vendorinfojosn.getResult().getVendorinfo().setExtendinfo("");
        vendorinfojosn.setId(2);
        if (TextUtils.isEmpty((CharSequence)versionStr)) {
            vendorinfojosn.getResult().setRes("FAILED");
        } else {
            vendorinfojosn.getResult().setRes("OK");
        }
        vendorInfo = gson.toJson((Object)vendorinfojosn);
        Log.d("AidlService", "getVendorInfo : " + vendorInfo);
        return vendorInfo;
    }

    public Bundle getVendorInfo() {
        Bundle bundle = new Bundle();
        bundle.putString("result", this.buildVendorInfo());
        return bundle;
    }

    public Bundle checkWeakPassWD() {
        Bundle bundle = new Bundle();
        MyApplication application = MyApplication.myApplication;
        boolean isWeak = application == null ? true : application.isWeakPassWD;
        bundle.putBoolean("result", isWeak);
        return bundle;
    }

    public Bundle passwordEnter(Bundle inBundle) {
        String testPin = inBundle.getString("pin", "");
        Bundle bundle = new Bundle();
        MyApplication application = MyApplication.myApplication;
        int role = 1;
        int ret = -1;
        if (TextUtils.isEmpty((CharSequence)testPin)) {
            bundle.putBoolean("result", false);
            return bundle;
        }
        if (application != null && (role = application.sslClientConfig.getRole()) != 1 && role != 17) {
            byte[] defaultCertId = application.sslClientConfig.getCertId();
            role = Function.generateRole(defaultCertId);
        }
        bundle.putBoolean("result", (ret = this.mSafeKey.VerifyPIN((long)this.mHandle, role, testPin.getBytes(), testPin.length())) == 0);
        return bundle;
    }

    public Bundle readDefaultCertSN() {
        Bundle bundle = new Bundle();
        MyApplication application = MyApplication.myApplication;
        int nres = -1;
        CertDetailInfo certDetailInfo = null;
        SafeTF tf = new SafeTF();
        byte[] fid = new byte[]{0, 41};
        if (application != null && application.sslClientConfig != null) {
            fid = application.sslClientConfig.getCertId();
            Log.d(this.TAG, "CertId :" + fid[0] + fid[1]);
        }
        certDetailInfo = new CertDetailInfo();
        nres = tf.GetCertDetailInfo(this.mHandle, fid, certDetailInfo);
        Log.d(THIS_FILE, "handle = " + this.mHandle + "Get cert detail info ret " + nres);
        bundle.putInt("ret", nres);
        bundle.putString("result", nres == 0 ? certDetailInfo.sn : "");
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle readFile(Bundle inBundle) {
        Object lock;
        final Bundle retBundle = new Bundle();
        final byte[] fid = inBundle.getByteArray("fid");
        final int readpos = inBundle.getInt("readpos");
        final int readlen = inBundle.getInt("readlen");
        final int[] ret = new int[]{-1};
        final byte[] dataout = new byte[readlen];
        Object object = lock = new Object();
        synchronized (object) {
            this.myHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ret[0] = KeyWrapper.getInstance().xdjaKeyReadFile(fid, readpos, readlen, dataout);
                    if (ret[0] == 0) {
                        retBundle.putByteArray("result", dataout);
                    }
                    Object object = lock;
                    synchronized (object) {
                        lock.notify();
                    }
                }
            });
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        retBundle.putInt("ret", KeyErrno.errParseToXdja(ret[0]));
        return retBundle;
    }

    public Bundle killClient() {
        Bundle bundle = new Bundle();
        Log.e(THIS_FILE, "Force kill safeclient");
        MyApplication.myApplication.getHandler().post(new Runnable(){

            @Override
            public void run() {
                Function.exitApp((Context)MyApplication.myApplication);
            }
        });
        bundle.putInt("ret", 0);
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle readCert(Bundle inBundle) {
        final Bundle retBundle = new Bundle();
        final byte[] fid = inBundle.getByteArray("fid");
        final int[] ret = new int[]{-1};
        final Object lock = new Object();
        final byte[] certbuf = new byte[2048];
        final int[] certlen = new int[1];
        Object object = lock;
        synchronized (object) {
            this.myHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ret[0] = KeyWrapper.getInstance().xdjaKeyReadCert(fid, certbuf, certlen);
                    if (ret[0] == 0) {
                        byte[] result = new byte[certlen[0]];
                        System.arraycopy(certbuf, 0, result, 0, result.length);
                        retBundle.putByteArray("result", result);
                    }
                    Object object = lock;
                    synchronized (object) {
                        lock.notify();
                    }
                }
            });
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        retBundle.putInt("ret", KeyErrno.errParseToXdja(ret[0]));
        return retBundle;
    }

    public Bundle getDefaultCert() {
        Bundle bundle = new Bundle();
        MyApplication application = MyApplication.myApplication;
        int ret = -1;
        byte[] certBuf = new byte[2048];
        int[] certLen = new int[1];
        if (application != null && application.sslClientConfig != null) {
            byte[] fid = application.sslClientConfig.getCertId();
            Log.d(this.TAG, "CertId :" + fid[0] + fid[1]);
        }
        if ((ret = KeyWrapper.getInstance().readSignCert(certBuf, certLen)) == 0) {
            byte[] result = new byte[certLen[0]];
            System.arraycopy(certBuf, 0, result, 0, result.length);
            bundle.putByteArray("result", result);
        }
        bundle.putInt("ret", ret);
        return bundle;
    }

    public Bundle excuteCmd(Bundle inBundle) {
        MyApplication application = MyApplication.myApplication;
        Bundle outBundle = new Bundle();
        String cmd = inBundle.getString("cmd");
        if (application != null && application.sslvpn != null) {
            outBundle.putInt("ret", 0);
            outBundle.putString("result", application.sslvpn.excuteOuterCmd(cmd));
        } else {
            outBundle.putInt("ret", -1);
        }
        return outBundle;
    }

    public static int byteToInt(byte[] b, int len) {
        int mask = 255;
        int temp = 0;
        int n = 0;
        for (int i = 0; i < len; ++i) {
            n <<= 8;
            temp = b[i] & mask;
            n |= temp;
        }
        return n;
    }

    private void getCurSslvpnStatus(SslvpnStatus sslvpnStatus) {
        String temp = null;
        int vpnstatelen = 0;
        byte[] vpnstate = new byte[4096];
        MyApplication myApplication = MyApplication.myApplication;
        if (myApplication == null) {
            sslvpnStatus.monitorSrvIp = "";
            return;
        }
        if (TunVpnService.sock == null) {
            sslvpnStatus.monitorSrvIp = "";
            return;
        }
        TunVpnService.sock.sendData("GETCURSTATUS");
        vpnstatelen = TunVpnService.sock.recvData(vpnstate);
        Log.d("AidlService", "vpnstatelen = " + vpnstatelen);
        if (vpnstatelen <= 0) {
            Log.d("AidlService", "vpnstatelen = " + vpnstatelen);
            sslvpnStatus.monitorSrvIp = "";
            return;
        }
        temp = new String(vpnstate, 0, vpnstatelen);
        Log.d("AidlService", "temp = " + temp);
        String[] arrayStr = temp.split("#");
        if (arrayStr.length < 6) {
            Log.d("AidlService", "arrayStr.length = " + arrayStr.length);
            return;
        }
        sslvpnStatus.monitorserverporxyport = arrayStr[3];
        sslvpnStatus.monitorserverporxyport1 = arrayStr[4];
        sslvpnStatus.monitorSrvIp = arrayStr[5];
    }

    class MyHandler
    extends Handler {
        public MyHandler(Looper looper) {
            super(looper);
        }
    }
}

