/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.VpnService;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.telephony.TelephonyManager;
import com.squareup.otto.Subscribe;
import com.xdja.autoupdate.SCAutoUpdate;
import com.xdja.key.KeyWrapper;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.GuardianHelper;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.VerifyTime;
import com.xdja.safeclient.activity.SafeVerifyActivity;
import com.xdja.safeclient.bean.SafeVerifyStageInfo;
import com.xdja.safeclient.constant.IntentParam;
import com.xdja.safeclient.ottoobj.ExitAppEvent;
import com.xdja.safeclient.ottoobj.StopTunEvent;
import com.xdja.safeclient.ui.AlertUtil;
import com.xdja.safeclient.utils.AppSHAUtil;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.OttoUtil;
import com.xdja.safeclient.utils.StringUtil;
import com.xdja.sslvpn.AppAclList;
import com.xdja.sslvpn.AppAclRule;
import com.xdja.sslvpn.SSLVPN;
import com.xdja.sslvpn.SocketListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TunVpnService
extends VpnService {
    private static final String TAG = "TunVpnService";
    public static PendingIntent mConfigureIntent;
    public VpnService.Builder builder;
    public static ParcelFileDescriptor mInterface;
    private static MyApplication myApplication;
    public int connect = 0;
    public static SocketListener sock;
    public byte[] vpnstate = new byte[2048];
    public int vpnstatelen = 0;
    public static String issuccess;
    public String prestage = "";
    public static String curstage;
    public static boolean stopService;
    public static String errorState;
    private static String errorInfo;
    private static int errorInfoFlag;
    private static NotificationManager nm;
    public static List<SafeVerifyStageInfo> sslStageList;
    public static boolean safeVerifySuccess;
    private static String sessionId;
    BroadcastReceiver sdcardBroadCastReceiver = null;
    private BroadcastReceiver screenBroadCastReceiver = null;
    private static boolean screenOn;
    public static TunVpnService tunVpnObj;
    public static Object lock;
    public static boolean startflag;
    PowerManager pm = null;
    PowerManager.WakeLock mWakeLock = null;
    private String serverIP = null;
    private int serverPort = 0;
    private byte[] gatewayIp = null;
    private byte[] gatewayIp2 = null;
    private byte[] gatewayIp3 = null;
    private int gatewayPort = 0;
    private Map<String, PackageInfo> localNativeAppMap = new HashMap<String, PackageInfo>();
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    TunVpnService.this.showState();
                    break;
                }
                case 2: {
                    TunVpnService.this.vpnstatelen = msg.getData().getInt("len");
                    TunVpnService.this.vpnstate = msg.getData().getByteArray("content");
                    TunVpnService.this.showState();
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSDCardState(Context context, Intent intent) {
        Log.d(TAG, "getExternalStorageState : " + Environment.getExternalStorageState());
        if (!Function.getSafeTunVpnState(this.getApplicationContext())) {
            return;
        }
        safeVerifySuccess = false;
        errorState = this.getString(R.string.card_eject);
        SafeVerifyStageInfo stageInfo = new SafeVerifyStageInfo();
        stageInfo.name = this.getString(R.string.safe_verify);
        stageInfo.error = errorState;
        stageInfo.result = this.getString(R.string.fail);
        sslStageList.add(stageInfo);
        this.showVpnState(R.drawable.seq_off, this.getResources().getString(R.string.safe_client), errorState);
        if (TunVpnService.myApplication.sslvpn != null) {
            TunVpnService.myApplication.sslvpn.stopService();
            TunVpnService.myApplication.sslvpn.release();
            TunVpnService.myApplication.sslvpn = null;
        }
        try {
            if (mInterface != null) {
                Log.d(TAG, "TunVpnService.mInterface.close");
                mInterface.close();
                mInterface = null;
                if (tunVpnObj != null) {
                    tunVpnObj.destroyBuilder();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (TunVpnService.myApplication.sslvpn != null) {
            TunVpnService.myApplication.sslvpn.closeTunFd();
        }
        Object object = lock;
        synchronized (object) {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        Function.setSafeTunVpnState(this.getApplicationContext(), false);
        stopService = true;
        Log.d(TAG, "SDCard EJECT");
        Compatibility.onSDCardEject();
        this.stopSelf();
    }

    private void startWatchingDevice() {
        this.sdcardBroadCastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                Log.d(TunVpnService.TAG, "onReceive " + action);
                Log.d(TunVpnService.TAG, "onReceive " + intent.getData());
                if (intent.getData().toString().contains("udisk")) {
                    Log.d(TunVpnService.TAG, "onReceive igore second sdcard eject");
                    return;
                }
                if ("android.intent.action.MEDIA_EJECT".equals(action)) {
                    TunVpnService.this.checkSDCardState(context, intent);
                }
            }
        };
        IntentFilter sdcardFilter = new IntentFilter();
        sdcardFilter.addAction("android.intent.action.MEDIA_EJECT");
        sdcardFilter.addDataScheme("file");
        this.registerReceiver(this.sdcardBroadCastReceiver, sdcardFilter);
    }

    private void stopWatchingDevice() {
        if (this.sdcardBroadCastReceiver != null) {
            this.unregisterReceiver(this.sdcardBroadCastReceiver);
        }
    }

    public void onCreate() {
        super.onCreate();
        OttoUtil.register((Object)this);
        myApplication = (MyApplication)this.getApplication();
        Log.d("VerifyTime", "TunVpnService onCreate reset flag");
        VerifyTime.writeVerifySuccess((Context)this, false);
        screenOn = true;
        tunVpnObj = this;
        this.startWatchingDevice();
        this.startWatchingScreen();
        myApplication.initDevState();
        if (TunVpnService.myApplication.propertiesConfig != null && TunVpnService.myApplication.propertiesConfig.getIsWakeLock() == 1) {
            Function.getWakeLock();
        }
        if (!Function.checkHitomservice(this.getApplicationContext())) {
            AlertUtil.popSystemAlert(this.getApplicationContext(), StringUtil.getStringRes((Context)this, R.string.alert), StringUtil.getStringRes((Context)this, R.string.hitom_service_not_exist), null);
            return;
        }
        errorInfoFlag = 0;
        errorInfo = "";
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (!Function.getSafeTunVpnState(this.getApplicationContext())) {
            String safePin = null;
            if (intent != null) {
                safePin = null;
                safePin = intent.getStringExtra("SafePin");
                try {
                    if (safePin != null) {
                        Log.d(TAG, "putin safePin by intent, safePin = " + safePin);
                        TunVpnService.myApplication.sslClientConfig.setPin(safePin.getBytes());
                    } else {
                        Log.d(TAG, "not putin safePin by intent ");
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (intent != null) {
                try {
                    this.serverIP = intent.getStringExtra("ServerIP");
                    this.serverPort = intent.getIntExtra("ServerPort", TunVpnService.myApplication.sslClientConfig.gateWayPort);
                    if (this.serverIP != null) {
                        Log.d(TAG, "putin serverIP by intent,serverIP = " + this.serverIP);
                        Log.d(TAG, "putin serverPort by intent,serverPort = " + this.serverPort);
                        this.gatewayIp = TunVpnService.myApplication.sslClientConfig.getGateWayIp();
                        this.gatewayIp2 = TunVpnService.myApplication.sslClientConfig.getGateWayIp2();
                        this.gatewayIp3 = TunVpnService.myApplication.sslClientConfig.getGateWayIp3();
                        this.gatewayPort = TunVpnService.myApplication.sslClientConfig.getGateWayPort();
                        TunVpnService.myApplication.sslClientConfig.setGateWayIp(this.serverIP.getBytes());
                        TunVpnService.myApplication.sslClientConfig.setGateWayIp2(this.serverIP.getBytes());
                        TunVpnService.myApplication.sslClientConfig.setGateWayIp3(this.serverIP.getBytes());
                        TunVpnService.myApplication.sslClientConfig.setGateWayPort(this.serverPort);
                    }
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
            if (TunVpnService.myApplication.sslvpn == null || stopService) {
                Function.setSafeTunVpnState(this.getApplicationContext(), true);
                stopService = false;
                this.running();
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        Log.d(TAG, "onDestroy");
        this.stopForeground(true);
        startflag = false;
        curstage = "";
        errorState = "";
        this.stopWatchingScreen();
        GuardianHelper.cancleOnceAlarm(this.getApplicationContext());
        if (TunVpnService.myApplication.propertiesConfig != null && TunVpnService.myApplication.propertiesConfig.getIsWakeLock() == 1) {
            Function.releaseWakeLock();
        }
        if (this.serverIP != null) {
            TunVpnService.myApplication.sslClientConfig.setGateWayIp(this.gatewayIp);
            TunVpnService.myApplication.sslClientConfig.setGateWayIp2(this.gatewayIp2);
            TunVpnService.myApplication.sslClientConfig.setGateWayIp3(this.gatewayIp3);
            TunVpnService.myApplication.sslClientConfig.setGateWayPort(this.gatewayPort);
        }
        if (TunVpnService.myApplication.sslvpn != null) {
            TunVpnService.myApplication.sslvpn.stopService();
            TunVpnService.myApplication.sslvpn.release();
            TunVpnService.myApplication.sslvpn = null;
        }
        try {
            if (mInterface != null) {
                Log.d(TAG, "TunVpnService.mInterface.close");
                mInterface.close();
                mInterface = null;
                if (tunVpnObj != null) {
                    tunVpnObj.destroyBuilder();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Function.setSafeTunVpnState(this.getApplicationContext(), false);
        safeVerifySuccess = false;
        if (TunVpnService.myApplication.sslvpn != null) {
            TunVpnService.myApplication.sslvpn.closeTunFd();
        }
        Object object = lock;
        synchronized (object) {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        this.stopWatchingDevice();
        tunVpnObj = null;
        if (TunVpnService.myApplication.propertiesConfig.getmDisableFlag() == 1) {
            TunVpnService.myApplication.disableFlag = 0;
        }
        errorInfoFlag = 0;
        errorInfo = "";
        if (nm != null) {
            nm.cancel(1);
        }
        TunVpnService.myApplication.sslvpn = null;
        VerifyTime.writeVerifySuccess((Context)this, false);
        Log.d("VerifyTime", "TunVpnService onDestroy reset flag");
        OttoUtil.unRegister((Object)this);
        Log.d(TAG, "onDestroy ok");
    }

    private void startWatchingScreen() {
        this.screenBroadCastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String[] pin = new String[2];
                String action = intent.getAction();
                if (action == null) {
                    return;
                }
                Log.d(TunVpnService.TAG, "screenBroadCastReceiver onReceive " + action);
                if ("android.intent.action.SCREEN_ON".equals(action)) {
                    if (myApplication.sslvpn != null && myApplication.sslClientConfig != null) {
                        Function.startVpnActivity(context);
                        screenOn = true;
                        myApplication.sslvpn.guardianLearn(GuardianHelper.guardian_option.G_OPT_SCREEN_ON.ordinal(), 0L);
                    }
                } else if ("android.intent.action.SCREEN_OFF".equals(action) && myApplication.sslvpn != null) {
                    screenOn = false;
                    myApplication.sslvpn.guardianLearn(GuardianHelper.guardian_option.G_OPT_SCREEN_OFF.ordinal(), 0L);
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.SCREEN_ON");
        this.registerReceiver(this.screenBroadCastReceiver, filter);
    }

    private void stopWatchingScreen() {
        if (this.screenBroadCastReceiver != null) {
            this.unregisterReceiver(this.screenBroadCastReceiver);
        }
    }

    public VpnService.Builder createBuilder() {
        this.builder = new VpnService.Builder((VpnService)this);
        return this.builder;
    }

    public void destroyBuilder() {
        this.builder = null;
    }

    public VpnService.Builder getBuilder() {
        return this.builder;
    }

    public void setBuilder(VpnService.Builder builder) {
        this.builder = builder;
    }

    private void setRole() {
        int role = TunVpnService.myApplication.sslClientConfig.getRole();
        if (role != 1 && role != 17) {
            byte[] defaultCertId = TunVpnService.myApplication.sslClientConfig.getCertId();
            role = Function.generateRole(defaultCertId);
            TunVpnService.myApplication.sslClientConfig.setRole(role);
        }
    }

    private void running() {
        Log.d(TAG, "Starting");
        this.setRole();
        this.startTunVpn();
    }

    public static void setSessionId(String id2) {
        sessionId = id2;
        Log.d(TAG, "setSessionId : " + sessionId);
    }

    public int getTunFd() {
        int tunFd = -1;
        if (this.builder == null) {
            Log.e(TAG, "builder == null");
            return -1;
        }
        if (1 == TunVpnService.myApplication.sslClientConfig.transportMode) {
            block28: {
                this.loadingNativeAppList();
                try {
                    if (TunVpnService.myApplication.propertiesConfig.getVpnInfoDialog() == 0) {
                        this.builder.setSession(sessionId).setConfigureIntent(mConfigureIntent);
                        if (Build.VERSION.SDK_INT >= 21) {
                            AppAclList appAclList = TunVpnService.myApplication.sslvpn.getAppAclList();
                            if (!appAclList.getRuleList().isEmpty()) {
                                boolean isBlack = appAclList.getAclType() == 0;
                                boolean hasMatched = false;
                                try {
                                    for (AppAclRule rule : appAclList.getRuleList()) {
                                        PackageInfo packageInfo = this.localNativeAppMap.get(rule.getPackageName() + rule.getHashCode());
                                        if (packageInfo == null) continue;
                                        hasMatched = true;
                                        if (isBlack) {
                                            this.builder.addDisallowedApplication(rule.getPackageName());
                                            continue;
                                        }
                                        this.builder.addAllowedApplication(rule.getPackageName());
                                    }
                                    if (!hasMatched && !isBlack) {
                                        this.builder.addAllowedApplication(this.getPackageName());
                                    }
                                }
                                catch (PackageManager.NameNotFoundException e) {
                                    e.printStackTrace();
                                }
                            } else if (appAclList.getAclType() == 1) {
                                this.builder.addAllowedApplication(this.getPackageName());
                            } else {
                                List<String> disallowedApps = Compatibility.getTunDisallowedApps();
                                if (disallowedApps != null) {
                                    for (String app : disallowedApps) {
                                        try {
                                            this.builder.addDisallowedApplication(app);
                                        }
                                        catch (PackageManager.NameNotFoundException e1) {
                                            e1.printStackTrace();
                                        }
                                    }
                                }
                            }
                        }
                        mInterface = this.builder.establish();
                        break block28;
                    }
                    mInterface = this.builder.establish();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    Log.e(TAG, "a parameter is not accepted by the operating system");
                    return -1;
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                    Log.e(TAG, "a parameter cannot be applied by the operating system");
                    return -1;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                    Log.e(TAG, "the service is not properly declared in AndroidManifest.xml");
                    return -1;
                }
                catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (mInterface != null) {
                tunFd = mInterface.getFd();
                Log.d(TAG, "tunFd = " + tunFd);
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                TunVpnService.myApplication.sslClientConfig.setTunFd(tunFd);
                TunVpnService.myApplication.sslvpn.setTunFd(tunFd);
                int fd = TunVpnService.myApplication.sslvpn.getSSLSocketFd();
                Log.d(TAG, "ssl socket Fd = " + fd);
                if (fd != -1) {
                    this.protect(fd);
                }
            } else {
                Log.e(TAG, "create tun failed");
                return -1;
            }
        }
        return 0;
    }

    private void loadingNativeAppList() {
        List packageInfos = this.getPackageManager().getInstalledPackages(64);
        for (PackageInfo packageInfo : packageInfos) {
            String shaSign = AppSHAUtil.getAppSHASign((Context)this, packageInfo.packageName);
            String key = packageInfo.packageName + shaSign;
            Log.i("WH", "-------key:" + key);
            this.localNativeAppMap.put(key, packageInfo);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String GetTerminalInfo(Context context, byte[] terminalInfo, int[] terminalInfoLen) {
        String strTermInfo = "";
        String cardSN = "";
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        String imsi = "000000000000000";
        if (manager.getSimState() == 5) {
            imsi = manager.getSubscriberId();
        }
        String imei = manager.getDeviceId();
        try {
            if (0 == TunVpnService.myApplication.sslClientConfig.getCertMode()) {
                byte[] cardId = new byte[64];
                int[] cardIdLen = new int[1];
                int ret = KeyWrapper.getInstance().getSN(cardId, cardIdLen);
                if (ret != 0) {
                    Log.e(TAG, "Get card sn return " + ret);
                    return KeyWrapper.StatusCode.getComment(ret);
                }
                cardSN = new String(cardId, 0, cardIdLen[0]);
            } else {
                cardSN = "0000000000000000000000000000000000000000000000000000000000000000";
            }
            strTermInfo = "ANDROID;" + cardSN + ";" + imei + ";" + imsi;
            Log.d(TAG, "strTermInfo = " + strTermInfo);
            terminalInfoLen[0] = strTermInfo.getBytes().length;
            System.arraycopy(strTermInfo.getBytes(), 0, terminalInfo, 0, terminalInfoLen[0]);
            return "";
        }
        catch (Exception e) {
            Log.d(TAG, "Covercard failed." + e.getMessage());
            return this.getString(R.string.gen_terminal_info_failed);
        }
    }

    private void startTunVpn() {
        int nres = -1;
        byte[] terminalInfo = new byte[256];
        int[] terminalInfoLen = new int[]{0};
        String strRes = this.GetTerminalInfo(this.getBaseContext(), terminalInfo, terminalInfoLen);
        if (!strRes.equals("")) {
            errorState = strRes;
            this.showVpnState(R.drawable.seq_off, this.getResources().getString(R.string.safe_client), errorState);
            Function.setSafeTunVpnState(this.getApplicationContext(), false);
            safeVerifySuccess = false;
            stopService = true;
            return;
        }
        if (TunVpnService.myApplication.sslvpn != null) {
            TunVpnService.myApplication.sslvpn.stopService();
            TunVpnService.myApplication.sslvpn.release();
            TunVpnService.myApplication.sslvpn = null;
        }
        TunVpnService.myApplication.sslvpn = new SSLVPN();
        TunVpnService.myApplication.sslClientConfig.setTerminalInfo(terminalInfo);
        TunVpnService.myApplication.sslClientConfig.setNetType(GuardianHelper.getNetWorkType(myApplication.getApplicationContext()).ordinal());
        nres = TunVpnService.myApplication.sslvpn.setParam(TunVpnService.myApplication.sslClientConfig);
        if (nres != 0) {
            errorState = nres == -1134 ? this.getString(R.string.no_cert) : this.getString(R.string.invalid_param);
            this.showVpnState(R.drawable.seq_off, this.getResources().getString(R.string.safe_client), errorState);
            Function.setSafeTunVpnState(this.getApplicationContext(), false);
            safeVerifySuccess = false;
            stopService = true;
            return;
        }
        nres = TunVpnService.myApplication.sslvpn.startService();
        if (nres != 0) {
            Log.d(TAG, "startService failed");
            errorState = StringUtil.getStringRes((Context)this, R.string.start_service_failed);
            this.showVpnState(R.drawable.seq_off, this.getResources().getString(R.string.safe_client), StringUtil.getStringRes((Context)this, R.string.start_service_failed));
            Function.setSafeTunVpnState(this.getApplicationContext(), false);
            safeVerifySuccess = false;
            stopService = true;
            return;
        }
        startflag = true;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object;
                int res;
                Object object2 = lock;
                synchronized (object2) {
                    sock = new SocketListener("127.0.0.1", myApplication.sslClientConfig.getPrivatePort());
                    res = sock.connect();
                }
                long ctime = System.currentTimeMillis();
                while (res != 0) {
                    if (System.currentTimeMillis() - ctime > 3000L) {
                        Log.e(TunVpnService.TAG, "connect to 127.0.0.1:" + myApplication.sslClientConfig.getPrivatePort() + " failed");
                        errorState = TunVpnService.this.getString(R.string.connect_service_failed);
                        TunVpnService.this.showVpnState(R.drawable.seq_off, TunVpnService.this.getResources().getString(R.string.safe_client), StringUtil.getStringRes((Context)TunVpnService.this, R.string.connect_service_failed));
                        object = lock;
                        synchronized (object) {
                            if (sock != null) {
                                sock.close();
                                sock = null;
                            }
                        }
                        myApplication.sslvpn.stopService();
                        Function.setSafeTunVpnState(TunVpnService.this.getApplicationContext(), false);
                        safeVerifySuccess = false;
                        stopService = true;
                        return;
                    }
                    object = lock;
                    synchronized (object) {
                        res = sock.connect();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                }
                object = lock;
                synchronized (object) {
                    if (sock != null) {
                        sock.sendData("VPNSTART");
                        TunVpnService.this.vpnstatelen = sock.recvData(TunVpnService.this.vpnstate);
                    }
                }
                if (!Function.getSafeTunVpnState(TunVpnService.this.getApplicationContext())) {
                    stopService = true;
                    SafeVerifyActivity.startService = false;
                }
                object = lock;
                synchronized (object) {
                    if (sock == null) {
                        stopService = true;
                        SafeVerifyActivity.startService = false;
                    }
                }
            }
        }).start();
    }

    public void stateChange(byte[] state, int len) {
        Message message = new Message();
        message.what = 2;
        Bundle bundle = new Bundle();
        bundle.putInt("len", len);
        bundle.putByteArray("content", state);
        message.setData(bundle);
        this.mHandler.sendMessage(message);
        Intent sendIntent = new Intent("com.xdja.safeclient.statechange");
        sendIntent.putExtra("content", state);
        this.sendBroadcast(sendIntent);
    }

    private void saveCertifyTime(String data) {
        if (TunVpnService.myApplication.sslvpn == null) {
            Log.d("VerifyTime", "sslvpn is null");
            return;
        }
        String[] state = data.split(" ");
        String success = state[0];
        String stage = state[1];
        if (!success.equals("OK")) {
            VerifyTime.writeVerifySuccess((Context)this, false);
        }
        if (success.equals("OK") && stage.equals("100") && !VerifyTime.readLastVerifySuccess((Context)this)) {
            VerifyTime.writeVerifyTime((Context)this);
            VerifyTime.writeVerifySuccess((Context)this, true);
        }
    }

    public void showState() {
        this.saveCertifyTime(new String(this.vpnstate, 0, this.vpnstatelen));
        if (this.vpnstatelen < 0) {
            Log.d(TAG, "vpnstatelen = " + this.vpnstatelen);
            return;
        }
        if (!screenOn) {
            // empty if block
        }
        if (!startflag) {
            Log.d(TAG, "service stop, give up status show");
            return;
        }
        int firstindex = 0;
        int lastindex = 0;
        String stageStatus = "";
        String errorStatus = "";
        String errorCode = "";
        String temp = null;
        temp = new String(this.vpnstate, 0, this.vpnstatelen);
        try {
            String[] arrState = temp.split(" ");
            issuccess = arrState[0];
            curstage = arrState[1];
            errorCode = arrState[2];
            if (Integer.parseInt(errorCode) == -1510) {
                errorStatus = arrState[3];
                errorInfoFlag = !errorInfo.equals(errorStatus) ? 1 : 0;
                errorInfo = errorStatus;
                Log.d(TAG, "errorInfo: " + errorInfo);
            } else {
                lastindex = StringUtil.getCharacterPosition(temp, " ", 3);
                errorStatus = new String(this.vpnstate, lastindex + 1, this.vpnstatelen - lastindex - 1, "gbk");
            }
        }
        catch (Exception e) {
            Log.d(TAG, "vpnstate :" + temp + " len :" + temp.length());
            Log.d(TAG, "firstindex: " + firstindex);
            Log.d(TAG, "lastindex: " + lastindex);
            return;
        }
        if (curstage.compareTo(this.prestage) != 0 || errorInfoFlag == 1) {
            this.prestage = curstage;
            SafeVerifyStageInfo stageInfo = new SafeVerifyStageInfo();
            if (curstage.compareTo("20") == 0) {
                stageInfo.name = this.getString(R.string.init_safe_component);
            } else if (curstage.compareTo("30") == 0) {
                stageInfo.name = this.getString(R.string.connect_to_safe_gateway);
            } else if (curstage.compareTo("40") == 0) {
                stageInfo.name = StringUtil.getStringRes((Context)this, R.string.safe_verify);
            } else if (curstage.compareTo("50") == 0) {
                stageInfo.name = this.getString(R.string.bind_verify_info);
            } else if (curstage.compareTo("60") == 0) {
                stageInfo.name = this.getString(R.string.start_service);
            } else if (curstage.compareTo("100") == 0) {
                stageInfo.name = TunVpnService.myApplication.sslClientConfig.transportMode == 0 ? this.getString(R.string.safe_tunnel_via_trans_mode) : this.getString(R.string.safe_tunnel_via_tunnel_mode);
            } else {
                return;
            }
            if (issuccess.compareTo("OK") == 0) {
                stageInfo.result = StringUtil.getStringRes((Context)this, R.string.success);
                stageStatus = stageInfo.name + stageInfo.result;
            } else {
                stageInfo.result = StringUtil.getStringRes((Context)this, R.string.fail);
            }
            stageInfo.error = errorStatus;
            sslStageList.add(stageInfo);
            if (SafeVerifyActivity.myTunAdapter != null) {
                SafeVerifyActivity.myTunAdapter.notifyDataSetChanged();
            }
            if (issuccess.compareTo("OK") == 0) {
                if (curstage.compareTo("100") == 0) {
                    safeVerifySuccess = true;
                    errorState = "";
                    this.showVpnState(R.drawable.seq_on, this.getResources().getString(R.string.safe_client), stageStatus);
                    errorInfoFlag = 0;
                    errorInfo = "";
                    if (nm != null) {
                        nm.cancel(1);
                    }
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (tunVpnObj != null) {
                                SCAutoUpdate.updateStart((Context)tunVpnObj, false);
                            }
                        }
                    }, 800L);
                } else {
                    ++this.connect;
                    if (this.connect > 4) {
                        this.connect = 1;
                    }
                    switch (this.connect) {
                        case 1: {
                            this.showVpnState(R.drawable.seq_conn1, this.getResources().getString(R.string.safe_client), stageStatus);
                            break;
                        }
                        case 2: {
                            this.showVpnState(R.drawable.seq_conn2, this.getResources().getString(R.string.safe_client), stageStatus);
                            break;
                        }
                        case 3: {
                            this.showVpnState(R.drawable.seq_conn3, this.getResources().getString(R.string.safe_client), stageStatus);
                            break;
                        }
                        case 4: {
                            this.showVpnState(R.drawable.seq_conn4, this.getResources().getString(R.string.safe_client), stageStatus);
                        }
                    }
                }
            } else {
                Log.e(TAG, "curstage: " + curstage);
                Log.e(TAG, "issuccess: " + issuccess);
                Log.e(TAG, "errorStatus: " + errorStatus);
                safeVerifySuccess = false;
                errorState = errorStatus;
                this.showVpnState(R.drawable.seq_off, this.getResources().getString(R.string.safe_client), errorStatus);
                try {
                    if (mInterface != null) {
                        Log.d(TAG, "TunVpnService.mInterface.close");
                        mInterface.close();
                        mInterface = null;
                        if (tunVpnObj != null) {
                            tunVpnObj.destroyBuilder();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (TunVpnService.myApplication.sslvpn != null) {
                    TunVpnService.myApplication.sslvpn.closeTunFd();
                }
                if (errorInfoFlag == 1) {
                    this.showVpnErrorInfo(R.drawable.tf_locked, this.getResources().getString(R.string.safe_client), errorInfo);
                }
            }
        }
    }

    public void showVpnState(int icon, String title, String text) {
        if (TunVpnService.myApplication.propertiesConfig.getNotification() == 0) {
            Intent intent = new Intent((Context)this, SafeVerifyActivity.class);
            intent.setFlags(0x10200000);
            intent.putExtra("FLAG_START_FROM_NOTIFICATION", true);
            Notification.Builder builder = new Notification.Builder((Context)this);
            builder.setSmallIcon(icon);
            builder.setWhen(System.currentTimeMillis());
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)0);
            builder.setContentIntent(pendingIntent);
            builder.setContentTitle((CharSequence)title);
            builder.setContentText((CharSequence)text);
            this.startForeground(2, builder.build());
        }
    }

    private void showVpnErrorInfo(int icon, String title, String text) {
        nm = (NotificationManager)this.getSystemService("notification");
        Notification.Builder builder = new Notification.Builder((Context)this);
        builder.setSmallIcon(icon);
        builder.setWhen(System.currentTimeMillis());
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)new Intent((Context)this, SafeVerifyActivity.class), (int)0);
        builder.setContentIntent(pendingIntent);
        builder.setContentTitle((CharSequence)title);
        builder.setContentText((CharSequence)text);
        nm.notify(1, builder.build());
    }

    @Subscribe
    public void handleExitAppEvent(ExitAppEvent event) {
        this.handleStopTunEvent(new StopTunEvent());
    }

    @Subscribe
    public void handleStopTunEvent(StopTunEvent event) {
        boolean success;
        if (mInterface != null) {
            try {
                mInterface.close();
                mInterface = null;
                if (tunVpnObj != null) {
                    tunVpnObj.destroyBuilder();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            mInterface = null;
        }
        if (TunVpnService.myApplication.sslvpn != null) {
            TunVpnService.myApplication.sslvpn.closeTunFd();
        }
        if (success = this.stopService(IntentParam.stopTunVpn((Context)this))) {
            Function.setSafeTunVpnState(this.getApplicationContext(), false);
            stopService = true;
            sslStageList.clear();
        }
    }

    static {
        mInterface = null;
        myApplication = null;
        sock = null;
        issuccess = "";
        curstage = "";
        stopService = false;
        errorState = "";
        errorInfo = "";
        errorInfoFlag = 0;
        nm = null;
        sslStageList = new ArrayList<SafeVerifyStageInfo>();
        safeVerifySuccess = false;
        sessionId = "";
        screenOn = true;
        tunVpnObj = null;
        lock = new Object();
        startflag = false;
    }
}

