/*
 * Decompiled with CFR 0.152.
 */
package com.zf.simkeyb.mb;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.PowerManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.hed.bluetooth.le.BluetoothDeviceWrapper;
import com.hed.bluetooth.le.GattError;
import com.hed.bluetooth.le.RfcommGatt;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class zfBleApi {
    private final String TAG = zfBleApi.class.getSimpleName();
    public static String ACTION_Connect_SUC = "Bluetooth.connect.succ";
    public static String ACTION_Connect_FAIL = "Bluetooth.connect.fail";
    private RfcommGatt mGatt;
    private PowerManager.WakeLock mwl;
    private static Context CONTEXT_INSTANCE;
    private String mDeviceAddress = "";
    private BluetoothManager mBluetoothManager = null;
    private BluetoothAdapter mBluetoothAdapter = null;

    public zfBleApi(Context parent) {
    }

    public zfBleApi() {
    }

    public BluetoothManager getManager() {
        return this.mBluetoothManager;
    }

    public BluetoothAdapter getAdapter() {
        return this.mBluetoothAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Context getcontext() {
        if (CONTEXT_INSTANCE != null) return CONTEXT_INSTANCE;
        Class<zfBleApi> clazz = zfBleApi.class;
        synchronized (zfBleApi.class) {
            if (CONTEXT_INSTANCE != null) return CONTEXT_INSTANCE;
            try {
                Class<?> ActivityThread = Class.forName("android.app.ActivityThread");
                Method method = ActivityThread.getMethod("currentActivityThread", new Class[0]);
                Object currentActivityThread = method.invoke(ActivityThread, new Object[0]);
                Method method2 = currentActivityThread.getClass().getMethod("getApplication", new Class[0]);
                CONTEXT_INSTANCE = (Context)method2.invoke(currentActivityThread, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return CONTEXT_INSTANCE;
        }
    }

    public static boolean checkBleHardwareAvailable(Context context) {
        BluetoothManager manager = (BluetoothManager)context.getSystemService("bluetooth");
        if (manager == null) {
            return false;
        }
        BluetoothAdapter adapter = manager.getAdapter();
        if (adapter == null) {
            return false;
        }
        boolean hasBle = context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
        return hasBle;
    }

    public boolean initialize() {
        if (this.mBluetoothManager == null) {
            this.mBluetoothManager = (BluetoothManager)this.getcontext().getSystemService("bluetooth");
            if (this.mBluetoothManager == null) {
                return false;
            }
        }
        if (this.mBluetoothAdapter == null) {
            this.mBluetoothAdapter = this.mBluetoothManager.getAdapter();
        }
        if (this.mBluetoothAdapter == null) {
            return false;
        }
        boolean hasBle = this.getcontext().getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
        return hasBle;
    }

    public boolean isBtEnabled() {
        BluetoothManager manager = (BluetoothManager)this.getcontext().getSystemService("bluetooth");
        if (manager == null) {
            return false;
        }
        BluetoothAdapter adapter = manager.getAdapter();
        if (adapter == null) {
            return false;
        }
        return adapter.isEnabled();
    }

    public int SMK_EnumDevice(byte[] device, int[] devicelen) {
        Log.e((String)this.TAG, (String)"Enum begin ~~");
        TelephonyManager telManager = (TelephonyManager)this.getcontext().getSystemService("phone");
        String iccid = telManager.getSimSerialNumber();
        if (iccid == null || iccid.equals("")) {
            return 1;
        }
        String strdevice = String.valueOf(iccid.substring(8, 10)) + ":" + iccid.substring(10, 12) + ":" + iccid.substring(12, 14) + ":" + iccid.substring(14, 16) + ":" + iccid.substring(16, 18) + ":" + iccid.substring(18);
        byte[] tdevice = strdevice.getBytes();
        System.arraycopy(tdevice, 0, device, 0, 17);
        device[17] = 0;
        device[18] = 0;
        devicelen[0] = 19;
        return 0;
    }

    public int SMK_EnumDevice(String[] device, int[] devicelen) {
        return 0;
    }

    public int SMK_Connect(String deviceAddress) {
        BluetoothDevice device = this.mBluetoothAdapter.getRemoteDevice(deviceAddress);
        RfcommGatt.CONNECTION_PARAM_UPDATE_REQ_DELAY = 500;
        int ret = 0;
        try {
            BluetoothDeviceWrapper wrapper = new BluetoothDeviceWrapper(device);
            this.mGatt = wrapper.createRfcommGatt(this.getcontext());
            ret = this.mGatt.connect(10000);
            Log.e((String)this.TAG, (String)("connect ret = " + Integer.toBinaryString(ret)));
            this.mDeviceAddress = deviceAddress;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)e.getMessage());
            return 1;
        }
        PowerManager pm = (PowerManager)this.getcontext().getSystemService("power");
        this.mwl = pm.newWakeLock(1, "myWakeLock");
        this.mwl.acquire();
        return ret;
    }

    public int SMK_DisConnect(String address) {
        if (address == null) {
            return 4103;
        }
        if (!address.equals(this.mDeviceAddress)) {
            return 4103;
        }
        if (this.mGatt != null) {
            try {
                this.mGatt.close(10000);
                if (this.mwl != null && this.mwl.isHeld()) {
                    this.mwl.release();
                    this.mwl = null;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.mGatt = null;
            return 0;
        }
        return 0;
    }

    private String bytesToHexString(byte[] bArray, int len) {
        StringBuffer sb = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
            ++i;
        }
        return sb.toString();
    }

    public int SMK_CommandApi(String address, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        byte[] command = new byte[inLen];
        Log.e((String)"SMK_CommandApi", (String)("send data is" + this.bytesToHexString(dataIn, inLen)));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy\u5e74m\u6708d\u65e5   HH:mm:ss", Locale.getDefault());
        Date curDate = new Date(System.currentTimeMillis());
        String str = String.valueOf(formatter.format(curDate)) + "\n";
        if (!address.equals(this.mDeviceAddress)) {
            return 1001;
        }
        System.arraycopy(dataIn, 0, command, 0, inLen);
        try {
            byte[] resp = this.mGatt.transmit(command, 10000);
            if (resp.length <= outLen[0]) {
                outLen[0] = resp.length;
                System.arraycopy(resp, 0, dataOut, 0, outLen[0]);
                Log.e((String)"SMK_CommandApi", (String)("receive data is " + this.bytesToHexString(dataOut, outLen[0]) + "\n"));
                return 0;
            }
            return 4105;
        }
        catch (GattError e) {
            e.printStackTrace();
            return 1;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return 1;
        }
    }
}

