package com.mpt.aidlservice;

import java.util.Arrays;

import org.json.JSONException;
import org.json.JSONObject;

import com.google.gson.Gson;
import com.mpt.aidlservice.IApnAndSafeKey.Stub;
import com.safetf.SafeTF;
import com.xdja.bean.VendorInfoJson;
import com.xdja.key.KeyWrapper;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.utils.Log;
import com.xdja.sslvpn.CONSTANT;
import com.xdja.sslvpn.SslvpnStatus;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;

public class AidlService extends Service {
	private IApnAndSafeKeyBinder iBinder;
	private boolean blockMainThread = false;
	MyApplication myApplication = null;

	private static final String TAG = "AidlService";
	
	@Override
	public void onCreate() {
		// TODO Auto-generated method stub
		super.onCreate();
		Log.d("AidlService","onCreate");
		myApplication = (MyApplication)getApplication();
		
		iBinder = new IApnAndSafeKeyBinder();
	}



	@Override
	public void onDestroy() {
		// TODO Auto-generated method stub
		super.onDestroy();
	}



	@Override
	public IBinder onBind(Intent intent) {
		// TODO Auto-generated method stub
		Log.d("AidlService","onBind");
		return iBinder;
	}		

	public class IApnAndSafeKeyBinder extends Stub {

		@Override
		public boolean XKF_GetVPNTunnelState() throws RemoteException {
			// TODO Auto-generated method stub
//			if (0 == myApplication.sslClientConfig.transportMode
//					|| myApplication.havingRootPermission == true) {
			if (0 == myApplication.sslClientConfig.transportMode) {
				return VpnService.safeVerifySuccess;
			}
			else {
				return TunVpnService.safeVerifySuccess;
			}
		}

		@Override
		public String XKF_GetMonitorServerAddress() throws RemoteException {
			// TODO Auto-generated method stub
			return getMonitorServerAddress();
		}

		@Override
		public String XKF_GetVendorInfo() throws RemoteException {
			// TODO Auto-generated method stub
			return getVendorInfo();
		}

		@Override
		public String XKF_GetCardID() throws RemoteException {
			// TODO Auto-generated method stub
			return getCardId();
		}

		@Override
		public String XKF_ReadCert() throws RemoteException {
			// TODO Auto-generated method stub
			return readCert();
		}

		@Override
		public byte[] XKF_SM1KEY(byte[] sourceData, byte[] testKey,
				int encryptFlag,byte[] iv) throws RemoteException {
			// TODO Auto-generated method stub
			return sm1Key(sourceData,testKey,encryptFlag,iv);
		}

		@Override
		public boolean XKF_CheckWeakPassWD() throws RemoteException {
			// TODO Auto-generated method stub
			return checkWeakPassWD();
		}

		@Override
		public boolean XKF_PassWordEnter(String testPin) throws RemoteException {
			// TODO Auto-generated method stub
			return passWordEnter(testPin);
		}

		
		private String getCardId() {
			String cardId = "";
			int ret;
			byte[] cardIdArray = new byte[64];
			int[] cardIdLen = new int[1];

			ret = KeyWrapper.getInstance().getSN(cardIdArray, cardIdLen);
			if (ret == 0) {
				cardId = new String(cardIdArray, 0, cardIdLen[0]);
				Log.d(TAG, "Cover card id " + cardId);
			}

			return cardId;
		}
		
//		private String getMonitorServerAddress() {
//			int res = -1;
//			String serverAddr = null;
//			
//			Gson gson = new Gson();	
//			
//			MonitorServerAddrJson serverAddrJson = new MonitorServerAddrJson();
//			
//			serverAddrJson.setId(1);				
//			
//			if (VpnService.safeVerifySuccess == false && TunVpnService.safeVerifySuccess == false) {
//				serverAddrJson.getResult().setRes("FAILED");
//				Log.d("AidlService","safeVerifySuccess false");
//			}
//			else {
//				serverAddrJson.getResult().setRes("OK");
//				Log.d("AidlService","safeVerifySuccess true");
//				
//				// ?????
//				if (0 == myApplication.sslClientConfig.transportMode) {
//					
//					SslvpnStatus sslvpnStatus = new SslvpnStatus();
//				
//					if (myApplication.sslvpn != null) {
//						res = myApplication.sslvpn.getStatus(sslvpnStatus);	
//					
//						if (res == 0 && sslvpnStatus != null) {
//							serverAddrJson.getResult().getServerAddr().setListenport(sslvpnStatus.aidlListenPortList);
//						}
//					
//						serverAddrJson.getResult().getServerAddr().setTunelmode("101");
//						serverAddrJson.getResult().getServerAddr().setProtectsubnet("127.0.0.1");
//					}
//					else {
//						serverAddrJson.getResult().setRes("FAILED");
//					}
//				}
//				// ?????
//				else {	
//					final SslvpnStatus sslvpnStatus = new SslvpnStatus();	
//					blockMainThread = true;
//					int count = 0;
//					
//					new Thread() {
//						public void run() {
//							getCurSslvpnStatus(sslvpnStatus);
//							blockMainThread = false;
//						}
//					}.start();
//										
//					while(blockMainThread) {
//						if (count > 30) {
//							break;
//						}
//						
//						count++;
//						
//						try {
//							Thread.sleep(100);
//						} catch (InterruptedException e) {
//							// TODO Auto-generated catch block
//							e.printStackTrace();
//						}
//					}
//															
//					serverAddrJson.getResult().getServerAddr().setProtectsubnet(sslvpnStatus.monitorSrvIp);
//					serverAddrJson.getResult().getServerAddr().setTunelmode("100");
//					serverAddrJson.getResult().getServerAddr().setListenport("");
//				}	
//			}
//			
//			serverAddr = gson.toJson(serverAddrJson);
//			Log.d("AidlService","getMonitorServerAddress : " + serverAddr);
//			
//			return serverAddr;
//		}
		
		private String getMonitorServerAddress() {
			int res = -1;
			String serverAddr = null;
			
			JSONObject json = new JSONObject();
	        try {
	            json.put("jsonrpc", "2.0");
	            json.put("id", "1");
	            
	            JSONObject result = new JSONObject();
	            
	            JSONObject serveraddress = new JSONObject();
			
				if (VpnService.safeVerifySuccess == false && TunVpnService.safeVerifySuccess == false) {
					result.put("res", "FAILED");
					Log.d("AidlService","safeVerifySuccess false");
				}
				else {
					result.put("res", "OK");
					Log.d("AidlService","safeVerifySuccess true");
					
					// ?????
					if (0 == myApplication.sslClientConfig.transportMode) {
						
						SslvpnStatus sslvpnStatus = new SslvpnStatus();
					
						if (myApplication.sslvpn != null) {
							res = myApplication.sslvpn.getStatus(sslvpnStatus);	
							
							serveraddress.put("monitorserverip", "127.0.0.1");
							if (res == 0 && sslvpnStatus != null) {
								serveraddress.put("monitorserverporxyport", sslvpnStatus.monitorserverporxyport);
								serveraddress.put("monitorserverporxyport1", sslvpnStatus.monitorserverporxyport1);
							}
							serveraddress.put("tunelmode", "101");
	
						}
						else {
							result.put("res", "FAILED");
						}
					}
					// ?????
					else {	
						final SslvpnStatus sslvpnStatus = new SslvpnStatus();	
						blockMainThread = true;
						int count = 0;
						
						new Thread() {
							public void run() {
								getCurSslvpnStatus(sslvpnStatus);
								blockMainThread = false;
							}
						}.start();
											
						while(blockMainThread) {
							if (count > 30) {
								break;
							}
							
							count++;
							
							try {
								Thread.sleep(100);
							} catch (InterruptedException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						}
						
						if (sslvpnStatus != null) {
							serveraddress.put("monitorserverip", sslvpnStatus.monitorSrvIp);
							serveraddress.put("realPort", sslvpnStatus.monitorserverporxyport);
							serveraddress.put("realPort1", sslvpnStatus.monitorserverporxyport1);
						}
						serveraddress.put("tunelmode", "100");
					}	
				}
				
				result.put("serveraddress", serveraddress);
				json.put("result", result);
				
				
				serverAddr = json.toString();
				Log.d("AidlService","getMonitorServerAddress : " + serverAddr);
				
				return serverAddr;
	        } catch (JSONException e) {
	            return "";
	        }
		}
		
		/**
		 * @param sslvpnStatus
		 */
		private void getCurSslvpnStatus(SslvpnStatus sslvpnStatus) {

			String temp = null;
			int vpnstatelen = 0;
			byte[] vpnstate = new byte[4096];

//			if (myApplication.havingRootPermission == true) {
//				if (VpnService.sock == null) {
//					sslvpnStatus.monitorSrvIp = "";
//					return;
//				}
//				VpnService.sock.sendData(CONSTANT.CMD_GET_CUR_STATE);
//
//				vpnstatelen = VpnService.sock.recvData(vpnstate);
//			}else
		 {
				if (TunVpnService.sock == null) {
					sslvpnStatus.monitorSrvIp = "";
					return;
				}
				TunVpnService.sock.sendData(CONSTANT.CMD_GET_CUR_STATE);
				
				vpnstatelen = TunVpnService.sock.recvData(vpnstate);
			}	
			
			Log.d("AidlService", "vpnstatelen = " + vpnstatelen);
			
			
			if (vpnstatelen <= 0) {
				Log.d("AidlService", "vpnstatelen = " + vpnstatelen);
				sslvpnStatus.monitorSrvIp = "";
				return;
			}
			
			temp = new String(vpnstate, 0, vpnstatelen);
			
			Log.d("AidlService", "temp = " + temp);
			
			String[] arrayStr = temp.split("#");
			
			if (arrayStr.length < 6) {
				Log.d("AidlService", "arrayStr.length = " + arrayStr.length);
				return;
			}
			
			sslvpnStatus.monitorserverporxyport = arrayStr[3];
			
			sslvpnStatus.monitorserverporxyport1 = arrayStr[4];
				
			sslvpnStatus.monitorSrvIp = arrayStr[5];						
			
		}
		
		private String getVendorInfo() {
//			int hMutex = -1;
			String version = null;
			String vendorInfo = null;
			Gson gson = new Gson();	
			
			VendorInfoJson vendorinfojosn = new VendorInfoJson();
			
			// ??汾??
			SafeTF tf = new SafeTF();
			int hHandle = 0;
//			if (myApplication.sslClientConfig.getSdkVersion() >= MyApplication.ANDROID_4_4_VERSION) {
//				String tmp = new String(myApplication.sslClientConfig.getDevPath());
//				hHandle = tf.OpenSTFCard(tmp);
//			}
//			
//			if (hHandle == 0) {
//				hHandle = tf.OpenSTFCardAuto();
//				if (hHandle == 0) {
//					Log.d("AidlService","OpenSTFCardAuto failed");
//					return null;
//				}
//			}
			
			hHandle = tf.OpenSTFCardAuto();
			
			Log.d("AidlService","OpenSTFCardAuto, hHandle = " + hHandle);
			
			if (hHandle == 0) {
				if (myApplication.sslClientConfig.getSdkVersion() 
						>= MyApplication.ANDROID_4_4_VERSION) {
					String tmp = new String(myApplication.sslClientConfig.getDevPath());
					
					hHandle = tf.OpenSTFCard(tmp);
					Log.d("AidlService","OpenSTFCard ,hHandle = " + hHandle);
					if (hHandle == 0) {
						Log.d("AidlService","OpenSTFCard failed");
						return null;
					}
				}
			}

//			hMutex = tf.BeginTransaction(hHandle);// ???????
//			
//			if (hMutex != 0) {
//				Log.d("AidlService","BeginTransaction " + tf.getErrorMsg(hHandle));
//				return null;
//			}
			
			version = tf.GetVersion();
						
//			if (hMutex == 0) {
//				tf.EndTransaction(hHandle);// ???????
//			}			
		
			tf.CloseSTFCard(hHandle);
			
			// ???????????
			vendorinfojosn.getResult().getVendorinfo().setVendor("xdja");
			// ????汾??
			vendorinfojosn.getResult().getVendorinfo().setVersion(version);			
			// ??????????
			vendorinfojosn.getResult().getVendorinfo().setExtendinfo("");
			// ????josn id
			vendorinfojosn.setId(2);	
			// ??????
			if (version == null || version.equals("")) {
				vendorinfojosn.getResult().setRes("FAILED");
			}
			else {
				vendorinfojosn.getResult().setRes("OK");
			}
			
			vendorInfo = gson.toJson(vendorinfojosn);
			
			Log.d("AidlService","getVendorInfo : " + vendorInfo);
			
			return vendorInfo;
		}

		private String readCert() {
			byte[] bCertBuf = new byte[2048];
			int[] bCertLen = new int[1];
			String certBase64 = null;
			int iCertLen = 0;
			int res = 0;
//			int hMutex = -1;
			byte[] defaultCertId = new byte[2];
			
			
			SafeTF tf = new SafeTF();
			
			int hHandle = 0;
//			if (myApplication.sslClientConfig.getSdkVersion() >= MyApplication.ANDROID_4_4_VERSION) {
//				String tmp = new String(myApplication.sslClientConfig.getDevPath());
//				hHandle = tf.OpenSTFCard(tmp);
//			}
//			
//			if (hHandle == 0) {
//				hHandle = tf.OpenSTFCardAuto();
//				if (hHandle == 0) {
//					Log.d("AidlService","OpenSTFCardAuto failed");
//					return null;
//				}
//			}
			
			hHandle = tf.OpenSTFCardAuto();
			
			Log.d("AidlService","OpenSTFCardAuto, hHandle = " + hHandle);
			
			if (hHandle == 0) {
				if (myApplication.sslClientConfig.getSdkVersion() 
						>= MyApplication.ANDROID_4_4_VERSION) {
					String tmp = new String(myApplication.sslClientConfig.getDevPath());
					
					hHandle = tf.OpenSTFCard(tmp);
					Log.d("AidlService","OpenSTFCard ,hHandle = " + hHandle);
					if (hHandle == 0) {
						Log.d("AidlService","OpenSTFCard failed");
						return null;
					}
				}
			}

//			hMutex = tf.BeginTransaction(hHandle);// ???????
			
//			if (hMutex != 0) {
//				Log.d("AidlService","BeginTransaction " + tf.getErrorMsg(hHandle));
//				return null;
//			}
			
			if (myApplication.sslClientConfig != null) {
				defaultCertId = myApplication.sslClientConfig.getCertId();
				Log.d("AidlService","CertId :" + defaultCertId[0] + defaultCertId[1]);
			}
			
			res = tf.GetCert(hHandle, bCertBuf, bCertLen, defaultCertId);
			
			iCertLen = bCertLen[0];			
			Log.d("AidlService","CertLen : " + iCertLen);
			
			if (res == 0) {
				try {				
					certBase64 = Base64.encodeBytes(bCertBuf,0,iCertLen);
					Log.d("AidlService","certBase64 : " + certBase64);
				}
				catch (NullPointerException e) {
					e.printStackTrace();
				}
				catch (IndexOutOfBoundsException e) {
					e.printStackTrace();
				}
			}
			else if (res == 2) {
				certBase64 = null;
				Log.d("AidlService","parm is error");
			}
			else {
				certBase64 = null;
				Log.d("AidlService","GetCardID " + tf.getErrorMsg(AidlService.this, hHandle));
			}
			
//			if (hMutex == 0) {
//				tf.EndTransaction(hHandle);// ???????
//			}			
		
			tf.CloseSTFCard(hHandle);
						
			return certBase64;
		}
		
		private byte[] sm1Key(byte[] sourceData,byte[] testKey,int encryptFlag,byte[] iv) {
//			int hMutex = -1;
			int res = -1;
			byte[] pDataOut = new byte[sourceData.length];
			SafeTF tf = new SafeTF();
			
			int hHandle = 0;
//			if (myApplication.sslClientConfig.getSdkVersion() >= MyApplication.ANDROID_4_4_VERSION) {
//				String tmp = new String(myApplication.sslClientConfig.getDevPath());
//				hHandle = tf.OpenSTFCard(tmp);
//			}
//			
//			if (hHandle == 0) {
//				hHandle = tf.OpenSTFCardAuto();
//				if (hHandle == 0) {
//					Log.d("AidlService","OpenSTFCardAuto failed");
//					return null;
//				}
//			}
			
			hHandle = tf.OpenSTFCardAuto();
			
			Log.d("AidlService","OpenSTFCardAuto, hHandle = " + hHandle);
			
			if (hHandle == 0) {
				if (myApplication.sslClientConfig.getSdkVersion() 
						>= MyApplication.ANDROID_4_4_VERSION) {
					String tmp = new String(myApplication.sslClientConfig.getDevPath());
					
					hHandle = tf.OpenSTFCard(tmp);
					Log.d("AidlService","OpenSTFCard ,hHandle = " + hHandle);
					if (hHandle == 0) {
						Log.d("AidlService","OpenSTFCard failed");
						return null;
					}
				}
			}
			
//			hMutex = tf.BeginTransaction(hHandle);// ???????
//			
//			if (hMutex != 0) {
//				Log.d("AidlService","BeginTransaction " + tf.getErrorMsg(hHandle));
//				return null;
//			}
			
			res = tf.SM1KEY(hHandle, testKey, sourceData, encryptFlag, pDataOut, iv);
			
			if (res == 0) {
				Log.d("AidlService","SM1KEY success");
			}
			else if (res == 2) {
				pDataOut = null;
				Log.d("AidlService","parm is error");
			}
			else {
				pDataOut = null;
				Log.d("AidlService","sm1Key " + tf.getErrorMsg(AidlService.this, hHandle));
			}
			
//			if (hMutex == 0) {
//				tf.EndTransaction(hHandle);// ???????
//			}			
		
			tf.CloseSTFCard(hHandle);
			
			return pDataOut;
		}
		
		private boolean checkWeakPassWD() {			
			return myApplication.isWeakPassWD;
		}
		
		private boolean passWordEnter(String testPin) {
			int nres = -1;
			int hMutex = -1;
			int role = 0;
			
			boolean result = false;
			
			SafeTF tf = new SafeTF();
			
			int hHandle = 0;
//			if (myApplication.sslClientConfig.getSdkVersion() >= MyApplication.ANDROID_4_4_VERSION) {
//				String tmp = new String(myApplication.sslClientConfig.getDevPath());
//				hHandle = tf.OpenSTFCard(tmp);
//			}
//			
//			if (hHandle == 0) {
//				hHandle = tf.OpenSTFCardAuto();
//				if (hHandle == 0) {
//					Log.d("AidlService","OpenSTFCardAuto" + "?????????");
//					return false;
//				}
//			}
			
			hHandle = tf.OpenSTFCardAuto();
			
			Log.d("AidlService","OpenSTFCardAuto, hHandle = " + hHandle);
			
			if (hHandle == 0) {
				if (myApplication.sslClientConfig.getSdkVersion() 
						>= MyApplication.ANDROID_4_4_VERSION) {
					String tmp = new String(myApplication.sslClientConfig.getDevPath());
					
					hHandle = tf.OpenSTFCard(tmp);
					Log.d("AidlService","OpenSTFCard ,hHandle = " + hHandle);
					if (hHandle == 0) {
						Log.d("AidlService","OpenSTFCard failed");
						return false;
					}
				}
			}
			
//			hMutex = tf.BeginTransaction(hHandle);// ???????
						
//			if (hMutex != 0) {
//				Log.d("AidlService","BeginTransaction" + tf.getErrorMsg(hHandle));
//				return false;
//			}
			
			
			role = myApplication.sslClientConfig.getRole();
			if(role != 0x01 && role != 0x11){
				byte[] defaultCertId = myApplication.sslClientConfig.getCertId();
				role = Function.generateRole(defaultCertId);
			}
			
			nres = tf.SafePin(hHandle, testPin.getBytes(), role);
			
			if (nres != 0) {
				Log.d("AidlService","???????????" + tf.getErrorMsg(AidlService.this, nres));
				result = false;
			}		
			else {
				Log.d("AidlService","??????????");
				result = true;
			}
		
//			if (hMutex == 0) {
//				tf.EndTransaction(hHandle);// ???????
//			}
			
			tf.CloseSTFCard(hHandle);
			
			return result;
		}
		
	}
}
