package com.safetf;
import android.content.Context;

import com.safetf.SafeTFError;
public class SafeTF {
	/**
	 *功能：自动搜索并打开设备 返回值：成功返回打开设备的句柄,失败返回0
	 */
	public native int OpenSTFCardAuto();

	/**
	*功能：指定设备挂载路径，打开安全设备
	*[in]  devicePath 指定设备挂载路径,约定已'/'结束,如 /mnt/sdcard/
	* @return  成功返回打开设备句柄，失败返回0
	*/
	public native int OpenSTFCard(String devicePath);
	
	/**
	 *[in]hHandle 已经成功打开的设备 开始事务操作，由上层应用控制，一担开始此事务，其它进程进入事务时会等待，直到超时。超时默认为30秒
	 * 返回值：成功返回0，失败返回其他。返回事务锁操作句柄在hHandle中。
	 */
	public native int BeginTransaction(int hHandle);

	/**
	 *关闭事务，释放事务锁
	 * 
	 * @param hHandle
	 * [IN] 操作句柄
	 */
	public native int EndTransaction(int hHandle);

	/**
	 *功能：设备复位 [in] hHandle 设备句柄 返回值：0成功，-1失败 说明：复位成功后，根目录会被自动选定为当前目录
	 */
	public native int CardReset(int hHandle);

	/**
	 *功能：关闭已经成功打开的设备 [in] hHandle 设备句柄
	 */
	public native void CloseSTFCard(int hHandle);

	/**
	 *功能：选择目录或文件 参数： [in] hHandle 设备句柄 [in] appid 目录或文件id，2字节
	 * 返回值：0成功，-2参数错误，其它见“API返回码说明”
	 */
	public native int SelectApp(int hHandle, byte[] appid);

	/**
	 *口令认证 作用与用法同 SafePin ,建议使用SafePin
	 */
	public native int Pin(int hHandle, byte[] pass, int role);

	/**
	 *功能：安全口令认证 为获得某种操作角色的操作权，认证其对应的口令 [in] hHandle 设备句柄 [in] pass
	 * 口令最长16字节，不够右补0x06 [in] role 被认证口令的角色范围[0x01-0x05] 返回值: 0成功,
	 * -2参数错误，其它见“API返回码说明”
	 */
	public native int SafePin(int hHandle, byte[] pass, int role);

	/**
	 *功能：产生随机数 参数 [in] hHandle 设备句柄 [in] len 需要获取的随机数长度 [out] Random 输出的随机数缓冲区
	 * 返回值：0成功，-2参数错误，其它见“API返回码说明”
	 */
	public native int GenRandom(int hHandle, int len, byte[] random);

	/**
	 *功能：取卡序列号 参数： [in] hHandle 设备句柄 [out] pDataOut
	 * 输出卡序号缓冲区，如果此值为NULL则可根据outLen取返回的数据长度 [out] outLen 输出数据长度
	 * 返回值：0成功，-2参数错误，其它见“API返回码说明”
	 */
	public native int GetCardID(int hHandle, byte[] pDataOut, int[] outLen);

	/**
	 *功能：验证并修改PIN口令 [in] hHandle 设备句柄 [in] oldpass 旧口令最长16字节 [in] newpass
	 * 新口令最长16字节 [in] role 被修改口令对应的角色 返回值：0成功，-2参数错误，其它见“API返回码说明”
	 */
	public native int SafeChangePin(int hHandle, byte[] oldpass,
			byte[] newpass, int role);

	/**
	 *功能：公钥运算 参数： [in] hHandle 设备句柄 [in] pDataIn 输入数据,数据长度为128字节 [out] pDataOut
	 * 输出数据,数据长度为128字节 [in] fid 公钥ID，二字节，第一个字节无效，第二个字节有效
	 * 返回值：0成功，-2参数错误，其它见“API返回码说明”
	 */
	public native int PubKeyCalculate(int hHandle, byte[] pDataIn,
			byte[] pDataOut, byte[] fid);

	/**
	 *功能：私钥运算 参数： [in] hHandle 设备句柄 [in] pDataIn 输入数据,数据长度为128字节 [out] pDataOut
	 * 输出数据,数据长度为128字节 [in] fid 私钥ID，二字节，第一个字节无效，第二个字节有效
	 * 返回值：0成功，-2参数错误，其它见“API返回码说明”
	 */
	public native int PriKeyCalculate(int hHandle, byte[] pDataIn,
			byte[] pDataOut, byte[] fid);

	/**
	 *功能：SHA1运算 参数： [in] hHandle 设备句柄 [in] pDataIn 被压缩的数据 [out] pDataOut
	 * 输出压缩数据的结果， 数据长度20字节 返回值：0成功，-2参数错误，其它见“API返回码说明”
	 */
	public native int SHA1Calculate(int hHandle, byte[] pDataIn, byte[] pDataOut);

	/**
	 *功能：SM1临时密钥 加/解密数据 参数： [in] hHandle 设备句柄 [in] tmpkey 临时密钥，16字节 [in]
	 * pDataIn 输入数据，数据长度为16整数倍 [in] flag 标识符 0x00 ECB解密 0x01 ECB加密 0x10 CBC解密
	 * 0x11 CBC加密 [out] pDataOut 输出数据 [in] pIV
	 * 采用EBC模式此参数无效，可置为NULL;CBC模式时为初始向量，16字节 返回值：0成功，-2参数错误，其它见“API返回码说明”
	 */
	public native int SM1KEY(int hHandle, byte[] tmpkey, byte[] pDataIn,
			int flag, byte[] pDataOut, byte[] pIV);

	/**
	 *功能：取证书 [in] hHandle 设备句柄 [out] certbuf 证书缓存区,如果此值为null则可根据outLen取返回的证书长度
	 * [out] outLen 证书长度 [in] certid 证书文件ID,二字节，第一个字节无效，第二个字节有效 返回值：0成功，
	 * -2参数错误，其它见“API返回码说明”
	 */
	public native int GetCert(int hHandle, byte[] certbuf, int[] outLen,
			byte[] certid);

	/**
	 *功能：导入密钥 参数： [in] hHandle 设备句柄 [in] type 导入密钥类型 [1加密密钥，2解密密钥] [in] pDataIn
	 * 密钥数据，长度为16字节 [in] kID 密钥标识范围 返回值：0成功，-2参数错误，其它见“API返回码说明”
	 */
	public native int ImportKey(int hHandle, int type, byte[] pDataIn, byte kID);

	/**
	 *功能：SM1卡内密钥 加/解密数据 参数： [in] hHandle 设备句柄 [in] pDataIn 输入数据，数据长度为16整数倍 [in]
	 * flag 标识符 0x00 ECB解密 0x01 ECB加密 0x10 CBC解密 0x11 CBC加密 [out] pDataOut 输出数据
	 * [in] kNo 密钥标识 [in] pIV 采用EBC模式此参数无效，可置为NULL;CBC模式时为初始向量，16字节
	 * 返回值：0成功，-2参数错误，其它见“API返回码说明”
	 */
	public native int SM1(int hHandle, byte[] pDataIn, int flag,
			byte[] pDataOut, byte kNo, byte[] pIV);

	/**
	 *功能：读二进制文件 参数： [in] hHandle 设备句柄 [in] fid 文件ID，2字节 [in] ReadPos 起始位置 [in]
	 * ReadLen 要读取的内容长度 [out] pDataOut 读取内容缓冲区 返回值：0成功，-2参数错误，其它见“API返回码说明”
	 */
	public native int ReadCardBinFile(int hHandle, byte[] fid, int readPos,
			int readLen, byte[] pDataOut);

	/**
	 *功能：写二进制文件 参数： [in] hHandle 设备句柄 [in] fid 文件ID，2字节 [in] writePos 起始位置 [in]
	 * writeLen 写入内容的长度 [in] pDataIn 写入内容 返回值：0成功，-2参数错误，其它见“API返回码说明”
	 */
	public native int WriteCardBinFile(int hHandle, byte[] fid, int writePos,
			int writeLen, byte[] pDataIn);

	/**
	 *功能：获取卡中证书信息 参数： [in] hHandle 设备句柄 [in] type 证书类型 0＝交换证书，1＝签名证书 [out]
	 * certCount 卡内该类证书数量 [out] ctnIdsBuf 证书所在容器的ID列表，一个ID2个字节依次排列
	 * 返回值：0成功，-2参数错误，其它见“API返回码说明”
	 */
	public native int GetCertInfo(int hHandle, byte type, int[] certCount,
			byte[] ctnIdsBuf);

	  
    /**
     * 获取指定ID证书中组织名称
     * 
     * @param hHandle    已经打开设备句柄
     * @param certID     证书ID,2个字节
     * @param orgName    返回证书组织名称，若为null，通过orgNameLen返回证书组织名称长度
     * @param orgNameLen 返回证书组织名称长度
     * @return 返回值为0表示成功，其他值表示失败
     */
    public native int GetCertOrgName(int hHandle, byte[] certID, byte[] orgName, int[] orgNameLen);
    
	/**
	**功能：取证书序列号
	*[in]   hHandle     设备句柄
	*[in]   certId      证书ID
	*[out]  sn     		sn缓存区,如果此值为NULL则可根据outLen取返回的sn长度
	*[out]  outLen      返回sn长度
	*返回值：0成功，其它见“API返回码说明”
	*/
	public native int  GetCertSN(int hHandle, byte[] certId, byte[] sn, int[] outLen);
	
	/**
	 *[in] certID 证书ID,2个字节 [out] cnBuf 证书CN缓存地址，如果cnBuf＝NULL，返回正确的cnLen [out]
	 * cnLen 证书CN长度
	 */
	public native int GetCertDN(int hHandle, byte[] certID, byte[] dnBuf,
			int[] dnLen);

	/**
	 *功能：获取证书中拥有者和颁发者 参数： [in] hHandle 设备句柄 [in] type 证书类型 0＝交换证书，1＝签名证书 [in]
	 * ctnId 证书所在容器的ID,2个字节 [out] cnBuf 证书CN缓存地址，如果cnBuf＝null，返回正确的cnLen [out]
	 * cnLen 证书CN长度 [out] issuerBuf 证书颁发者缓存地址，如果cnBuf＝null，返回正确的issuerLen [out]
	 * issuerLen 证书颁发者长度 返回值：0成功，-2参数错误，其它见“API返回码说明”
	 */
	public native int GetCertCNAndIssuer(int hHandle, byte type, byte[] ctnId,
			byte[] cnBuf, int[] cnLen, byte[] issuerBuf, int[] issuerLen);

	/**
	 *功能：获得证书ID 参数： [in] hHandle 设备句柄 [in] type IN 证书类型 0＝交换证书，1＝签名证书 [in]
	 * ctnId IN 证书所在容器的ID,2个字节 [out] idBuf 证书ID缓存地址，2个字节
	 * 返回值：0成功，-2参数错误，其它见“API返回码说明”
	 */
	public native int GetCertId(int hHandle, byte type, byte[] ctnId,
			byte[] idBuf);

	/**
	 *功能：获取证书公钥ID [in] hHandle 设备句柄 [in] type 证书类型 0＝交换证书，1＝签名证书 [in] ctnId
	 * 证书所在容器的ID,2个字节 [out] idBuf 公钥ID缓存地址，2个字节 返回值：0成功，-2参数错误，其它见“API返回码说明”
	 */
	public native int GetRSAPubKeyId(int hHandle, byte type, byte[] ctnId,
			byte[] idBuf);

	/**
	 *功能: 获取证书私钥ID 参数： [in] hHandle 设备句柄 [in] type 证书类型 0＝交换证书，1＝签名证书 [in]
	 * ctnId 证书所在容器的ID,2个字节 [out] idBuf 私钥ID缓存地址，2个字节
	 * 返回值：0成功，-2参数错误，其它见“API返回码说明”
	 */
	public native int GetRSAPriKeyId(int hHandle, byte type, byte[] ctnId,
			byte[] idBuf);

	public native int GetCertDetailInfo(int hHandle, byte[] certId, CertDetailInfo certInfo);
	
	/**
	 * 功能：获取当前TF卡库时间版本
	 * @return ：当前TF卡库时间版本
	 */
	public native String GetVersion();
	
	static {
		System.loadLibrary("safekey");
		System.loadLibrary("safetf");
	}

	/*
	public String getErrorMsg(int error) {
		String msg = "";
		switch (error) {
		case 0:
			return "成功";
		case -81:
		case -82:
		case -83:
		case -84:
		case -85:
		case -86:
		case -87:
		case -88:
		case -89:
			return "卡口令还有" +  -1 * (error + 80) + "数重试机会";
			
		case -1:
			return "未知错误";
		case -2:
			return "参数错误";
		case -10:
			return "数据错误";
		case -11:
			return "应用锁定";
		case -12:
			return "文件不存在";
		case -13:
			return "命令不存在";
		case -14:
			return "文件空间不足";
		case -15:
			return "未取随机数";
		case -16:
			return "文件已存在";
		case -17:
			return "文件内容错误";
		case -18:
			return "错误状态";
		case -19:
			return "卡锁定";

		case -21:
			return "命令与内容不符";
		case -22:
			return "权限不够";
		case -23:
			return "密钥死锁";

		case -32:
			return "MAC错误";
		case -33:
			return "密钥不存在";
		case -34:
			return "密钥类型错";
		case -35:
			return "密钥文件不存在";

		case -100:
			return "未找到卡";
		case -101:
			return "未找到安全TF卡";
		case -102:
			return "读卡标识失败";
		case -103:
			return "指定盘不存在";

		case -200:
			return "发送命令失败";
		case -201:
			return "接收命令失败";
		case -202:
			return "分配内存失败";
		case -203:
			return "响应信息解码失败";
		case -204:
			return "返回错误长度";
		case -205:
			return "缓冲区长度不够";
		case -206:
			return "接收命令超时";

		case -300:
			return "调用者传入参数错误";
		case -400:
			return "卡复位错误";
		case -500:
			return "导入导出公钥错误";
		case -501:
			return "导入私钥错误";

		case -550:
			return "当前容器已经被使用";
		case -551:
			return "当前容器未使用";
		case -552:
			return "超过最大容器个数";

		case -600:
			return "读写卡内文件错误";

		case -800:
			return "事务标识创建失败";
		case -801:
			return "事务标识检测超时";

		case -900:
			return "输入缓冲区错误";
		case -901:
			return "口令错误，重试次数为零";
		}
		return msg;
	}
	*/
	
	public String getErrorMsg(Context context, int error) {
		return SafeTFError.getErrorInfo(context, error);
	}
}
