package com.xdja.emm.framework.binder.param;

import android.os.Parcel;
import android.os.Parcelable;


public class ApnInfo implements Parcelable{

    private int id;
    private String name;    //apn中文描述
    private String apn;     //apn名称 唯一域名
    private String type = "default,supl";
    private String numeric;
    private String mcc;     //not null
    private String mnc;     //not null
    private String proxy = "";
    private String port = "";
    private String mmsproxy = "";
    private String mmsport = "";
    private String user = "";
    private String server = "";
    private String password = "";
    private String mmsc = "";
    

	@Override
	public int describeContents() {
		return 0;
	}

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeInt(id);
		dest.writeString(name);
		dest.writeString(apn);
		dest.writeString(type);
		dest.writeString(numeric);
		dest.writeString(mcc);
		dest.writeString(mnc);
		dest.writeString(proxy);
		dest.writeString(port);
		dest.writeString(mmsproxy);
		dest.writeString(mmsport);
		dest.writeString(user);
		dest.writeString(server);
		dest.writeString(password);
		dest.writeString(mmsc);
	}
	
	public static final Creator<ApnInfo> CREATOR = new Creator<ApnInfo>() {

		@Override
		public ApnInfo createFromParcel(Parcel source) {
			return new ApnInfo(source);
		}

		@Override
		public ApnInfo[] newArray(int size) {
			return new ApnInfo[size];
		}
		
	};

    public ApnInfo(){
    	
    }
    
    public ApnInfo(Parcel parcel){
    	id = parcel.readInt();
    	name = parcel.readString();
    	apn = parcel.readString();
    	type = parcel.readString();
    	numeric = parcel.readString();
    	mcc = parcel.readString();
    	mnc = parcel.readString();
    	proxy = parcel.readString();
    	port = parcel.readString();
    	mmsproxy = parcel.readString();
    	mmsport = parcel.readString();
    	user = parcel.readString();
    	server = parcel.readString();
    	password = parcel.readString();
    	mmsc = parcel.readString();
    }
    
    public ApnInfo(int id,String name,String apn){
    	this.id = id;
        this.name = name;
        this.apn = apn;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getMcc() {
        return mcc;
    }

    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public String getApn() {
        return apn;
    }

    public void setApn(String apn) {
        this.apn = apn;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getMmsc() {
        return mmsc;
    }

    public void setMmsc(String mmsc) {
        this.mmsc = mmsc;
    }

    public String getMmsport() {
        return mmsport;
    }

    public void setMmsport(String mmsport) {
        this.mmsport = mmsport;
    }

    public String getMmsproxy() {
        return mmsproxy;
    }

    public void setMmsproxy(String mmsproxy) {
        this.mmsproxy = mmsproxy;
    }

    public String getMnc() {
        return mnc;
    }

    public void setMnc(String mnc) {
        this.mnc = mnc;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumeric() {
        return numeric;
    }

    public void setNumeric(String numeric) {
        this.numeric = numeric;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPort() {
        return port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getProxy() {
        return proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public String getServer() {
        return server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }


}
