package com.xdja.safeclient;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityManager.RunningServiceInfo;
import android.app.AlarmManager;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.os.Build;
import android.os.Build.VERSION;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.PowerManager;
import android.os.PowerManager.WakeLock;
import android.os.StatFs;
import android.support.annotation.NonNull;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

import com.safetf.SafeTF;
import com.xdja.key.KeyDevInfo;
import com.xdja.key.KeySelector;
import com.xdja.key.KeyWrapper;
import com.xdja.key.covercard.CoverCardWrapper;
import com.xdja.key.longmai.LongmaiCfg;
import com.xdja.key.xdjakey.XdjaKeyCfg;
import com.xdja.key.zhongfu.ZhongfuCfg;
import com.xdja.safeclient.config.PropertiesConfig;
import com.xdja.safeclient.event.TelnetResultCallback;
import com.xdja.safeclient.ui.AlertUtil;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.Log;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.safeclient.activity.SafeVerifyActivity;
import com.xdja.safeclient.receiver.bootBroadcastReceiver;
import com.xdja.safeclient.utils.LogUtil;
import com.xdja.safeclient.wrapper.QuitWrapper;
import com.xdja.sslvpn.CONSTANT;

import org.apache.commons.net.telnet.TelnetClient;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import static com.xdja.safeclient.utils.StringUtil.getStringRes;

public class Function {

    private static PowerManager pm = null;
    private static WakeLock mWakeLock = null;
    private static String TAG = "Function";

    /**
     * 退出
     */
    public static void exitApp(Context context) {


        QuitWrapper.setHasBeenQuit(context);
        //清理通知栏通知
        NotificationManager  notificationManager = (NotificationManager)context.getSystemService(Context.NOTIFICATION_SERVICE);
        notificationManager.cancel(1);

        MyApplication myApplication = MyApplication.myApplication;

        SafeVerifyActivity.startService = false;
        MyApplication.selfStartFlag = false;

        //转发模式
//        if (myApplication.sslClientConfig.transportMode == 0
//                || myApplication.havingRootPermission == true) {
        if (myApplication.sslClientConfig.transportMode == 0)
        {
            Function.setSafeVpnState(context.getApplicationContext(), false);
            VpnService.stopService = true;

            VpnService.sslStageList.clear();
            //停止服务
            Intent intent = new Intent();
            intent.setClassName(MyApplication.packageName, "com.xdja.safeclient.VpnService");
            context.stopService(intent);
        } else {
            Function.setSafeTunVpnState(context.getApplicationContext(), false);
            TunVpnService.stopService = true;

            TunVpnService.sslStageList.clear();

            //停止服务
            try {
                boolean res = false;
                try {
                    if (TunVpnService.mInterface != null) {
                        Log.d("MainActivity", "TunVpnService.mInterface.close");
                        TunVpnService.mInterface.close();
                        TunVpnService.mInterface = null;
                        if (TunVpnService.tunVpnObj != null) {
                            TunVpnService.tunVpnObj.destroyBuilder();
                        }
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }

                if (myApplication.sslvpn != null) {
                    myApplication.sslvpn.closeTunFd();
                }

                Intent intent = new Intent();
                intent.setClassName(MyApplication.packageName, "com.xdja.safeclient.TunVpnService");
                res = context.stopService(intent);

                if (res == false) {
                    Log.e(TAG, "stopService TunVpnService failed");
                } else {
                    Log.d(TAG, "stopService TunVpnService success ");
                }
            } catch (SecurityException e) {
                e.printStackTrace();
            }
        }

        for (Activity activity : myApplication.activityList) {
            activity.finish();
        }

        myApplication.activityList.clear();

        if (myApplication.propertiesConfig.getmDisableFlag() == 1) {
            myApplication.disableFlag = 0;
        }


        if (myApplication.propertiesConfig.hasCoverKey() == 1) {
            CoverCardWrapper.getInstance().destroy();
        }

        MyApplication.myApplication.getHandler().postDelayed(new Runnable() {
            @Override
            public void run() {
                System.exit(0);
            }
        },500);
    }

    /**
     * 写私有目录文件
     *
     * @param filename 文件名
     * @param text     文件内容
     * @return
     */
    public static void writePrivateFile(Context context, String filename, String text) {
        OutputStream os = null;
        OutputStreamWriter osw = null;
        try {
            os = context.openFileOutput(filename, Context.MODE_PRIVATE);
            osw = new OutputStreamWriter(os);
            osw.write(text);
            osw.close();
            os.close();
        } catch (Exception e) {
            return;
        } finally {
            if (os != null) {
                try {
                    os.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (osw != null) {
                try {
                    osw.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }


    public static int writeFile(String filePath, String text) {
        File file = new File(filePath);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(new FileOutputStream(file));
            osw.write(text);

        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (osw!=null) {
                try {
                    osw.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        return 0;
    }

    public static int readFile(String filePath, byte[] output, int[] len) {
        File file = new File(filePath);
        byte[] tmp = new byte[10];
        InputStream in = null;
        int size;
        int byteread = 0;
        try {
            in = new FileInputStream(file);
            while((size = in.read(tmp)) != -1) {
                System.arraycopy(tmp, 0, output, byteread, size);
                byteread += size;
            }

        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                in.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        len[0] = byteread;
        return 0;


    }
    /**
     * 复制assets目录下的文件到其他目录
     * @param context
     * @param destFilePath
     * @param filename
     */
    public static void copyAssets(Context context, String destFilePath, String filename) {
        InputStream in = null;
        FileOutputStream out = null;
        byte[] data = new byte[2048];
        int byteCount = 0;
        try {
            in = context.getResources().getAssets().open(filename);
            out = context.openFileOutput(filename, Context.MODE_PRIVATE);

            FileOutputStream fos = new FileOutputStream(new File(destFilePath));

            while ((byteCount = in.read(data)) != -1) {// 循环从输入流读取
                // buffer字节
                fos.write(data, 0, byteCount);// 将读取的输入流写入到输出流
            }
            fos.flush();// 刷新缓冲区
            in.close();
            fos.close();

        } catch (IOException e) {
        } finally {
            try {
                if (in != null)
                    in.close();
                if (out != null)
                    out.close();
            } catch (IOException e) {
            }
        }
    }

    /*
     * 移动配置文件ca.cer和config.xml到私有空间
     */
    public static void moveFile(Context context, String filename) {
        InputStream in = null;
        FileOutputStream out = null;
        byte[] data = new byte[2048];
        int datalen = 0;
        try {
            in = (InputStream) context.getResources().getAssets().open(filename);
            out = context.openFileOutput(filename, Context.MODE_PRIVATE);
            while ((datalen = in.read(data)) != -1) {
                out.write(data, 0, datalen);
            }
        } catch (IOException e) {
        } finally {
            try {
                if (in != null)
                    in.close();
                if (out != null)
                    out.close();
            } catch (IOException e) {
            }
        }
    }

    /*
     * 将进制字符串还原为进制数组
     *
     * @param str 16进制字符串，长度要是进制数组的倍
     *
     * @param digest 16进制数组
     *
     * @param digestlength 16进制数组长度
     */
    public static void Hex_Decode(byte[] str, byte[] digest, int digestlength) {
        int i = 0;
        int tmp = 0;
        for (i = 0; i < digestlength; i++) {
            if (str[i * 2] >= 'a') {
                tmp = str[i * 2] - 0x57;
            } else {
                tmp = str[i * 2] - '0';
            }

            tmp *= 16;
            if (str[i * 2 + 1] >= 'a') {
                tmp += str[i * 2 + 1] - 0x57;
            } else {
                tmp += str[i * 2 + 1] - '0';
            }

            digest[i] = (byte) (tmp & 0xFF);
        }
        return;
    }

    public static String byte2hex(byte [] buffer, int start, int length){
        String h = "";
        int end = start + length;
        for(int i = start; i < end; i++){
            String temp = Integer.toHexString(buffer[i] & 0xFF);
            if(temp.length() == 1){
                temp = "0" + temp;
            }
            h = h + " "+ temp;
        }

        return h;
    }


    public static String byte2hex(byte [] buffer, int length){
        String h = "";
        for(int i = 0; i < length; i++){
            String temp = Integer.toHexString(buffer[i] & 0xFF);
            if(temp.length() == 1){
                temp = "0" + temp;
            }
            h = h + " "+ temp;
        }

        return h;
    }


    public static String byte2hex(byte [] buffer){
        String h = "";
        for(int i = 0; i < buffer.length; i++){
            String temp = Integer.toHexString(buffer[i] & 0xFF);
            if(temp.length() == 1){
                temp = "0" + temp;
            }
            h = h + " "+ temp;
        }

        return h;
    }

    public static boolean getRootAhth() {
        float ver = Float.parseFloat(android.os.Build.VERSION.RELEASE);
        if (ver > 4.4)
        {
            return  false;
        }
        Process process = null;
        DataOutputStream os = null;
        try {
            process = Runtime.getRuntime().exec("su");
            if (process == null) {
                return false;
            }
            os = new DataOutputStream(process.getOutputStream());
            os.writeBytes("exit\n");
            os.flush();
            int exitValue = process.waitFor();
            if (exitValue == 0) {
                Log.d("Function", "have root promission");
                return true;
            } else {
                Log.d("Function", "not have root promission");
                return false;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        } finally {
            try {
                if (os != null) {
                    os.close();
                    os = null;
                }
                if (process != null) {
                    process.destroy();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 获得SD卡总大小
     *
     * @return
     */
    public static double getSDTotalSize(Context context) {

        String mountPath = getTFMountPath(context);

        //芯片或者没有安全卡,跳过此检查
        if (mountPath == null || mountPath.equals("")) {
            return 128;
        }

        //File path = Environment.getExternalStorageDirectory(); 

        File path = new File(mountPath);

        Log.i("Function", "tf card path : " + path.getAbsolutePath());

        StatFs stat = new StatFs(path.getPath());

        long blockSize = stat.getBlockSize();

        Log.i("Function", "tf card blockSize : " + blockSize);

        long totalBlocks = stat.getBlockCount();

        Log.i("Function", "tf card totalBlocks : " + totalBlocks);

        Log.i("Function", "tf card totalSize : " + ((double) (blockSize * totalBlocks)) / (1024 * 1024 * 1024) + " G");

        return ((double) (blockSize * totalBlocks)) / (1024 * 1024 * 1024);
    }

    /**
     * SD卡总大小是否大于4G
     *
     * @return
     */
    public static boolean isSDTotalSizeBigThan4G(double sdTotalSize) {
        Log.i("Function", "isSDTotalSizeBigThan4G, sdTotalSize : " + sdTotalSize + " G");
        return sdTotalSize > 4;
    }

    /**
     * 根据包名查找应用在sdcard卡(包含外置卡和内置卡)上私有目录
     *
     * @param packageName 应用包名
     * @return
     */
    public static ArrayList<String> findSdcardPrivatePath(String packageName) {
        ArrayList<String> devList = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new FileReader("/proc/mounts"));

            String line = "";
            String privatePath = "";
            while ((line = br.readLine()) != null) {
                String columns[] = line.split(" ");
                if (columns != null && columns.length > 3) {
                    privatePath = columns[1] + "/Android/data/" + packageName + "/files";
                    File file = new File(privatePath);
                    if (file.exists()) {
                        devList.add(privatePath);
                    }
                }
            }
            br.close();
        } catch (IOException e) {
            e.printStackTrace();
        }

        return devList;
    }

    public static String getTFMountPath(Context context) {
        JNIAPI safekey = new JNIAPI();

        int[] devNum = new int[1];
        long[] devHandle = new long[1];

        byte[] mountPath = new byte[256];
        int[] pathLen = new int[1];

        String path;

        int ANDROID_4_4_2 = 19;

        int ret = -1;

        if (MyApplication.devOpenFlag == 0
                || MyApplication.devOpenFlag == MyApplication.OPEN_DEV_AUTO) {
            //枚举安全设备列表
            ret = safekey.EnumDev(JNIAPI.CT_ALL, devNum);//枚举安全设备列表
            if (ret != 0) {
                Log.e("Function", "EnumDev failed, ret = " + ret);
                return "";
            } else {
                Log.d("Function", "EnumDev sucess, devNum = " + devNum[0]);
            }

            //打开第一个设备
            ret = safekey.OpenDev(0, devHandle);//打开第一个设备
            if (ret != 0) {
                return "";
            }

            if (ret == 0) {
                Log.d("Function", "openDevAuto,success");
                MyApplication.devOpenFlag = MyApplication.OPEN_DEV_AUTO;
            }
        }

        if (MyApplication.devOpenFlag == 0
                || MyApplication.devOpenFlag == MyApplication.OPEN_DEV_BY_PATH) {
            if (ret != 0) {
                if (VERSION.SDK_INT >= ANDROID_4_4_2) {

                    context.getExternalFilesDir(null);//创建sdcard卡上应用对应私有目录
                    ArrayList<String> sdcardPrivatePathList = findSdcardPrivatePath(context.getPackageName());
                    int listCount = sdcardPrivatePathList.size();
                    for (int i = 0; i < listCount; i++) {
                        String sdcardPrivatePath = sdcardPrivatePathList.get(i) + "/";
                        ret = safekey.OpenDevByName(sdcardPrivatePath.getBytes(), devHandle);
                        if (0 == ret) {
                            MyApplication.devOpenFlag = MyApplication.OPEN_DEV_BY_PATH;
                            break;
                        }
                    }
                    Log.d("Function", "openDevByName, ret = " + ret);
                }
            }
        }

        if (ret != 0) {
            MyApplication.devOpenFlag = 0;
            return "";
        }

        safekey.GetTFMountPath(devHandle[0], mountPath, pathLen);

        path = new String(mountPath, 0, pathLen[0]);

        Log.i("Function", "mountPath : " + path);

        return path;
    }

    public static void getWakeLock() {
        if (mWakeLock == null) {
            pm = (PowerManager) MyApplication.myApplication.getSystemService(Context.POWER_SERVICE);
            mWakeLock = pm.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK, "XDJA");
        }
        Log.d("Function", "mWakeLock.acquire");
        mWakeLock.acquire();

        // 设置周期唤醒CPU Alarm
        Function.invokeWakeupAlarm(MyApplication.myApplication, 10);
    }

    public static void releaseWakeLock() {
        Log.d("Function", "mWakeLock.release");
        if (mWakeLock != null) {
            mWakeLock.release();
            mWakeLock = null;
        }

        Function.cancleWakeupAlarm(MyApplication.myApplication);
    }

    public static void invokeWakeupAlarm(Context context, long cycleSecond) {

        Log.d("Function", "invokeWakeupAlarm, time = " + (int) cycleSecond);

        Intent intent = new Intent(context, bootBroadcastReceiver.class);

        intent.setAction(CONSTANT.ALARM_WAKEUP_ACTION);

        PendingIntent sender = PendingIntent.getBroadcast(context, 0, intent, 0);

        AlarmManager am = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);

        am.setRepeating(AlarmManager.RTC_WAKEUP, System.currentTimeMillis(), cycleSecond * 1000, sender);

    }

    public static void cancleWakeupAlarm(Context context) {
        Log.d("Function", "cancleWakeupAlarm");

        Intent intent = new Intent(context, bootBroadcastReceiver.class);

        intent.setAction(CONSTANT.ALARM_WAKEUP_ACTION);

        PendingIntent sender = PendingIntent.getBroadcast(context, 0, intent, 0);

        AlarmManager alarm = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);

        alarm.cancel(sender);

    }


    /**
     * @return 用户手机运营商名称
     */

    public static String getProvidersName(Context context) {

        String ProvidersName = null;

        TelephonyManager telephonyManager = (TelephonyManager) context
                .getSystemService(Context.TELEPHONY_SERVICE);

        String IMSI; // 返回唯一的用户ID;就是这张卡的编号神马的

        IMSI = telephonyManager.getSubscriberId();

        if (IMSI == null)
            return "unkwon";

        // IMSI号前面3位460是国家，紧接着后面2位00 02 07是中国移动，01是中国联通，03 05是中国电信。其中

        //这个地方不做国际化处理，因为SSLVPN中底层回调会判断这些字符串
        //但是没有context对象，无法从string.xml中获取值
        if (IMSI.startsWith("46000") || IMSI.startsWith("46002") || IMSI.startsWith("46007")) {
            ProvidersName = "中国移动";
        } else if (IMSI.startsWith("46001")) {
            ProvidersName = "中国联通";
        } else if (IMSI.startsWith("46003") || IMSI.startsWith("46005")) {
            ProvidersName = "中国电信";
        } else {
            ProvidersName = "中国移动";
        }

        return ProvidersName;
    }

    /*
     * 根据包名判断应用是否已经安装（理论上，比旧版本，更高效。）。
     *
     * @param context
     *            上下文
     * @param packageName
     *            包名
     * @return 如果应用已经安装，则返回true，否则返回false.
   */
    public static boolean isPackageExist_v2(Context context, String packageName) {
        try {
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(packageName, PackageManager.GET_UNINSTALLED_PACKAGES);
            return true;
        } catch (NameNotFoundException e) {
            return false;
        }
    }

    public static boolean checkHitomservice(Context context) {
        MyApplication myApplication = MyApplication.myApplication;
        if (myApplication.propertiesConfig.getCheckhitomservice() == 1) {

            boolean ret = Function.isPackageExist_v2(context, "com.hitom.hitomservice");

            Log.d("Function", "isPackageExist_v2 ret = " + ret);

            if (ret == false) {
                return false;
            } else {
                return true;
            }
        }

        return true;
    }

    public static void setSafeVpnState(Context context, boolean state) {
        SharedPreferences sp = context.getSharedPreferences("status", Context.MODE_PRIVATE);
        Editor editor = sp.edit();
        editor.putBoolean("VpnState", state);
        editor.commit();
    }

    public static boolean getSafeVpnState(Context context) {
        SharedPreferences sp = context.getSharedPreferences("status", Context.MODE_PRIVATE);
        return sp.getBoolean("VpnState", false);
    }

    public static void setSafeTunVpnState(Context context, boolean state) {
        SharedPreferences sp = context.getSharedPreferences("status", Context.MODE_PRIVATE);
        Editor editor = sp.edit();
        editor.putBoolean("TunVpnState", state);
        editor.commit();
    }

    public static boolean getSafeTunVpnState(Context context) {
        SharedPreferences sp = context.getSharedPreferences("status", Context.MODE_PRIVATE);
        return sp.getBoolean("TunVpnState", false);
    }

    /**
     * 判断某个服务是否正在运行的方法
     *
     * @param mContext
     * @param serviceName 是包名+服务的类名（例如：net.loonggg.testbackstage.TestService）
     * @return true代表正在运行，false代表服务没有正在运行
     */
    public static boolean isServiceWork(Context mContext, String serviceName) {
        boolean isWork = false;
        ActivityManager am = (ActivityManager) mContext
                .getSystemService(Context.ACTIVITY_SERVICE);
        List<RunningServiceInfo> myList = am.getRunningServices(100);
        if (myList.size() <= 0) {
            return false;
        }
        for (int i = 0; i < myList.size(); i++) {
            String mName = myList.get(i).service.getClassName().toString();
            if (mName.equals(serviceName)) {
                isWork = true;
                break;
            }
        }
        return isWork;
    }


    public static void stopOtherSafeClient(Context context) {
        //停止隧道安全客户端
        Intent itt = new Intent();
        itt.setAction("com.xdja.safeclient.tun.video.action.STOP_SERVICE");
        context.sendBroadcast(itt);
    }

    public static void startVpnActivity(Context context) {
        ComponentName componetName = new ComponentName(
                // 这个是另外一个应用程序的包名
                MyApplication.packageName,
                // 这个参数是要启动的Activity
                "com.xdja.safeclient.StartVpnActivity");

        try {
            Intent intt = new Intent();
            intt.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            intt.setComponent(componetName);
            context.startActivity(intt);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // add by zhaoxiaolong 20160707 4号和6号容器为0x11,其他的为0x01
    public static int generateRole(byte[] certId) {
        int role = 0x00;

        byte[][] especialCert = {{0x00, 0x45}, {0x00, 0x48}, {0x00, 0x53}, {0x00, 0x56}};

        if (certId.length != 2) {
            return 0x01;
        }

        // 查找是否是4号或者6号的证书
        for (int i = 0; i < especialCert.length; i++) {
            if (Arrays.equals(certId, especialCert[i])) {
                role = 0x11;
                break;
            }
        }

        // 除了4号和6号外，警务项目其他容器使用0x01角色
        if (role == 0x00) {
            role = 0x01;
        }

        Log.d(TAG, "gererate role: 0x" + Integer.toHexString(role));

        return role;
    }

    public static String getIP() {
        try {
            for (Enumeration<NetworkInterface> en = NetworkInterface
                    .getNetworkInterfaces(); en.hasMoreElements(); ) {
                NetworkInterface intf = en.nextElement();
                for (Enumeration<InetAddress> enumIpAddr = intf
                        .getInetAddresses(); enumIpAddr.hasMoreElements(); ) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (!inetAddress.isLoopbackAddress() && !inetAddress.isLinkLocalAddress()) {
                        return inetAddress.getHostAddress();
                    }
                }
            }
        } catch (SocketException ex) {
            Log.e("WifiPreferenceIpAddress", "error", ex);
        }


        return "";
    }

    public static boolean isMainThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }


    public static boolean isBackground(Context context) {

        ActivityManager activityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningAppProcessInfo> appProcesses = activityManager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (appProcess.processName.equals(context.getPackageName())) {
                if (appProcess.importance == ActivityManager.RunningAppProcessInfo.IMPORTANCE_BACKGROUND) {
                    Log.i("后台", appProcess.processName);
                    return true;
                }else{
                    Log.i("前台", appProcess.processName);
                    return false;
                }
            }
        }
        return false;
    }

    /**
     * 停止安全客户端
     * @param context
     */
    public static void stopVPN(Context context) {
        String packageName = context.getPackageName();
        if (packageName.equals(CONSTANT.COMMON_CLIENT_PACKAGE_NAME)) {
            context.sendBroadcast(new Intent(CONSTANT.STOP_COMMON_CLIENT_ACTION));
        } else if (packageName.equals(CONSTANT.VIDEO_CLIENT_PACKAGE_NAME)) {
            context.sendBroadcast(new Intent(CONSTANT.STOP_VIDEO_CLIENT_ACTION));
        }
    }


    /**
     * 初始化卡模块
     */
    public static void initKeyModule(boolean reinit) {
        int keyFlag = 0;

        int state = KeyWrapper.getInstance().getState();

        if (state != KeyWrapper.State.NULL && !reinit) {
            Log.e(TAG, "Key module already inited.");
            return;
        }
        MyApplication myApplication = MyApplication.myApplication;

        PropertiesConfig propertiesConfig = myApplication.propertiesConfig;

        if (propertiesConfig.hasCoverKey() == 1) {

            // 由于初始化检测比较慢，此处需要优化为：如果公司卡存在，则不去检测贴膜卡是否存在。 add by xjq, 2017-11-20 10:28:38
            if ((propertiesConfig.hasXdjaKey() == 1 && (!TextUtils.isEmpty(MyApplication.myApplication.getDevPath()) ||
                    (Function.hasXdjaChip() && !Compatibility.disableXdjaChip())))
                    && (MyApplication.myApplication.propertiesConfig.forceDectectCoverCard() == 0)) // 看是否配置强制检测贴膜卡
            {
                Log.e(TAG, "Has avalibale xdja key, do not need to check cover card.");
            } else {
                Log.e(TAG, "add cover key flag");
                Log.e(TAG, "Need to check cover card.");
                keyFlag |= KeyWrapper.COVER_KEY;
            }
        }

        if (propertiesConfig.hasXdjaKey() == 1) {
            Log.e(TAG, "add xdja key flag ");
            keyFlag |= KeyWrapper.XDJA_KEY;
        }

        if (propertiesConfig.hasChipManager() == 1) {
            Log.e(TAG, "add chip manager flag");
            keyFlag |= KeyWrapper.CHIP_MANAGER_KEY;
        }

        if (propertiesConfig.hasProviderKey() == 1) {
            Log.d(TAG, "add provider key flag");
            keyFlag |= KeyWrapper.CONTENT_PROVIDER_KEY;
        }

        if (propertiesConfig.hasLongmaiKey() == 1) {
            Log.d(TAG, "add longmai key flag");
            keyFlag |= KeyWrapper.LONGMAI_KEY;
        }

        if (propertiesConfig.hasKoalKey() == 1) {
            Log.d(TAG, "add koal key flag");
            keyFlag |= KeyWrapper.KOAL_KEY;
        }

        Log.d(TAG, "Current key flag " + keyFlag);
        if ((keyFlag & KeyWrapper.XDJA_KEY) == KeyWrapper.XDJA_KEY ||
                (keyFlag & KeyWrapper.COVER_KEY) == KeyWrapper.COVER_KEY ||
                (keyFlag & KeyWrapper.CHIP_MANAGER_KEY) == KeyWrapper.CHIP_MANAGER_KEY) {
            XdjaKeyCfg xdjaKeyCfg = new XdjaKeyCfg();

            String currentPath = "";
            if (myApplication.sslClientConfig.devPath != null)
                currentPath = new String(myApplication.sslClientConfig.devPath);

            if (TextUtils.isEmpty(currentPath)) {
                String path = "";
                if ((keyFlag & KeyWrapper.XDJA_KEY) == KeyWrapper.XDJA_KEY) {
                    path = myApplication.getDevPath();
                }
                Log.d(TAG, "Xdja dev path " + path);
                xdjaKeyCfg.setDevPath(path);
            } else {
                xdjaKeyCfg.setDevPath(new String(myApplication.sslClientConfig.devPath));
            }

            xdjaKeyCfg.setSignCertId(myApplication.sslClientConfig.certId);
            xdjaKeyCfg.setRole(Function.generateRole(myApplication.sslClientConfig.certId));
            xdjaKeyCfg.setSignPubkeyId(myApplication.sslClientConfig.pubkeyId);
            xdjaKeyCfg.setSignPrikeyId(myApplication.sslClientConfig.prikeyId);

            KeyWrapper.getInstance().configXdjaKey(xdjaKeyCfg);
        }

        if ((keyFlag & KeyWrapper.ZHONGFU_KEY) == KeyWrapper.ZHONGFU_KEY) {
            ZhongfuCfg zhongfuCfg = new ZhongfuCfg();
            zhongfuCfg.setDevMac("61:11:08:09:62:25");
            zhongfuCfg.setAppName("RSA-Application");
            zhongfuCfg.setContainerName("xdja");
            KeyWrapper.getInstance().configZhongfuKey(zhongfuCfg);
        }

        if ((keyFlag & KeyWrapper.LONGMAI_KEY) == KeyWrapper.LONGMAI_KEY) {
            LongmaiCfg longmaiCfg = new LongmaiCfg();
            KeyWrapper.getInstance().configLongmaiKey(longmaiCfg);
        }

        Log.e(TAG, "Start to call init device auto");
        KeyWrapper.getInstance().initDviceAuto(keyFlag, new KeySelector() {
            @Override
            public int select(ArrayList<KeyDevInfo> keyDevInfoArrayList) {
                int size = keyDevInfoArrayList.size();
                int xdjaChipIndex = -1;
                int xdjaTFIndex = -1;
                int coverKeyIndex = -1;
                int providerKeyIndex = -1;
                int longmaiKeyIndex = -1;
                int koalKeyIndex = -1;

                for (int i = 0; i < size; i++) {
                    KeyDevInfo keyDevInfo = keyDevInfoArrayList.get(i);
                    if (keyDevInfo.getDriver().equals(KeyWrapper.CHIP_MANAGER_DRIVER_NAME)) {
                        if (keyDevInfo.getType() == KeyWrapper.KEY_TYPE_CHIP) {
                            xdjaChipIndex = i;
                        }
                        if (keyDevInfo.getType() == KeyWrapper.KEY_TYPE_TF) {
                            xdjaTFIndex = i;
                        }
                        if (keyDevInfo.getType() == KeyWrapper.KEY_TYPE_SIM) {
                            coverKeyIndex = i;
                        }
                    } else if (keyDevInfo.getDriver().equals(KeyWrapper.XDJA_KEY_DRIVER_NAME)) {
                        if (keyDevInfo.getType() == KeyWrapper.KEY_TYPE_CHIP) {
                            xdjaChipIndex = i;
                        }
                        if (keyDevInfo.getType() == KeyWrapper.KEY_TYPE_TF) {
                            xdjaTFIndex = i;
                        }
                    } else if (keyDevInfo.getDriver().equals(KeyWrapper.COVER_KEY_DRIVER_NAME)) {
                        coverKeyIndex = i;
                    } else if (keyDevInfo.getDriver().equals(KeyWrapper.PROVIDER_DRIVER_NAME)) {
                        providerKeyIndex = i;
                    } else if (keyDevInfo.getDriver().equals(KeyWrapper.LONGMAI_DRIVER_NAME)) {
                        longmaiKeyIndex = i;
                    } else if (keyDevInfo.getDriver().equals(KeyWrapper.KOAL_DRIVER_NAME)) {
                        koalKeyIndex = i;
                    }
                }

                if (koalKeyIndex != -1) {
                    return koalKeyIndex;
                }

                if (longmaiKeyIndex != -1) {
                    return longmaiKeyIndex;
                }

                if (coverKeyIndex != -1) {
                    return coverKeyIndex;
                }

                if (xdjaTFIndex != -1) {
                    return xdjaTFIndex;
                }

                if (xdjaChipIndex != -1 && !Compatibility.disableXdjaChip()) {
                    return xdjaChipIndex;
                }



                if (providerKeyIndex != -1) {
                    return providerKeyIndex;
                }

                return -1;
            }
        });
    }

    /**
     * 获取当前连接状态（转发 && 隧道）
     *
     * @return true 连接建立 false 连接失败
     */
    public static boolean isVPNConnected() {
        MyApplication application = MyApplication.myApplication;

        if (application != null &&
                application.sslClientConfig != null) {
//            if ((application.sslClientConfig.transportMode == 0) || // 转发模式
//                    application.havingRootPermission) // 有root权限？
            if ((application.sslClientConfig.transportMode == 0))
            {
                return VpnService.safeVerifySuccess; // 转发模式的状态
            } else {
                return TunVpnService.safeVerifySuccess; // 隧道模式状态
            }
        } else {
            return false;
        }

    }

    public static boolean hasXdjaChip() {
        SafeTF tf = new SafeTF();
        int handle = tf.OpenSTFCardAuto();

        if (handle != 0) {
            return true;
        }

        return false;
    }


    /**
     * telnet远程主机
     * @param ip
     * @param port
     * @param trc
     */
    public static void telnet(final String ip, final int port, final int timeout, final TelnetResultCallback trc) {
        new Thread(new Runnable() {
            @Override
            public void run() {
                TelnetClient tc = new TelnetClient();

                try {
                    tc.setConnectTimeout(timeout);
                    tc.connect(ip, port);
                    trc.onSuccess(); // telnet success
                } catch (SocketTimeoutException e) {
                    e.printStackTrace();
                    trc.onTimeout();
                } catch (IOException e) {
                    e.printStackTrace();
                    trc.onError(-1);
                }

                try {
                    tc.disconnect();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();

    }

    public static void runOnMainThread(Runnable r) {
        MyApplication.myApplication.getHandler().post(r);
    }

    public static void startChipManagerActivity(@NonNull Context context) {

        Intent intent = new Intent();
        intent.setClassName("com.xdja.safekeyservice", "com.xdja.scservice.presenter.activity.SplashScreenPresener");
        intent.setPackage("com.xdja.safekeyservice");

        if (!(context instanceof Activity)) {
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }
        context.startActivity(intent);
    }
}