package com.xdja.safeclient;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Build.VERSION;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.telephony.TelephonyManager;
import android.widget.Toast;

import com.orhanobut.logger.LogLevel;
import com.orhanobut.logger.Logger;
import com.safetf.SafeTF;
import com.squareup.otto.Subscribe;
import com.xdja.safeclient.bean.SafeVerifyStageInfo;
import com.xdja.safeclient.bean.UpgradeVersionInfo;
import com.xdja.safeclient.config.PropertiesConfig;
import com.xdja.safeclient.config.SslClientConfig;
import com.xdja.safeclient.config.UpgradeConfig;
import com.xdja.safeclient.event.EventManager;
import com.xdja.safeclient.ottoobj.ExitAppEvent;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.LocaleUtil;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.OttoUtil;
import com.xdja.safeclient.utils.SharedPreferencesUtil;
import com.xdja.safeclient.wrapper.QuitWrapper;
import com.xdja.sslvpn.CONSTANT;
import com.xdja.sslvpn.SSLVPN;
import com.xdja.third.emm.EmmServcieCallback;
import com.xdja.third.emm.SecManager;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import koal.cert.tools.ICertManager;

import static com.xdja.safeclient.utils.StringUtil.getStringRes;

//import com.tencent.bugly.crashreport.CrashReport;

public class MyApplication extends Application implements EmmServcieCallback{

    public static final boolean isDebug = false;

    public static final String LOG_TAG = "SafeClient";

    public String curVersion = "";// 当前版本号
    public String env_flag = ""; // 环境标识
    public String mobile_os = ""; // 手机操作系统
    public String channel_type = "";// 通道类型
    public String firewall = ""; // 是否开启防火墙，针对转发模式
    public String close_wifi = "";//是否关闭wifi
    public String close_bluetooth = "";//是否关闭蓝牙
    public boolean isWeakPassWD = true; // 默认为弱密码

    public SslClientConfig sslClientConfig = null;//sslclient本地配置信息
    public UpgradeConfig upgradeConfig = null;//升级配置信息
    public SSLVPN sslvpn = null;
    public Activity topActivity = null;
    public List<Activity> activityList = null;

    public PropertiesConfig propertiesConfig = null;

    public final static int ANDROID_4_4_VERSION = 19;

    public static String packageName = "";

    String g_DevPath = "";

    public static final int OPEN_DEV_AUTO = 1;
    public static final int OPEN_DEV_BY_PATH = 2;
    public static int devOpenFlag = 0; //1:直接打开卡； 2：通过路径打开卡

    public static MyApplication myApplication = null;

    //public boolean havingRootPermission = false;

    public int disableFlag = 1; // 0: 不禁用蓝牙wifi；1:禁用蓝牙wifi

    public static boolean selfStartFlag = false; //如果是第三方应用启动服务则为false，客户端启动服务为true
    public static boolean rememberPin = false;   //登陆页面是否记住密码

    public static final String TAG = "MyApplication";

    public static BluetoothAdapter bluetoothAdapter = null;


    private Handler handler = new Handler(Looper.getMainLooper());

    public Handler getHandler() {
        return handler;
    }

    /**
     * 获取自身进程名
     *
     * @return
     */
    private String getSelfProcessName() {
        String processName = "";
        int pid = Process.myPid();
        ActivityManager am = (ActivityManager) getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningAppProcessInfo> list = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo info : list) {
            if (info.pid == pid) {
                processName = info.processName;
            }
        }
        return processName;
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);

        String processName = getSelfProcessName();
        if (!processName.equals(base.getPackageName()))
            return;

        myApplication = this;

        packageName = myApplication.getPackageName();


        // 初始化日志模块
//        String path = Compatibility.getLogsFile(this).getAbsolutePath();
//        try {
//            Log.init(path, 6);
//        } catch (IOException e) {
//            e.printStackTrace();
//        }

        Compatibility.initAreaVersion();
        Log.e(TAG, "CurrentVersion" + Compatibility.getAreaVersion());

        // 首先获取当前版本号 xjq, 2017-04-20 11:43:37
        packageName = getPackageName();

        try {
            curVersion = getPackageManager().getPackageInfo(getPackageName(), 0).versionName;
        } catch (NameNotFoundException e) {
            Log.d(TAG, "Get app version failed." + e.getMessage());
        }

        dealAssetsFile();//处理assets目录下文件
        sslClientConfig = new SslClientConfig();
        readSslclientConfigFile();//读取配置文件

        loadProperties();

        Log.e(TAG, "Call init key module int application");
        if (!BuildConfig.isAAR) {
                Function.initKeyModule(false);
        }
    }


    private final static int SIM_VALID = 0;
    private final static int SIM_INVALID = -1;
    private static int simState = SIM_INVALID;
    BroadcastReceiver broadcastReceiver = new BroadcastReceiver() {

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            switch (action) {
                case CONSTANT.ACTION_SIM_STATE_CHANGED:
                    TelephonyManager tm = (TelephonyManager) context.getSystemService(Service.TELEPHONY_SERVICE);
                    int prevState = simState;
                    simState = tm.getSimState();
                    Log.d(TAG, "sim state changed.Current state " + simState);
                    EventManager.getInstance().onSimStateChanged(prevState, simState);
                    break;

                case ConnectivityManager.CONNECTIVITY_ACTION:
                    Log.d(TAG, "network state has changed");
                    //某些终端锁屏时网络断开，但解锁时收不到网络变更广播，所以暂时去掉此机制
                    //checkNetWorkState(context);
                    MyApplication mapp = MyApplication.myApplication;

                    if (mapp.sslvpn != null) {
                        mapp.sslvpn.guardianLearn(GuardianHelper.guardian_option.G_OPT_NETWORK_SWITCHED.ordinal(),
                                GuardianHelper.getNetWorkType(context).ordinal());
                    }

                    ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
                    NetworkInfo info = cm.getActiveNetworkInfo();

                    if (info != null && info.isConnected()) {
                        // 通知底层这是由于网络切换重连，不需要更换网关IP. Add by xjq, 2017-5-10 09:08:46
                        if (mapp.sslvpn != null) {
                            mapp.sslvpn.notifyNetworkReconnect(1);
                        }
                    } else {
                        // 更新认证界面
                        if (Function.isVPNConnected()) {
                            if (VpnService.FORWARD_MODE == myApplication.sslClientConfig.transportMode) {
                                // 转发模式
                                VpnService.errorState = getStringRes(MyApplication.myApplication, R.string.check_network);
                                SafeVerifyStageInfo stageInfo = new SafeVerifyStageInfo();
                                stageInfo.name = getStringRes(MyApplication.myApplication, R.string.safe_verify);
                                stageInfo.error = VpnService.errorState;
                                stageInfo.result = getStringRes(MyApplication.myApplication, R.string.fail);
                                VpnService.sslStageList.add(stageInfo);
                            } else {
                                // 隧道模式
                                TunVpnService.errorState = getStringRes(MyApplication.myApplication, R.string.check_network);
                                SafeVerifyStageInfo stageInfo = new SafeVerifyStageInfo();
                                stageInfo.name = getStringRes(MyApplication.myApplication, R.string.safe_verify);
                                stageInfo.error = TunVpnService.errorState;
                                stageInfo.result = getStringRes(MyApplication.myApplication, R.string.fail);
                                TunVpnService.sslStageList.add(stageInfo);
                            }
                        }
                    }

                    break;
                case CONSTANT.ACTION_EXIT_TUN_CLIENT:
                    // 延时退出应用
                    if (getPackageName().equals(CONSTANT.VIDEO_CLIENT_PACKAGE_NAME) && propertiesConfig.hasProviderKey() == 1) {
                        Log.d(TAG, "Forward client cover card not avalible, exit tun client!!");
                        Function.stopVPN(MyApplication.myApplication);
                        new Timer().schedule(new TimerTask() {
                            @Override
                            public void run() {
                                Function.exitApp(MyApplication.myApplication);
                            }
                        }, 2000);
                    }
                default:
                    break;
            }

        }
    };

    private void registerRecievers() {
        IntentFilter filter = new IntentFilter();
        filter.addAction(CONSTANT.ACTION_SIM_STATE_CHANGED);
        filter.addAction(ConnectivityManager.CONNECTIVITY_ACTION);
        filter.addAction(CONSTANT.ACTION_EXIT_TUN_CLIENT);
        registerReceiver(broadcastReceiver, filter);
    }

    private void unregisterRecievers() {
        if (broadcastReceiver != null) {
            unregisterReceiver(broadcastReceiver);
        }
    }

    @Override
    public void onTerminate() {
        unregisterRecievers();
        super.onTerminate();
    }

    /**
     * 读取conf.properties配置文件 Add by xjq, 2017-6-28 15:56:57
     */
    private void loadProperties() {
        String propertiesPath = "conf.properties";
        InputStream in = null;
        try {
            in = getResources().getAssets().open(propertiesPath);
            propertiesConfig = new PropertiesConfig(in);
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    private void checkAppReplacingState() {
        if (getResources() == null) {
            Process.killProcess(Process.myPid());
        }
    }

    @Override
    public void onCreate() {
        super.onCreate();
        String processName = getSelfProcessName();
        if (!processName.equals(getPackageName()))
            return;

        checkAppReplacingState();

        QuitWrapper.resetHasBeenQuit(this);



        Log.d(TAG, "application INIT");

        OttoUtil.register(this);

        //bugly add by zhaoxiaolong 20160505 for debug
        //CrashReport.initCrashReport(getApplicationContext(), "900028491", true);

        initLogger();

        // 底层语言初始化
        if (LocaleUtil.autoChoose(this)) {
            SSLVPN.setLocale(Locale.getDefault());
        } else {
            Locale locale = LocaleUtil.getCurrent(this);
            if (locale != null) {
                SSLVPN.setLocale(locale);
            }
        }

        File pageInternal = getFilesDir();
        String internalFilesDir = "/data/data/com.xdja.safeclient/files/";
        if (pageInternal != null) {
            internalFilesDir = pageInternal.getPath();
            Log.d(TAG, "getFilesDir = " + internalFilesDir);
        }


        env_flag = getResources().getString(R.string.env_flag);
        mobile_os = getResources().getString(R.string.mobile_os);
        channel_type = getResources().getString(R.string.channel_type);
        firewall = getResources().getString(R.string.firewall);
        close_wifi = getResources().getString(R.string.close_wifi);
        close_bluetooth = getResources().getString(R.string.close_bluetooth);
        activityList = new ArrayList<Activity>();





        sslClientConfig.setPrivDir(internalFilesDir.getBytes());

        //4.4版本以上
        sslClientConfig.setSdkVersion(VERSION.SDK_INT);

        // Get xdja tf path is done by card module, modify by xjq,2017-9-21 08:39:50
        sslClientConfig.setDevPath("".getBytes());

        sslClientConfig.setDevOpenFlag(devOpenFlag);
        //4.4版本以上

        upgradeConfig = new UpgradeConfig();
        readUpgradeConfigFile();//读取升级配置文件

        initDevState();

//        if (VpnService.TUNNEL_MODE == myApplication.sslClientConfig.transportMode) {
//            havingRootPermission = Function.getRootAhth();
//        }

        //Log.d("MyApplication","havingRootPermission = " + havingRootPermission);

		/* 调试版本 ，获取全局异常 */
        File page = getExternalFilesDir(null);

        if (page != null) {
            String extFilePath = page.getAbsolutePath();
            CrashHandler crashHandler = CrashHandler.getInstance();
            crashHandler.init(getApplicationContext(), extFilePath + "/crash");
        }

        Function.setSafeVpnState(getApplicationContext(), false);

        Function.setSafeTunVpnState(getApplicationContext(), false);

        // 贵阳市版本，需要自动安装EMM应用. Add by xjq, 2017-5-27 14:55:14
        if (Compatibility.getAreaVersion() == Compatibility.AREA_VERSION_GUIYANG_EMM) {
            SecManager.getInstance().initServer(this, this);
            checkDevAdmin();
        }

        bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();

        // 初始化SSLVPN 配置：包名  私有目录名 是否使用贴膜key 是否阻断公网
        SSLVPN.initVPN(getPackageName(), getFilesDir().getPath(), 0, Compatibility.needBindAllIP()?1:0, propertiesConfig.getDisablePublicNetwork());

        // 注册动态广播监听器
        registerRecievers();
    }
    /**
     * 贵阳市局安全客户端需要检查设备admin状态 Add by xjq, 2017-5-31 12:02:17
     */
    public void checkDevAdmin() {
        Intent intent = new Intent();
        intent.setAction("com.xdja.emm.InitService");
        intent.setPackage("com.xdja.emm");
        startService(intent);
    }

    public String getDevPath() {
        // 确保外部路径存在 xjq, 2017-4-19 11:52:14
        // TODO:需要增加静态的SD卡插拔状态监听，在SD卡插入时，调用getExternalFilesDir创建外部目录
        getExternalFilesDir(null);

        int handle = 0;

        Log.d("MyApplication", "getDevPath()");
        SafeTF tf = new SafeTF();

//        if (devOpenFlag == 0 || devOpenFlag == OPEN_DEV_AUTO) {
//            handle = tf.OpenSTFCardAuto();
//
//            if (handle != 0) {
//                devOpenFlag = OPEN_DEV_AUTO;
//                Log.d("MyApplication", "OpenSTFCardAuto success, handle = " + handle);
//                tf.CloseSTFCard(handle);
//                return "";
//            }
//        }

//        if (devOpenFlag == 0 || devOpenFlag == OPEN_DEV_BY_PATH) {
            if (VERSION.SDK_INT >= ANDROID_4_4_VERSION) {
                ArrayList<String> devList = null;
                String devpath = "";
                this.g_DevPath = "";

//				devList = findExterSD();
//                devList = Function.findSdcardPrivatePath(getPackageName());

                devList = Function.findSdcardPrivatePath(Compatibility.getTFPackage(this));
                for (int i = 0; i < devList.size(); i++) {
                    devpath = devList.get(i) + "/";

                    Log.d("MyApplication", "devpath = " + devpath);

                    handle = tf.OpenSTFCard(devpath);
                    if (0 != handle) {
                        this.g_DevPath = devpath;
                        Log.d("MyApplication", "OpenSTFCard success, g_DevPath = " + g_DevPath);
                        devOpenFlag = OPEN_DEV_BY_PATH;
                        tf.CloseSTFCard(handle);
                        return this.g_DevPath;
                    } else {
                        MyApplication.devOpenFlag = 0;
                        Log.d("MyApplication", "OpenSTFCard failed,handle = " + handle);
                    }
                }
            }
//        }
        return "";
    }

    public void initDevState() {

        disableFlag = 1;

        WifiManager wifi = (WifiManager) getSystemService(Context.WIFI_SERVICE);

        if (wifi != null) {

            int wifiState = wifi.getWifiState();

            if (WifiManager.WIFI_STATE_ENABLING == wifiState
                    || WifiManager.WIFI_STATE_ENABLED == wifiState) {
                if (propertiesConfig.getmDisableWifi() == 1) {
                    wifi.setWifiEnabled(false);//禁止使用WIFI
                    Log.d("MyApplication", "setWifiEnabled(false)");
                }
            }
        }

        BluetoothAdapter bluetooth = BluetoothAdapter.getDefaultAdapter();

        if (bluetooth != null) {
            int blueState = bluetooth.getState();

            if (BluetoothAdapter.STATE_TURNING_ON == blueState
                    || BluetoothAdapter.STATE_ON == blueState) {
                if (propertiesConfig.getmDisableBluetoolth() == 1) {
                    try {
                        bluetooth.disable();//禁止使用蓝牙
                        Log.d("MyApplication", "bluetooth.disable");
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }


    /**
     * 读取sslclientConfig本地配置文件
     */
    public void readSslclientConfigFile() {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        String privatePath = "";
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            privatePath = getFilesDir().getPath();
            FileInputStream in = new FileInputStream(privatePath + "/config.xml");
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();

            NodeList nodeList = root.getElementsByTagName("CONFIGINFO");
            if (nodeList != null && nodeList.getLength() > 0) {
                Element elt = (Element) nodeList.item(0);

                Node eltTransportMode = elt.getElementsByTagName("TRANSPORTMODE").item(0);
                if (eltTransportMode == null || eltTransportMode.getFirstChild() == null) {
                    Toast.makeText(this, R.string.config_error_trans_mode_empty, Toast.LENGTH_SHORT).show();
                    return;
                }

                Node eltCertMode = elt.getElementsByTagName("CERTMODE").item(0);
                if (eltCertMode == null || eltCertMode.getFirstChild() == null) {
                    Toast.makeText(this, R.string.config_error_cert_empty, Toast.LENGTH_SHORT).show();
                    return;
                }

                Node eltGatewayIp = elt.getElementsByTagName("GATEWAYIP").item(0);
                if (eltGatewayIp == null || eltGatewayIp.getFirstChild() == null) {
                    Toast.makeText(this, R.string.config_error_gateway1_address_empty, Toast.LENGTH_SHORT).show();
                    return;
                }

                Node eltGatewayIp2 = elt.getElementsByTagName("GATEWAYIP2").item(0);

                Node eltGatewayIp3 = elt.getElementsByTagName("GATEWAYIP3").item(0);

                Node eltGatewayPort = elt.getElementsByTagName("GATEWAYPORT").item(0);
                if (eltGatewayPort == null || eltGatewayPort.getFirstChild() == null) {
                    Toast.makeText(this, R.string.config_error_gateway_port_empty, Toast.LENGTH_SHORT).show();
                    return;
                }


                Node eltCipherSuit = elt.getElementsByTagName("CIPHERSUITE").item(0);
                if (eltCipherSuit == null || eltCipherSuit.getFirstChild() == null) {
                    Toast.makeText(this, R.string.config_error_cipher_suite_empty, Toast.LENGTH_SHORT).show();
                    return;
                }

                Node eltConnectTimeout = elt.getElementsByTagName("CONNECTTIMEOUT").item(0);
                if (eltConnectTimeout == null || eltConnectTimeout.getFirstChild() == null) {
                    Toast.makeText(this, R.string.config_error_connect_timeout_empty, Toast.LENGTH_SHORT).show();
                    return;
                }

                Node eltRetryConnectCount = elt.getElementsByTagName("RETRYCONNECTCOUNT").item(0);
                if (eltRetryConnectCount == null || eltRetryConnectCount.getFirstChild() == null) {
                    Toast.makeText(this, R.string.config_error_reconnect_count_empty, Toast.LENGTH_SHORT).show();
                    return;
                }

                // add by zhaoxiaolong 20160707
                Node eltRole = elt.getElementsByTagName("ROLE").item(0);
                if (eltRole == null || eltRole.getFirstChild() == null) {
                    Toast.makeText(this, R.string.config_error_role_empty, Toast.LENGTH_SHORT).show();
                    return;
                }
                // add end

                //add by wangyue start 20160719
                Node eltPrivatePort = elt.getElementsByTagName("PRIVATEPORT").item(0);
                if (eltPrivatePort == null || eltPrivatePort.getFirstChild() == null) {
                    Toast.makeText(this, R.string.config_error_private_port_empty, Toast.LENGTH_SHORT).show();
                    return;
                }
                //add by wangyue end   20160719

                Node eltCertId = elt.getElementsByTagName("CERTID").item(0);
                if (eltCertId == null || eltCertId.getFirstChild() == null) {
                    Toast.makeText(this, R.string.config_error_cert_id_empty, Toast.LENGTH_SHORT).show();
                    return;
                }

                Node eltPubkeyId = elt.getElementsByTagName("PUBKEYID").item(0);
                if (eltPubkeyId == null || eltPubkeyId.getFirstChild() == null) {
                    Toast.makeText(this, R.string.config_error_pubkey_id_empty, Toast.LENGTH_SHORT).show();
                    return;
                }

                Node eltPrikeyId = elt.getElementsByTagName("PRIKEYID").item(0);
                if (eltPrikeyId == null || eltPrikeyId.getFirstChild() == null) {
                    Toast.makeText(this, R.string.config_error_prikey_id_empty, Toast.LENGTH_SHORT).show();
                    return;
                }

                Node eltLogSwitch = elt.getElementsByTagName("LOGSWITCH").item(0);
                if (eltLogSwitch == null || eltLogSwitch.getFirstChild() == null) {
                    Toast.makeText(this, R.string.config_error_log_switch_empty, Toast.LENGTH_SHORT).show();
                    return;
                }

                Node eltLogLevel = elt.getElementsByTagName("LOGLEVEL").item(0);
                if (eltLogLevel == null || eltLogLevel.getFirstChild() == null) {
                    Toast.makeText(this, R.string.config_error_log_level_empty, Toast.LENGTH_SHORT).show();
                    return;
                }

                Node eltLogFileSize = elt.getElementsByTagName("LOGFILESIZE").item(0);
                if (eltLogFileSize == null || eltLogFileSize.getFirstChild() == null) {
                    Toast.makeText(this, R.string.config_error_log_size_empty, Toast.LENGTH_SHORT).show();
                    return;
                }

                Node eltMixNum = elt.getElementsByTagName("MIXNUM").item(0);
                if (eltMixNum == null || eltMixNum.getFirstChild() == null) {
                    Toast.makeText(this, R.string.config_error_mix_num_empty, Toast.LENGTH_SHORT).show();
                    return;
                }

                Node eltMixDeno = elt.getElementsByTagName("MIXDENO").item(0);
                if (eltMixDeno == null || eltMixDeno.getFirstChild() == null) {
                    Toast.makeText(this, R.string.config_error_mix_deno_empty, Toast.LENGTH_SHORT).show();
                    return;
                }

                Node eltAclVersion = elt.getElementsByTagName("ACLVERSION").item(0);
                if (eltAclVersion == null || eltAclVersion.getFirstChild() == null) {
                    Toast.makeText(this, R.string.config_error_acl_version_empty, Toast.LENGTH_SHORT).show();
                    return;
                }

                String transportMode = eltTransportMode.getFirstChild().getNodeValue();
                String certMode = eltCertMode.getFirstChild().getNodeValue();
                String gatewayIp = eltGatewayIp.getFirstChild().getNodeValue();
                String gatewayIp2 = null;
                if (eltGatewayIp2 != null && eltGatewayIp2.getFirstChild() != null) {
                    gatewayIp2 = eltGatewayIp2.getFirstChild().getNodeValue();
                } else {
                    gatewayIp2 = gatewayIp;
                }
                String gatewayIp3 = null;
                if (eltGatewayIp3 != null && eltGatewayIp3.getFirstChild() != null) {
                    gatewayIp3 = eltGatewayIp3.getFirstChild().getNodeValue();
                } else {
                    gatewayIp3 = gatewayIp;
                }
                String gatewayPort = eltGatewayPort.getFirstChild().getNodeValue();
                String cipherSuit = eltCipherSuit.getFirstChild().getNodeValue();
                String connectTimeout = eltConnectTimeout.getFirstChild().getNodeValue();
                String retryConnectCount = eltRetryConnectCount.getFirstChild().getNodeValue();
                String roleStr = eltRole.getFirstChild().getNodeValue();
                String certId = eltCertId.getFirstChild().getNodeValue();
                String pubkeyId = eltPubkeyId.getFirstChild().getNodeValue();
                String prikeyId = eltPrikeyId.getFirstChild().getNodeValue();

                //add by wangyue 20160719
                String priPort = eltPrivatePort.getFirstChild().getNodeValue();

                String logSwitch = eltLogSwitch.getFirstChild().getNodeValue();
                String logLevel = eltLogLevel.getFirstChild().getNodeValue();
                String logFileSize = eltLogFileSize.getFirstChild().getNodeValue();

                String mixNum = eltMixNum.getFirstChild().getNodeValue();
                String mixDeno = eltMixDeno.getFirstChild().getNodeValue();

                String aclVerison = eltAclVersion.getFirstChild().getNodeValue();

                sslClientConfig.setTransportMode(Integer.parseInt(transportMode));
                sslClientConfig.setCertMode(Integer.parseInt(certMode));
                sslClientConfig.setGateWayIp(gatewayIp.getBytes());
                if (eltGatewayIp2 != null && eltGatewayIp2.getFirstChild() != null) {
                    sslClientConfig.setGateWayIp2(gatewayIp2.getBytes());
                }
                if (eltGatewayIp3 != null && eltGatewayIp3.getFirstChild() != null) {
                    sslClientConfig.setGateWayIp3(gatewayIp3.getBytes());
                }
                sslClientConfig.setGateWayPort(Integer.parseInt(gatewayPort));
                sslClientConfig.setCipherSuit(Integer.parseInt(cipherSuit));
                sslClientConfig.setConnectTimeOut(Integer.parseInt(connectTimeout));
                sslClientConfig.setRetryConnectCount(Integer.parseInt(retryConnectCount));

                sslClientConfig.setLogSwitch(Integer.parseInt(logSwitch));
                sslClientConfig.setLogLevel(Integer.parseInt(logLevel));
                sslClientConfig.setLogFileSize(Integer.parseInt(logFileSize));

                sslClientConfig.setMixNum(Integer.parseInt(mixNum));
                sslClientConfig.setMixDeno(Integer.parseInt(mixDeno));

                sslClientConfig.setAclVersion(Integer.parseInt(aclVerison));
                // add by zhaoxiaolong 20160707
                sslClientConfig.setRole(Integer.parseInt(roleStr));
                // add by wangyue 20160719
                sslClientConfig.setPrivatePort(Integer.parseInt(priPort));

                byte[] byt_certId = new byte[2];
                byte[] byt_pubkeyId = new byte[2];
                byte[] byt_prikeyId = new byte[2];
                Function.Hex_Decode(certId.getBytes(), byt_certId, 2);
                Function.Hex_Decode(pubkeyId.getBytes(), byt_pubkeyId, 2);
                Function.Hex_Decode(prikeyId.getBytes(), byt_prikeyId, 2);

                sslClientConfig.setCertId(byt_certId);
                sslClientConfig.setPubkeyId(byt_pubkeyId);
                sslClientConfig.setPrikeyId(byt_prikeyId);

                String caPath = privatePath + "/ca.cer";
                sslClientConfig.setCaPath(caPath.getBytes());
            }
        } catch (IOException e) {
        } catch (SAXException e) {
        } catch (ParserConfigurationException e) {
        } finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
    }

    /**
     * 写入sslclientConfig本地配置文件
     */
    public void writeSslclientConfigFile() {
        java.lang.StringBuffer configXml = new StringBuffer();
        configXml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        configXml.append("<Root>");

        configXml.append("<CONFIGINFO>");
        configXml.append("<TRANSPORTMODE>" + sslClientConfig.transportMode + "</TRANSPORTMODE>");
        configXml.append("<CERTMODE>" + sslClientConfig.certMode + "</CERTMODE>");
        configXml.append("<GATEWAYIP>" + new String(sslClientConfig.gateWayIp) + "</GATEWAYIP>");

        String gw2 = null;
        if (sslClientConfig.gateWayIp2 == null) {
            gw2 = "";
        } else {
            gw2 = new String(sslClientConfig.gateWayIp2);
        }

        String gw3 = null;
        if (sslClientConfig.gateWayIp3 == null) {
            gw3 = "";
        } else {
            gw3 = new String(sslClientConfig.gateWayIp3);
        }

        configXml.append("<GATEWAYIP2>" + gw2 + "</GATEWAYIP2>");
        configXml.append("<GATEWAYIP3>" + gw3 + "</GATEWAYIP3>");
        configXml.append("<GATEWAYPORT>" + sslClientConfig.gateWayPort + "</GATEWAYPORT>");
        configXml.append("<CIPHERSUITE>" + sslClientConfig.cipherSuit + "</CIPHERSUITE>");
        configXml.append("<CONNECTTIMEOUT>" + sslClientConfig.connectTimeOut + "</CONNECTTIMEOUT>");
        configXml.append("<RETRYCONNECTCOUNT>" + sslClientConfig.retryConnectCount + "</RETRYCONNECTCOUNT>");
        configXml.append("<ROLE>" + sslClientConfig.role + "</ROLE>");
        configXml.append("<PRIVATEPORT>" + sslClientConfig.privatePort + "</PRIVATEPORT>");
        String certId = String.format("%02x%02x", sslClientConfig.certId[0], sslClientConfig.certId[1]);
        String pubkeyId = String.format("%02x%02x", sslClientConfig.pubkeyId[0], sslClientConfig.pubkeyId[1]);
        String prikeyId = String.format("%02x%02x", sslClientConfig.prikeyId[0], sslClientConfig.prikeyId[1]);
        configXml.append("<CERTID>" + certId + "</CERTID>");
        configXml.append("<PUBKEYID>" + pubkeyId + "</PUBKEYID>");
        configXml.append("<PRIKEYID>" + prikeyId + "</PRIKEYID>");

        configXml.append("<LOGSWITCH>" + sslClientConfig.logSwitch + "</LOGSWITCH>");
        configXml.append("<LOGLEVEL>" + sslClientConfig.logLevel + "</LOGLEVEL>");
        configXml.append("<LOGFILESIZE>" + sslClientConfig.logFileSize + "</LOGFILESIZE>");

        configXml.append("<MIXNUM>" + sslClientConfig.mixNum + "</MIXNUM>");
        configXml.append("<MIXDENO>" + sslClientConfig.mixDeno + "</MIXDENO>");

        configXml.append("<ACLVERSION>" + sslClientConfig.aclVersion + "</ACLVERSION>");

        configXml.append("</CONFIGINFO>");
        configXml.append("</Root>");

        Function.writePrivateFile(this, "config.xml", configXml.toString());// 写xml数据到配置文件中
    }

    /**
     * 处理软件中资源文件
     */
    public void dealAssetsFile() {
        SharedPreferences sharedPreferences = getSharedPreferences("SafeClientConfig", 0);
        String preVersion = sharedPreferences.getString("preVersion", "");
        Log.d("app", "preVersion " + preVersion);
        Log.d("app", "curVersion " + curVersion);
        if (preVersion.equals("")) {// 第一次使用
            Editor editor = sharedPreferences.edit(); // 提交当前版本
            editor.putString("preVersion", curVersion);
            editor.commit();

            // 贵阳版本需要安装EMM应用. Add by xjq, 2017年5月27日14:51:00
            if (Compatibility.getAreaVersion() == Compatibility.AREA_VERSION_GUIYANG_EMM) {
                Log.d("app", "copy emm apk file");
                Function.copyAssets(this, Environment.getExternalStorageDirectory().getAbsolutePath()
                                + File.separator + CONSTANT.EMM_GUIYANG_APK_FILE,
                                CONSTANT.EMM_GUIYANG_APK_FILE);

                Log.d("app", "copy push apk file");
                Function.copyAssets(this, Environment.getExternalStorageDirectory().getAbsolutePath()
                                + File.separator + CONSTANT.PUSH_GUIYANG_APK_FILE,
                        CONSTANT.PUSH_GUIYANG_APK_FILE);
            }

            Function.moveFile(this, "ca.cer"); // 移动根证书到私有目录
            Function.moveFile(this, "config.xml"); // 移动配置文件到私有目录
            Function.moveFile(this, "ClientVer.xml"); // 移动配置文件到私有目录
            Function.moveFile(this, "tuncontrol"); //移动隧道模式arm控制文件到私有目录
            Function.moveFile(this, "conf.properties"); //移动配置文件到私有目录

        } else {
            if (preVersion.equals(curVersion)) {// 未升级
                Function.moveFile(this, "ca.cer"); // 移动根证书到私有目录
                Function.moveFile(this, "tuncontrol"); //移动隧道模式控制文件到私有目录
                Function.moveFile(this, "conf.properties"); //移动配置文件到私有目录
            } else {// 已升级
                Function.moveFile(this, "ca.cer"); // 移动根证书到私有目录
                Function.moveFile(this, "config.xml"); // 移动配置文件到私有目录
                Function.moveFile(this, "ClientVer.xml"); // 移动配置文件到私有目录
                Function.moveFile(this, "tuncontrol"); //移动隧道模式控制文件到私有目录
                Function.moveFile(this, "conf.properties"); //移动配置文件到私有目录

                // 贵阳版本需要安装EMM应用. Add by xjq, 2017年5月27日14:51:00
                if (Compatibility.getAreaVersion() == Compatibility.AREA_VERSION_GUIYANG_EMM) {
                    Function.copyAssets(this, Environment.getExternalStorageDirectory().getAbsolutePath()
                                    + File.separator + CONSTANT.EMM_GUIYANG_APK_FILE,
                                    CONSTANT.EMM_GUIYANG_APK_FILE);

                    Function.copyAssets(this, Environment.getExternalStorageDirectory().getAbsolutePath()
                                    + File.separator + CONSTANT.PUSH_GUIYANG_APK_FILE,
                            CONSTANT.PUSH_GUIYANG_APK_FILE);
                }
            }

            Editor editor = sharedPreferences.edit(); // 提交当前版本
            editor.putString("preVersion", curVersion);
            editor.commit();
        }
    }


    /**
     * 读升级配置文件
     */
    public void readUpgradeConfigFile() {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        String privatePath = "";
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            privatePath = getFilesDir().getPath();
            FileInputStream in = new FileInputStream(privatePath + "/ClientVer.xml");

            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();

            Node eltIP = root.getElementsByTagName("ServerIP").item(0);
            Node eltPort = root.getElementsByTagName("ServerPort").item(0);

            Node eltFactory = root.getElementsByTagName("Factory").item(0);
            Node eltMod = root.getElementsByTagName("Mod").item(0);
            Node eltOS = root.getElementsByTagName("OS").item(0);

            Node eltSoft = root.getElementsByTagName("Soft").item(0);
            Node eltUserName = root.getElementsByTagName("UserName").item(0);

            if (eltIP.getFirstChild() != null) {
                upgradeConfig.serverIp = eltIP.getFirstChild().getNodeValue();
            }

            if (eltPort.getFirstChild() != null) {
                upgradeConfig.serverPort = eltPort.getFirstChild().getNodeValue();
            }

            upgradeConfig.factory = eltFactory.getFirstChild().getNodeValue();
            upgradeConfig.mod = eltMod.getFirstChild().getNodeValue();
            upgradeConfig.os = eltOS.getFirstChild().getNodeValue();

            upgradeConfig.soft = eltSoft.getFirstChild().getNodeValue();
            upgradeConfig.userName = eltUserName.getFirstChild().getNodeValue();

            NodeList nodeList = root.getElementsByTagName("Ver");// 取升级版本历史信息
            int nodeNum = nodeList.getLength();

            Element childElement = null;
            NodeList childList = null;

            for (int i = 0; i < nodeNum; i++) {
                UpgradeVersionInfo vi = new UpgradeVersionInfo();
                childElement = (Element) nodeList.item(i);
                childList = childElement.getElementsByTagName("Version");
                vi.version = childList.item(0).getFirstChild().getNodeValue();// 取版本信息

                childList = childElement.getElementsByTagName("Date");
                vi.date = childList.item(0).getFirstChild().getNodeValue(); // 取时间信息

                childList = childElement.getElementsByTagName("Note");
                if (childList.item(0).getFirstChild() != null) {
                    vi.note = childList.item(0).getFirstChild().getNodeValue();// 取备注信息
                }
                upgradeConfig.verList.add(vi);// 添加版本信息到链表中
            }
        } catch (IOException e) {
        } catch (SAXException e) {
        } catch (ParserConfigurationException e) {
        } finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
    }

    /**
     * 写升级配置文件
     */
    public void writeUpgradeConfigFile() {
        java.lang.StringBuffer verXml = new StringBuffer();
        verXml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        verXml.append("<Root>");

        verXml.append("<ServerIP>" + upgradeConfig.serverIp + "</ServerIP>");
        verXml.append("<ServerPort>" + upgradeConfig.serverPort + "</ServerPort>");
        verXml.append("<Factory>" + upgradeConfig.factory + "</Factory>");
        verXml.append("<Mod>" + upgradeConfig.mod + "</Mod>");
        verXml.append("<OS>" + upgradeConfig.os + "</OS>");

        verXml.append("<Soft>安全客户端</Soft>");
        verXml.append("<UserName>ldz</UserName>");

        int verListNum = upgradeConfig.verList.size();
        UpgradeVersionInfo vi = null;
        for (int i = 0; i < verListNum; i++) {// 版本升级历史信息
            vi = upgradeConfig.verList.get(i);
            verXml.append("<Ver>");
            verXml.append("<Version>" + vi.version + "</Version>");
            verXml.append("<Date>" + vi.date + "</Date>");
            verXml.append("<Note>" + vi.note + "</Note>");
            verXml.append("</Ver>");
        }

        verXml.append("</Root>");

        Function.writePrivateFile(this, "ClientVer.xml", verXml.toString());// 写升级配置数据到升级配置配置文件中
    }
    private void initLogger() {
        Logger.init(LOG_TAG)
                .methodCount(3)
                .logLevel(isDebug ? LogLevel.FULL : LogLevel.NONE);
    }

    @Subscribe
    public void handleExitAppEvent(ExitAppEvent event) {
        if (propertiesConfig.getmDisableFlag() == 1) {
            disableFlag = 0;
        }
    }


    /**
     * 获取包版本
     * @param packageName
     * @return
     */
    private String getPackageVersion(String packageName) {
        PackageManager pm = getPackageManager();
        try {
            PackageInfo info = pm.getPackageInfo(packageName, PackageManager.GET_CONFIGURATIONS);
            if (null != info) {
                return info.versionName;
            }
        } catch (NameNotFoundException e) {
            e.printStackTrace();
        }

        return null;
    }

    /**
     * EMM Service连接成功后，开始静默安装EMM应用（贵阳市局版本专用）. Add by xjq, 2017-5-31 14:36:19
     */
    @Override
    public void onConnected() {
        if (Compatibility.getAreaVersion() == Compatibility.AREA_VERSION_GUIYANG_EMM) {
            Log.d(TAG, "EMM service connected.");

            int ret = -1;

            // 首先尝试更新推送客户端 Add by xjq, 2017-6-26 19:15:34
            String pushVersion = getPackageVersion("com.xdja.jxpush");
            if (pushVersion == null || pushVersion.compareTo("4.0.5.7") < 0) { // 低于apk中文件版本
                String apkPath = Environment.getExternalStorageDirectory().getAbsolutePath() +
                        File.separator + CONSTANT.PUSH_GUIYANG_APK_FILE;
                File apkFile = new File(apkPath);
                String apkUri = Uri.fromFile(apkFile).toString();
                ret = SecManager.getInstance().silentInstall(apkUri, 0x00000002);

                if (ret == 1) {
                    Log.d(TAG, "Install push apk file success.");
                }
            } else {
                Log.d(TAG, "No need to install push apk file");
            }




            if (!(Boolean)SharedPreferencesUtil.get(this, CONSTANT.EMM_APK_INSTALLED_FLAG, false)) {

                String emmVersion = getPackageVersion("com.xdja.emm");
                if (emmVersion != null && emmVersion.compareTo("1.1.11.0620") >= 0) {
                    if (!emmVersion.equals("1.1.8.1201")) {
                        return;
                    }
                }

                String apkPath = Environment.getExternalStorageDirectory().getAbsolutePath() +
                        File.separator + CONSTANT.EMM_GUIYANG_APK_FILE;
                File apkFile = new File(apkPath);
                String apkUri = Uri.fromFile(apkFile).toString();
                ret = SecManager.getInstance().silentInstall(apkUri, 0x00000002);

                if (ret == 1) {
                    // 安装成功
                    SharedPreferencesUtil.put(this, CONSTANT.EMM_APK_INSTALLED_FLAG, true);
                }
            }
        }
    }

    @Override
    public void onDisnnected() {
        if (Compatibility.getAreaVersion() == Compatibility.AREA_VERSION_GUIYANG_EMM) {

        }
    }
}
