/*
 * Copyright (C) 2011 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xdja.safeclient;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.VpnService;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.os.PowerManager.WakeLock;
import android.telephony.TelephonyManager;

import com.squareup.otto.Subscribe;
import com.xdja.autoupdate.SCAutoUpdate;
import com.xdja.key.KeyWrapper;
import com.xdja.safeclient.activity.SafeVerifyActivity;
import com.xdja.safeclient.bean.SafeVerifyStageInfo;
import com.xdja.safeclient.constant.IntentParam;
import com.xdja.safeclient.ottoobj.ExitAppEvent;
import com.xdja.safeclient.ottoobj.StopTunEvent;
import com.xdja.safeclient.ui.AlertUtil;
import com.xdja.safeclient.utils.AppSHAUtil;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.OttoUtil;
import com.xdja.safeclient.utils.StringUtil;
import com.xdja.sslvpn.AppAclList;
import com.xdja.sslvpn.AppAclRule;
import com.xdja.sslvpn.CONSTANT;
import com.xdja.sslvpn.SSLVPN;
import com.xdja.sslvpn.SocketListener;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TunVpnService extends VpnService {
    private static final String TAG = "TunVpnService";

    public static PendingIntent mConfigureIntent;

    public Builder builder;

    public static ParcelFileDescriptor mInterface = null;

    private static MyApplication myApplication = null;
    public int connect = 0;
    public static SocketListener sock = null;
    public byte[] vpnstate = new byte[2048];
    public int vpnstatelen = 0;

    public static String issuccess = "";
    public String prestage = "";//ssl前一阶段
    public static String curstage = ""; // ssl当前阶段

    //	static public boolean startService = false;// 服务是否启动
    static public boolean stopService = false;// 服务是否停止完毕
    static public String errorState = "";// 错误状态

    private static String errorInfo = "";  //三码绑定错误信息
    private static int errorInfoFlag = 0;   //0不显示，1显示
    private static NotificationManager nm = null;

    static public List<SafeVerifyStageInfo> sslStageList = new ArrayList<SafeVerifyStageInfo>(); // ssl状态
    static public boolean safeVerifySuccess = false;

    private static String sessionId = "";

    BroadcastReceiver sdcardBroadCastReceiver = null;
    private BroadcastReceiver screenBroadCastReceiver = null;

    // add by zhaoxiaolong 2016-09-56
    private static boolean screenOn = true;

    public static TunVpnService tunVpnObj = null;

    public static Object lock = new Object();

    public static boolean startflag = false; //如果为true，点击桌面图标，跳过登陆页面进入认证页面。

    PowerManager pm = null;
    WakeLock mWakeLock = null;

    // add by zhaoxiaolong 2016-05-17
    private String serverIP = null;
    private int serverPort = 0;

    private byte[] gatewayIp = null;
    private byte[] gatewayIp2 = null;
    private byte[] gatewayIp3 = null;
    private int gatewayPort = 0;


    private void checkSDCardState(Context context, Intent intent) {
        Log.d(TAG, "getExternalStorageState : " + Environment.getExternalStorageState());

//		if (TunVpnService.startService == false) {
        if (Function.getSafeTunVpnState(getApplicationContext()) == false) {
            return;
        }

        safeVerifySuccess = false;
        TunVpnService.errorState = getString(R.string.card_eject);
        SafeVerifyStageInfo stageInfo = new SafeVerifyStageInfo();

        stageInfo.name = getString(R.string.safe_verify);
        stageInfo.error = TunVpnService.errorState;
        stageInfo.result = getString(R.string.fail);
        sslStageList.add(stageInfo);

        showVpnState(R.drawable.seq_off, getResources().getString(R.string.safe_client), TunVpnService.errorState);// 显示离线状态

        if (myApplication.sslvpn != null) {
            myApplication.sslvpn.stopService();
            myApplication.sslvpn.release();
            myApplication.sslvpn = null;
        }

        try {
            if (TunVpnService.mInterface != null) {
                Log.d(TAG, "TunVpnService.mInterface.close");
                TunVpnService.mInterface.close();
                TunVpnService.mInterface = null;
                if (TunVpnService.tunVpnObj != null) {
                    TunVpnService.tunVpnObj.destroyBuilder();
                }
            }
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        if (myApplication.sslvpn != null) {
            myApplication.sslvpn.closeTunFd();
        }
        synchronized (lock) {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }

//			TunVpnService.startService = false; 
        Function.setSafeTunVpnState(getApplicationContext(), false);
        TunVpnService.stopService = true;

        Log.d(TAG, "SDCard EJECT");

        // sd卡被移除，需要做处理 Add by xjq, 2017-01-06 08:46:46
        Compatibility.onSDCardEject();

        stopSelf();

    }

    private void startWatchingDevice() {

        sdcardBroadCastReceiver = new BroadcastReceiver() {

            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();

                Log.d(TAG, "onReceive " + action);
                Log.d(TAG, "onReceive " + intent.getData());

                if (intent.getData().toString().contains("udisk")) {
                    Log.d(TAG, "onReceive " + "igore second sdcard eject");
                    return;
                }

                if (Intent.ACTION_MEDIA_EJECT.equals(action)) {

//                    if (MyApplication.devOpenFlag != MyApplication.OPEN_DEV_BY_PATH) {
//                        Log.d(TAG, "Current use tf. Don't stop service");
//                        return;
//                    }

                    checkSDCardState(context, intent);
                }

            }
        };

        IntentFilter sdcardFilter = new IntentFilter();
        sdcardFilter.addAction(Intent.ACTION_MEDIA_EJECT);
        sdcardFilter.addDataScheme("file");
        registerReceiver(sdcardBroadCastReceiver, sdcardFilter);
    }

    private void stopWatchingDevice() {
        if (sdcardBroadCastReceiver != null) {
            unregisterReceiver(sdcardBroadCastReceiver);
        }
    }


    @Override
    public void onCreate() {
        super.onCreate();

        OttoUtil.register(this);

        myApplication = (MyApplication) getApplication();

        //每次服务启动的时候，清除状态，重新记录认证时间
        Log.d(VerifyTime.TAG, "TunVpnService onCreate reset flag");
        VerifyTime.writeVerifySuccess(this, false);

//        startflag = true;

        screenOn = true;
//        builder = new Builder();
        tunVpnObj = this;
        startWatchingDevice();
        startWatchingScreen();

        myApplication.initDevState();

        if (myApplication.propertiesConfig != null && myApplication.propertiesConfig.getIsWakeLock() == 1) {
            Function.getWakeLock();
        }

        //检查海棠服务
        if (!Function.checkHitomservice(getApplicationContext())) {
            AlertUtil.popSystemAlert(getApplicationContext(), StringUtil.getStringRes(this, R.string.alert), StringUtil.getStringRes(this, R.string.hitom_service_not_exist), null);
            return;
        }

        errorInfoFlag = 0;
        errorInfo = "";

//        //避免多次启动安全认证
//		if (!Function.getSafeTunVpnState(getApplicationContext())) {
//			Function.setSafeTunVpnState(getApplicationContext(), true);
//			stopService = false;		
//			running();
//      	}
    }


    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {

//        if (intent != null) {
//            int fd = intent.getIntExtra("socket", -1);
//            if (fd != -1) {
//                protect(fd);
//                return START_STICKY;
//            }
//        }

        //避免多次启动安全认证
        if (!Function.getSafeTunVpnState(getApplicationContext())) {

            //广东财政厅，烽火第三方应用需求，传入PIN码, 2014.08.21 start
            String safePin = null;
            if (intent != null) {
                safePin = null;
                safePin = intent.getStringExtra("SafePin");
                try {
                    if (safePin != null) {
                        Log.d("TunVpnService", "putin safePin by intent, safePin = " + safePin);
                        myApplication.sslClientConfig.setPin(safePin.getBytes());
                    } else {
                        Log.d("TunVpnService", "not putin safePin by intent ");
                    }
                } catch (NullPointerException e) {

                }
            }
            //广东财政厅，烽火第三方应用需求，传入PIN码, 2014.08.21 end

            // add by zhaoxiaolong 2016-05-17
            if (intent != null) {
                try {
                    serverIP = intent.getStringExtra("ServerIP");
                    //fix by zhaoxiaolong 20160525
                    serverPort = intent.getIntExtra("ServerPort", myApplication.sslClientConfig.gateWayPort);

                    if (serverIP != null) {
                        Log.d(TAG, "putin serverIP by intent,serverIP = " + serverIP);
                        Log.d(TAG, "putin serverPort by intent,serverPort = " + serverPort);
                        gatewayIp = myApplication.sslClientConfig.getGateWayIp();
                        gatewayIp2 = myApplication.sslClientConfig.getGateWayIp2();
                        gatewayIp3 = myApplication.sslClientConfig.getGateWayIp3();
                        gatewayPort = myApplication.sslClientConfig.getGateWayPort();

                        myApplication.sslClientConfig.setGateWayIp(serverIP.getBytes());
                        myApplication.sslClientConfig.setGateWayIp2(serverIP.getBytes());
                        myApplication.sslClientConfig.setGateWayIp3(serverIP.getBytes());

                        myApplication.sslClientConfig.setGateWayPort(serverPort);

                    }
                } catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }

            // 如果安全客户端当前是停止的状态，则重新启动 xjq, 2017-3-22 18:58:12
            if (myApplication.sslvpn == null || stopService) {
                Function.setSafeTunVpnState(getApplicationContext(), true);
                stopService = false;
                running();
            }
        }

        return START_STICKY;
    }

//	@Override
//	public void onRevoke () {
//		Log.d(TAG, "onRevoke");
//		super.onRevoke();
//	}


    @Override
    public void onDestroy() {

        Log.d(TAG, "onDestroy");

        stopForeground(true);

        startflag = false;

        curstage = "";// ssl当前状态
        errorState = "";// 错误状态

        stopWatchingScreen();
        GuardianHelper.cancleOnceAlarm(getApplicationContext());

        if (myApplication.propertiesConfig != null && myApplication.propertiesConfig.getIsWakeLock() == 1) {
            Function.releaseWakeLock();
        }

//		startService = false;
//		safeVerifySuccess = false;

        if (serverIP != null) {
            myApplication.sslClientConfig.setGateWayIp(gatewayIp);
            myApplication.sslClientConfig.setGateWayIp2(gatewayIp2);
            myApplication.sslClientConfig.setGateWayIp3(gatewayIp3);

            myApplication.sslClientConfig.setGateWayPort(gatewayPort);
        }

        if (myApplication.sslvpn != null) {
            myApplication.sslvpn.stopService();
            myApplication.sslvpn.release();
            myApplication.sslvpn = null;
        }

        try {
            if (TunVpnService.mInterface != null) {
                Log.d(TAG, "TunVpnService.mInterface.close");
                TunVpnService.mInterface.close();
                TunVpnService.mInterface = null;
                if (TunVpnService.tunVpnObj != null) {
                    TunVpnService.tunVpnObj.destroyBuilder();
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

//		startService = false;
        Function.setSafeTunVpnState(getApplicationContext(), false);
        safeVerifySuccess = false;

        if (myApplication.sslvpn != null) {
            myApplication.sslvpn.closeTunFd();
        }

        synchronized (lock) {
            if (sock != null) {
                //Log.d(TAG, "VPNEXIT");
                //sock.sendData("VPNEXIT");
                sock.close();
                sock = null;
            }
        }


        stopWatchingDevice();

        tunVpnObj = null;

        if (myApplication.propertiesConfig.getmDisableFlag() == 1) {
            myApplication.disableFlag = 0;
        }

        errorInfoFlag = 0;
        errorInfo = "";

        // add by zhaoxiaolong 20160604 如果用户点击停止按钮，则清除通知栏消息
        if (nm != null) {
            nm.cancel(1);
        }

        // add by zhaoxiaolong
        myApplication.sslvpn = null;

        VerifyTime.writeVerifySuccess(this, false);
        Log.d(VerifyTime.TAG, "TunVpnService onDestroy reset flag");

        OttoUtil.unRegister(this);

        Log.d(TAG, "onDestroy ok");
    }

    private void startWatchingScreen() {

        screenBroadCastReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                String[] pin = new String[2];

                String action = intent.getAction();

                if (action == null) {
                    return;
                }

                Log.d(TAG, "screenBroadCastReceiver onReceive " + action);

                if (Intent.ACTION_SCREEN_ON.equals(action)) {
                    if (myApplication.sslvpn != null && myApplication.sslClientConfig != null) {
                        // 防止 mate8 休眠后没有网络
                        Function.startVpnActivity(context);

                        screenOn = true;
                        myApplication.sslvpn.guardianLearn(GuardianHelper.guardian_option.G_OPT_SCREEN_ON.ordinal(), 0);
                    }
                } else if (Intent.ACTION_SCREEN_OFF.equals(action)) {
                    if (myApplication.sslvpn != null) {
                        screenOn = false;
                        myApplication.sslvpn.guardianLearn(GuardianHelper.guardian_option.G_OPT_SCREEN_OFF.ordinal(), 0);
                    }
                }
            }
        };

        final IntentFilter filter = new IntentFilter();
        filter.addAction(Intent.ACTION_SCREEN_OFF);
        filter.addAction(Intent.ACTION_SCREEN_ON);
        registerReceiver(screenBroadCastReceiver, filter);
    }

    private void stopWatchingScreen() {
        if (screenBroadCastReceiver != null) {
            unregisterReceiver(screenBroadCastReceiver);
        }
    }


    public Builder createBuilder() {
        builder = new Builder();
        return builder;
    }

    public void destroyBuilder() {
        builder = null;
    }

    public Builder getBuilder() {
        return builder;
    }

    public void setBuilder(Builder builder) {
        this.builder = builder;
    }

    private void setRole() {
        int role = myApplication.sslClientConfig.getRole();
        if (role != 0x01 && role != 0x11) {
            byte[] defaultCertId = myApplication.sslClientConfig.getCertId();
            role = Function.generateRole(defaultCertId);
            myApplication.sslClientConfig.setRole(role);
        }
    }

    private void running() {

        Log.d(TAG, "Starting");

        setRole();

        startTunVpn();
    }

    public static void setSessionId(String id) {
        sessionId = id;
        Log.d(TAG, "setSessionId : " + sessionId);
    }

    public int getTunFd() {
        int tunFd = -1;

        if (builder == null) {
            Log.e(TAG, "builder == null");
            return -1;
        }

        if (1 == myApplication.sslClientConfig.transportMode) {//隧道模式
            loadingNativeAppList();
            try {
                if (myApplication.propertiesConfig.getVpnInfoDialog() == 0) {
                    builder.setSession(sessionId).setConfigureIntent(mConfigureIntent);
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                        AppAclList appAclList = myApplication.sslvpn.getAppAclList();
                        if (!appAclList.getRuleList().isEmpty()) { // 优先使用网关下推的应用列表
                            boolean isBlack = appAclList.getAclType() == 0;
                            boolean hasMatched = false;

                            try {
                                for (AppAclRule rule : appAclList.getRuleList()) {
                                    PackageInfo packageInfo = localNativeAppMap.get(rule.getPackageName() + rule.getHashCode());
                                    if (packageInfo != null) {
                                        hasMatched = true; // 存在至少一个应用匹配成功
                                        if (isBlack) {
                                            builder.addDisallowedApplication(rule.getPackageName());
                                        } else {
                                            builder.addAllowedApplication(rule.getPackageName());
                                        }
                                    }
                                }

                                // 如果没有匹配的应用而且是白名单，则禁止所有应用联网
                                // //只有客户端的包可以
                                if (!hasMatched && !isBlack) {
                                    builder.addAllowedApplication(getPackageName());
                                }
                            } catch (PackageManager.NameNotFoundException e) {
                                e.printStackTrace();
                            }


                        } else {
                            if (appAclList.getAclType() == 1)
                            {
                                builder.addAllowedApplication(getPackageName());
                            }
                            else {
                                List<String> disallowedApps = Compatibility.getTunDisallowedApps();
                                if (disallowedApps != null) {
                                    for (String app : disallowedApps) {
                                        try {
                                            builder.addDisallowedApplication(app);
                                        } catch (PackageManager.NameNotFoundException e1) {
                                            e1.printStackTrace();
                                        }
                                    }
                                }
                            }
                        }
                    }
                    mInterface = builder.establish();
                } else {
                    mInterface = builder.establish();
                }
            } catch (IllegalArgumentException e) {
                e.printStackTrace();
                Log.e(TAG, "a parameter is not accepted by the operating system");
                return -1;
            } catch (IllegalStateException e) {
                e.printStackTrace();
                Log.e(TAG, "a parameter cannot be applied by the operating system");
                return -1;
            } catch (SecurityException e) {
                e.printStackTrace();
                Log.e(TAG, "the service is not properly declared in AndroidManifest.xml");
                return -1;
            } catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }

            if (mInterface != null) {
// 				tunFd = mInterface.detachFd();	
                tunFd = mInterface.getFd();
                Log.d(TAG, "tunFd = " + tunFd);

                // add by zhaoxiaolong 2016-06-23
                // MATE8路由生效需要等待0.3秒
                try {
                    Thread.sleep(300);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                // add end

                myApplication.sslClientConfig.setTunFd(tunFd);
                myApplication.sslvpn.setTunFd(tunFd);

                int fd = myApplication.sslvpn.getSSLSocketFd();
                Log.d(TAG, "ssl socket Fd = " + fd);
                if (fd != -1)
                    protect(fd);

            } else {
                Log.e(TAG, "create tun failed");
                return -1;
            }
        }

        return 0;
    }


    private Map<String,PackageInfo> localNativeAppMap = new HashMap<>();
    private void loadingNativeAppList() {
        List<PackageInfo> packageInfos = getPackageManager().getInstalledPackages(PackageManager.GET_SIGNATURES);
        for(PackageInfo packageInfo : packageInfos){
            String shaSign = AppSHAUtil.getAppSHASign(this,packageInfo.packageName);
            String key = packageInfo.packageName+shaSign;
            Log.i("WH","-------key:"+key);
            localNativeAppMap.put(key,packageInfo);
        }
    }

    private String GetTerminalInfo(Context context, byte[] terminalInfo, int[] terminalInfoLen) {
        String strTermInfo = "";
        String cardSN = "";
        TelephonyManager manager = (TelephonyManager) context
                .getSystemService(Context.TELEPHONY_SERVICE);
        String imsi = "000000000000000";// 默认sim卡号
        if (manager.getSimState() != TelephonyManager.SIM_STATE_READY) {
            //没有插入sim卡使用默认sim卡号
        } else {
            imsi = manager.getSubscriberId(); // 获取IMSI号
        }

        String imei = manager.getDeviceId(); // 获取IMEI号

        try {
            if (0 == myApplication.sslClientConfig.getCertMode()) {//硬证书
                byte[] cardId = new byte[64];
                int[] cardIdLen = new int[1];
                int ret = KeyWrapper.getInstance().getSN(cardId, cardIdLen);
                if (ret == 0) {
                    cardSN = new String(cardId, 0, cardIdLen[0]);
                } else {
                    Log.e(TAG, "Get card sn return " + ret);
                    return KeyWrapper.StatusCode.getComment(ret);
                }
            } else {
                cardSN = "0000000000000000000000000000000000000000000000000000000000000000";
            }

            strTermInfo = "ANDROID;" + cardSN + ";" + imei + ";" + imsi;

            Log.d(TAG, "strTermInfo = " + strTermInfo);

            terminalInfoLen[0] = strTermInfo.getBytes().length;

            System.arraycopy(strTermInfo.getBytes(), 0, terminalInfo, 0,
                    terminalInfoLen[0]);
        } catch (Exception e) {
            Log.d(TAG, "Covercard failed." + e.getMessage());
            return getString(R.string.gen_terminal_info_failed);
        }

        return "";
    }

    private void startTunVpn() {
        int nres = -1;

        //byte[] terminalInfo = "ANDROID;".getBytes();
        byte[] terminalInfo = new byte[256];
        int[] terminalInfoLen = {0};

        String strRes = GetTerminalInfo(this.getBaseContext(), terminalInfo, terminalInfoLen);



        if (!strRes.equals("")) {
            errorState = strRes;
            showVpnState(R.drawable.seq_off, getResources().getString(R.string.safe_client), errorState);//显示离线状态
//			startService = false;
            Function.setSafeTunVpnState(getApplicationContext(), false);
            safeVerifySuccess = false;
            stopService = true;
            return;
        }

        if (myApplication.sslvpn != null) {
            myApplication.sslvpn.stopService();
            myApplication.sslvpn.release();
            myApplication.sslvpn = null;
        }

        myApplication.sslvpn = new SSLVPN();

        myApplication.sslClientConfig.setTerminalInfo(terminalInfo);
        myApplication.sslClientConfig.setNetType(
                GuardianHelper.getNetWorkType(myApplication.getApplicationContext()).ordinal());

        nres = myApplication.sslvpn.setParam(myApplication.sslClientConfig);

        if (nres != 0) {
            if (nres == -1134) {
                errorState = getString(R.string.no_cert);
            } else {
                errorState = getString(R.string.invalid_param);
            }

            showVpnState(R.drawable.seq_off, getResources().getString(R.string.safe_client), errorState);//显示离线状态
//			startService = false;
            Function.setSafeTunVpnState(getApplicationContext(), false);
            safeVerifySuccess = false;
            stopService = true;
            return;
        }

        nres = myApplication.sslvpn.startService();

        if (nres != 0) {
            Log.d(TAG, "startService failed");
            errorState = StringUtil.getStringRes(this, R.string.start_service_failed);
            showVpnState(R.drawable.seq_off, getResources().getString(R.string.safe_client), StringUtil.getStringRes(this, R.string.start_service_failed));//显示离线状态
//			startService = false;
            Function.setSafeTunVpnState(getApplicationContext(), false);
            safeVerifySuccess = false;
            stopService = true;
            return;
        }
        startflag = true;

        new Thread(new Runnable() {
            public void run() {
                int res;
                synchronized (lock) {
                    //modify by wangyue
                    sock = new SocketListener("127.0.0.1", myApplication.sslClientConfig.getPrivatePort());
                    res = sock.connect();
                }

                long ctime = System.currentTimeMillis();

                while (res != 0) {
                    if (System.currentTimeMillis() - ctime > 3000) {
                        Log.e(TAG, "connect to 127.0.0.1:" + myApplication.sslClientConfig.getPrivatePort() + " failed");
                        errorState = getString(R.string.connect_service_failed);
                        showVpnState(R.drawable.seq_off, getResources().getString(R.string.safe_client), StringUtil.getStringRes(TunVpnService.this, R.string.connect_service_failed));// 显示离线状态
                        synchronized (lock) {
                            if (sock != null) {
                                sock.close(); // 关闭socket
                                sock = null;
                            }
                        }
                        myApplication.sslvpn.stopService();// 停止服务
//						startService = false;
                        Function.setSafeTunVpnState(getApplicationContext(), false);
                        safeVerifySuccess = false;
                        stopService = true;
                        return;
                    }
                    synchronized (lock) {
                        res = sock.connect();
                    }
                    try {
                        Thread.sleep(1000);
                    } catch (Exception ex) {

                    }
                }
                synchronized (lock) {
                    if (sock != null) {
                        sock.sendData(CONSTANT.CMD_START);
                        vpnstatelen = sock.recvData(vpnstate);
                    }
                }


                if (!Function.getSafeTunVpnState(getApplicationContext())) {
                    stopService = true;
                    SafeVerifyActivity.startService = false;
                }
                synchronized (lock) {
                    if (sock == null) {
                        stopService = true;
                        SafeVerifyActivity.startService = false;
                    }
                }

/*
                while (true) {

					if (!Function.getSafeTunVpnState(getApplicationContext())) {
						Log.d(TAG, "break TunVpnService by file flag");
						break;
					}
					synchronized (lock) {
						if (sock == null) {
							Log.d(TAG, "break TunVpnService by sock null");
							break;
						}
	
						//sock.sendData(CONSTANT.CMD_GET_STATE);
						vpnstatelen = sock.recvData(vpnstate);
					}
					
					// fix by zhaoiaolong MATE8 手机休眠会断开本地socket连接 2016-05-13
					if(vpnstatelen == -1 && Function.getSafeTunVpnState(getApplicationContext())){
						
						Log.d(TAG, "recv len = -1, then reconnect local "+myApplication.sslClientConfig.getPrivatePort());
						// 重连本地服务端口
						synchronized (lock) {
							if (sock != null) {
								res = sock.connect();
							}
						}
						// 多次重连，直到成功或者超时
						ctime = System.currentTimeMillis();
						while (res != 0) {
							// 服务已经停止，不再重连
							if(!Function.getSafeVpnState(getApplicationContext())){
								break;
							}
							
							if (System.currentTimeMillis() - ctime > 3000) {
								Log.e(TAG,"reconnect to 127.0.0.1:"+myApplication.sslClientConfig.getPrivatePort()+" failed");
					
								synchronized (lock) {
									if (sock != null) {								
										sock.close(); // 只关闭socket,不置为null
										Log.e(TAG,"close socket");
									}
								}
								break;    // 退出重连
							}
							// 重连
							synchronized (lock) {
								if (sock != null) {
									res = sock.connect();
								}
							}
						}
					}

					Message message = new Message();
					message.what = 1;
					mHandler.sendMessage(message);
					
//					try {
//						Thread.sleep(500);
//					} catch (InterruptedException e) {
//					}
				}
				stopService = true;
				SafeVerifyActivity.startService = false;
				*/
            }

            ;
        }).start();
    }

    private Handler mHandler = new Handler() {
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1:
                    showState();
                    break;
                case 2:
                    vpnstatelen = msg.getData().getInt("len");
                    vpnstate = msg.getData().getByteArray("content");
                    showState();
                    break;
            }
        }

        ;
    };


    public void stateChange(byte[] state, int len) {
//		vpnstate = state.getBytes();
//		vpnstatelen = len;
        Message message = new Message();
        message.what = 2;
        Bundle bundle = new Bundle();
        bundle.putInt("len", len);
        bundle.putByteArray("content", state);
//		bundle.putString( "content", state );
        message.setData(bundle);
        mHandler.sendMessage(message);
        Intent sendIntent = new Intent("com.xdja.safeclient.statechange");
        sendIntent.putExtra("content", state);
        sendBroadcast(sendIntent);
    }

    private void saveCertifyTime(String data) {

        if (myApplication.sslvpn == null) {
            Log.d(VerifyTime.TAG, "sslvpn is null");
            return;
        }

        String[] state = data.split(" ");
        String success = state[0];
        String stage = state[1];
//		String errorCode = state[2];

        if (!success.equals("OK")) {
            VerifyTime.writeVerifySuccess(this, false);
//			Log.d("认证时间", "认证失败" + success + ":" + stage);
        }

        if (success.equals("OK") && stage.equals("100")) {
//			Log.d("认证时间", "认证成功" + success + ":" + stage);

            //如果上次认证失败或者清除了认证标识，则此次需要存储时间
            if (!VerifyTime.readLastVerifySuccess(this)) {
                VerifyTime.writeVerifyTime(this);
                //无论是否存储认证时间，都要记录此次认证成功
                VerifyTime.writeVerifySuccess(this, true);
            } else {
                //上次认证成功，此次不再认证（这种情况下是在同一次认证过程中的多次认证）
            }

        }
    }

    /**
     * 以通知方式显示Vpn认证过程中状态
     */
    public void showState() {

        saveCertifyTime(new String(vpnstate, 0, vpnstatelen));

        if (vpnstatelen < 0) {
            Log.d(TAG, "vpnstatelen = " + vpnstatelen);
            return;
        }

        if (screenOn == false) {
            //return ;
        }
        // add by zhaoxiaolong 20160604
        if (startflag == false) {
            Log.d(TAG, "service stop, give up status show");
            return;
        }
        int firstindex = 0;
        int lastindex = 0;
        String stageStatus = "";
        String errorStatus = "";
        String errorCode = "";
        String temp = null;
        temp = new String(vpnstate, 0, vpnstatelen);

        try {
            /*
            firstindex = temp.indexOf((int) ' '); // 查找空格第一次出现位置
			lastindex = temp.lastIndexOf((int) ' ');// 查找空格最后一次出现位置

			issuccess = temp.substring(0, firstindex);
			curstage = temp.substring(firstindex + 1, lastindex);
			
			errorStatus = new String(vpnstate, lastindex + 1, vpnstatelen - lastindex - 1, "gbk");
			*/

            String[] arrState = temp.split(" ");
            issuccess = arrState[0];
            curstage = arrState[1];
            errorCode = arrState[2];

            if (Integer.parseInt(errorCode) == -1510) {
                errorStatus = arrState[3];

                if (!errorInfo.equals(errorStatus)) {
                    errorInfoFlag = 1;
                } else {
                    errorInfoFlag = 0;
                }

                errorInfo = errorStatus;
                Log.d(TAG, "errorInfo: " + errorInfo);
            } else {
                // 英文描述有多个空格，所以不能通过定位最后一个空格的方式来确定描述
//                lastindex = temp.lastIndexOf((int) ' ');// 查找空格最后一次出现位置

                // 查找第三次空格出现的下标 xjq,2017-02-10 14:25:54
                // 格式：OK/FAILED stage code errString  所以需要定位第三个空格的位置
                lastindex = StringUtil.getCharacterPosition(temp, " ", 3);
//                errorStatus = new String(vpnstate, lastindex + 1, vpnstateelen - lastindex - 1, "utf8");
                errorStatus = new String(vpnstate, lastindex + 1, vpnstatelen - lastindex - 1, "gbk");
            }
        } catch (Exception e) {
            Log.d(TAG, "vpnstate :" + temp + " len :" + temp.length());
            Log.d(TAG, "firstindex: " + firstindex);
            Log.d(TAG, "lastindex: " + lastindex);
            return;
        }

//		Log.d(TAG, "curstage: " + curstage);
//		Log.d(TAG, "issuccess: " + issuccess);
//		Log.d(TAG, "errorStatus: " + errorStatus);

        // fix by zhaoxiaolong 20160604 解决辅警提示不及时的问题
        if (curstage.compareTo(prestage) != 0 || errorInfoFlag == 1) {
            prestage = curstage;
            SafeVerifyStageInfo stageInfo = new SafeVerifyStageInfo();

            if (curstage.compareTo("20") == 0) {
                stageInfo.name = getString(R.string.init_safe_component);
            } else if (curstage.compareTo("30") == 0) {
                stageInfo.name = getString(R.string.connect_to_safe_gateway);
            } else if (curstage.compareTo("40") == 0) {
                stageInfo.name = StringUtil.getStringRes(this, R.string.safe_verify);
            } else if (curstage.compareTo("50") == 0) {
                stageInfo.name = getString(R.string.bind_verify_info);
            } else if (curstage.compareTo("60") == 0) {
                stageInfo.name = getString(R.string.start_service);
            } else if (curstage.compareTo("100") == 0) {
                if (myApplication.sslClientConfig.transportMode == 0) {
                    stageInfo.name = getString(R.string.safe_tunnel_via_trans_mode);
                } else {
                    stageInfo.name = getString(R.string.safe_tunnel_via_tunnel_mode);
                }
            } else {
                return;
            }

            if (issuccess.compareTo("OK") == 0) {
                stageInfo.result = StringUtil.getStringRes(TunVpnService.this, R.string.success);
                stageStatus = stageInfo.name + stageInfo.result;
            } else {
                stageInfo.result = StringUtil.getStringRes(TunVpnService.this, R.string.fail);
            }
            stageInfo.error = errorStatus;

            sslStageList.add(stageInfo);

            if (SafeVerifyActivity.myTunAdapter != null) {
                SafeVerifyActivity.myTunAdapter.notifyDataSetChanged();
            }


            if (issuccess.compareTo("OK") == 0) {// 成功状态
                if (curstage.compareTo("100") == 0) {
                    safeVerifySuccess = true;
                    errorState = "";
                    showVpnState(R.drawable.seq_on, getResources().getString(R.string.safe_client), stageStatus);// 显示在线状态图标

                    errorInfoFlag = 0;
                    errorInfo = "";

                    // 认证成功之后清楚异常通知栏
                    if (nm != null) {
                        nm.cancel(1);
                    }

                    //后台自动升级  fix by zhaoxiaolong 2016-05-30, bugid:12830
                    //fix 2016-06-23 配置路由后，休眠300毫秒等待路由生效。此处可以直接连接
//                    SCAutoUpdate.updateStart(this, false);//调用升级模块

                    // 加休眠0.5秒，在MATE8上隧道建立后，立即连接，练级升级服务器会失败
					new Handler().postDelayed(new Runnable(){
			    		public void run(){
			    			if(tunVpnObj != null)
			    				SCAutoUpdate.updateStart(tunVpnObj, false);//调用升级模块
			    		}
			    	}, 800);
                } else {
                    connect += 1;
                    if (connect > 4) {
                        connect = 1;
                    }
                    switch (connect) {
                        case 1:
                            showVpnState(R.drawable.seq_conn1, getResources().getString(R.string.safe_client), stageStatus);// 显示连接中图标
                            break;

                        case 2:
                            showVpnState(R.drawable.seq_conn2, getResources().getString(R.string.safe_client), stageStatus);// 显示连接中图标
                            break;

                        case 3:
                            showVpnState(R.drawable.seq_conn3, getResources().getString(R.string.safe_client), stageStatus);// 显示连接中图标
                            break;

                        case 4:
                            showVpnState(R.drawable.seq_conn4, getResources().getString(R.string.safe_client), stageStatus);// 显示连接中图标
                            break;
                    }
                }
            }
            //失败状态
            else {
                Log.e(TAG, "curstage: " + curstage);
                Log.e(TAG, "issuccess: " + issuccess);
                Log.e(TAG, "errorStatus: " + errorStatus);

                safeVerifySuccess = false;
                TunVpnService.errorState = errorStatus;
                showVpnState(R.drawable.seq_off, getResources().getString(R.string.safe_client), errorStatus);// 显示离线状态

                try {
                    if (TunVpnService.mInterface != null) {
                        Log.d(TAG, "TunVpnService.mInterface.close");
                        TunVpnService.mInterface.close();
                        TunVpnService.mInterface = null;
                        if (TunVpnService.tunVpnObj != null) {
                            TunVpnService.tunVpnObj.destroyBuilder();
                        }
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }

                if (myApplication.sslvpn != null) {
                    myApplication.sslvpn.closeTunFd();
                }

                if (errorInfoFlag == 1) {
                    showVpnErrorInfo(R.drawable.tf_locked, getResources().getString(R.string.safe_client), errorInfo);// 显示离线状态
                }
            }

        }
//        Log.d(TAG, issuccess);
    }


    /**
     * 显示vpn认证过程中状态
     */
    public void showVpnState(int icon, String title, String text) {
        if (myApplication.propertiesConfig.getNotification() == 0) {
            Intent intent = new Intent(this, SafeVerifyActivity.class);
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_RESET_TASK_IF_NEEDED);
            intent.putExtra(IntentParam.FLAG_START_FROM_NOTIFICATION, true);


            Notification.Builder builder = new Notification.Builder(this);
            builder.setSmallIcon(icon);
            builder.setWhen(System.currentTimeMillis());
            PendingIntent pendingIntent = PendingIntent.getActivity(this, 0, intent, 0);
            builder.setContentIntent(pendingIntent);
            builder.setContentTitle(title);
            builder.setContentText(text);
            startForeground(Notification.FLAG_ONGOING_EVENT, builder.build());//设置服务为前台
            /*Notification notification = new Notification(icon, null, System.currentTimeMillis());
            PendingIntent contentIntent = PendingIntent.getActivity(this, 0, intent, 0);
            notification.flags = Notification.FLAG_ONGOING_EVENT;// 正在运行
            notification.setLatestEventInfo(this, title, text, contentIntent);
            startForeground(Notification.FLAG_ONGOING_EVENT, notification);//设置服务为前台*/
        }
    }

    private void showVpnErrorInfo(int icon, String title, String text) {
        nm = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
        Notification.Builder builder = new Notification.Builder(this);
        builder.setSmallIcon(icon);
        builder.setWhen(System.currentTimeMillis());
        PendingIntent pendingIntent = PendingIntent.getActivity(this, 0, new Intent(this, SafeVerifyActivity.class), 0);
        builder.setContentIntent(pendingIntent);
        builder.setContentTitle(title);
        builder.setContentText(text);
        //builder.build();
        nm.notify(1,builder.build());
        //Notification nt = new Notification(icon, null, System.currentTimeMillis());
        //PendingIntent pi = PendingIntent.getActivity(this, 0, new Intent(this, SafeVerifyActivity.class), 0);
        //nt.setLatestEventInfo(this, title, text, pi);
        //nm.notify(1, nt);
    }

    @SuppressWarnings(value = "unused")
    @Subscribe
    public void handleExitAppEvent(ExitAppEvent event) {
        handleStopTunEvent(new StopTunEvent());
    }

    @SuppressWarnings(value = "unused")
    @Subscribe
    public void handleStopTunEvent(StopTunEvent event) {

        if (mInterface != null) {
            try {
                mInterface.close();
                mInterface = null;
                if (tunVpnObj != null) {
                    tunVpnObj.destroyBuilder();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
            mInterface = null;
        }

        if (myApplication.sslvpn != null) {
            myApplication.sslvpn.closeTunFd();
        }

        boolean success = stopService(IntentParam.stopTunVpn(this));
        if (success) {
            Function.setSafeTunVpnState(getApplicationContext(), false);
            TunVpnService.stopService = true;
            sslStageList.clear();
        }

    }


}
