package com.xdja.safeclient.activity;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.graphics.BitmapFactory;
import android.os.Bundle;

import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.Log;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.safetf.SafeTF;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.backdoor.BackDoorActivity;

import org.w3c.dom.Text;


public class AboutActivity extends BaseActivity {

    private TextView mVersionName = null;
    private TextView mAPPABI = null;
    private TextView mDriverVersion = null;

    private TextView viewCert;

    private TextView declText = null;

    private ImageView aboutImage;

    //进入后门的计数器
    int clickCount = 0;

    private Button exitDebug;

    MyApplication myApplication = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_about);

        myApplication = (MyApplication) getApplication();

        mVersionName = (TextView) findViewById(R.id.version_name_text);
        mAPPABI = (TextView) findViewById(R.id.APP_ABI);

        viewCert = (TextView) findViewById(R.id.view_cert);
        viewCert.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(AboutActivity.this, CertSetActivity.class);
                intent.putExtra(CertSetActivity.FLAG_JUST_SHOW, true);
                startActivity(intent);
            }
        });

        mLeftBtn = (ImageView) findViewById(R.id.titlebar_leftbtn);
        mRightBtn = (ImageView) findViewById(R.id.titlebar_rightbtn);
        mTitleText = (TextView) findViewById(R.id.titlebar_text);
        declText = (TextView)findViewById(R.id.declaration_text);

        declText.setText(Compatibility.getDeclaration());

        String strVerName = getVersionName();

        if (strVerName != null) {
            mVersionName.setText(getString(R.string.about_version_name) + strVerName);
        }

        if (myApplication.propertiesConfig.getmArmOrX86() == 1) {
            mAPPABI.setText(R.string.app_abi_x86);
        } else {
            mAPPABI.setText(R.string.app_abi_arm);
        }

        Log.d("AboutActivity", "driver version : " + getDriverVersion());
        mDriverVersion = (TextView) findViewById(R.id.driver_version);
        mDriverVersion.setText(getString(R.string.driver_version) + getDriverVersion());

        aboutImage = (ImageView) findViewById(R.id.about_image);
//        aboutImage.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                clickCount++;
//                if (clickCount % 5 == 0) {
//                    exitDebug.setVisibility(View.VISIBLE);
//                    showNotification();
//                    openLynxActivity();
//                }
//            }
//        });


        exitDebug = (Button) findViewById(R.id.exit_debug);
        exitDebug.setVisibility(View.GONE);
        exitDebug.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                exitDebug.setVisibility(View.GONE);

            }
        });

        initLeftBtn();

        initTitleText();

        myApplication.activityList.add(this);
        myApplication.topActivity = this;

    }

    private void openLynxActivity() {
//        LynxConfig lynxConfig = new LynxConfig();
//        lynxConfig.setMaxNumberOfTracesToShow(10000)
//                .setFilterTraceLevel(TraceLevel.INFO)
//                .setFilter("WTF");


//        Intent lynxActivityIntent = LynxActivity.getIntent(this, lynxConfig);
//        startActivity(lynxActivityIntent);
        Intent intent = new Intent(AboutActivity.this, LogDebugActivity.class);
        startActivity(intent);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();

//        cancelNotification();

        if (myApplication.activityList != null) {
            myApplication.activityList.remove(this);
        }
    }

    private String getDriverVersion() {
        String version = "";
        SafeTF tf = new SafeTF();

        version = tf.GetVersion();

        return version;
    }

    private String getVersionName() {
        PackageManager packManager = null;
        PackageInfo packInfo = null;

        packManager = getPackageManager();

        try {
            packInfo = packManager.getPackageInfo(getPackageName(), 0);
            return packInfo.versionName;
        } catch (NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }

    }

    @Override
    protected void initTitleText() {
        super.initTitleText();
        mTitleText.setText(R.string.about);
    }

//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleExitAppEvent(ExitAppEvent event) {
//        super.handleExitAppEvent(event);
//    }
//
//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleFinishEvent(FinishActivityEvent event) {
//        super.handleFinishEvent(event);
//    }


    private NotificationManager getNM() {
        NotificationManager nm = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
        return nm;
    }


    private void showNotification() {

        Notification.Builder builder = new Notification.Builder(this);
        builder.setContentIntent(PendingIntent.getActivity(this, 0, new Intent(this, LogDebugActivity.class), PendingIntent.FLAG_CANCEL_CURRENT));
        builder.setSmallIcon(R.drawable.ic_launcher1);
        builder.setAutoCancel(false);
        builder.setOngoing(true);
        builder.setWhen(System.currentTimeMillis());
        builder.setContentTitle("点击");
        builder.setContentText("查看日志");

        Notification notification = builder.build();
        getNM().notify(888, notification);

    }

    private void cancelNotification() {
        getNM().cancel(888);
    }


}
