package com.xdja.safeclient.activity;

import android.media.Image;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;

import com.xdja.key.KeyWrapper;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.Log;

import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.utils.StringUtil;
import com.xdja.sslvpn.CONSTANT;
import com.xdja.sslvpn.SslvpnStatus;

import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import static com.xdja.safeclient.utils.StringUtil.getStringRes;

public class CurrentStatusActivity extends BaseActivity {

    TextView tv_transportMode = null;
    TextView tv_listenPortText = null;
    TextView tv_listenPort = null;
    TextView tv_recvDataPackage = null;
    TextView tv_sendDataPackage = null;
    TextView tv_serviceStarttime = null;
    TextView tv_breaklineRetryconnectCount = null;
    TextView tv_netDelay = null;
    TextView tv_name = null;
    TextView tv_dep = null;
    TextView tv_nameText = null;
    TextView tv_depText = null;

    public byte[] vpncurstate = new byte[4096];

    private String TAG = "CurrentStatusActivity";

    public static SslvpnStatus sslvpnStatus = new SslvpnStatus();

    private MyApplication myApplication = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_current_status);

        mLeftBtn = (ImageView) findViewById(R.id.titlebar_leftbtn);
        mTitleText = (TextView) findViewById(R.id.titlebar_text);

        mTitleText.setText(getString(R.string.currentstatus));
        initLeftBtn();

        tv_transportMode = (TextView) findViewById(R.id.transportmode);
        tv_listenPortText = (TextView) findViewById(R.id.listenporttext);
        tv_listenPort = (TextView) findViewById(R.id.listenport);
        tv_recvDataPackage = (TextView) findViewById(R.id.recvdatapackage);
        tv_sendDataPackage = (TextView) findViewById(R.id.senddatapackage);
        tv_serviceStarttime = (TextView) findViewById(R.id.serverstarttime);
        tv_breaklineRetryconnectCount = (TextView) findViewById(R.id.breaklineretryconnectcount);
        tv_netDelay = (TextView) findViewById(R.id.netdelay);

        tv_name = (TextView) findViewById(R.id.person_name);
        tv_dep = (TextView) findViewById(R.id.person_dep);
        tv_nameText = (TextView) findViewById(R.id.person_name_text);
        tv_depText = (TextView) findViewById(R.id.person_dep_text);

        if (!Compatibility.showPersionInfo()) {
            tv_name.setVisibility(View.GONE);
            tv_dep.setVisibility(View.GONE);
            tv_nameText.setVisibility(View.GONE);
            tv_depText.setVisibility(View.GONE);
        }

        myApplication = (MyApplication) getApplication();
        myApplication.activityList.add(this);
        myApplication.topActivity = this;

        if (0 == myApplication.sslClientConfig.transportMode) {

            SslvpnStatus sslvpnStatus = new SslvpnStatus();

            myApplication.sslvpn.getStatus(sslvpnStatus);

            tv_transportMode.setText(getStringRes(this, R.string.mode_trans));
            tv_listenPortText.setText(R.string.listenport);
            tv_listenPort.setText(sslvpnStatus.listenPortList);

            tv_recvDataPackage.setText(sslvpnStatus.recvDataSize + "KB");
            tv_sendDataPackage.setText(sslvpnStatus.sendDataSize + "KB");

			/* modified by majp 2013-12-02 start bug id 1390 */
            if (sslvpnStatus.dataServerStartTime < 60) {
                tv_serviceStarttime.setText(sslvpnStatus.dataServerStartTime + getStringRes(this, R.string.second));
            } else {
                tv_serviceStarttime.setText(sslvpnStatus.dataServerStartTime / 60 + getStringRes(this, R.string.minute)
                        + sslvpnStatus.dataServerStartTime % 60 + getStringRes(this, R.string.second));
            }
            /* modified by majp 2013-12-02 end bug id 1390 */
            //tv_breaklineRetryconnectCount.setText(sslvpnStatus.breaklineRetryconnectCount + "次");

            //fix by zhaoxiaolong 2016-06-01
            tv_breaklineRetryconnectCount.setText(sslvpnStatus.breaklineRetryconnectCount / 10 + getStringRes(this, R.string.count));
            tv_netDelay.setText(sslvpnStatus.netDelay + getStringRes(this, R.string.millisecond));

        } else {
            Log.d(TAG, "tunsportMode == 1");

            new Thread(new Runnable() {
                public void run() {
                    getCurSslvpnStatus(sslvpnStatus);

                    Message message = new Message();
                    message.what = 1;
                    mHandler.sendMessage(message);

                    if (Compatibility.showPersionInfo()) {
                        // 更新人员信息
                        String cardSN;
                        byte[] cardId = new byte[64];
                        int[] cardIdLen = new int[1];
                        int ret = KeyWrapper.getInstance().getSN(cardId, cardIdLen);
                        if (ret == 0) {
                            cardSN = new String(cardId, 0, cardIdLen[0]);
                        } else {
                            Log.e(TAG, "Get card sn return " + ret);
                            return;
                        }

                        // test card sn 78646a6178646a6134355532370a2d48
                        String strUrlPath = "http://192.168.20.72:58083/pams/scms/readcardcontroller/readcardinfo.do?cardNO=" + cardSN.toLowerCase();
                        Log.d(TAG, "Request url : " + strUrlPath);
                        InputStream is = null;
                        String resultData = "";
                        HttpURLConnection conn = null;//声明连接对象
                        try {
                            URL url = new URL(strUrlPath); //URL对象
                            conn = (HttpURLConnection) url.openConnection(); //使用URL打开一个链接,下面设置这个连接
                            conn.setRequestMethod("GET"); //使用get请求

                            if (conn.getResponseCode() == 200) {//返回200表示连接成功
                                is = conn.getInputStream(); //获取输入流
                                InputStreamReader isr = new InputStreamReader(is);
                                BufferedReader bufferReader = new BufferedReader(isr);
                                String inputLine = "";
                                while ((inputLine = bufferReader.readLine()) != null) {
                                    resultData += inputLine + "\n";
                                }
                                message = new Message();
                                message.what = 2;
                                message.obj = resultData;
                                mHandler.sendMessage(message);

                                conn.disconnect();
                            }

                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }

                ;
            }).start();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d(TAG, "onDestroy");
        if (myApplication.activityList != null) {
            myApplication.activityList.remove(this);
        }
    }

    private Handler mHandler = new Handler() {
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1:
                    setPage();
                    break;
                case 2:
                    String result = (String) msg.obj;
                    setNameAndDepartment(result);
                    break;
            }
        }

        ;
    };

    //{"flag":"1","obj":{"cardtype":"TF","sex":"男","policeCode":"22","police":"其他","depCode":"420106000000","name":"测试一","depName":"武汉市公安局武昌区分局","grade":"3","code":"000001","identifier":"000000000000000001","mobile":"18286059598"}}
    private void setNameAndDepartment(String result) {

        try {
            //将json字符串jsonData装入JSON数组，即JSONArray
            //jsonData可以是从文件中读取，也可以从服务器端获得
            JSONArray jsonArray = new JSONArray("["+result+"]");
            for (int i = 0; i< jsonArray.length(); i++) {
                //循环遍历，依次取出JSONObject对象
                //用getInt和getString方法取出对应键值
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                int flag = jsonObject.getInt("flag");
                if (flag == 0) {
                    tv_name.setText(R.string.unknown);
                    tv_dep.setText(R.string.unknown);
                    return;
                }

                JSONObject personInfoObj = jsonObject.getJSONObject("obj");
                String name = personInfoObj.getString("name");
                String depName = personInfoObj.getString("depName");
                tv_name.setText(name);
                tv_dep.setText(depName);
            }
        } catch (Exception e) {
            e.printStackTrace();
            tv_name.setText(R.string.unknown);
            tv_dep.setText(R.string.unknown);
        }
    }

    private void setPage() {
        tv_transportMode.setText(getStringRes(this, R.string.mode_tunnel));
        tv_listenPortText.setText(R.string.protectsubnet);
        String[] temp = sslvpnStatus.protectNetworksegmentList.split(",");
        StringBuffer str = new StringBuffer();
        for (String ip : temp) {
            str.append(ip + "\n");
        }
        tv_listenPort.setText(str.toString());

        tv_recvDataPackage.setText(sslvpnStatus.recvDataSize + "KB");
        tv_sendDataPackage.setText(sslvpnStatus.sendDataSize + "KB");

		/* modified by majp 2013-12-02 start bug id 1390 */
        if (sslvpnStatus.dataServerStartTime < 60) {
            tv_serviceStarttime.setText(sslvpnStatus.dataServerStartTime + getStringRes(this, R.string.second));
        } else {
            tv_serviceStarttime.setText(sslvpnStatus.dataServerStartTime / 60 + getStringRes(this, R.string.minute)
                    + sslvpnStatus.dataServerStartTime % 60 + getStringRes(this, R.string.second));
        }
        /* modified by majp 2013-12-02 end bug id 1390 */
        //tv_breaklineRetryconnectCount.setText(sslvpnStatus.breaklineRetryconnectCount + "次");

        //fix by zhaoxiaolong 2016-06-01
        tv_breaklineRetryconnectCount.setText(sslvpnStatus.breaklineRetryconnectCount / 10 + StringUtil.getStringRes(this, R.string.count));
        tv_netDelay.setText(sslvpnStatus.netDelay + getStringRes(this, R.string.millisecond));
    }

    /**
     * @param sslvpnStatus
     */
    private void getCurSslvpnStatus(SslvpnStatus sslvpnStatus) {
        String temp = null;
        int vpnstatelen = 0;
        byte[] vpnstate = new byte[4096];
        int res = myApplication.sslvpn.getStatus(sslvpnStatus);
        if (res != 0 || sslvpnStatus == null) {
            return;
        }

        Log.d("CurrentStateActivity", "vpnstatelen = " + vpnstatelen);

        Log.d("CurrentStateActivity", "vpnstate = " + temp);

        if (vpnstatelen <= 0) {
            Log.d("CurrentStateActivity", "vpnstatelen = " + vpnstatelen);
            return;
        }

//		temp = new String(vpnstate, 0, vpnstatelen);
//		
//		String[] arrayStr = temp.split("#");
//		
//		sslvpnStatus.transportMode = Integer.parseInt(arrayStr[0]);
//		
//		sslvpnStatus.listenPortList = arrayStr[1];
//		
//		sslvpnStatus.protectNetworksegmentList = arrayStr[2];
//
//		sslvpnStatus.monitorserverporxyport = arrayStr[3];
//		
//		sslvpnStatus.monitorserverporxyport = arrayStr[4];
//
//		sslvpnStatus.monitorSrvIp = arrayStr[5];
//
//		sslvpnStatus.sendDataSize = Integer.parseInt(arrayStr[6]);
//
//		sslvpnStatus.recvDataSize = Integer.parseInt(arrayStr[7]);
//
//		sslvpnStatus.dataServerStartTime = Integer.parseInt(arrayStr[8]);
//
//		sslvpnStatus.breaklineRetryconnectCount = Integer.parseInt(arrayStr[9]);
//
//		sslvpnStatus.netDelay = Integer.parseInt(arrayStr[10]);
    }

//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleExitAppEvent(ExitAppEvent event) {
//        super.handleExitAppEvent(event);
//    }
//
//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleFinishEvent(FinishActivityEvent event) {
//        super.handleFinishEvent(event);
//    }

}
