package com.xdja.safeclient.activity;

import java.util.ArrayList;

import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.adapter.ListViewAdapter;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.utils.FileUtil;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.xdja.safeclient.utils.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;


public class LogQueryActivity extends BaseActivity {
    private ProgressBar progressBar = null;
    private String pathStr;
    //	private final String mLogFileName = "log.txt";
    private final String mLogFileName = "safeclient.log";
    private String mLogFilePath;
    private ArrayList<String> mStrArray = null;

    private ListView mLogQueryListView = null;
    private ListViewAdapter mAdapter = null;

    private MyApplication myApplication = null;

    Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0:
                    setListItems();
                    break;
                default:
                    break;
            }
        }

    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_log_query);

        pathStr = this.getFilesDir().getAbsolutePath() + "/";
//		pathStr = "/sdcard/";
        mLogFilePath = pathStr + mLogFileName;

		/* test code start */
        /*
        final File file = new File(mLogFilePath);
		if (!file .exists()) {
			FileUtil.copyAssetsToPrivatePath(this, mLogFileName, file);
		}
		*/
        /* test code end */

        progressBar = (ProgressBar) findViewById(R.id.log_query_progressbar);
		
		/* 初始化列表 */
        mStrArray = new ArrayList<String>();
        initListView();

        mLeftBtn = (ImageView) findViewById(R.id.titlebar_leftbtn);
        mRightBtn = (ImageView) findViewById(R.id.titlebar_rightbtn);
        mTitleText = (TextView) findViewById(R.id.titlebar_text);

        initLeftBtn();

        initTitleText();

        myApplication = (MyApplication) getApplication();
        myApplication.activityList.add(this);
        myApplication.topActivity = this;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d("LogQueryActivity", "onDestroy");
        mStrArray.clear();
        mStrArray = null;
        mAdapter = null;
        mHandler = null;

        if (myApplication.activityList != null) {
            myApplication.activityList.remove(this);
        }
    }

    /**
     * 初始化链表
     */
    private void initListView() {

        mLogQueryListView = (ListView) findViewById(R.id.log_query_listview);

        Log.d("before initListView", "mStrArray.size() = " + mStrArray.size());

        if (progressBar != null) {
            progressBar.setVisibility(View.VISIBLE);
        }

        FileUtil.readLogOfCurDay(mLogFilePath, mStrArray, mHandler);

        if (progressBar != null) {
            progressBar.setVisibility(View.INVISIBLE);
        }
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return super.onKeyDown(keyCode, event);
    }

    /**
     * 初始化链表项
     */
    private void setListItems() {

        if (mStrArray == null) {
            return;
        }

        mAdapter = new ListViewAdapter(this, mStrArray,
                R.layout.list_tiem_log_query, R.id.logquerylistItemText) {

            @Override
            public boolean isEnabled(int position) {
                return false;
            }

            @Override
            public void setBackground(int position, View convertView) {
                //设置无背景
                return;
            }

        };
        Log.d("after setListItems", "mAdapter.getCount() = " + mAdapter.getCount());
        Log.d("after setListItems", "mStrArray.size() = " + mStrArray.size());
        mLogQueryListView.setAdapter(mAdapter);

        if (progressBar != null) {
            progressBar.setVisibility(View.INVISIBLE);
        }
    }

    protected void initTitleText() {
        super.initTitleText();
        mTitleText.setText(R.string.log_query);
    }

//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleExitAppEvent(ExitAppEvent event) {
//        super.handleExitAppEvent(event);
//    }
//
//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleFinishEvent(FinishActivityEvent event) {
//        super.handleFinishEvent(event);
//    }

}
