package com.xdja.safeclient.activity;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.event.TelnetResultCallback;
import com.xdja.safeclient.ui.AlertUtil;


/**
 * Created by xingjianqiang on 2018/1/24.
 */

public class NetworkCheckActivity extends BaseActivity {
    private TextView networkStatus;
    private Button checkBt;
    private EditText telnetIPEt;
    private EditText telnetPortEt;
    private static final String TAG = "NetworkCheckActivity";
    private TelephonyManager telephonyManager;
    private PhoneStateListener listener;

    private static final int NETWORK_WIFI = 0;
    private static final int NETWORK_4G = 1;
    private static final int NETWORK_2G = 2;
    private static final int NETWORK_NONE = 3;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_network_check);

        networkStatus = (TextView)findViewById(R.id.network_status);
        checkBt = (Button)findViewById(R.id.telnet_test);
        telnetIPEt = (EditText)findViewById(R.id.telnet_ip);
        telnetPortEt = (EditText)findViewById(R.id.telnet_port);

        mLeftBtn = (ImageView) findViewById(R.id.titlebar_leftbtn);
        mRightBtn = (ImageView) findViewById(R.id.titlebar_rightbtn);
        mTitleText = (TextView) findViewById(R.id.titlebar_text);


        telephonyManager = (TelephonyManager)getSystemService(TELEPHONY_SERVICE);
        telnetIPEt.setText(new String(MyApplication.myApplication.sslClientConfig.gateWayIp));
        telnetPortEt.setText(String.valueOf(MyApplication.myApplication.sslClientConfig.gateWayPort));

        checkBt.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                telnetTest();
            }
        });

        listener = new PhoneListener();
        telephonyManager.listen(listener, PhoneStateListener.LISTEN_SIGNAL_STRENGTHS);


        checkBt.callOnClick();

        initLeftBtn();
        initTitleText();
    }

    @Override
    protected void onResume() {
        super.onResume();
        telephonyManager.listen(listener, PhoneStateListener.LISTEN_SIGNAL_STRENGTHS);
    }



    @Override
    protected void onPause() {
        super.onPause();
        telephonyManager.listen(listener, PhoneStateListener.LISTEN_NONE);
    }

    private class PhoneListener extends PhoneStateListener {
        @RequiresApi(api = Build.VERSION_CODES.M)
        @Override
        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            super.onSignalStrengthsChanged(signalStrength);
            // 获取信号级别
            int level = signalStrength.getLevel();

            int networkType = getNetworkType();
            StringBuffer status = new StringBuffer();
            status.append(getString(R.string.current_network));
            switch (networkType) {
                case NETWORK_WIFI:
                    status.append("wifi");
                    break;
                case NETWORK_4G:
                    status.append("4G");
                    break;
                case NETWORK_2G:
                    status.append("2G");
                    break;
                case NETWORK_NONE:
                    status.append(getString(R.string.no_network));
                    break;
            }
            status.append("." + getString(R.string.signal_strength) +level);
            networkStatus.setText(status.toString());

        }
    }

    private void updateSignal() {

    }

    private void telnetTest() {
        String ip = telnetIPEt.getEditableText().toString();
        int port = Integer.parseInt(telnetPortEt.getEditableText().toString());
        checkBt.setClickable(false);

        checkBt.setText(getString(R.string.connecting));
        Function.telnet(ip, port, 10000, new TelnetResultCallback() {
            @Override
            public void onTimeout() {
                MyApplication.myApplication.getHandler().post(new Runnable() {
                    @Override
                    public void run() {
                        AlertUtil.popAlert(NetworkCheckActivity.this, getString(R.string.alert),getString(R.string.connect_timeout));
                        checkBt.setClickable(true);
                        checkBt.setText(getString(R.string.connect));
                    }
                });
            }

            @Override
            public void onSuccess() {
                MyApplication.myApplication.getHandler().post(new Runnable() {
                    @Override
                    public void run() {
                        AlertUtil.popAlert(NetworkCheckActivity.this, getString(R.string.alert), getString(R.string.connect_success));
                        checkBt.setClickable(true);
                        checkBt.setText(getString(R.string.connect));
                    }
                });

            }

            @Override
            public void onError(final int err) {
                MyApplication.myApplication.getHandler().post(new Runnable() {
                    @Override
                    public void run() {
                        AlertUtil.popAlert(NetworkCheckActivity.this, getString(R.string.alert), getString(R.string.connect_error)+err);
                        checkBt.setClickable(true);
                        checkBt.setText(getString(R.string.connect));
                    }
                });
            }
        });
    }
    @Override
    protected void onDestroy() {
        super.onDestroy();
    }


    @Override
    protected void initTitleText() {
        super.initTitleText();
        mTitleText.setText(R.string.network_check);
    }

    private int getNetworkType(){
        ConnectivityManager cm = (ConnectivityManager)getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            String netType = networkInfo.getTypeName();
            if (netType.equalsIgnoreCase("WIFI")) {
                return NETWORK_WIFI;
            } else if(netType.equalsIgnoreCase("MOBILE")){
                return isFastMobileNetwork()? NETWORK_4G:NETWORK_2G;
            } else {
                return NETWORK_NONE;
            }
        }

        return NETWORK_NONE;
    }
    private boolean isFastMobileNetwork() {
        if (telephonyManager.getNetworkType() == TelephonyManager.NETWORK_TYPE_LTE) {
            return true;
        }
        return false;
    }


}
