package com.xdja.safeclient.activity.sz;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.xdja.safeclient.utils.Log;

import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.utils.FileUtil;
import com.xdja.sslvpn.SocketListener;
import com.xdja.sslvpn.api.VPN;
import com.xdja.sslvpn.api.VPNApi;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class StartVpnActivity extends Activity {
    private String TAG = "SZStartVpnActivity";
    private final static int start_tunvpn_ok = 0;
    private final static int start_tunvpn_failed = -1;
    private final static int user_not_permit = -2;

    private VPN vpnApi;
    private String userPin;
    private long connectTime = 30000;

    private String mLogFileName = "call_safeclient.log";
    private String filePath;
    File externalFilesDir;
    File targetFile;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        userPin = getIntent().getStringExtra("PIN");
        vpnApi = new VPN(this);
        buildPrivateLogPath();
        buildTargetLogPath();
        Log.i(TAG,"----------onCreate");
        writeData("----------onCreate");
        writeData("---------call StartVpnActivity");
        startTunVpnService();
    }

    void buildPrivateLogPath(){
        String appPrivatePath = this.getFilesDir().getAbsolutePath() + "/";
        File dirPath = new File(appPrivatePath);
        if(!dirPath.exists()){
            dirPath.mkdirs();
        }
        filePath = dirPath.getAbsolutePath()+"/"+mLogFileName;
    }

    void buildTargetLogPath(){
        externalFilesDir = getExternalFilesDir(null);
        if(externalFilesDir != null){
            targetFile = new File(externalFilesDir.getPath() + "/" + mLogFileName);
        }else{
            Log.i(TAG,"buildTargetLogPath---------externalFilesDir error");
            writeData("---------buildTargetLogPath-->externalFilesDir error");
        }
    }



    public void startTunVpnService() {
        writeData("call startTunVpnSerivce()");
        Intent itt = android.net.VpnService.prepare(this);
        if (itt != null) {
            Log.d(TAG, "startActivityForResult...");
            writeData("first start...vpn");
            writeData("call startTunVpnSerivce()--->startActivityForResult(itt,0)");
            startActivityForResult(itt, 0);
            FileUtil.copeFile(new File(filePath),targetFile);
        } else {
            Log.d(TAG, "onActivityResult...");
            writeData("N*** start...vpn");
            //writeData("call startTunVpnSerivce()--->onActivityResult(0, RESULT_OK, null)");
            //onActivityResult(0, RESULT_OK, null);
            Intent intent = new Intent(this, TunVpnService.class);
            intent.putExtra("SafePin", userPin);
            ComponentName name = startService(intent);
            if(name == null){
                Log.i(TAG,"烽火调用启动安全客户端出错--------");
                writeData("烽火调用启动安全客户端出错--------");
                setResult(RESULT_CANCELED);
            }else{
                Log.i(TAG,"烽火调用-----服务启动----开始轮询连接网关状态");
                writeData("烽火调用-----服务启动----开始轮询连接网关状态");
                looperStatus = new LooperStatus();
                looperStatus.execute();
            }
        }
    }
    LooperStatus looperStatus;
    class LooperStatus extends AsyncTask<Void,Void,Integer>{
        @Override
        protected Integer doInBackground(Void... params) {
            long curTime = System.currentTimeMillis();
            VPNApi.StateResult result;
            do {
                result = vpnApi.getStatus();
                if (result.getCode() == VPNApi.CONNECTED) {
                    Log.i(TAG,"轮询状态查询----连接成功");
                    writeData("轮询状态查询----连接成功");
                    writeData("vpn connect success");
                    return VPNApi.CONNECTED;
                }

                if (result.getCode() == VPNApi.CONNECTING) {
                    Log.i(TAG,"轮询状态查询----连接中.......");
                    Log.e(TAG, "CONNECTING " + result.getComment() + ":" + result.getOriginalCode());
                    writeData("轮询状态查询----连接中.......");
                    writeData("vpn connect is  CONNECTING");
                }

                if (result.getCode() == VPNApi.FAILED) {
                    Log.i(TAG,"轮询状态查询----连接失败.......");
                    writeData("轮询状态查询----连接失败.......");
                    writeData("vpn connect is  FAILED");
                    return VPNApi.FAILED;
                }

                if (System.currentTimeMillis() - curTime > connectTime) {
                    Log.i(TAG,"轮询状态查询----连接超时.......失败");
                    writeData("轮询状态查询----连接超时.......失败");
                    writeData("vpn connect timeout");
                    return VPNApi.FAILED;
                }

                if (result.getCode() == VPNApi.APP_NOT_STARTED) {
                    vpnApi.start();
                }

                try {
                    Thread.sleep(500);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }

            } while (true);
        }

        @Override
        protected void onPostExecute(Integer result) {
            super.onPostExecute(result);
            Intent intent = getIntent();
            intent.putExtra("Package", "com.xdja.sjj1320client");
            intent.putExtra("Activity", "StartVpnActivity");
            if(result == VPNApi.CONNECTED){
                Log.i(TAG,"轮询状态>>>结果...连接成功");
                writeData("轮询状态>>>结果...连接成功 ");
                writeData("onPostExecute---- ");
                setResult(RESULT_OK, intent);
            }else {
                Log.i(TAG,"轮询状态>>>结果...连接失败");
                writeData("轮询状态>>>结果...连接失败");
                writeData("onPostExecute----result_canceled");
                setResult(RESULT_CANCELED, intent);
            }
            Log.i(TAG,"-------------filePath:"+filePath);
            Log.i(TAG,"-------------targetFile:"+targetFile);
            FileUtil.copeFile(new File(filePath),targetFile);
            writeData("轮询状态>>>关闭activity");
            finish();
        }
    }



    Task task;
    @Override
    protected void onActivityResult(int request, int result, Intent data) {
        int permit = 0;
        if (RESULT_OK == result) {
            Log.d(TAG, "onActivityResult , user permit");
            Intent ittTunVpn = new Intent(this, TunVpnService.class);
            if (!"".equals(userPin) && userPin != null) {
                ittTunVpn.putExtra("SafePin", userPin);
            }
            ComponentName name = startService(ittTunVpn);
            if (name == null) {
                Log.i(TAG, "start TunVpnService failed");
                permit = start_tunvpn_failed;
            } else {
                Log.i(TAG, "start TunVpnService success " + name.toString());
                permit = start_tunvpn_ok;
            }
        } else {
            permit = user_not_permit;
            Log.i(TAG, "onActivityResult , user not permit:" + result);
        }
        writeData("onActivityResult-------permit:"+permit);
        task = new Task();
        task.execute(permit);
    }

    private class Task extends AsyncTask<Integer, Integer, Integer> {
        @Override
        protected Integer doInBackground(Integer... params) {
            if (params[0] != start_tunvpn_ok) {
                Log.i(TAG, "start TunVpnService error:" + params[0]);
                return VPNApi.FAILED;
            }
            long curTime = System.currentTimeMillis();
            VPNApi.StateResult result;
            do {
                result = vpnApi.getStatus();
                if (result.getCode() == VPNApi.CONNECTED) {
                    writeData("vpn connect success");
                    return VPNApi.CONNECTED;
                }

                if (result.getCode() == VPNApi.CONNECTING) {
                    Log.e(TAG, "CONNECTING " + result.getComment() + ":" + result.getOriginalCode());
                    writeData("vpn connect is  CONNECTING");
                }

                if (result.getCode() == VPNApi.FAILED) {
                    writeData("vpn connect is  FAILED");
                    return VPNApi.FAILED;
                }

                if (System.currentTimeMillis() - curTime > connectTime) {
                    writeData("vpn connect timeout");
                    return VPNApi.FAILED;
                }
                try {
                    Thread.sleep(500);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }

            } while (true);
        }

        @Override
        protected void onPostExecute(Integer result) {
            Log.i(TAG,"onPostExecute");
            Intent intent = getIntent();
            intent.putExtra("Package", "com.xdja.sjj1320client");
            intent.putExtra("Activity", "StartVpnActivity");
            if(result == VPNApi.CONNECTED){
                writeData("onPostExecute---- ");
                setResult(RESULT_OK, intent);
            }else {
                writeData("onPostExecute----result_canceled");
                setResult(RESULT_CANCELED, intent);
            }
            Log.i(TAG,"-------------filePath:"+filePath);
            Log.i(TAG,"-------------targetFile:"+targetFile);
            FileUtil.copeFile(new File(filePath),targetFile);
            finish();
        }
    }

    private void writeData(String content){
        FileOutputStream fos = null;
        BufferedWriter bw = null;
        try {
            fos = new FileOutputStream(filePath, true);
            bw = new BufferedWriter(new OutputStreamWriter(fos));
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timeline = dateFormat.format(new Date());
            bw.write(timeline + " :" + content + "\r\n");
            bw.flush();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (bw != null) {
                    bw.close();//关闭缓冲流
                }
                if(fos != null){
                    fos.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.i(TAG,"-------------关闭烽火  startVpnActivity");
        if(task != null && !task.isCancelled()){
            task.cancel(true);
            task = null;
        }

        if(looperStatus != null && !looperStatus.isCancelled()){
            looperStatus.cancel(true);
            looperStatus = null;
        }
    }
}
