package com.xdja.safeclient.adapter;

import java.util.ArrayList;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import com.xdja.safeclient.R;

public class ListViewAdapter extends BaseAdapter {
	private ArrayList<String> mListItems;
	private int mResource;
	private int mItemTextViewId;
	private LayoutInflater mLayoutInflater;

	public ListViewAdapter(Context mContext, ArrayList<String> mListItems,
			int mResource, int mItemTextViewId) {
		super();
		this.mListItems = mListItems;
		this.mResource = mResource;
		this.mItemTextViewId = mItemTextViewId;
		this.mLayoutInflater = (LayoutInflater) mContext
				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
	}

	@Override
	public int getCount() {
		return mListItems.size();
	}

	@Override
	public Object getItem(int position) {
		return mListItems.get(position);
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {

		ViewHolder holder;

		if (convertView == null) {
			convertView = mLayoutInflater.inflate(mResource, null);
			holder = new ViewHolder();

			holder.text = (TextView) convertView.findViewById(mItemTextViewId);

			convertView.setTag(holder);
		} else {
			holder = (ViewHolder) convertView.getTag();
		}
		
		/* 设置item的背景 */
		setBackground(position,convertView);
		
		/* 设置item的属性 */
		setItemViewAttribute(holder.text);

		bindView(holder.text, mListItems.get(position));

		return convertView;
	}

	private void bindView(View view, String str) {
		if (view instanceof TextView) {
			((TextView) view).setText(str);
		}
	}

	public View setItemViewAttribute(View view) {
		return view;
	}

	static class ViewHolder {
		TextView text;
	}
	
	/**
	 * 设置item的背景
	 * @param position
	 * @param convertView
	 */
	public void setBackground(int position,View convertView) {
		convertView.setBackgroundResource(getListItemBG(position));
	}

	private int getListItemBG(int position) {

		if (1 == mListItems.size()) {
			return R.drawable.list_item_single;
		}
		
		if (position == 0) {
			return R.drawable.list_item_top;
		}
		
		if (position == mListItems.size() - 1) {
			return R.drawable.list_item_bottom;
		}

		return R.drawable.list_item_middle;
	}
	
}
