package com.xdja.safeclient.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.xdja.safeclient.R;
import com.xdja.safeclient.bean.LanguageBean;
import com.xdja.safeclient.utils.LocaleUtil;

import java.util.List;
import java.util.Locale;

/**
 * Description:选择语言界面Adapter
 * Created by Administrator on 2017/2/8 0008.
 */
public class SwitchLanguageAdapter extends RecyclerView.Adapter<SwitchLanguageAdapter.ViewHolder> {

    private Context context;

    private List<LanguageBean> languageList;

    private int selectedPosition = -1;

    public SwitchLanguageAdapter(Context context, List<LanguageBean> languageList, int selectedPosition) {
        this.context = context;
        this.languageList = languageList;
        this.selectedPosition = selectedPosition;
    }

    public int getSelectedPosition() {
        return selectedPosition;
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(context).inflate(R.layout.switch_language_item, null));
    }

    @Override
    public void onBindViewHolder(final ViewHolder holder, final int position) {

        final LanguageBean language = languageList.get(position);

        holder.tv_language.setText(language.getName());

        holder.entireLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectedPosition = position;
                holder.rb_choose.setChecked(true);
                notifyDataSetChanged();
            }
        });

        holder.rb_choose.setClickable(false);

        if (position == selectedPosition) {
            holder.rb_choose.setChecked(true);
        } else {
            holder.rb_choose.setChecked(false);
        }

    }

    @Override
    public int getItemCount() {
        return languageList.size();
    }

    class ViewHolder extends RecyclerView.ViewHolder {
        RelativeLayout entireLayout;
        TextView tv_language;
        RadioButton rb_choose;

        public ViewHolder(View itemView) {
            super(itemView);
            entireLayout = (RelativeLayout) itemView.findViewById(R.id.entire_layout);
            tv_language = (TextView) itemView.findViewById(R.id.language);
            rb_choose = (RadioButton) itemView.findViewById(R.id.choose);
        }
    }

}
