package com.xdja.safeclient.architecture;

import android.app.Activity;
import android.media.Image;
import android.support.annotation.CallSuper;
import com.xdja.safeclient.utils.Log;
import android.view.View;
import android.view.Window;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.safeclient.ottoobj.ExitAppEvent;
import com.xdja.safeclient.ottoobj.FinishActivityEvent;
import com.xdja.safeclient.utils.LogUtil;
import com.xdja.safeclient.utils.OttoUtil;

public class BaseActivity extends Activity {
    protected ImageView mLeftBtn = null;
    protected ImageView mRightBtn = null;
    protected TextView mTitleText = null;

    @CallSuper
    protected void onCreate(android.os.Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        LogUtil.always(this.getClass().getName(), "life circle", "onCreate");
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        OttoUtil.register(this);
    }

    @CallSuper
    @Override
    protected void onDestroy() {
        super.onDestroy();
        LogUtil.always(this.getClass().getName(), "life circle", "onDestroy");
        OttoUtil.unRegister(this);
    }

    @CallSuper
    protected void initLeftBtn() {
        if (mLeftBtn == null) {
            return;
        }

        mLeftBtn.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                finish();
            }
        });
    }

    @CallSuper
    protected void initRightBtn() {
        if (mRightBtn == null) {
            Log.d("initRightBtn", "mRightBtn == null");
            return;
        }
    }

    @CallSuper
    protected void initTitleText() {
        if (mTitleText == null) {
            Log.d("initTitleText", "mTitleText == null");
            return;
        }
    }

    @CallSuper
    public void handleFinishEvent(FinishActivityEvent event) {
        if (event.getClassName().equals(this.getClass().getName())) {
            LogUtil.d("finishActivity", this.getClass().getName());
            this.finish();
        }
    }

    @CallSuper
    public void handleExitAppEvent(ExitAppEvent event) {
        LogUtil.d("exitApp", this.getClass().getName());
        finish();
    }


}
