package com.xdja.safeclient.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.xdja.safeclient.utils.Log;
import android.widget.Toast;

import com.xdja.safeclient.utils.LocaleUtil;
import com.xdja.safeclient.utils.OttoUtil;
import com.xdja.sslvpn.SSLVPN;

import java.util.Locale;

/**
 * Description:系统语言广播
 * Created by Administrator on 2017/2/8 0008.
 */
public class LocaleLanguageReceiver extends BroadcastReceiver {

    private static final String TAG = "LocaleLanguageReceiver";

    @Override
    public void onReceive(Context context, Intent intent) {
        OttoUtil.systemChangeLanguage();

        // 存储系统语言
        LocaleUtil.setSystemLocale(Locale.getDefault());

        // 底层语言设置初始化 xjq,2017-02-14 18:35:14
        if (LocaleUtil.autoChoose(context)) {
            SSLVPN.setLocale(Locale.getDefault());
        } else {
            Locale locale = LocaleUtil.getCurrent(context);
            if (locale != null) {
                SSLVPN.setLocale(locale);
            }
        }

    }

}
