package com.xdja.safeclient.receiver;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.telephony.TelephonyManager;
import com.xdja.safeclient.utils.Log;
import android.widget.Toast;

/**
 * Description:
 * Created by Administrator on 2017/2/21 0021.
 */
public class SimChangedReceiver extends BroadcastReceiver {

    public static final String ANDROID_INTENT_ACTION_SIM_STATE_CHANGED = "android.intent.action.SIM_STATE_CHANGED";
    public final String TAG = this.getClass().getName();

    @Override
    public void onReceive(Context context, Intent intent) {

        String action = intent.getAction();
        if (action.equalsIgnoreCase(ANDROID_INTENT_ACTION_SIM_STATE_CHANGED)) {
            Log.d(TAG, action);
            Log.d(TAG, "--> SIM state changed <--");

            TelephonyManager tm = (TelephonyManager) context.getSystemService(Service.TELEPHONY_SERVICE);
            int state = tm.getSimState();

            Log.d(TAG, state + "");

            switch (state) {

                case TelephonyManager.SIM_STATE_READY:
                    break;

                //无SIM卡
                case TelephonyManager.SIM_STATE_ABSENT:

                    break;
                case TelephonyManager.SIM_STATE_UNKNOWN:
                case TelephonyManager.SIM_STATE_PIN_REQUIRED:
                case TelephonyManager.SIM_STATE_PUK_REQUIRED:
                case TelephonyManager.SIM_STATE_NETWORK_LOCKED:
                default:
                    break;


            }

        }
    }
}
