package com.xdja.safeclient.ui;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.xdja.safeclient.R;


/**
 * Created by geyao on 2016/4/13.
 */
public class MDialog {
    private boolean mCancel;
    private boolean mCancelable = true;
    private Context mContext;
    private AlertDialog mAlertDialog;
    private Builder mBuilder;
    private int mTitleResId;
    private CharSequence mTitle;
    private int mMessageResId;
    private CharSequence mMessage;
    private TextView mPositiveButton;
    private boolean positiveButtonExit;
    private TextView mNegativeButton;
    private boolean negativeButtonExit;
    private TextView mNeutralButton;
    private boolean neutralButtonIsShow;
    private LinearLayout buttonLayout;
    private LinearLayout mainView;
    private View mDialogView;
    private View mBtnLine;
    private View mBtnLine2;
    private int gravity = Gravity.CENTER_VERTICAL;
    private boolean mHasShow = false;

    private DialogInterface.OnDismissListener mOnDismissListener;

    private DialogInterface.OnKeyListener onKeyListener;

    public void setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
        this.onKeyListener = onKeyListener;
    }

    private String mPositiveButtonTitle;
    private View.OnClickListener mPositiveButtonClick;

    private String mNegativeButtonTitle;
    private View.OnClickListener mNegativeButtonClick;

    private String mNeutralButtonTitle;
    private View.OnClickListener mNeutralButtonClick;
    private DialogInterface.OnShowListener onShowListener;

    public MDialog(Context context) {
        this.mContext = context;
    }

    /**
     * 显示对话框
     */
    public void show() {
        if (mHasShow == false)
            mBuilder = new Builder();
        else
            mAlertDialog.show();

        mHasShow = true;
    }

    /**
     * 设置对话框局部View(该方法可设置出了底部按钮布局以上的View)
     *
     * @param view 要设置显示的view
     * @return
     */
    public MDialog setView(View view) {
        mDialogView = view;
        if (mBuilder != null) {
            mBuilder.setView(view);
        }
        return this;
    }

    /**
     * 取消提示框
     */
    public void dismiss() {
        mAlertDialog.dismiss();
    }

    /**
     * 设置标题
     *
     * @param resId 标题资源id
     * @return
     */
    public MDialog setTitle(int resId) {
        mTitleResId = resId;
        if (mBuilder != null) {
            mBuilder.setTitle(resId);
        }
        return this;
    }

    /**
     * 设置标题
     *
     * @param title 标题字符串
     * @return
     */
    public MDialog setTitle(CharSequence title) {
        mTitle = title;
        if (mBuilder != null) {
            mBuilder.setTitle(title);
        }
        return this;
    }

    /**
     * 设置提示信息
     *
     * @param resId 提示信息资源id
     * @return
     */
    public MDialog setMessage(int resId) {
        mMessageResId = resId;
        if (mBuilder != null) {
            mBuilder.setMessage(resId);
        }
        return this;
    }

    /**
     * 设置提示信息
     *
     * @param message 提示信息字符串
     * @return
     */
    public MDialog setMessage(CharSequence message) {
        mMessage = message;
        if (mBuilder != null) {
            mBuilder.setMessage(message);
        }
        return this;
    }

    public MDialog setMessageGravity( int gravity) {
        this.gravity = gravity;
        if (mBuilder != null) {
            mBuilder.setMessageGravity(gravity);
        }
        return this;
    }

    /**
     * @param text     显示文字
     * @param listener 点击监听事件
     * @return
     */
    public MDialog setNeutralButton(String text, final View.OnClickListener listener) {
        neutralButtonIsShow = true;
        mNeutralButtonTitle = text;
        mNeutralButtonClick = listener;
        if (mBuilder != null) {
            mBuilder.setNeutralButton(text, listener);
        }
        return this;
    }

    /**
     * @param text     显示文字
     * @param listener 点击监听事件
     * @return
     */
    public MDialog setPositiveButton(String text, final View.OnClickListener listener) {
        positiveButtonExit = true;
        mPositiveButtonTitle = text;
        mPositiveButtonClick = listener;
        if (mBuilder != null) {
            mBuilder.setPositiveButton(text, listener);
        }
        return this;
    }

    /**
     * @param text     显示文字
     * @param listener 点击监听事件
     * @return
     */
    public MDialog setNegativeButton(String text, final View.OnClickListener listener) {
        negativeButtonExit = true;
        mNegativeButtonTitle = text;
        mNegativeButtonClick = listener;
        if (mBuilder != null) {
            mBuilder.setNegativeButton(text, listener);
        }
        return this;
    }

    /**
     * 设置是否外部点击可取消
     *
     * @param cancel 是否可取消
     * @return
     */
    public MDialog setCanceledOnTouchOutside(boolean cancel) {
        this.mCancel = cancel;
        if (mBuilder != null) {
            mBuilder.setCanceledOnTouchOutside(mCancel);
        }
        return this;
    }

    /**
     * 设置返回键是否可取消
     *
     * @param cancelable 是否可取消
     * @return
     */
    public MDialog setCancelable(boolean cancelable) {
        this.mCancelable = cancelable;
        if (mBuilder != null) {
            mBuilder.setCancelable(mCancelable);
        }
        return this;
    }

    /**
     * 设置对话框消失监听事件
     *
     * @param onDismissListener 对话框消息监听事件
     * @return
     */
    public MDialog setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
        return this;
    }

    private class Builder {

        private TextView mTitleView;
        private TextView mMessageView;
        private View contv;

        private Builder() {
            mAlertDialog = new AlertDialog.Builder(mContext, R.style.Theme_Transparent).create();

            mAlertDialog.getWindow().clearFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE | WindowManager.LayoutParams.FLAG_ALT_FOCUSABLE_IM);
            mAlertDialog.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_VISIBLE);
            contv = LayoutInflater.from(mContext).inflate(R.layout.layout_mdialog, null);
            mAlertDialog.setView(contv);

            mTitleView = (TextView) contv.findViewById(R.id.mDialog_title);
            mMessageView = (TextView) contv.findViewById(R.id.mDialog_message);
            mPositiveButton = (TextView) contv.findViewById(R.id.mDialog_ok);
            mNegativeButton = (TextView) contv.findViewById(R.id.mDialog_cancel);
            mNeutralButton = (TextView) contv.findViewById(R.id.mDialog_neutral);
            buttonLayout = (LinearLayout) contv.findViewById(R.id.mDialog_btn_layout);
            mainView = (LinearLayout) contv.findViewById(R.id.mDialog_view);
            mBtnLine = contv.findViewById(R.id.mDialog_btn_line);
            mBtnLine2 = contv.findViewById(R.id.mDialog_btn_line_2);

            if (mTitleResId != 0) {
                setTitle(mTitleResId);
                mTitleView.setVisibility(View.VISIBLE);
            }
            if (mTitle != null) {
                setTitle(mTitle);
                mTitleView.setVisibility(View.VISIBLE);
            }
            if (mMessageResId != 0) {
                setMessage(mMessageResId);
                mMessageView.setVisibility(View.VISIBLE);
            }
            if (mMessage != null) {
                setMessage(mMessage);
                mMessageView.setVisibility(View.VISIBLE);
            }
            setMessageGravity(gravity);
            if (positiveButtonExit) {
                setPositiveButton(mPositiveButtonTitle, mPositiveButtonClick);
                mPositiveButton.setVisibility(View.VISIBLE);
            }
            if (negativeButtonExit) {
                setNegativeButton(mNegativeButtonTitle, mNegativeButtonClick);
                mNegativeButton.setVisibility(View.VISIBLE);
            }
            if (neutralButtonIsShow) {
                setNeutralButton(mNeutralButtonTitle, mNeutralButtonClick);
                mNeutralButton.setVisibility(View.VISIBLE);
                mNeutralButton.setBackgroundResource(R.drawable.selector_dialog_btn);
            }
            if (positiveButtonExit && !negativeButtonExit) {
                mPositiveButton.setBackgroundResource(R.drawable.bg_mdialog_one_btn);
            }
            if (negativeButtonExit && !positiveButtonExit) {
                mNegativeButton.setBackgroundResource(R.drawable.bg_mdialog_one_btn);
            }
            if (neutralButtonIsShow && !positiveButtonExit && !negativeButtonExit) {
                mNeutralButton.setBackgroundResource(R.drawable.bg_mdialog_one_btn);
            }
            if (negativeButtonExit && positiveButtonExit) {
                mBtnLine.setVisibility(View.VISIBLE);
            }
            if (negativeButtonExit && positiveButtonExit && neutralButtonIsShow) {
                mBtnLine.setVisibility(View.VISIBLE);
                mBtnLine2.setVisibility(View.VISIBLE);
            }
            if (negativeButtonExit || positiveButtonExit || neutralButtonIsShow) {
                buttonLayout.setVisibility(View.VISIBLE);
            }
            if (mDialogView != null) {
                this.setView(mDialogView);
            }
            mAlertDialog.setCanceledOnTouchOutside(mCancel);
            if (mOnDismissListener != null) {
                mAlertDialog.setOnDismissListener(mOnDismissListener);
            }
            if (onKeyListener != null) {
                mAlertDialog.setOnKeyListener(onKeyListener);
            }
            if (onShowListener != null) {
                mAlertDialog.setOnShowListener(onShowListener);
            }
            mAlertDialog.setCancelable(mCancelable);
            mAlertDialog.getWindow().setType(WindowManager.LayoutParams.TYPE_SYSTEM_ALERT);
            mAlertDialog.show();
            Window window = mAlertDialog.getWindow();
            WindowManager.LayoutParams attributes = window.getAttributes();
            int v =mContext.getApplicationContext().getResources().getDimensionPixelOffset(R.dimen.base_308);
            attributes.width = v;
            attributes.dimAmount = 0.65f;
            window.setAttributes(attributes);
        }

        public void setTitle(int resId) {
            mTitleView.setText(resId);
        }

        public void setTitle(CharSequence title) {
            mTitleView.setText(title);
        }

        public void setMessage(int resId) {
            mMessageView.setText(resId);
        }

        public void setMessage(CharSequence message) {
            mMessageView.setText(message);
        }

        public void setMessageGravity(int gravity) {
            mMessageView.setGravity(gravity);
        }

        public void setPositiveButton(String text, final View.OnClickListener listener) {
            mPositiveButton.setText(text);
            if (listener == null) {
                mPositiveButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        dismiss();
                    }
                });
            } else {
                mPositiveButton.setOnClickListener(listener);
            }

        }

        public void setNegativeButton(String text, final View.OnClickListener listener) {
            mNegativeButton.setText(text);
            mNegativeButton.setOnClickListener(listener);
        }

        public void setNeutralButton(String text, final View.OnClickListener listener) {
            mNeutralButton.setText(text);
            mNeutralButton.setOnClickListener(listener);
        }

        public void setView(View view) {
            mainView.removeAllViews();
            mainView.addView(view);
        }

        public void setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
            mAlertDialog.setCanceledOnTouchOutside(canceledOnTouchOutside);
        }

        public void setCancelable(boolean cancelable) {
            mAlertDialog.setCancelable(cancelable);
        }
    }
}