package com.xdja.safeclient.utils;

import com.xdja.safeclient.utils.Log;

import java.util.Arrays;

/**
 * Description:封装byte相关操作
 * Created by zjc on 2017/1/9 0009.
 */
public class ByteUtil {

//    public static byte[] merge(byte[]... byteArrays) {
//
//        return null;
//
//    }

//    public static boolean equals(byte[] byteArray1, byte[] byteArray2) {
//
//        if (byteArray1 == null && byteArray2 == null) {
//            return true;
//        } else if (byteArray1 == null || byteArray2 == null) {
//            return false;
//        }
//
//        if (byteArray1.length != byteArray2.length) {
//            return false;
//        } else {
//            for (int )
//        }
//    }

    public static void print(byte[] value) {
        printByteToHex("SafeClient", value);
    }

    public static void print(String tag, byte[] value) {
        printByteToHex(tag, value);
    }

    private static void printByteToHex(String tag, byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; i++) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            Log.d("tag", i + ": " + hex.toUpperCase());
            sb.append(hex.toUpperCase());
            sb.append(" ");
        }
        Log.d(tag, sb.toString());
    }

    public static boolean equals(byte[] bytes1, byte[] bytes2) {
        return Arrays.equals(bytes1, bytes2);
    }


    public static String bytesToHexString(byte[] src){
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; i++) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }
    /**
     * Convert hex string to byte[]
     * @param hexString the hex string
     * @return byte[]
     */
    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; i++) {
            int pos = i * 2;
            d[i] = (byte) (charToByte(hexChars[pos]) << 4 | charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    /**
     * Convert char to byte
     * @param c char
     * @return byte
     */
    private static byte charToByte(char c) {
        return (byte) "0123456789ABCDEF".indexOf(c);
    }
}
