package com.xdja.safeclient.utils;

import android.content.Context;

import com.xdja.safeclient.ui.DialogWrapper;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 测试版（试用期版）安全客户端，操作工具类
 * Created by zjc on 2018/5/21 0021.
 */

public class ExpireUtil {

    public static long last = 0;

    /**
     * @param activity
     * @return true 没到期；false 到期
     */
    public static boolean validExpiredDate(Context activity) {

        Date date = new Date();

        Date target = strToDate("2018-08-01");

        int result = differentDays(date, target);
        LogUtil.d("date", result);

        long current = System.currentTimeMillis();

        int second = (int) (((current - last) / 1000));
        if (second > 2) {
            //说明没到期
            if (result > 0) {
                final DialogWrapper dialogWrapper = new DialogWrapper();
                dialogWrapper.showTitleClickableMessage1BtnDialog(activity,
                        "测试版安全客户端",
                        "该软件为测试版本",
                        "距离试用期结束还有" + result + "天，请获取正式版本",
                        "是",
                        null
                );
            } else {
                DialogWrapper dialogWrapper = new DialogWrapper();
                dialogWrapper.showTitleClickableMessage1BtnDialog(activity,
                        "测试版安全客户端",
                        "该软件为测试版本",
                        "试用期已结束，请联系技术支持人员获取正式版本",
                        "是"
                );
            }
        }

        last = current;

        return result > 0;

    }

    /**
     * 字符串转日期类
     *
     * @param strDate
     * @return
     */
    public static Date strToDate(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;

    }

    /**
     * 比较两个日期差
     *
     * @param date1
     * @param date2
     * @return >0代表，前面的日期在后面日期的前面
     * <0代表，前面的日期在后面日期的后面
     */
    public static int differentDays(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);

        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(Calendar.DAY_OF_YEAR);
        int day2 = cal2.get(Calendar.DAY_OF_YEAR);

        int year1 = cal1.get(Calendar.YEAR);
        int year2 = cal2.get(Calendar.YEAR);
        if (year1 != year2) {
            //同一年
            int timeDistance = 0;
            for (int i = year1; i < year2; i++) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    //闰年
                    timeDistance += 366;
                } else {
                    //不是闰年
                    timeDistance += 365;
                }
            }

            return timeDistance + (day2 - day1);
        } else {
            //不同年
            System.out.println("判断day2 - day1 : " + (day2 - day1));
            return day2 - day1;
        }
    }

}
