package com.xdja.safeclient.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import com.xdja.safeclient.utils.Log;

public class FileUtil {

    public static final String DATE_FORMATE = "YYYY.MM.DD";

    public FileUtil() {

    }

    public static String getSDPath() {
        String sdDir = null;

        boolean sdCardExist = Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED);

        if (sdCardExist) {
            sdDir = Environment.getExternalStorageDirectory().getAbsolutePath();
            return sdDir;
        } else {
            return null;
        }
    }

    /**
     * 拷贝文件
     *
     * @param sourceFile
     * @param targetFile
     */
    public static boolean copeFile(final File sourceFile, final File targetFile) {

//		new Thread() {
        boolean result = false;
        BufferedInputStream inBuff = null;
        BufferedOutputStream outBuff = null;
//			public void run() {
        try {
            inBuff = new BufferedInputStream(new FileInputStream(sourceFile));
            outBuff = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] buf = new byte[1024 * 4];
            int len;
            while ((len = inBuff.read(buf)) != -1) {
                outBuff.write(buf, 0, len);
            }
            outBuff.flush();
            result = true;
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            result = false;
        } catch (IOException e) {
            e.printStackTrace();
            result = false;
        } finally {
            if (inBuff != null) {
                try {
                    inBuff.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

            if (outBuff != null) {
                try {
                    outBuff.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

        }
//			}
//		}.start();
        return result;
    }

    /**
     * 获取文件编码格式
     *
     * @param strFilePath
     * @return
     */
    public static String getFileEncoding(String strFilePath) {
        File file = null;
        FileInputStream fis = null;
        BufferedInputStream in = null;

        try {
            file = new File(strFilePath);

            fis = new FileInputStream(file);

            in = new BufferedInputStream(fis);

            in.mark(4);

            byte[] first3bytes = new byte[3];

            in.read(first3bytes);

            in.reset();

            in.close();

//			utf-8
            if (first3bytes[0] == (byte) 0xEF && first3bytes[1] == (byte) 0xBB
                    && first3bytes[2] == (byte) 0xBF) {
                Log.d("getFileEncoding", "utf-8");
                return "utf-8";
            }
//			unicode
            else if (first3bytes[0] == (byte) 0xFF && first3bytes[1] == (byte) 0xFE) {
                Log.d("getFileEncoding", "unicode");
                return "unicode";
            }
//			utf-16be
            else if (first3bytes[0] == (byte) 0xFE && first3bytes[1] == (byte) 0xFF) {
                Log.d("getFileEncoding", "utf-16be");
                return "utf-16be";
            }
//			utf-16le
            else if (first3bytes[0] == (byte) 0xFF && first3bytes[1] == (byte) 0xFF) {
                Log.d("getFileEncoding", "utf-16le");
                return "utf-16le";
            }
//			GBK
            else {
                Log.d("getFileEncoding", "GBK");
                return "GBK";
            }

        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;

    }

    /**
     * 读取文件中每一行并存入ArrayList中
     *
     * @param fileName
     * @param strArray
     * @param handler
     */
    public static void readFileByLines(final String fileName, final ArrayList<String> strArray, final Handler handler) {

        new Thread() {
            public void run() {

                Message msg = new Message();

                File file = null;
                FileInputStream fis = null;
                BufferedInputStream in = null;
                InputStreamReader isr = null;
                BufferedReader reader = null;
                String encoding = null;

                try {


                    file = new File(fileName);
                    fis = new FileInputStream(file);

                    in = new BufferedInputStream(fis);

                    encoding = getFileEncoding(fileName);

                    isr = new InputStreamReader(in, encoding);

//					Log.d("readFileByLines", "以行为单位读取文件内容，一次读一整行：");

                    reader = new BufferedReader(isr);

                    String tempString = null;

                    while ((tempString = reader.readLine()) != null) {
//						Log.d("readFileByLines 1","tempString = " + tempString);
                        if (!tempString.equals("\n") && !tempString.equals("")) {
                            strArray.add(tempString);
//							Log.d("readFileByLines 2","tempString = " + tempString);
                        }
                    }
                    tempString = null;
                    msg.what = 0;
                    handler.sendMessage(msg);
                } catch (IOException e) {
                    e.printStackTrace();
                } finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        } catch (IOException e1) {
                        }
                    }
                    if (isr != null) {
                        try {
                            isr.close();
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }

                    if (in != null) {
                        try {
                            in.close();
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }

            ;
        }.start();

    }

    /**
     * 判断日志是否指当天的
     *
     * @param strLog
     * @return
     */
    public static boolean isLogOfCurDay(String strLog, String strCurDate) {

        if (strLog == null || strLog.equals("")) {
            return false;
        }

        if (strLog.length() < DATE_FORMATE.length()) {
            return false;
        }


        if (strLog.contains(strCurDate)) {
            return true;
        } else {
            return false;
        }

    }

    /**
     * 从文件中读出当天的日志，保存到ArrayList中
     *
     * @param fileName
     * @param strArray
     * @param handler
     */
    public static void readLogOfCurDay(final String fileName, final ArrayList<String> strArray, final Handler handler) {

        new Thread() {
            public void run() {

                Message msg = new Message();

                File file = null;
                FileInputStream fis = null;
                BufferedInputStream in = null;
                InputStreamReader isr = null;
                BufferedReader reader = null;

                SimpleDateFormat sDateFormat = null;
                String strCurDate = null;

                sDateFormat = new SimpleDateFormat("yyyy.MM.dd", Locale.CHINA);

                strCurDate = sDateFormat.format(new java.util.Date());

                Log.d("readLogOfCurDay", "strCurDate = " + strCurDate);

                try {


                    file = new File(fileName);
                    fis = new FileInputStream(file);

                    in = new BufferedInputStream(fis);

                    isr = new InputStreamReader(in, getFileEncoding(fileName));

//					Log.d("readFileByLines", "以行为单位读取文件内容，一次读一整行：");

                    reader = new BufferedReader(isr);

                    String strDate = null;
                    String strLog = null;

                    while ((strDate = reader.readLine()) != null) {
                        //只取当天的日志
//						Log.d("readLogOfCurDay","strDate = " + strDate);
                        if (isLogOfCurDay(strDate, strCurDate)) {
                            strLog = reader.readLine();
//							Log.d("readLogOfCurDay","strLog = " + strLog);
                            strArray.add(strDate + "\n" + strLog);
                        }
                    }
                    strDate = null;
                    strLog = null;
                    msg.what = 0;
                    handler.sendMessage(msg);
                } catch (IOException e) {
                    e.printStackTrace();
                } finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        } catch (IOException e1) {
                        }
                    }
                    if (isr != null) {
                        try {
                            isr.close();
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }

                    if (in != null) {
                        try {
                            in.close();
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }

            ;
        }.start();

    }

    /**
     * 将字符串写入文件
     *
     * @param fileName
     * @param message
     */
    public static boolean writeFile(String fileName, String message) {
        FileOutputStream fileOut = null;
        boolean result = false;

        File file = new File(fileName);

        try {
            fileOut = new FileOutputStream(file);
            byte[] buffer = message.getBytes();
            fileOut.write(buffer);
            result = true;
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            result = false;
        } catch (IOException e) {
            e.printStackTrace();
            result = false;
        } finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                } catch (IOException e1) {
                }
            }
        }
        return result;
    }


    public static boolean copyAssetsToPrivatePath(final Context context, final String srcFileName, final File toFile) {

        AssetManager am = null;
        InputStream is = null;
        FileOutputStream fos = null;

        try {
            am = context.getAssets();
            is = am.open(srcFileName);
            fos = new FileOutputStream(toFile);
            byte[] buffer = new byte[1024];
            int count = 0;
            while ((count = is.read(buffer)) > 0) {
                fos.write(buffer, 0, count);
            }
            fos.flush();
            fos.close();
            is.close();
            return true;
        } catch (IOException e) {
            e.printStackTrace();
            if (fos != null) {
                try {
                    fos.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }

            if (is != null) {
                try {
                    is.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }

            return false;
        }
    }

    public static Properties loadProperties(InputStream in) {
        Properties properties = new Properties();
        try {
            Log.d("FileUtil", "properties.load");
            properties.load(in);
            Log.d("FileUtil", "properties.load success");
            in.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }

        return properties;

    }

    public static int saveProperties(String filename, Properties properties) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            properties.save(fos, "");
            fos.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            return -1;
        } catch (IOException e) {
            e.printStackTrace();
        }

        return 0;
    }

}
