package com.xdja.safeclient.utils;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.DisplayMetrics;

import com.xdja.safeclient.bean.LanguageBean;
import com.xdja.safeclient.constant.SPKey;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/**
 * Description:国际化工具类
 * Created by Administrator on 2017/2/8 0008.
 */
public class LocaleUtil {

    //Locale.CHINA、Locale.CHINESE和Locale.SIMPLIFIED_CHINESE暂时没有发现什么区别，现在用最后一个

    public static final String SIMPLIFIED_CHINESE = "简体中文";
    public static final String ENGLISH = "English";

    public static Map<String, Locale> languages = new HashMap<>();

    // 系统语言
    private static Locale systemLocale = null;

    public static Locale getSystemLocale() {
        return systemLocale;
    }

    public static void setSystemLocale(Locale systemLocale) {
        LocaleUtil.systemLocale = systemLocale;
    }

    static {
        languages.put(SIMPLIFIED_CHINESE, Locale.SIMPLIFIED_CHINESE);
        languages.put(ENGLISH, Locale.ENGLISH);
        // 获取系统语言
        systemLocale = Locale.getDefault();
    }

    /**
     * 是否跟随系统
     *
     * @return
     */
    public static boolean autoChoose(Context context) {
        return (boolean) (SharedPreferencesUtil.get(context, SPKey.AUTO_LANGUAGE, true));
    }

    /**
     * 获取当前设置的语言的名称
     *
     * @param context
     * @return
     */
    public static String getCurrentLocaleName(Context context) {
        return (String) SharedPreferencesUtil.get(context, SPKey.CURRENT_lANGUAGE, "");
    }

    /**
     * 获取当前设置的语言
     *
     * @param context
     * @return
     */
    public static Locale getCurrent(Context context) {
        return parseLocale(getCurrentLocaleName(context));
    }

    /**
     * 根据名称获取对应的语言区信息
     * 需要手动判断是否为空
     *
     * @param languageName
     * @return
     */
    public static Locale parseLocale(String languageName) {
        return languages.get(languageName);
    }

    public static void changeLanguage(Context context, Locale locale) {
        Resources resources = context.getResources();

        Configuration configuration = resources.getConfiguration();
        DisplayMetrics dm = resources.getDisplayMetrics();
        configuration.locale = locale;
        resources.updateConfiguration(configuration, dm);

        OttoUtil.customChangeLanguage(resources.getConfiguration().locale);
    }

    public static void changeLanguage(Context context, LanguageBean language, ChangeListener listener) {

        Resources resources = context.getResources();

        Configuration configuration = resources.getConfiguration();
        DisplayMetrics dm = resources.getDisplayMetrics();

        configuration.locale = language.isAuto() ? LocaleUtil.getSystemLocale() : language.getLocale();
        resources.updateConfiguration(configuration, dm);

        listener.onChange(language);

        OttoUtil.customChangeLanguage(resources.getConfiguration().locale);

    }

    public interface ChangeListener {

        /**
         * 改变只会改变当前Activity界面
         * 对于其他界面，需要退出和重新进入
         * 所以自行在里面处理Activity结束和跳转
         * finish();
         * Intent intent = new Intent(this, MainActivity.class);
         * intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
         * startActivity(intent);
         */
        void onChange(LanguageBean language);

    }

}
