package com.xdja.safeclient.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

/**
 * Created by xingjianqiang on 2017/1/5.
 * Project : safeclient.android.origin
 * Email : xingjianqiang@xdja.com
 */

public class Log {

    private static int logLevel = 6;
    private static String filePath;
    private static Writer writer;
    private static SimpleDateFormat sdf;

    private static final String TAG = "Log";

    private Log(String path) {
        filePath = path;
        writer = null;
    }

    public static void init(String path, int level) throws IOException {

        logLevel = level;

        if (path != null) {
            if (writer != null) {
                Log.e(TAG, "Log file path already set.");
                return;
            }
            File file = new File(path);
            writer = new BufferedWriter(new FileWriter(file), 2048);
            sdf = new SimpleDateFormat("MM-dd hh:mm:ss ", Locale.getDefault());
        }
    }

    /**
     * Change current logging level
     *
     * @param level new log level 1 <= level <= 6
     */
    public static void setLogLevel(int level) {
        logLevel = level;
    }

    /**
     * Get the current log level
     *
     * @return the log level
     */
    public static int getLogLevel() {
        return logLevel;
    }


    private static void writeLog(String tag, String log) {
        try {
            if (writer != null) {
                writer.write(sdf.format(new Date()));
                writer.write(tag + " :");
                writer.write(log);
                writer.write("\n");
                writer.flush();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
    /**
     * Log verbose
     *
     * @param tag Tag for this log
     * @param msg Msg for this log
     */
    public static void v(String tag, String msg) {
        if (logLevel >= 5) {
            android.util.Log.v(tag, msg);
        }

        writeLog(tag, msg);
    }

    /**
     * Log verbose
     *
     * @param tag Tag for this log
     * @param msg Msg for this log
     * @param tr  Error to serialize in log
     */
    public static void v(String tag, String msg, Throwable tr) {
        if (logLevel >= 5) {
            android.util.Log.v(tag, msg, tr);
        }
        writeLog(tag, msg);
    }

    /**
     * Log debug
     *
     * @param tag Tag for this log
     * @param msg Msg for this log
     */
    public static void d(String tag, String msg) {
        if (logLevel >= 4) {
            android.util.Log.d(tag, msg);
        }
        writeLog(tag, msg);
    }

    /**
     * Log debug
     *
     * @param tag Tag for this log
     * @param msg Msg for this log
     * @param tr  Error to serialize in log
     */
    public static void d(String tag, String msg, Throwable tr) {
        if (logLevel >= 4) {
            android.util.Log.d(tag, msg, tr);
        }
        writeLog(tag, msg);
    }

    /**
     * Log info
     *
     * @param tag Tag for this log
     * @param msg Msg for this log
     */
    public static void i(String tag, String msg) {
        if (logLevel >= 3) {
            android.util.Log.i(tag, msg);
        }
        writeLog(tag, msg);
    }

    /**
     * Log info
     *
     * @param tag Tag for this log
     * @param msg Msg for this log
     * @param tr  Error to serialize in log
     */
    static void i(String tag, String msg, Throwable tr) {
        if (logLevel >= 3) {
            android.util.Log.i(tag, msg, tr);
        }
        writeLog(tag, msg);
    }

    /**
     * Log warning
     *
     * @param tag Tag for this log
     * @param msg Msg for this log
     */
    public static void w(String tag, String msg) {
        if (logLevel >= 2) {
            android.util.Log.w(tag, msg);
        }
        writeLog(tag, msg);
    }

    /**
     * Log warning
     *
     * @param tag Tag for this log
     * @param msg Msg for this log
     * @param tr  Error to serialize in log
     */
    public static void w(String tag, String msg, Throwable tr) {
        if (logLevel >= 2) {
            android.util.Log.w(tag, msg, tr);
        }
        writeLog(tag, msg);
    }

    /**
     * Log error
     *
     * @param tag Tag for this log
     * @param msg Msg for this log
     */
    public static void e(String tag, String msg) {
        if (logLevel >= 1) {
            android.util.Log.e(tag, msg);
        }
        writeLog(tag, msg);
    }

    /**
     * Log error
     *
     * @param tag Tag for this log
     * @param msg Msg for this log
     * @param tr  Error to serialize in log
     */
    public static void e(String tag, String msg, Throwable tr) {
        if (logLevel >= 1) {
            android.util.Log.e(tag, msg, tr);
        }
        writeLog(tag, msg);
    }




}
