package com.xdja.safeclient.wrapper;

import com.xdja.safeclient.card.Cert;
import com.xdja.safeclient.card.Container;
import com.xdja.safeclient.utils.ByteUtil;

/**
 * Description:卡对象封装，主要是容器和证书
 * Created by zjc on 2017/1/10 0010.
 */
public class CardWrapper {

    public static final Container CONTAINER0 = new Container(
            new byte[]{0x28},
            new Cert(new byte[]{0x00, 0x29}, new byte[]{0x00, 0x2a}, new byte[]{0x00, 0x2b}),
            new Cert(new byte[]{0x00, 0x2c}, new byte[]{0x00, 0x2d}, new byte[]{0x00, 0x2e}));

    public static final Container CONTAINER4 = new Container(
            new byte[]{0x44},
            new Cert(new byte[]{0x00, 0x45}, new byte[]{0x00, 0x46}, new byte[]{0x00, 0x47}),
            new Cert(new byte[]{0x00, 0x48}, new byte[]{0x00, 0x49}, new byte[]{0x00, 0x4a}));

    public static final Container CONTAINER6 = new Container(
            new byte[]{0x52},
            new Cert(new byte[]{0x00, 0x53}, new byte[]{0x00, 0x54}, new byte[]{0x00, 0x55}),
            new Cert(new byte[]{0x00, 0x56}, new byte[]{0x00, 0x57}, new byte[]{0x00, 0x58}));

    public static boolean isContainer0(Cert cert) {
        return equals(cert, CONTAINER0.getSignCert()) || equals(cert, CONTAINER0.getExchangeCert());
    }

    public static boolean isContainer4(Cert cert) {
        return equals(cert, CONTAINER4.getSignCert()) || equals(cert, CONTAINER4.getExchangeCert());
    }

    public static boolean isContainer6(Cert cert) {
        return equals(cert, CONTAINER6.getSignCert()) || equals(cert, CONTAINER6.getExchangeCert());
    }

    public static boolean equals(Cert cert1, Cert cert2) {

        if (!ByteUtil.equals(cert1.getCertId(), cert2.getCertId())) {
            return false;
        } else if (!ByteUtil.equals(cert1.getPubKey(), cert2.getPubKey())) {
            return false;
        } else if (!ByteUtil.equals(cert1.getPriKey(), cert2.getPriKey())) {
            return false;
        } else {
            return true;
        }

    }

}
